/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.ObjectInputStreamWithLoader;
import org.apache.spark.streaming.Time;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

public final class Checkpoint$
implements Logging,
Serializable {
    public static final Checkpoint$ MODULE$ = new Checkpoint$();
    private static final String PREFIX;
    private static final Regex REGEX;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        PREFIX = "checkpoint-";
        REGEX = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(16).append(MODULE$.PREFIX()).append("([\\d]+)([\\w\\.]*)").toString()));
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String PREFIX() {
        return PREFIX;
    }

    public Regex REGEX() {
        return REGEX;
    }

    public Path checkpointFile(String checkpointDir, Time checkpointTime) {
        return new Path(checkpointDir, new StringBuilder(0).append(this.PREFIX()).append(checkpointTime.milliseconds()).toString());
    }

    public Path checkpointBackupFile(String checkpointDir, Time checkpointTime) {
        return new Path(checkpointDir, new StringBuilder(3).append(this.PREFIX()).append(checkpointTime.milliseconds()).append(".bk").toString());
    }

    public Seq<Path> getCheckpointFiles(String checkpointDir, Option<FileSystem> fsOption) {
        Seq seq;
        block3: {
            Path path = new Path(checkpointDir);
            FileSystem fs = (FileSystem)fsOption.getOrElse((Function0 & Serializable)() -> path.getFileSystem(SparkHadoopUtil$.MODULE$.get().conf()));
            try {
                FileStatus[] statuses = fs.listStatus(path);
                if (statuses != null) {
                    Path[] paths = (Path[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])statuses), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isDirectory()))), (Function1 & Serializable)x$4 -> x$4.getPath(), ClassTag$.MODULE$.apply(Path.class));
                    Path[] filtered = (Path[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])paths), (Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Checkpoint$.$anonfun$getCheckpointFiles$4(p)));
                    seq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.sortWith$extension(Predef$.MODULE$.refArrayOps((Object[])filtered), (Function2 & Serializable)(path1, path2) -> BoxesRunTime.boxToBoolean((boolean)this.sortFunc$1(path1, path2))));
                    break block3;
                }
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Listing ").append(path).append(" returned null").toString());
                seq = (Seq)package$.MODULE$.Seq().empty();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Checkpoint directory ").append(path).append(" does not exist").toString());
                seq = (Seq)package$.MODULE$.Seq().empty();
            }
        }
        return seq;
    }

    public Option<FileSystem> getCheckpointFiles$default$2() {
        return None$.MODULE$;
    }

    public byte[] serialize(Checkpoint checkpoint, SparkConf conf) {
        CompressionCodec compressionCodec = CompressionCodec$.MODULE$.createCodec(conf);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStream zos = compressionCodec.compressedOutputStream((OutputStream)bos);
        ObjectOutputStream oos = new ObjectOutputStream(zos);
        Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable)() -> oos.writeObject(checkpoint), (Function0)(JFunction0.mcV.sp & Serializable)() -> oos.close());
        return bos.toByteArray();
    }

    public Checkpoint deserialize(InputStream inputStream, SparkConf conf) {
        CompressionCodec compressionCodec = CompressionCodec$.MODULE$.createCodec(conf);
        ObjectRef ois = ObjectRef.create(null);
        return (Checkpoint)Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable)() -> {
            InputStream zis = compressionCodec.compressedInputStream(inputStream);
            ois$1.elem = new ObjectInputStreamWithLoader(zis, Thread.currentThread().getContextClassLoader());
            Checkpoint cp = (Checkpoint)((ObjectInputStreamWithLoader)ois$1.elem).readObject();
            cp.validate();
            return cp;
        }, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            block0: {
                if ((ObjectInputStreamWithLoader)ois$1.elem == null) break block0;
                ((ObjectInputStreamWithLoader)ois$1.elem).close();
            }
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Checkpoint$.class);
    }

    private final boolean sortFunc$1(Path path1, Path path2) {
        Option option;
        Option option2;
        String string = path1.getName();
        if (string == null || (option2 = this.REGEX().unapplySeq((CharSequence)string)).isEmpty() || option2.get() == null || ((List)option2.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)string);
        }
        String x = (String)((LinearSeqOps)option2.get()).apply(0);
        String y = (String)((LinearSeqOps)option2.get()).apply(1);
        Tuple2.mcJZ.sp sp2 = new Tuple2.mcJZ.sp(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x)), !y.isEmpty());
        Tuple2.mcJZ.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        long time1 = sp3._1$mcJ$sp();
        boolean bk1 = sp3._2$mcZ$sp();
        Tuple2.mcJZ.sp sp4 = new Tuple2.mcJZ.sp(time1, bk1);
        Tuple2.mcJZ.sp sp5 = sp4;
        long time12 = sp5._1$mcJ$sp();
        boolean bk12 = sp5._2$mcZ$sp();
        String string2 = path2.getName();
        if (string2 == null || (option = this.REGEX().unapplySeq((CharSequence)string2)).isEmpty() || option.get() == null || ((List)option.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)string2);
        }
        String x2 = (String)((LinearSeqOps)option.get()).apply(0);
        String y2 = (String)((LinearSeqOps)option.get()).apply(1);
        Tuple2.mcJZ.sp sp6 = new Tuple2.mcJZ.sp(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x2)), !y2.isEmpty());
        Tuple2.mcJZ.sp sp7 = sp6;
        if (sp7 == null) {
            throw new MatchError((Object)sp7);
        }
        long time2 = sp7._1$mcJ$sp();
        boolean bk2 = sp7._2$mcZ$sp();
        Tuple2.mcJZ.sp sp8 = new Tuple2.mcJZ.sp(time2, bk2);
        Tuple2.mcJZ.sp sp9 = sp8;
        long time22 = sp9._1$mcJ$sp();
        boolean bk22 = sp9._2$mcZ$sp();
        return time12 < time22 || time12 == time22 && bk12;
    }

    public static final /* synthetic */ boolean $anonfun$getCheckpointFiles$4(Path p) {
        return MODULE$.REGEX().findFirstIn((CharSequence)p.getName()).nonEmpty();
    }

    private Checkpoint$() {
    }
}

