/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.apache.spark.deploy.yarn.YarnAppReport;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.guava.base.Objects;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Client$
implements Logging {
    public static final Client$ MODULE$ = new Client$();
    private static final String APP_JAR_NAME;
    private static final String SPARK_STAGING;
    private static final FsPermission STAGING_DIR_PERMISSION;
    private static final FsPermission APP_FILE_PERMISSION;
    private static final String ENV_DIST_CLASSPATH;
    private static final String LOCALIZED_CONF_DIR;
    private static final String LOCALIZED_HADOOP_CONF_DIR;
    private static final String LOCALIZED_CONF_ARCHIVE;
    private static final String SPARK_CONF_FILE;
    private static final String DIST_CACHE_CONF_FILE;
    private static final String LOCALIZED_PYTHON_DIR;
    private static final String LOCALIZED_LIB_DIR;
    private static final String SPARK_TESTING;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        APP_JAR_NAME = "__app__.jar";
        SPARK_STAGING = ".sparkStaging";
        STAGING_DIR_PERMISSION = FsPermission.createImmutable((short)((short)Integer.parseInt("700", 8)));
        APP_FILE_PERMISSION = FsPermission.createImmutable((short)((short)Integer.parseInt("644", 8)));
        ENV_DIST_CLASSPATH = "SPARK_DIST_CLASSPATH";
        LOCALIZED_CONF_DIR = "__spark_conf__";
        LOCALIZED_HADOOP_CONF_DIR = "__hadoop_conf__";
        LOCALIZED_CONF_ARCHIVE = new StringBuilder(4).append(MODULE$.LOCALIZED_CONF_DIR()).append(".zip").toString();
        SPARK_CONF_FILE = "__spark_conf__.properties";
        DIST_CACHE_CONF_FILE = "__spark_dist_cache__.properties";
        LOCALIZED_PYTHON_DIR = "__pyfiles__";
        LOCALIZED_LIB_DIR = "__spark_libs__";
        SPARK_TESTING = "SPARK_TESTING";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String APP_JAR_NAME() {
        return APP_JAR_NAME;
    }

    public String SPARK_STAGING() {
        return SPARK_STAGING;
    }

    public FsPermission STAGING_DIR_PERMISSION() {
        return STAGING_DIR_PERMISSION;
    }

    public FsPermission APP_FILE_PERMISSION() {
        return APP_FILE_PERMISSION;
    }

    public String ENV_DIST_CLASSPATH() {
        return ENV_DIST_CLASSPATH;
    }

    public String LOCALIZED_CONF_DIR() {
        return LOCALIZED_CONF_DIR;
    }

    public String LOCALIZED_HADOOP_CONF_DIR() {
        return LOCALIZED_HADOOP_CONF_DIR;
    }

    public String LOCALIZED_CONF_ARCHIVE() {
        return LOCALIZED_CONF_ARCHIVE;
    }

    public String SPARK_CONF_FILE() {
        return SPARK_CONF_FILE;
    }

    public String DIST_CACHE_CONF_FILE() {
        return DIST_CACHE_CONF_FILE;
    }

    public String LOCALIZED_PYTHON_DIR() {
        return LOCALIZED_PYTHON_DIR;
    }

    public String LOCALIZED_LIB_DIR() {
        return LOCALIZED_LIB_DIR;
    }

    public String SPARK_TESTING() {
        return SPARK_TESTING;
    }

    public String org$apache$spark$deploy$yarn$Client$$getAppStagingDir(ApplicationId appId) {
        return this.buildPath((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.SPARK_STAGING(), appId.toString()}));
    }

    public void populateHadoopClasspath(Configuration conf, HashMap<String, String> env) {
        Seq classPathElementsToAdd = (Seq)this.getYarnAppClasspath(conf).$plus$plus(this.getMRAppClasspath(conf));
        classPathElementsToAdd.foreach((Function1 & Serializable)c -> {
            YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)env, ApplicationConstants.Environment.CLASSPATH.name(), c.trim());
            return BoxedUnit.UNIT;
        });
    }

    private Seq<String> getYarnAppClasspath(Configuration conf) {
        Seq seq;
        Option option = Option$.MODULE$.apply((Object)conf.getStrings("yarn.application.classpath"));
        if (option instanceof Some) {
            Some some = (Some)option;
            String[] s = (String[])some.value();
            seq = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])s));
        } else if (None$.MODULE$.equals(option)) {
            seq = this.getDefaultYarnApplicationClasspath();
        } else {
            throw new MatchError((Object)option);
        }
        return seq;
    }

    private Seq<String> getMRAppClasspath(Configuration conf) {
        Seq seq;
        Option option = Option$.MODULE$.apply((Object)conf.getStrings("mapreduce.application.classpath"));
        if (option instanceof Some) {
            Some some = (Some)option;
            String[] s = (String[])some.value();
            seq = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])s));
        } else if (None$.MODULE$.equals(option)) {
            seq = this.getDefaultMRApplicationClasspath();
        } else {
            throw new MatchError((Object)option);
        }
        return seq;
    }

    public Seq<String> getDefaultYarnApplicationClasspath() {
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH));
    }

    public Seq<String> getDefaultMRApplicationClasspath() {
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])StringUtils.getStrings((String)MRJobConfig.DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH)));
    }

    /*
     * Unable to fully structure code
     */
    public void populateClasspath(ClientArguments args, Configuration conf, SparkConf sparkConf, HashMap<String, String> env, Option<String> extraClassPath) {
        extraClassPath.foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$populateClasspath$1$adapted(org.apache.spark.SparkConf scala.collection.mutable.HashMap java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((SparkConf)sparkConf, env));
        var8_6 = extraClassPath;
        if (!(var8_6 instanceof Some)) ** GOTO lbl-1000
        var9_7 = (Some)var8_6;
        classPath = (String)var9_7.value();
        if (Utils$.MODULE$.isTesting()) {
            var6_9 = Predef$.MODULE$.wrapRefArray((Object[])classPath.split(File.pathSeparator)).toSet();
        } else lbl-1000:
        // 2 sources

        {
            var6_9 = Predef$.MODULE$.Set().empty();
        }
        cpSet = var6_9;
        this.addClasspathEntry(ApplicationConstants.Environment.PWD.$$(), env);
        this.addClasspathEntry(new StringBuilder(1).append(ApplicationConstants.Environment.PWD.$$()).append("/").append(this.LOCALIZED_CONF_DIR()).toString(), env);
        if (BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.USER_CLASS_PATH_FIRST()))) {
            mainJar = args != null ? this.getMainJarUri((Option<String>)Option$.MODULE$.apply((Object)args.userJar())) : this.getMainJarUri((Option<String>)((Option)sparkConf.get(package$.MODULE$.APP_JAR())));
            mainJar.foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$populateClasspath$2$adapted(org.apache.spark.SparkConf org.apache.hadoop.conf.Configuration scala.collection.mutable.HashMap java.net.URI ), (Ljava/net/URI;)Ljava/lang/Object;)((SparkConf)sparkConf, (Configuration)conf, env));
            secondaryJars = args != null ? this.getSecondaryJarUris((Option<Seq<String>>)Option$.MODULE$.apply(sparkConf.get(package$.MODULE$.JARS_TO_DISTRIBUTE()))) : this.getSecondaryJarUris((Option<Seq<String>>)((Option)sparkConf.get(package$.MODULE$.SECONDARY_JARS())));
            secondaryJars.foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$populateClasspath$3$adapted(org.apache.spark.SparkConf org.apache.hadoop.conf.Configuration scala.collection.mutable.HashMap java.net.URI ), (Ljava/net/URI;)Ljava/lang/Object;)((SparkConf)sparkConf, (Configuration)conf, env));
        }
        this.addClasspathEntry(this.buildPath((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), this.LOCALIZED_LIB_DIR(), "*"})), env);
        if (((Option)sparkConf.get(package$.MODULE$.SPARK_ARCHIVE())).isEmpty()) {
            ((Option)sparkConf.get(package$.MODULE$.SPARK_JARS())).foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$populateClasspath$4$adapted(org.apache.spark.SparkConf scala.collection.mutable.HashMap scala.collection.immutable.Seq ), (Lscala/collection/immutable/Seq;)Ljava/lang/Object;)((SparkConf)sparkConf, env));
        }
        if (BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.POPULATE_HADOOP_CLASSPATH()))) {
            this.populateHadoopClasspath(conf, env);
        }
        scala.sys.package$.MODULE$.env().get((Object)this.ENV_DIST_CLASSPATH()).foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$populateClasspath$7$adapted(scala.collection.immutable.Set org.apache.spark.SparkConf scala.collection.mutable.HashMap java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((Set)cpSet, (SparkConf)sparkConf, env));
        this.addClasspathEntry(this.buildPath((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), this.LOCALIZED_CONF_DIR(), this.LOCALIZED_HADOOP_CONF_DIR()})), env);
    }

    public Option<String> populateClasspath$default$5() {
        return None$.MODULE$;
    }

    public URI[] getUserClasspath(SparkConf conf) {
        Option<URI> mainUri = this.getMainJarUri((Option<String>)((Option)conf.get(package$.MODULE$.APP_JAR())));
        Seq<URI> secondaryUris = this.getSecondaryJarUris((Option<Seq<String>>)((Option)conf.get(package$.MODULE$.SECONDARY_JARS())));
        return (URI[])((IterableOnceOps)Option$.MODULE$.option2Iterable(mainUri).$plus$plus(secondaryUris)).toArray(ClassTag$.MODULE$.apply(URI.class));
    }

    public URL[] getUserClasspathUrls(SparkConf conf, boolean useClusterPath) {
        return (URL[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.getUserClasspath(conf)), arg_0 -> Client$.$anonfun$getUserClasspathUrls$1(useClusterPath, conf, arg_0), ClassTag$.MODULE$.apply(URL.class));
    }

    private Option<URI> getMainJarUri(Option<String> mainJar) {
        return mainJar.flatMap((Function1 & Serializable)path -> {
            URI uri = Utils$.MODULE$.resolveURI(path);
            String string = uri.getScheme();
            String string2 = Utils$.MODULE$.LOCAL_SCHEME();
            return !(string != null ? !string.equals(string2) : string2 != null) ? new Some((Object)uri) : None$.MODULE$;
        }).orElse((Function0 & Serializable)() -> new Some((Object)new URI(MODULE$.APP_JAR_NAME())));
    }

    private Seq<URI> getSecondaryJarUris(Option<Seq<String>> secondaryJars) {
        return (Seq)((IterableOps)secondaryJars.getOrElse((Function0 & Serializable)() -> scala.package$.MODULE$.Nil())).map((Function1 & Serializable)x$21 -> new URI((String)x$21));
    }

    private void addFileToClasspath(SparkConf conf, Configuration hadoopConf, URI uri, String fileName, HashMap<String, String> env) {
        block1: {
            block2: {
                block0: {
                    if (uri == null) break block0;
                    String string = uri.getScheme();
                    String string2 = Utils$.MODULE$.LOCAL_SCHEME();
                    if (string != null ? !string.equals(string2) : string2 != null) break block0;
                    this.addClasspathEntry(this.getClusterPath(conf, uri.getPath()), env);
                    break block1;
                }
                if (fileName == null) break block2;
                this.addClasspathEntry(this.buildPath((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), fileName})), env);
                break block1;
            }
            if (uri == null) break block1;
            Path localPath = this.org$apache$spark$deploy$yarn$Client$$getQualifiedLocalPath(uri, hadoopConf);
            String linkName = (String)Option$.MODULE$.apply((Object)uri.getFragment()).getOrElse((Function0 & Serializable)() -> localPath.getName());
            this.addClasspathEntry(this.buildPath((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ApplicationConstants.Environment.PWD.$$(), linkName})), env);
        }
    }

    private void addClasspathEntry(String path, HashMap<String, String> env) {
        YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment(env, ApplicationConstants.Environment.CLASSPATH.name(), path);
    }

    public String getClusterPath(SparkConf conf, String path) {
        String localPath = (String)conf.get(package$.MODULE$.GATEWAY_ROOT_PATH());
        String clusterPath = (String)conf.get(package$.MODULE$.REPLACEMENT_ROOT_PATH());
        return localPath != null && clusterPath != null ? path.replace(localPath, clusterPath) : path;
    }

    public boolean compareUri(URI srcUri, URI dstUri) {
        block9: {
            block8: {
                if (srcUri.getScheme() == null) break block8;
                String string = srcUri.getScheme();
                String string2 = dstUri.getScheme();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block9;
            }
            return false;
        }
        String srcAuthority = srcUri.getAuthority();
        String dstAuthority = dstUri.getAuthority();
        if (srcAuthority != null && !srcAuthority.equalsIgnoreCase(dstAuthority)) {
            return false;
        }
        String srcHost = srcUri.getHost();
        String dstHost = dstUri.getHost();
        if (srcHost != null && dstHost != null) {
            String string = srcHost;
            String string3 = dstHost;
            if (string == null ? string3 != null : !string.equals(string3)) {
                try {
                    srcHost = InetAddress.getByName(srcHost).getCanonicalHostName();
                    dstHost = InetAddress.getByName(dstHost).getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    return false;
                }
            }
        }
        return Objects.equal((Object)srcHost, (Object)dstHost) && srcUri.getPort() == dstUri.getPort();
    }

    public boolean compareFs(FileSystem srcFs, FileSystem destFs) {
        URI srcUri = srcFs.getUri();
        URI dstUri = destFs.getUri();
        return this.compareUri(srcUri, dstUri);
    }

    public Path org$apache$spark$deploy$yarn$Client$$getQualifiedLocalPath(URI localURI, Configuration hadoopConf) {
        URI qualifiedURI = localURI.getScheme() == null ? new URI(FileSystem.getLocal((Configuration)hadoopConf).makeQualified(new Path(localURI)).toString()) : localURI;
        return new Path(qualifiedURI);
    }

    public boolean isUserClassPathFirst(SparkConf conf, boolean isDriver) {
        return isDriver ? BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_USER_CLASS_PATH_FIRST())) : BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_USER_CLASS_PATH_FIRST()));
    }

    public String buildPath(Seq<String> components) {
        return components.mkString("/");
    }

    public YarnAppReport createAppReport(ApplicationReport report) {
        String diags = report.getDiagnostics();
        None$ diagsOpt = diags != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(diags)) ? new Some((Object)diags) : None$.MODULE$;
        return new YarnAppReport(report.getYarnApplicationState(), report.getFinalApplicationStatus(), (Option<String>)diagsOpt);
    }

    public String createLibraryPathPrefix(String libpath, SparkConf conf) {
        String string;
        if (Utils$.MODULE$.isWindows()) {
            string = Utils$.MODULE$.libraryPathEnvPrefix((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{libpath})));
        } else {
            String envName = Utils$.MODULE$.libraryPathEnvName();
            String quoted = libpath.replace("\"", "\\\\\\\"");
            string = new StringBuilder(6).append(envName).append("=\\\"").append(quoted).append(File.pathSeparator).append("$").append(envName).append("\\\"").toString();
        }
        String cmdPrefix = string;
        return this.getClusterPath(conf, cmdPrefix);
    }

    /*
     * WARNING - void declaration
     */
    public Properties confToProperties(SparkConf conf) {
        void var2_2;
        Properties props = new Properties();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])conf.getAll()), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = props.setProperty(k, v);
            return object;
        });
        return var2_2;
    }

    public void writePropertiesToArchive(Properties props, String name, ZipOutputStream out) {
        out.putNextEntry(new ZipEntry(name));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
        props.store(writer, "Spark configuration.");
        writer.flush();
        out.closeEntry();
    }

    public static final /* synthetic */ void $anonfun$populateClasspath$6(SparkConf sparkConf$1, HashMap env$3, String jar) {
        URI uri = new URI(jar);
        MODULE$.addClasspathEntry(MODULE$.getClusterPath(sparkConf$1, uri.getPath()), (HashMap<String, String>)env$3);
    }

    public static final /* synthetic */ void $anonfun$populateClasspath$4(SparkConf sparkConf$1, HashMap env$3, Seq jars) {
        ((IterableOnceOps)jars.filter((Function1 & Serializable)uri -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.isLocalUri(uri)))).foreach((Function1 & Serializable)jar -> {
            Client$.$anonfun$populateClasspath$6(sparkConf$1, env$3, jar);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$populateClasspath$7(Set cpSet$1, SparkConf sparkConf$1, HashMap env$3, String cp) {
        String newCp = Utils$.MODULE$.isTesting() ? Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])cp.split(File.pathSeparator)), (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)cpSet$1.contains((Object)elem)))).mkString(File.pathSeparator) : cp;
        MODULE$.addClasspathEntry(MODULE$.getClusterPath(sparkConf$1, newCp), (HashMap<String, String>)env$3);
    }

    public static final /* synthetic */ String $anonfun$getUserClasspathUrls$2(URI uri$2) {
        return new StringBuilder(70).append("getUserClasspath should only return 'file' or 'local' URIs but found: ").append(uri$2).toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ URL $anonfun$getUserClasspathUrls$1(boolean useClusterPath$1, SparkConf conf$2, URI uri) {
        block3: {
            block2: {
                inputPath = uri.getPath();
                if (!Utils$.MODULE$.isLocalUri(uri.toString()) || !useClusterPath$1) break block2;
                v0 = Client$.MODULE$.getClusterPath(conf$2, inputPath);
                break block3;
            }
            if (uri.getScheme() == null) ** GOTO lbl-1000
            v1 = uri.getScheme();
            var5_4 = "file";
            if (!(v1 == null ? var5_4 != null : v1.equals(var5_4) == false) || Utils$.MODULE$.isLocalUri(uri.toString())) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            Predef$.MODULE$.assert(v2, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getUserClasspathUrls$2(java.net.URI ), ()Ljava/lang/String;)((URI)uri));
            v0 = inputPath;
        }
        replacedFilePath = v0;
        envVarResolvedFilePath = YarnSparkHadoopUtil$.MODULE$.replaceEnvVars(replacedFilePath, (Map<String, String>)scala.sys.package$.MODULE$.env(), YarnSparkHadoopUtil$.MODULE$.replaceEnvVars$default$3());
        return Paths.get(envVarResolvedFilePath, new String[0]).toAbsolutePath().toUri().toURL();
    }

    private Client$() {
    }

    public static final /* synthetic */ Object $anonfun$populateClasspath$1$adapted(SparkConf sparkConf$1, HashMap env$3, String cp) {
        Client$.MODULE$.addClasspathEntry(Client$.MODULE$.getClusterPath(sparkConf$1, cp), (HashMap<String, String>)env$3);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$populateClasspath$2$adapted(SparkConf sparkConf$1, Configuration conf$1, HashMap env$3, URI x$20) {
        Client$.MODULE$.addFileToClasspath(sparkConf$1, conf$1, x$20, Client$.MODULE$.APP_JAR_NAME(), (HashMap<String, String>)env$3);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$populateClasspath$3$adapted(SparkConf sparkConf$1, Configuration conf$1, HashMap env$3, URI x) {
        Client$.MODULE$.addFileToClasspath(sparkConf$1, conf$1, x, null, (HashMap<String, String>)env$3);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$populateClasspath$4$adapted(SparkConf sparkConf$1, HashMap env$3, Seq jars) {
        Client$.$anonfun$populateClasspath$4(sparkConf$1, env$3, jars);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$populateClasspath$7$adapted(Set cpSet$1, SparkConf sparkConf$1, HashMap env$3, String cp) {
        Client$.$anonfun$populateClasspath$7(cpSet$1, sparkConf$1, env$3, cp);
        return BoxedUnit.UNIT;
    }
}

