/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.io.Serializable;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class LogisticRegressionSummaryExample$ {
    public static final LogisticRegressionSummaryExample$ MODULE$ = new LogisticRegressionSummaryExample$();

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("LogisticRegressionSummaryExample").getOrCreate();
        Dataset training = spark.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        LogisticRegression lr = new LogisticRegression().setMaxIter(10).setRegParam(0.3).setElasticNetParam(0.8);
        LogisticRegressionModel lrModel = (LogisticRegressionModel)lr.fit(training);
        BinaryLogisticRegressionTrainingSummary trainingSummary = lrModel.binarySummary();
        double[] objectiveHistory = trainingSummary.objectiveHistory();
        Predef$.MODULE$.println((Object)"objectiveHistory:");
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(objectiveHistory), (Function1)(JFunction1.mcVD.sp & Serializable)loss -> Predef$.MODULE$.println((Object)BoxesRunTime.boxToDouble((double)loss)));
        Dataset roc = trainingSummary.roc();
        roc.show();
        Predef$.MODULE$.println((Object)new StringBuilder(14).append("areaUnderROC: ").append(trainingSummary.areaUnderROC()).toString());
        Dataset fMeasure = trainingSummary.fMeasureByThreshold();
        double maxFMeasure = ((Row)fMeasure.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max("F-Measure")})).head()).getDouble(0);
        double bestThreshold = ((Row)fMeasure.where(spark.implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"F-Measure"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)maxFMeasure))).select("threshold", (Seq)Nil$.MODULE$).head()).getDouble(0);
        lrModel.setThreshold(bestThreshold);
        spark.stop();
    }

    private LogisticRegressionSummaryExample$() {
    }
}

