/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.mllib.stat.test.BinarySample;
import org.apache.spark.mllib.stat.test.StreamingTest;
import org.apache.spark.mllib.stat.test.StreamingTestResult;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.Utils$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class StreamingTestExample$ {
    public static final StreamingTestExample$ MODULE$ = new StreamingTestExample$();

    public void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: StreamingTestExample <dataDir> <batchDuration> <numBatchesTimeout>");
            System.exit(1);
        }
        String dataDir = args[0];
        Duration batchDuration = Seconds$.MODULE$.apply(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(args[1])));
        int numBatchesTimeout = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[2]));
        SparkConf conf = new SparkConf().setMaster("local").setAppName("StreamingTestExample");
        StreamingContext ssc = new StreamingContext(conf, batchDuration);
        File dir = Utils$.MODULE$.createTempDir();
        ssc.checkpoint(dir.toString());
        DStream data = ssc.textFileStream(dataDir).map((Function1 & Serializable)line -> {
            Object object;
            String[] stringArray = line.split(",");
            if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
                throw new MatchError((Object)stringArray);
            }
            String label = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            String value = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
            BinarySample binarySample = new BinarySample(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(label)), StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(value)));
            return binarySample;
        }, ClassTag$.MODULE$.apply(BinarySample.class));
        StreamingTest streamingTest = new StreamingTest().setPeacePeriod(0).setWindowSize(0).setTestMethod("welch");
        DStream out = streamingTest.registerStream(data);
        out.print();
        IntRef timeoutCounter = IntRef.create((int)numBatchesTimeout);
        out.foreachRDD((Function1 & Serializable)rdd -> {
            StreamingTestExample$.$anonfun$main$2(timeoutCounter, rdd);
            return BoxedUnit.UNIT;
        });
        ssc.start();
        ssc.awaitTermination();
    }

    public static final /* synthetic */ boolean $anonfun$main$3(StreamingTestResult x$1) {
        return x$1.pValue() < 0.05;
    }

    public static final /* synthetic */ boolean $anonfun$main$4(boolean x$2, boolean x$3) {
        return x$2 || x$3;
    }

    public static final /* synthetic */ void $anonfun$main$2(IntRef timeoutCounter$1, RDD rdd) {
        block0: {
            --timeoutCounter$1.elem;
            boolean anySignificant = BoxesRunTime.unboxToBoolean((Object)rdd.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamingTestExample$.$anonfun$main$3(x$1)), (ClassTag)ClassTag$.MODULE$.Boolean()).fold((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable)(x$2, x$3) -> BoxesRunTime.boxToBoolean((boolean)StreamingTestExample$.$anonfun$main$4(BoxesRunTime.unboxToBoolean((Object)x$2), BoxesRunTime.unboxToBoolean((Object)x$3)))));
            if (timeoutCounter$1.elem != 0 && !anySignificant) break block0;
            rdd.context().stop();
        }
    }

    private StreamingTestExample$() {
    }
}

