/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.streaming.StreamingExamples$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StateSpec$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.MapWithStateDStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class StatefulNetworkWordCount$ {
    public static final StatefulNetworkWordCount$ MODULE$ = new StatefulNetworkWordCount$();

    public void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: StatefulNetworkWordCount <hostname> <port>");
            System.exit(1);
        }
        StreamingExamples$.MODULE$.setStreamingLogLevels();
        SparkConf sparkConf = new SparkConf().setAppName("StatefulNetworkWordCount");
        StreamingContext ssc = new StreamingContext(sparkConf, Seconds$.MODULE$.apply(1L));
        ssc.checkpoint(".");
        SparkContext qual$1 = ssc.sparkContext();
        List x$12 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"hello", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"world", (Object)BoxesRunTime.boxToInteger((int)1))}));
        int x$2 = qual$1.parallelize$default$2();
        RDD initialRDD = qual$1.parallelize((Seq)x$12, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
        ReceiverInputDStream lines = ssc.socketTextStream(args[0], StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[1])), ssc.socketTextStream$default$3());
        DStream words = lines.flatMap((Function1 & Serializable)x$1 -> Predef$.MODULE$.wrapRefArray((Object[])x$1.split(" ")), ClassTag$.MODULE$.apply(String.class));
        DStream wordDstream = words.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class));
        Function3 & Serializable mappingFunc = (Function3 & Serializable)(word, one, state) -> {
            int sum = BoxesRunTime.unboxToInt((Object)one.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + BoxesRunTime.unboxToInt((Object)state.getOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
            Tuple2 output = new Tuple2(word, (Object)BoxesRunTime.boxToInteger((int)sum));
            state.update((Object)BoxesRunTime.boxToInteger((int)sum));
            return output;
        };
        MapWithStateDStream stateDstream = DStream$.MODULE$.toPairDStreamFunctions(wordDstream, ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).mapWithState(StateSpec$.MODULE$.function((Function3)mappingFunc).initialState(initialRDD), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class));
        stateDstream.print();
        ssc.start();
        ssc.awaitTermination();
    }

    private StatefulNetworkWordCount$() {
    }
}

