/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.CompactibleFileStreamLog$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tEe!B\u0017/\u0003\u0003Y\u0004\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u0011Y\u0003!\u0011!Q\u0001\n]C\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tO\u0002\u0011\u0019\u0011)A\u0006Q\")a\u000e\u0001C\u0001_\"9a\u000f\u0001b\u0001\n\u00179\bbBA\u0011\u0001\u0001\u0006I\u0001\u001f\u0005\n\u0003G\u0001!\u0019!C\u0006\u0003KA\u0001\"!\f\u0001A\u0003%\u0011q\u0005\u0005\n\u0003_\u0001!\u0019!C\t\u0003cAq!a\r\u0001A\u0003%1\u000bC\u0004\u00026\u00011\t\"a\u000e\t\u000f\u0005}\u0002A\"\u0005\u0002B!9\u0011\u0011\n\u0001\u0007\u0012\u0005E\u0002BCA&\u0001!\u0015\r\u0011\"\u0006\u00022!9\u0011Q\n\u0001\u0005\u0002\u0005=\u0003bBA-\u0001\u0011\u0005\u00131\f\u0005\b\u0003c\u0002A\u0011IA:\u0011\u001d\t9\b\u0001C!\u0003sBq!! \u0001\t\u0013\ty\bC\u0004\u0002 \u0002!I!!)\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u0002*\"9\u0011\u0011\u0017\u0001\u0005B\u0005M\u0006bBA`\u0001\u0011\u0005\u0013\u0011\u0019\u0005\b\u0003\u0013\u0004A\u0011IAf\u0011\u001d\t\t\u000e\u0001C\u0001\u0003'Dq!a9\u0001\t\u0003\t)\u000fC\u0004\u0002x\u0002!I!!?\t\u000f\t\u0015\u0002\u0001\"\u0003\u0003(!9!Q\u0006\u0001\u0005\u0002\t=\u0002b\u0002B\u0019\u0001\u0011%!1G\u0004\b\u0005sq\u0003\u0012\u0001B\u001e\r\u0019ic\u0006#\u0001\u0003>!1a.\tC\u0001\u0005\u007fA\u0011B!\u0011\"\u0005\u0004%\tAa\u0011\t\u0011\t=\u0013\u0005)A\u0005\u0005\u000bB\u0011B!\u0015\"\u0005\u0004%\t!!\r\t\u000f\tM\u0013\u0005)A\u0005'\"9!QK\u0011\u0005\u0002\t]\u0003b\u0002B/C\u0011\u0005!q\f\u0005\b\u0005K\nC\u0011\u0001B4\u0011\u001d\u0011)(\tC\u0001\u0005oBqA! \"\t\u0003\u0011y\bC\u0004\u0003\u0006\u0006\"\tAa\"\u00031\r{W\u000e]1di&\u0014G.\u001a$jY\u0016\u001cFO]3b[2{wM\u0003\u00020a\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003cI\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005M\"\u0014aA:rY*\u0011QGN\u0001\u0006gB\f'o\u001b\u0006\u0003oa\na!\u00199bG\",'\"A\u001d\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005qJ5C\u0001\u0001>!\rqt(Q\u0007\u0002]%\u0011\u0001I\f\u0002\u0010\u0011\u001235+T3uC\u0012\fG/\u0019'pOB\u0019!)R$\u000e\u0003\rS\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u0013Q!\u0011:sCf\u0004\"\u0001S%\r\u0001\u0011)!\n\u0001b\u0001\u0017\n\tA+\u0005\u0002M\u001fB\u0011!)T\u0005\u0003\u001d\u000e\u0013qAT8uQ&tw\r\u0005\u0002C!&\u0011\u0011k\u0011\u0002\u0007\u0003:L(+\u001a4\u0002%5,G/\u00193bi\u0006dun\u001a,feNLwN\u001c\t\u0003\u0005RK!!V\"\u0003\u0007%sG/\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002Y36\t!'\u0003\u0002[e\ta1\u000b]1sWN+7o]5p]\u0006!\u0001/\u0019;i!\tiFM\u0004\u0002_EB\u0011qlQ\u0007\u0002A*\u0011\u0011MO\u0001\u0007yI|w\u000e\u001e \n\u0005\r\u001c\u0015A\u0002)sK\u0012,g-\u0003\u0002fM\n11\u000b\u001e:j]\u001eT!aY\"\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002jY\u001ek\u0011A\u001b\u0006\u0003W\u000e\u000bqA]3gY\u0016\u001cG/\u0003\u0002nU\nA1\t\\1tgR\u000bw-\u0001\u0004=S:LGO\u0010\u000b\u0005aN$X\u000f\u0006\u0002reB\u0019a\bA$\t\u000b\u001d,\u00019\u00015\t\u000bI+\u0001\u0019A*\t\u000bY+\u0001\u0019A,\t\u000bm+\u0001\u0019\u0001/\u0002\u000f\u0019|'/\\1ugV\t\u0001P\u0005\u0003z\u001f\u0006\u0005a\u0001\u0002>\u0001\u0001a\u0014A\u0002\u0010:fM&tW-\\3oizJ!A\u001e?\n\u0005ut(!D*fe&\fG.\u001b>bi&|gN\u0003\u0002\u0000q\u00051!n]8oiM\u0004B!a\u0001\u0002\u00065\ta0C\u0002\u0002\by\u0014qAR8s[\u0006$8\u000fC\u0005\u0002\fe\u0014\r\u0011\"\u0001\u0002\u000e\u0005QA-\u0019;f\r>\u0014X.\u0019;\u0016\u0005\u0005=\u0001\u0003BA\u0002\u0003#I1!a\u0005\u007f\u0005)!\u0015\r^3G_Jl\u0017\r\u001e\u0005\n\u0003/I(\u0019!C!\u00033\t\u0011\u0002^=qK\"Kg\u000e^:\u0016\u0005\u0005m\u0001\u0003BA\u0002\u0003;I1!a\b\u007f\u0005%!\u0016\u0010]3IS:$8/\u0001\u0005g_Jl\u0017\r^:!\u0003!i\u0017M\\5gKN$XCAA\u0014!\u0011I\u0017\u0011F$\n\u0007\u0005-\"N\u0001\u0005NC:Lg-Z:u\u0003%i\u0017M\\5gKN$\b%\u0001\nnS:\u0014\u0015\r^2iKN$vNU3uC&tW#A*\u0002'5LgNQ1uG\",7\u000fV8SKR\f\u0017N\u001c\u0011\u0002%\u0019LG.Z\"mK\u0006tW\u000f\u001d#fY\u0006LXj]\u000b\u0003\u0003s\u00012AQA\u001e\u0013\r\tid\u0011\u0002\u0005\u0019>tw-\u0001\u000bjg\u0012+G.\u001a;j]\u001e,\u0005\u0010]5sK\u0012dunZ\u000b\u0003\u0003\u0007\u00022AQA#\u0013\r\t9e\u0011\u0002\b\u0005>|G.Z1o\u0003Y!WMZ1vYR\u001cu.\u001c9bGRLe\u000e^3sm\u0006d\u0017aD2p[B\f7\r^%oi\u0016\u0014h/\u00197\u0002\u0019MDw.\u001e7e%\u0016$\u0018-\u001b8\u0015\r\u0005\r\u0013\u0011KA+\u0011\u0019\t\u0019\u0006\u0005a\u0001\u000f\u0006\u0019An\\4\t\u000f\u0005]\u0003\u00031\u0001\u0002:\u0005Y1-\u001e:sK:$H+[7f\u00035\u0011\u0017\r^2i\u0013\u0012$v\u000eU1uQR!\u0011QLA7!\u0011\ty&!\u001b\u000e\u0005\u0005\u0005$\u0002BA2\u0003K\n!AZ:\u000b\u0007\u0005\u001dd'\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003W\n\tG\u0001\u0003QCRD\u0007bBA8#\u0001\u0007\u0011\u0011H\u0001\bE\u0006$8\r[%e\u00035\u0001\u0018\r\u001e5U_\n\u000bGo\u00195JIR!\u0011\u0011HA;\u0011\u0019Y&\u00031\u0001\u0002^\u0005Y\u0011n\u001d\"bi\u000eDg)\u001b7f)\u0011\t\u0019%a\u001f\t\rm\u001b\u0002\u0019AA/\u00039\u0019XM]5bY&TX-\u00128uef$b!!!\u0002\b\u0006-\u0005c\u0001\"\u0002\u0004&\u0019\u0011QQ\"\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u0013#\u0002\u0019A$\u0002\u000b\u0015tGO]=\t\u000f\u00055E\u00031\u0001\u0002\u0010\u0006\u0019q.\u001e;\u0011\t\u0005E\u00151T\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006\u0011\u0011n\u001c\u0006\u0003\u00033\u000bAA[1wC&!\u0011QTAJ\u00051yU\u000f\u001e9viN#(/Z1n\u0003A!Wm]3sS\u0006d\u0017N_3F]R\u0014\u0018\u0010F\u0002H\u0003GCa!!*\u0016\u0001\u0004a\u0016\u0001\u00027j]\u0016\f\u0011b]3sS\u0006d\u0017N_3\u0015\r\u0005\u0005\u00151VAX\u0011\u0019\tiK\u0006a\u0001\u0003\u00069An\\4ECR\f\u0007bBAG-\u0001\u0007\u0011qR\u0001\fI\u0016\u001cXM]5bY&TX\rF\u0002B\u0003kCq!a.\u0018\u0001\u0004\tI,\u0001\u0002j]B!\u0011\u0011SA^\u0013\u0011\ti,a%\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0004C\u0012$GCBA\"\u0003\u0007\f)\rC\u0004\u0002pa\u0001\r!!\u000f\t\r\u0005\u001d\u0007\u00041\u0001B\u0003\u0011awnZ:\u0002\u000bA,(oZ3\u0015\t\u0005\u0005\u0015Q\u001a\u0005\b\u0003\u001fL\u0002\u0019AA\u001d\u0003A!\bN]3tQ>dGMQ1uG\"LE-\u0001\bg_J,\u0017m\u00195J]\n\u000bGo\u00195\u0015\t\u0005U\u0017\u0011\u001d\u000b\u0005\u0003\u0003\u000b9\u000eC\u0004\u0002Zj\u0001\r!a7\u0002\u0005\u0019t\u0007C\u0002\"\u0002^\u001e\u000b\t)C\u0002\u0002`\u000e\u0013\u0011BR;oGRLwN\\\u0019\t\u000f\u0005=$\u00041\u0001\u0002:\u0005ia-\u001b7uKJLeNQ1uG\"$B!a:\u0002vR!\u0011\u0011^Ax!\u0011\u0011\u00151^!\n\u0007\u000558I\u0001\u0004PaRLwN\u001c\u0005\b\u0003c\\\u0002\u0019AAz\u0003%\u0001(/\u001a3jG\u0006$X\r\u0005\u0004C\u0003;<\u00151\t\u0005\b\u0003_Z\u0002\u0019AA\u001d\u00039\t\u0007\u000f\u001d7z\r:LeNQ1uG\",B!a?\u0003\u0002Q!\u0011Q B\u0012)\u0011\tyP!\u0004\u0011\u0007!\u0013\t\u0001B\u0004\u0003\u0004q\u0011\rA!\u0002\u0003\u0007I+E+E\u0002M\u0005\u000f\u00012A\u0011B\u0005\u0013\r\u0011Ya\u0011\u0002\u0004\u0003:L\bbBAm9\u0001\u0007!q\u0002\t\b\u0005\u0006u'\u0011CA\u0000!\u0015\u0011\u0019B!\bH\u001d\u0011\u0011)B!\u0007\u000f\u0007}\u00139\"C\u0001E\u0013\r\u0011YbQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yB!\t\u0003\u0011%#XM]1u_JT1Aa\u0007D\u0011\u001d\ty\u0007\ba\u0001\u0003s\tqaY8na\u0006\u001cG\u000f\u0006\u0004\u0002D\t%\"1\u0006\u0005\b\u0003_j\u0002\u0019AA\u001d\u0011\u0019\t9-\ba\u0001\u0003\u0006A\u0011\r\u001c7GS2,7\u000fF\u0001B\u0003A!W\r\\3uK\u0016C\b/\u001b:fI2{w\r\u0006\u0003\u0002\u0002\nU\u0002b\u0002B\u001c?\u0001\u0007\u0011\u0011H\u0001\u000fGV\u0014(/\u001a8u\u0005\u0006$8\r[%e\u0003a\u0019u.\u001c9bGRL'\r\\3GS2,7\u000b\u001e:fC6dun\u001a\t\u0003}\u0005\u001a\"!I(\u0015\u0005\tm\u0012aE\"P\u001bB\u000b5\tV0G\u00132+ulU+G\r&CVC\u0001B#!\u0011\u00119E!\u0014\u000e\u0005\t%#\u0002\u0002B&\u0003/\u000bA\u0001\\1oO&\u0019QM!\u0013\u0002)\r{U\nU!D)~3\u0015\nT#`'V3e)\u0013-!\u0003\u0005\u001au*\u0014)B\u0007R{F*\u0011+F\u001d\u000eKvlV!S\u001d~#\u0006JU#T\u0011>cEiX'T\u0003\t\u001au*\u0014)B\u0007R{F*\u0011+F\u001d\u000eKvlV!S\u001d~#\u0006JU#T\u0011>cEiX'TA\u00051r-\u001a;CCR\u001c\u0007.\u00133Ge>lg)\u001b7f\u001d\u0006lW\r\u0006\u0003\u0002:\te\u0003B\u0002B.O\u0001\u0007A,\u0001\u0005gS2,g*Y7f\u0003EI7oQ8na\u0006\u001cG/[8o\u0005\u0006$8\r\u001b\u000b\u0007\u0003\u0007\u0012\tGa\u0019\t\u000f\u0005=\u0004\u00061\u0001\u0002:!1\u00111\n\u0015A\u0002M\u000bAeZ3u-\u0006d\u0017\u000e\u001a\"bi\u000eDWm\u001d\"fM>\u0014XmQ8na\u0006\u001cG/[8o\u0005\u0006$8\r\u001b\u000b\u0007\u0005S\u0012yGa\u001d\u0011\r\tM!1NA\u001d\u0013\u0011\u0011iG!\t\u0003\u0007M+\u0017\u000fC\u0004\u0003r%\u0002\r!!\u000f\u0002#\r|W\u000e]1di&|gNQ1uG\"LE\r\u0003\u0004\u0002L%\u0002\raU\u0001\u0013O\u0016$\u0018\t\u001c7WC2LGMQ1uG\",7\u000f\u0006\u0004\u0003j\te$1\u0010\u0005\b\u0003_R\u0003\u0019AA\u001d\u0011\u001d\tYE\u000ba\u0001\u0003s\tQC\\3yi\u000e{W\u000e]1di&|gNQ1uG\"LE\r\u0006\u0004\u0002:\t\u0005%1\u0011\u0005\b\u0003_Z\u0003\u0019AA\u001d\u0011\u001d\tYe\u000ba\u0001\u0003s\tQ\u0003Z3sSZ,7i\\7qC\u000e$\u0018J\u001c;feZ\fG\u000eF\u0003T\u0005\u0013\u0013i\t\u0003\u0004\u0003\f2\u0002\raU\u0001\u0010I\u00164\u0017-\u001e7u\u0013:$XM\u001d<bY\"1!q\u0012\u0017A\u0002M\u000bA\u0003\\1uKN$8i\\7qC\u000e$()\u0019;dQ&#\u0007")
public abstract class CompactibleFileStreamLog<T>
extends HDFSMetadataLog<T[]> {
    private int compactInterval;
    private final int metadataLogVersion;
    private final Formats formats;
    private final Manifest<T> manifest;
    private final int minBatchesToRetain;
    private volatile boolean bitmap$0;

    public static int deriveCompactInterval(int defaultInterval, int latestCompactBatchId) {
        return CompactibleFileStreamLog$.MODULE$.deriveCompactInterval(defaultInterval, latestCompactBatchId);
    }

    public static long nextCompactionBatchId(long batchId, long compactInterval) {
        return CompactibleFileStreamLog$.MODULE$.nextCompactionBatchId(batchId, compactInterval);
    }

    public static Seq<Object> getAllValidBatches(long batchId, long compactInterval) {
        return CompactibleFileStreamLog$.MODULE$.getAllValidBatches(batchId, compactInterval);
    }

    public static Seq<Object> getValidBatchesBeforeCompactionBatch(long compactionBatchId, int compactInterval) {
        return CompactibleFileStreamLog$.MODULE$.getValidBatchesBeforeCompactionBatch(compactionBatchId, compactInterval);
    }

    public static boolean isCompactionBatch(long batchId, int compactInterval) {
        return CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, compactInterval);
    }

    public static long getBatchIdFromFileName(String fileName) {
        return CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(fileName);
    }

    public static int COMPACT_LATENCY_WARN_THRESHOLD_MS() {
        return CompactibleFileStreamLog$.MODULE$.COMPACT_LATENCY_WARN_THRESHOLD_MS();
    }

    public static String COMPACT_FILE_SUFFIX() {
        return CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX();
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public int minBatchesToRetain() {
        return this.minBatchesToRetain;
    }

    public abstract long fileCleanupDelayMs();

    public abstract boolean isDeletingExpiredLog();

    public abstract int defaultCompactInterval();

    private int compactInterval$lzycompute() {
        CompactibleFileStreamLog compactibleFileStreamLog = this;
        synchronized (compactibleFileStreamLog) {
            if (!this.bitmap$0) {
                long[] compactibleBatchIds = (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CompactibleFileStreamLog.$anonfun$compactInterval$1(f)))), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (ClassTag)ClassTag$.MODULE$.Long())), Ordering.Long$.MODULE$.reverse());
                IntRef interval = IntRef.create((int)this.defaultCompactInterval());
                if (compactibleBatchIds.length >= 2) {
                    long latestCompactBatchId = compactibleBatchIds[0];
                    long previousCompactBatchId = compactibleBatchIds[1];
                    interval.elem = (int)(latestCompactBatchId - previousCompactBatchId);
                } else if (compactibleBatchIds.length == 1) {
                    interval.elem = CompactibleFileStreamLog$.MODULE$.deriveCompactInterval(this.defaultCompactInterval(), (int)compactibleBatchIds[0]);
                }
                Predef$.MODULE$.assert(interval.elem > 0, (Function0 & Serializable)() -> new StringBuilder(36).append("intervalValue = ").append(interval$1.elem).append(" not positive value.").toString());
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(29).append("Set the compact interval to ").append(interval$1.elem).append(" ").toString()).append(new StringBuilder(26).append("[defaultCompactInterval: ").append(this.defaultCompactInterval()).append("]").toString()).toString());
                this.compactInterval = interval.elem;
                this.bitmap$0 = true;
            }
        }
        return this.compactInterval;
    }

    public final int compactInterval() {
        return !this.bitmap$0 ? this.compactInterval$lzycompute() : this.compactInterval;
    }

    public boolean shouldRetain(T log, long currentTime) {
        return true;
    }

    @Override
    public Path batchIdToPath(long batchId) {
        return CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, this.compactInterval()) ? new Path(this.metadataPath(), new StringBuilder(0).append(batchId).append(CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX()).toString()) : new Path(this.metadataPath(), Long.toString(batchId));
    }

    @Override
    public long pathToBatchId(Path path) {
        return CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
    }

    @Override
    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    private void serializeEntry(T entry, OutputStream out) {
        out.write(Serialization$.MODULE$.write(entry, this.formats()).getBytes(StandardCharsets.UTF_8));
    }

    private T deserializeEntry(String line) {
        return (T)Serialization$.MODULE$.read(line, this.formats(), this.manifest());
    }

    @Override
    public void serialize(T[] logData, OutputStream out) {
        out.write(new StringBuilder(1).append("v").append(this.metadataLogVersion).toString().getBytes(StandardCharsets.UTF_8));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])logData), (Function1 & Serializable)data -> {
            CompactibleFileStreamLog.$anonfun$serialize$1(this, out, data);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public T[] deserialize(InputStream in) {
        Iterator lines = Source$.MODULE$.fromInputStream(in, StandardCharsets.UTF_8.name()).getLines();
        if (!lines.hasNext()) {
            throw new IllegalStateException("Incomplete log file");
        }
        this.validateVersion((String)lines.next(), this.metadataLogVersion);
        return (Object[])lines.map((Function1 & Serializable)line -> this.deserializeEntry((String)line)).toArray(this.manifest());
    }

    @Override
    public boolean add(long batchId, T[] logs) {
        boolean batchAdded;
        block0: {
            boolean bl = batchAdded = CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, this.compactInterval()) ? this.compact(batchId, logs) : super.add(batchId, logs);
            if (!batchAdded || !this.isDeletingExpiredLog()) break block0;
            this.deleteExpiredLog(batchId);
        }
        return batchAdded;
    }

    @Override
    public void purge(long thresholdBatchId) {
        throw QueryExecutionErrors$.MODULE$.cannotPurgeAsBreakInternalStateError();
    }

    public void foreachInBatch(long batchId, Function1<T, BoxedUnit> fn) {
        this.applyFnInBatch(batchId, (Function1 & Serializable)x$1 -> {
            x$1.foreach(fn);
            return BoxedUnit.UNIT;
        });
    }

    public Option<T[]> filterInBatch(long batchId, Function1<T, Object> predicate) {
        Some some;
        try {
            some = new Some(this.applyFnInBatch(batchId, (Function1 & Serializable)x$2 -> (Object[])x$2.filter(predicate).toArray(this.manifest())));
        }
        catch (FileNotFoundException fileNotFoundException) {
            some = None$.MODULE$;
        }
        return some;
    }

    private <RET> RET applyFnInBatch(long batchId, Function1<Iterator<T>, RET> fn) {
        return this.applyFnToBatchByStream(batchId, this.applyFnToBatchByStream$default$2(), (Function1 & Serializable)input -> {
            Iterator lines = Source$.MODULE$.fromInputStream(input, StandardCharsets.UTF_8.name()).getLines();
            if (!lines.hasNext()) {
                throw new IllegalStateException("Incomplete log file");
            }
            this.validateVersion((String)lines.next(), $this.metadataLogVersion);
            return fn.apply((Object)lines.map((Function1 & Serializable)line -> this.deserializeEntry((String)line)));
        });
    }

    private boolean compact(long batchId, T[] logs) {
        long curTime = System.currentTimeMillis();
        Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0)(JFunction0.mcZ.sp & Serializable)() -> this.addNewBatchByStream(batchId, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable)output -> {
            CompactibleFileStreamLog.$anonfun$compact$2(this, batchId, logs, curTime, output);
            return BoxedUnit.UNIT;
        }));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean writeSucceed = tuple2._1$mcZ$sp();
        long elapsedMs = tuple2._2$mcJ$sp();
        Tuple2.mcZJ.sp sp2 = new Tuple2.mcZJ.sp(writeSucceed, elapsedMs);
        Tuple2.mcZJ.sp sp3 = sp2;
        boolean writeSucceed2 = sp3._1$mcZ$sp();
        long elapsedMs2 = sp3._2$mcJ$sp();
        if (elapsedMs2 >= (long)CompactibleFileStreamLog$.MODULE$.COMPACT_LATENCY_WARN_THRESHOLD_MS()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Compacting took ").append(elapsedMs2).append(" ms for compact batch ").append(batchId).toString());
        } else {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Compacting took ").append(elapsedMs2).append(" ms for compact batch ").append(batchId).toString());
        }
        return writeSucceed2;
    }

    public T[] allFiles() {
        long curTime = System.currentTimeMillis();
        LongRef latestId = LongRef.create((long)BoxesRunTime.unboxToLong((Object)this.getLatestBatchId().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
        while (latestId.elem >= 0L) {
            try {
                Seq logs = (Seq)CompactibleFileStreamLog$.MODULE$.getAllValidBatches(latestId.elem, this.compactInterval()).flatMap((Function1 & Serializable)id -> Predef$.MODULE$.wrapRefArray((Object[])this.filterInBatch(BoxesRunTime.unboxToLong((Object)id), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)$this.shouldRetain(x$4, curTime$2))).getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(15).append($this.batchIdToPath(id)).append(" doesn't exist ").toString()).append(new StringBuilder(31).append("(latestId: ").append(latestId$1.elem).append(", compactInterval: ").append($this.compactInterval()).append(")").toString()).toString());
                })));
                return (Object[])logs.toArray(this.manifest());
            }
            catch (IOException e) {
                long expectedMinLatestId = CompactibleFileStreamLog$.MODULE$.nextCompactionBatchId(latestId.elem, this.compactInterval());
                latestId.elem = BoxesRunTime.unboxToLong((Object)super.getLatestBatchId().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
                if (latestId.elem >= expectedMinLatestId) continue;
                throw e;
            }
        }
        return (Object[])Array$.MODULE$.empty(this.manifest());
    }

    private void deleteExpiredLog(long currentBatchId) {
        block0: {
            if ((long)this.compactInterval() > currentBatchId + 1L - (long)this.minBatchesToRetain()) break block0;
            long minBatchId = currentBatchId + 1L - (long)this.minBatchesToRetain();
            long minCompactionBatchId = minBatchId - minBatchId % (long)this.compactInterval() - 1L;
            Predef$.MODULE$.assert(CompactibleFileStreamLog$.MODULE$.isCompactionBatch(minCompactionBatchId, this.compactInterval()), (Function0 & Serializable)() -> new StringBuilder(26).append(minCompactionBatchId).append(" is not a compaction batch").toString());
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(28).append("Current compact batch id = ").append(currentBatchId).append(" ").toString()).append(new StringBuilder(36).append("min compaction batch id to delete = ").append(minCompactionBatchId).toString()).toString());
            long expiredTime = System.currentTimeMillis() - this.fileCleanupDelayMs();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), path -> {
                boolean bl;
                block3: {
                    try {
                        long batchId = CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
                        if (batchId < minCompactionBatchId) {
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                }
                return bl;
            })), (Function1 & Serializable)f -> {
                CompactibleFileStreamLog.$anonfun$deleteExpiredLog$4(this, expiredTime, f);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$compactInterval$1(FileStatus f) {
        return f.getPath().toString().endsWith(CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX());
    }

    public static final /* synthetic */ void $anonfun$serialize$1(CompactibleFileStreamLog $this, OutputStream out$1, Object data) {
        out$1.write(10);
        $this.serializeEntry(data, out$1);
    }

    private final void writeEntry$1(Object entry, OutputStream output, long curTime$1) {
        block0: {
            if (!this.shouldRetain(entry, curTime$1)) break block0;
            output.write(10);
            this.serializeEntry(entry, output);
        }
    }

    public static final /* synthetic */ void $anonfun$compact$2(CompactibleFileStreamLog $this, long batchId$1, Object[] logs$1, long curTime$1, OutputStream output) {
        output.write(new StringBuilder(1).append("v").append($this.metadataLogVersion).toString().getBytes(StandardCharsets.UTF_8));
        Seq<Object> validBatches = CompactibleFileStreamLog$.MODULE$.getValidBatchesBeforeCompactionBatch(batchId$1, $this.compactInterval());
        validBatches.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)id -> $this.foreachInBatch(id, (Function1 & Serializable)entry -> {
            $this.writeEntry$1(entry, output, curTime$1);
            return BoxedUnit.UNIT;
        }));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(logs$1), (Function1 & Serializable)entry -> {
            $this.writeEntry$1(entry, output, curTime$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$deleteExpiredLog$4(CompactibleFileStreamLog $this, long expiredTime$1, FileStatus f) {
        block0: {
            if (f.getModificationTime() > expiredTime$1) break block0;
            $this.fileManager().delete(f.getPath());
        }
    }

    public CompactibleFileStreamLog(int metadataLogVersion, SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.metadataLogVersion = metadataLogVersion;
        super(sparkSession, path, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$1.runtimeClass())));
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        this.minBatchesToRetain = sparkSession.sessionState().conf().minBatchesToRetain();
    }
}

