/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.WrappedString;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class CSVExprUtils$ {
    public static final CSVExprUtils$ MODULE$ = new CSVExprUtils$();

    public Iterator<String> filterCommentAndEmpty(Iterator<String> iter, CSVOptions options) {
        Iterator iterator;
        if (options.isCommentSet()) {
            String commentPrefix = Character.toString(options.comment());
            iterator = iter.filter((Function1 & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)CSVExprUtils$.$anonfun$filterCommentAndEmpty$1(commentPrefix, line)));
        } else {
            iterator = iter.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$1.trim()))));
        }
        return iterator;
    }

    public Iterator<String> skipComments(Iterator<String> iter, CSVOptions options) {
        Iterator iterator;
        if (options.isCommentSet()) {
            String commentPrefix = Character.toString(options.comment());
            iterator = iter.dropWhile((Function1 & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)CSVExprUtils$.$anonfun$skipComments$1(commentPrefix, line)));
        } else {
            iterator = iter.dropWhile((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CSVExprUtils$.$anonfun$skipComments$2(x$2)));
        }
        return iterator;
    }

    public Option<String> extractHeader(Iterator<String> iter, CSVOptions options) {
        Iterator<String> nonEmptyLines = this.skipComments(iter, options);
        return nonEmptyLines.hasNext() ? new Some(nonEmptyLines.next()) : None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public char toChar(String str) throws IllegalArgumentException {
        SeqOps seqOps;
        SeqOps seqOps2;
        SeqOps seqOps3;
        SeqOps seqOps4;
        SeqOps seqOps5;
        SeqOps seqOps6;
        SeqOps seqOps7;
        SeqOps seqOps8;
        char c;
        SeqOps seqOps9;
        SeqOps seqOps10;
        WrappedString wrappedString = Predef$.MODULE$.wrapString(str);
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps10 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps10)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps10), 0) == 0) {
            throw new IllegalArgumentException("Delimiter cannot be empty string");
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps9 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps9)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps9), 1) == 0 && '\\' == (c = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps9), 0)))) {
            throw new IllegalArgumentException("Single backslash is prohibited. It has special meaning as beginning of an escape sequence. To get the backslash character, pass a string with two backslashes as the delimiter.");
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps8 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 1) == 0) {
            int c2 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 0));
            return (char)c2;
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps7 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 2) == 0) {
            char c3 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 0));
            char c4 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 1));
            if ('\\' == c3 && 't' == c4) {
                return (char)9;
            }
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps6 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 2) == 0) {
            char c5 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 0));
            char c6 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 1));
            if ('\\' == c5 && 'r' == c6) {
                return (char)13;
            }
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps5 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 2) == 0) {
            char c7 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 0));
            char c8 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 1));
            if ('\\' == c7 && 'b' == c8) {
                return (char)8;
            }
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 2) == 0) {
            char c9 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0));
            char c10 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1));
            if ('\\' == c9 && 'f' == c10) {
                return (char)12;
            }
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 2) == 0) {
            char c11 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0));
            char c12 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1));
            if ('\\' == c11 && '\"' == c12) {
                return (char)34;
            }
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) == 0) {
            char c13 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0));
            char c14 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1));
            if ('\\' == c13 && '\'' == c14) {
                return (char)39;
            }
        }
        if (wrappedString != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            char c15 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0));
            char c16 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1));
            if ('\\' == c15 && '\\' == c16) {
                return (char)92;
            }
        }
        String string = str;
        String string2 = "\u0000";
        if (string == null) {
            if (string2 == null) return (char)0;
        } else if (string.equals(string2)) {
            return (char)0;
        }
        if (wrappedString == null) throw new IllegalArgumentException(new StringBuilder(45).append("Delimiter cannot be more than one character: ").append(str).toString());
        SeqOps seqOps11 = package$.MODULE$.Seq().unapplySeq((SeqOps)wrappedString);
        if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps11)) throw new IllegalArgumentException(new StringBuilder(45).append("Delimiter cannot be more than one character: ").append(str).toString());
        if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps11)) == null) throw new IllegalArgumentException(new StringBuilder(45).append("Delimiter cannot be more than one character: ").append(str).toString());
        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps11), 2) != 0) throw new IllegalArgumentException(new StringBuilder(45).append("Delimiter cannot be more than one character: ").append(str).toString());
        char c17 = BoxesRunTime.unboxToChar((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps11), 0));
        if ('\\' != c17) throw new IllegalArgumentException(new StringBuilder(45).append("Delimiter cannot be more than one character: ").append(str).toString());
        throw new IllegalArgumentException(new StringBuilder(45).append("Unsupported special character for delimiter: ").append(str).toString());
    }

    public String toDelimiterStr(String str) {
        String chunk;
        String delimiter = "";
        for (int idx = 0; idx < str.length(); idx += chunk.length()) {
            int readAhead = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), idx) == '\\' ? 2 : 1;
            chunk = StringUtils.substring((String)str, (int)idx, (int)(idx + readAhead));
            delimiter = new StringBuilder(0).append(delimiter).append(this.toChar(chunk)).toString();
        }
        return StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(delimiter), "");
    }

    public static final /* synthetic */ boolean $anonfun$filterCommentAndEmpty$1(String commentPrefix$1, String line) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(line.trim())) && !line.startsWith(commentPrefix$1);
    }

    public static final /* synthetic */ boolean $anonfun$skipComments$1(String commentPrefix$2, String line) {
        return line.trim().isEmpty() || line.startsWith(commentPrefix$2);
    }

    public static final /* synthetic */ boolean $anonfun$skipComments$2(String x$2) {
        return x$2.trim().isEmpty();
    }

    private CSVExprUtils$() {
    }
}

