/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RLike$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, regexp) - Returns true if `str` matches `regexp`, or false otherwise.", arguments="\n    Arguments:\n      * str - a string expression\n      * regexp - a string expression. The regex string should be a Java regular expression.\n\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".\n\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n  ", examples="\n    Examples:\n      > SET spark.sql.parser.escapedStringLiterals=true;\n      spark.sql.parser.escapedStringLiterals\ttrue\n      > SELECT _FUNC_('%SystemDrive%\\Users\\John', '%SystemDrive%\\\\Users.*');\n      true\n      > SET spark.sql.parser.escapedStringLiterals=false;\n      spark.sql.parser.escapedStringLiterals\tfalse\n      > SELECT _FUNC_('%SystemDrive%\\\\Users\\\\John', '%SystemDrive%\\\\\\\\Users.*');\n      true\n  ", note="\n    Use LIKE to match with simple string pattern.\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001dh\u0001B\u000f\u001f\u0001.B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\t\"A\u0001\n\u0001BK\u0002\u0013\u00051\t\u0003\u0005J\u0001\tE\t\u0015!\u0003E\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015i\u0007\u0001\"\u0011o\u0011\u0015\u0019\u0003\u0001\"\u0011p\u0011\u0015\u0001\b\u0001\"\u0015r\u0011\u0019y\b\u0001\"\u0015\u0002\u0002!I\u00111\u0002\u0001\u0002\u0002\u0013\u0005\u0011Q\u0002\u0005\n\u0003'\u0001\u0011\u0013!C\u0001\u0003+A\u0011\"a\u000b\u0001#\u0003%\t!!\u0006\t\u0013\u00055\u0002!!A\u0005B\u0005=\u0002\"CA\u001e\u0001\u0005\u0005I\u0011AA\u001f\u0011%\t)\u0005AA\u0001\n\u0003\t9\u0005C\u0005\u0002T\u0001\t\t\u0011\"\u0011\u0002V!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003S\u0002\u0011\u0011!C!\u0003WB\u0011\"a\u001c\u0001\u0003\u0003%\t%!\u001d\b\u0013\u0005\u0005f$!A\t\u0002\u0005\rf\u0001C\u000f\u001f\u0003\u0003E\t!!*\t\r);B\u0011AA_\u0011!iw#!A\u0005F\u0005}\u0006\"CAa/\u0005\u0005I\u0011QAb\u0011%\tImFA\u0001\n\u0003\u000bY\rC\u0005\u0002^^\t\t\u0011\"\u0003\u0002`\n)!\u000bT5lK*\u0011q\u0004I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\"E\u0005A1-\u0019;bYf\u001cHO\u0003\u0002$I\u0005\u00191/\u001d7\u000b\u0005\u00152\u0013!B:qCJ\\'BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001YA2\u0004CA\u0017/\u001b\u0005q\u0012BA\u0018\u001f\u0005U\u0019FO]5oOJ+w-\u001a=FqB\u0014Xm]:j_:\u0004\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00028\u007f9\u0011\u0001(\u0010\b\u0003sqj\u0011A\u000f\u0006\u0003w)\na\u0001\u0010:p_Rt\u0014\"A\u001a\n\u0005y\u0012\u0014a\u00029bG.\fw-Z\u0005\u0003\u0001\u0006\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0010\u001a\u0002\t1,g\r^\u000b\u0002\tB\u0011Q&R\u0005\u0003\rz\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2\u0001T'O!\ti\u0003\u0001C\u0003C\u000b\u0001\u0007A\tC\u0003I\u000b\u0001\u0007A)\u0001\u0004fg\u000e\f\u0007/\u001a\u000b\u0003#f\u0003\"A\u0015,\u000f\u0005M#\u0006CA\u001d3\u0013\t)&'\u0001\u0004Qe\u0016$WMZ\u0005\u0003/b\u0013aa\u0015;sS:<'BA+3\u0011\u0015Qf\u00011\u0001R\u0003\u00051\u0018aB7bi\u000eDWm\u001d\u000b\u0004;\u0002\\\u0007CA\u0019_\u0013\ty&GA\u0004C_>dW-\u00198\t\u000b\u0005<\u0001\u0019\u00012\u0002\u000bI,w-\u001a=\u0011\u0005\rLW\"\u00013\u000b\u0005\u0005,'B\u00014h\u0003\u0011)H/\u001b7\u000b\u0003!\fAA[1wC&\u0011!\u000e\u001a\u0002\b!\u0006$H/\u001a:o\u0011\u0015aw\u00011\u0001R\u0003\r\u0019HO]\u0001\ti>\u001cFO]5oOR\t\u0011+F\u0001R\u0003%!wnR3o\u0007>$W\rF\u0002sqv\u0004\"a\u001d<\u000e\u0003QT!!\u001e\u0010\u0002\u000f\r|G-Z4f]&\u0011q\u000f\u001e\u0002\t\u000bb\u0004(oQ8eK\")\u0011P\u0003a\u0001u\u0006\u00191\r\u001e=\u0011\u0005M\\\u0018B\u0001?u\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQA \u0006A\u0002I\f!!\u001a<\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#\u0002'\u0002\u0004\u0005\u001d\u0001BBA\u0003\u0017\u0001\u0007A)A\u0004oK^dUM\u001a;\t\r\u0005%1\u00021\u0001E\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$R\u0001TA\b\u0003#AqA\u0011\u0007\u0011\u0002\u0003\u0007A\tC\u0004I\u0019A\u0005\t\u0019\u0001#\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0003\u0016\u0004\t\u0006e1FAA\u000e!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015\"'\u0001\u0006b]:|G/\u0019;j_:LA!!\u000b\u0002 \t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\r\u0011\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000eh\u0003\u0011a\u0017M\\4\n\u0007]\u000b)$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002@A\u0019\u0011'!\u0011\n\u0007\u0005\r#GA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002J\u0005=\u0003cA\u0019\u0002L%\u0019\u0011Q\n\u001a\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002RE\t\t\u00111\u0001\u0002@\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0016\u0011\r\u0005e\u0013qLA%\u001b\t\tYFC\u0002\u0002^I\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t'a\u0017\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004;\u0006\u001d\u0004\"CA)'\u0005\u0005\t\u0019AA%\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005E\u0012Q\u000e\u0005\n\u0003#\"\u0012\u0011!a\u0001\u0003\u007f\ta!Z9vC2\u001cHcA/\u0002t!I\u0011\u0011K\u000b\u0002\u0002\u0003\u0007\u0011\u0011\n\u0015\u001c\u0001\u0005]\u0014QPA@\u0003\u0007\u000b))!#\u0002\f\u0006=\u0015\u0011SAK\u0003/\u000bY*!(\u0011\u00075\nI(C\u0002\u0002|y\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0002\u0006\tvLR+O\u0007~C3\u000f\u001e:-AI,w-\u001a=qS\u0001j\u0003EU3ukJt7\u000f\t;sk\u0016\u0004\u0013N\u001a\u0011agR\u0014\b\rI7bi\u000eDWm\u001d\u0011ae\u0016<W\r\u001f9aY\u0001z'\u000f\t4bYN,\u0007e\u001c;iKJ<\u0018n]3/\u0003%\t'oZ;nK:$8/\t\u0002\u0002\b\u0006!IN\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR\u0014\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011sK\u001e,\u0007\u0010\u001d\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/AQCW\r\t:fO\u0016D\be\u001d;sS:<\u0007e\u001d5pk2$\u0007EY3!C\u0002R\u0015M^1!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|gN\f\u0006\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u00023+\u001b8dK\u0002\u001a\u0006/\u0019:lAIr\u0003\u0007\f\u0011tiJLgn\u001a\u0011mSR,'/\u00197tA!Jgn\u00197vI&tw\r\t:fO\u0016D\b\u0005]1ui\u0016\u0014hn]\u0015!CJ,\u0007%\u001e8fg\u000e\f\u0007/\u001a3!S:\u0004s.\u001e:!'Fc%\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!a\u0006\u00148/\u001a:/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017!i>\u0004S.\u0019;dQ\u0002\u0012C,\u00192dE1\u0002\u0013\r\t:fOVd\u0017M\u001d\u0011fqB\u0014Xm]:j_:\u0004cm\u001c:!AJ,w-\u001a=qA\u0002\u001a\u0017M\u001c\u0011cK*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0012_9r\u000b'm\u0019\u0013#])Q\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011UQ\u0016\u0014X\rI5tA\u0005\u00043+\u0015'!G>tg-[4!OM\u0004\u0018M]6/gFdg\u0006]1sg\u0016\u0014h&Z:dCB,Gm\u0015;sS:<G*\u001b;fe\u0006d7o\n\u0011uQ\u0006$\beY1oA\t,\u0007%^:fI\u0002\"xN\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0019\fG\u000e\u001c2bG.\u0004Co\u001c\u0011uQ\u0016\u00043\u000b]1sW\u0002\ndF\u000e\u0011cK\"\fg/[8sAI,w-\u0019:eS:<\u0007e\u001d;sS:<\u0007\u0005\\5uKJ\fG\u000e\t9beNLgn\u001a\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001Jg\r\t;iK\u0002\u001awN\u001c4jO\u0002J7\u000fI3oC\ndW\r\u001a\u0017!i\",\u0007\u0005\u0019:fO\u0016D\b\u000f\u0019\u0011uQ\u0006$\beY1oA5\fGo\u00195!Eq\u000b'm\u0019\u0012!SN\u0004#E\u0018/bE\u000e$#E\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\u000e\u0006\u0019YD\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000bR\u00033\u000f]1sW:\u001a\u0018\u000f\u001c\u0018qCJ\u001cXM\u001d\u0018fg\u000e\f\u0007/\u001a3TiJLgn\u001a'ji\u0016\u0014\u0018\r\\:>iJ,Xm\u000f\u0006!A\u0001\u0002\u0003\u0005I:qCJ\\gf]9m]A\f'o]3s]\u0015\u001c8-\u00199fIN#(/\u001b8h\u0019&$XM]1mg&!(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d*3+_:uK6$%/\u001b<fKq+6/\u001a:t9*{\u0007N\\\u0014-A\u001d*3+_:uK6$%/\u001b<fKqcVk]3sg:Rs%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F)\u0002\u001a\b/\u0019:l]M\fHN\f9beN,'OL3tG\u0006\u0004X\rZ*ue&tw\rT5uKJ\fGn]\u001fgC2\u001cXm\u000f\u0006!A\u0001\u0002\u0003\u0005I:qCJ\\gf]9m]A\f'o]3s]\u0015\u001c8-\u00199fIN#(/\u001b8h\u0019&$XM]1mg&1\u0017\r\\:f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":SeU=ti\u0016lGI]5wK\u0016bF,V:feNdFLS8i]\u001eb\u0003eJ\u0013TsN$X-\u001c#sSZ,W\u0005\u0018/]9V\u001bXM]:/U\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003%\u0001\u0003o_R,\u0017EAAJ\u0003UR\u0001\u0005\t\u0011!+N,\u0007\u0005T%L\u000b\u0002\"x\u000eI7bi\u000eD\u0007e^5uQ\u0002\u001a\u0018.\u001c9mK\u0002\u001aHO]5oO\u0002\u0002\u0018\r\u001e;fe:t#\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005e\u0015!B\u0019/a9\u0002\u0014!B4s_V\u0004\u0018EAAP\u0003=\u0001(/\u001a3jG\u0006$Xm\u00184v]\u000e\u001c\u0018!\u0002*MS.,\u0007CA\u0017\u0018'\u00159\u0012qUAZ!\u001d\tI+a,E\t2k!!a+\u000b\u0007\u00055&'A\u0004sk:$\u0018.\\3\n\t\u0005E\u00161\u0016\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BA[\u0003wk!!a.\u000b\u0007\u0005ev-\u0001\u0002j_&\u0019\u0001)a.\u0015\u0005\u0005\rFCAA\u0019\u0003\u0015\t\u0007\u000f\u001d7z)\u0015a\u0015QYAd\u0011\u0015\u0011%\u00041\u0001E\u0011\u0015A%\u00041\u0001E\u0003\u001d)h.\u00199qYf$B!!4\u0002ZB)\u0011'a4\u0002T&\u0019\u0011\u0011\u001b\u001a\u0003\r=\u0003H/[8o!\u0015\t\u0014Q\u001b#E\u0013\r\t9N\r\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005m7$!AA\u00021\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t\t\u000f\u0005\u0003\u00024\u0005\r\u0018\u0002BAs\u0003k\u0011aa\u00142kK\u000e$\b")
public class RLike
extends StringRegexExpression
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(RLike x$0) {
        return RLike$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, RLike> tupled() {
        return RLike$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, RLike>> curried() {
        return RLike$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String escape(String v) {
        return v;
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).find(0);
    }

    @Override
    public String toString() {
        return new StringBuilder(9).append("RLIKE(").append(this.left()).append(", ").append(this.right()).append(")").toString();
    }

    @Override
    public String sql() {
        return new StringBuilder(4).append(this.prettyName().toUpperCase(Locale.ROOT)).append("(").append(this.left().sql()).append(", ").append(this.right().sql()).append(")").toString();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String patternClass = Pattern.class.getName();
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal != null) {
                String regexStr = StringEscapeUtils.escapeJava((String)((UTF8String)rVal).toString());
                String pattern = ctx.addMutableState(patternClass, "patternRLike", (Function1<String, String>)(Function1 & Serializable)v -> new StringBuilder(16).append((String)v).append(" = ").append(patternClass).append(".compile(\"").append(regexStr).append("\");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                ExprCode eval = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).find(0);\n          }\n        "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), pattern, eval.value()})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2())})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String rightStr = ctx.freshName("rightStr");
            String pattern = ctx.freshName("pattern");
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(eval1, eval2) -> new StringBuilder(112).append("\n          String ").append(rightStr).append(" = ").append((String)eval2).append(".toString();\n          ").append(patternClass).append(" ").append(pattern).append(" = ").append(patternClass).append(".compile(").append(rightStr).append(");\n          ").append(ev.value()).append(" = ").append(pattern).append(".matcher(").append((String)eval1).append(".toString()).find(0);\n        ").toString());
        }
        return exprCode;
    }

    @Override
    public RLike withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public RLike copy(Expression left, Expression right) {
        return new RLike(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "RLike";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RLike;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RLike)) return false;
        boolean bl = true;
        if (!bl) return false;
        RLike rLike = (RLike)x$1;
        Expression expression = this.left();
        Expression expression2 = rLike.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = rLike.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!rLike.canEqual(this)) return false;
        return true;
    }

    public RLike(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

