/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import java.io.Serializable;
import org.apache.spark.SparkException$;
import org.apache.spark.input.PortableDataStream;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Predef$;

public final class JsonUtils$ {
    public static final JsonUtils$ MODULE$ = new JsonUtils$();

    public Dataset<String> sample(Dataset<String> json, JSONOptions options) {
        Predef$.MODULE$.require(options.samplingRatio() > 0.0, (Function0 & Serializable)() -> "samplingRatio (" + options.samplingRatio() + ") should be greater than 0");
        if (options.samplingRatio() > 0.99) {
            return json;
        }
        return json.sample(false, options.samplingRatio(), 1L);
    }

    public RDD<PortableDataStream> sample(RDD<PortableDataStream> json, JSONOptions options) {
        Predef$.MODULE$.require(options.samplingRatio() > 0.0, (Function0 & Serializable)() -> "samplingRatio (" + options.samplingRatio() + ") should be greater than 0");
        if (options.samplingRatio() > 0.99) {
            return json;
        }
        return json.sample(false, options.samplingRatio(), 1L);
    }

    public void checkJsonSchema(DataType schema) {
        TypeCheckResult.DataTypeMismatch dataTypeMismatch;
        String string;
        TypeCheckResult typeCheckResult = ExprUtils$.MODULE$.checkJsonSchema(schema);
        if (typeCheckResult instanceof TypeCheckResult.DataTypeMismatch && "INVALID_JSON_MAP_KEY_TYPE".equals(string = (dataTypeMismatch = (TypeCheckResult.DataTypeMismatch)typeCheckResult).errorSubClass())) {
            throw QueryCompilationErrors$.MODULE$.invalidJsonSchema(schema);
        }
        if (TypeCheckResult.TypeCheckSuccess$.MODULE$.equals(typeCheckResult)) {
            return;
        }
        throw SparkException$.MODULE$.internalError("Unknown type check result: " + typeCheckResult + ".");
    }

    private JsonUtils$() {
    }
}

