/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.classification.MultilayerPerceptronClassificationModel;
import org.apache.spark.ml.classification.MultilayerPerceptronClassifier;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class MultilayerPerceptronClassifierExample$ {
    public static final MultilayerPerceptronClassifierExample$ MODULE$ = new MultilayerPerceptronClassifierExample$();

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("MultilayerPerceptronClassifierExample").getOrCreate();
        Dataset data = spark.read().format("libsvm").load("data/mllib/sample_multiclass_classification_data.txt");
        Dataset[] splits = data.randomSplit(new double[]{0.6, 0.4}, 1234L);
        Dataset train = splits[0];
        Dataset test = splits[1];
        int[] layers = new int[]{4, 5, 4, 3};
        MultilayerPerceptronClassifier trainer = new MultilayerPerceptronClassifier().setLayers(layers).setBlockSize(128).setSeed(1234L).setMaxIter(100);
        MultilayerPerceptronClassificationModel model = (MultilayerPerceptronClassificationModel)trainer.fit(train);
        Dataset result = model.transform(test);
        Dataset predictionAndLabels = result.select("prediction", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"label"}));
        MulticlassClassificationEvaluator evaluator = new MulticlassClassificationEvaluator().setMetricName("accuracy");
        Predef$.MODULE$.println((Object)("Test set accuracy = " + evaluator.evaluate(predictionAndLabels)));
        spark.stop();
    }

    private MultilayerPerceptronClassifierExample$() {
    }
}

