/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DeflateCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.Lz4Codec;
import org.apache.hadoop.io.compress.SnappyCodec;

public enum HadoopCompressionCodec {
    NONE(null),
    UNCOMPRESSED(null),
    BZIP2((CompressionCodec)new BZip2Codec()),
    DEFLATE((CompressionCodec)new DeflateCodec()),
    GZIP((CompressionCodec)new GzipCodec()),
    LZ4((CompressionCodec)new Lz4Codec()),
    SNAPPY((CompressionCodec)new SnappyCodec());

    private final CompressionCodec compressionCodec;
    private static final Map<String, String> codecNameMap;

    private HadoopCompressionCodec(CompressionCodec compressionCodec) {
        this.compressionCodec = compressionCodec;
    }

    public CompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    public String lowerCaseName() {
        return codecNameMap.get(this.name());
    }

    static {
        codecNameMap = Arrays.stream(HadoopCompressionCodec.values()).collect(Collectors.toMap(Enum::name, codec -> codec.name().toLowerCase(Locale.ROOT)));
    }
}

