/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree;

import java.io.Serializable;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.InternalNode;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.util.collection.OpenHashMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class TreeEnsembleModel$ {
    public static final TreeEnsembleModel$ MODULE$ = new TreeEnsembleModel$();

    public <M extends DecisionTreeModel> Vector featureImportances(M[] trees, int numFeatures, boolean perTreeNormalization) {
        Tuple2 tuple2;
        int d;
        OpenHashMap.mcD.sp totalImportances = new OpenHashMap.mcD.sp((ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Double());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])trees), arg_0 -> TreeEnsembleModel$.$anonfun$featureImportances$1$adapted(perTreeNormalization, (OpenHashMap)totalImportances, arg_0));
        this.normalizeMapValues((OpenHashMap<Object, Object>)totalImportances);
        if (numFeatures != -1) {
            v0 = numFeatures;
        } else {
            int maxFeatureIndex = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])trees), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.maxSplitFeatureIndex()), (ClassTag)ClassTag$.MODULE$.Int())).max((Ordering)Ordering.Int$.MODULE$));
            v0 = d = maxFeatureIndex + 1;
        }
        if (d == 0) {
            Predef$.MODULE$.assert(totalImportances.size() == 0, (Function0 & Serializable)() -> "Unknown error in computing feature importance: No splits found, but some non-zero importances.");
        }
        if ((tuple2 = ((IterableOps)totalImportances.iterator().toSeq().sortBy((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).unzip(Predef$.MODULE$.$conforms())) == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq indices = (Seq)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indices, (Object)values);
        Seq indices2 = (Seq)tuple22._1();
        Seq values2 = (Seq)tuple22._2();
        return Vectors$.MODULE$.sparse(d, (int[])indices2.toArray((ClassTag)ClassTag$.MODULE$.Int()), (double[])values2.toArray((ClassTag)ClassTag$.MODULE$.Double()));
    }

    public <M extends DecisionTreeModel> Vector featureImportances(M tree, int numFeatures, ClassTag<M> evidence$1) {
        Object object = evidence$1.newArray(1);
        ScalaRunTime$.MODULE$.array_update(object, 0, tree);
        return this.featureImportances((DecisionTreeModel[])object, numFeatures, this.featureImportances$default$3());
    }

    public <M extends DecisionTreeModel> boolean featureImportances$default$3() {
        return true;
    }

    public void computeFeatureImportance(Node node, OpenHashMap<Object, Object> importances) {
        Node node2;
        while ((node2 = node) instanceof InternalNode) {
            InternalNode internalNode = (InternalNode)node2;
            int feature = internalNode.split().featureIndex();
            double scaledGain = internalNode.gain() * internalNode.impurityStats().count();
            importances.changeValue$mcD$sp((Object)BoxesRunTime.boxToInteger((int)feature), (Function0)(JFunction0.mcD.sp & Serializable)() -> scaledGain, (Function1)(JFunction1.mcDD.sp & Serializable)x$11 -> x$11 + scaledGain);
            this.computeFeatureImportance(internalNode.leftChild(), importances);
            node = internalNode.rightChild();
        }
        if (!(node2 instanceof LeafNode)) {
            throw new MatchError((Object)node2);
        }
    }

    public void normalizeMapValues(OpenHashMap<Object, Object> map) {
        double total = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)map.map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToDouble((double)x$12._2$mcD$sp()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        if (total != 0.0) {
            int[] keys = (int[])map.iterator().map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13._1$mcI$sp())).toArray((ClassTag)ClassTag$.MODULE$.Int());
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(keys), (Function1)(JFunction1.mcDI.sp & Serializable)key -> map.changeValue$mcD$sp((Object)BoxesRunTime.boxToInteger((int)key), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (Function1)(JFunction1.mcDD.sp & Serializable)x$14 -> x$14 / total));
            return;
        }
    }

    public static final /* synthetic */ double $anonfun$featureImportances$3(boolean perTreeNormalization$1, double treeNorm$1, OpenHashMap totalImportances$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int idx = tuple2._1$mcI$sp();
            double impt = tuple2._2$mcD$sp();
            double normImpt = perTreeNormalization$1 ? impt / treeNorm$1 : impt;
            return totalImportances$1.changeValue$mcD$sp((Object)BoxesRunTime.boxToInteger((int)idx), (Function0)(JFunction0.mcD.sp & Serializable)() -> normImpt, (Function1)(JFunction1.mcDD.sp & Serializable)x$7 -> x$7 + normImpt);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$featureImportances$1(boolean perTreeNormalization$1, OpenHashMap totalImportances$1, DecisionTreeModel tree) {
        double treeNorm;
        OpenHashMap.mcD.sp importances = new OpenHashMap.mcD.sp((ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Double());
        MODULE$.computeFeatureImportance(tree.rootNode(), (OpenHashMap<Object, Object>)importances);
        double d = treeNorm = perTreeNormalization$1 ? BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)importances.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)x$6._2$mcD$sp()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) : Double.NaN;
        if (treeNorm != 0.0) {
            importances.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)TreeEnsembleModel$.$anonfun$featureImportances$3(perTreeNormalization$1, treeNorm, totalImportances$1, x0$1)));
            return;
        }
    }

    private TreeEnsembleModel$() {
    }

    public static final /* synthetic */ Object $anonfun$featureImportances$1$adapted(boolean perTreeNormalization$1, OpenHashMap totalImportances$1, DecisionTreeModel tree) {
        TreeEnsembleModel$.$anonfun$featureImportances$1(perTreeNormalization$1, totalImportances$1, tree);
        return BoxedUnit.UNIT;
    }
}

