/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LinuxContainerUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class LinuxContainerUserFluent<A extends LinuxContainerUserFluent<A>>
extends BaseFluent<A> {
    private Long gid;
    private List<Long> supplementalGroups = new ArrayList<Long>();
    private Long uid;
    private Map<String, Object> additionalProperties;

    public LinuxContainerUserFluent() {
    }

    public LinuxContainerUserFluent(LinuxContainerUser instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(LinuxContainerUser instance) {
        LinuxContainerUser linuxContainerUser = instance = instance != null ? instance : new LinuxContainerUser();
        if (instance != null) {
            this.withGid(instance.getGid());
            this.withSupplementalGroups(instance.getSupplementalGroups());
            this.withUid(instance.getUid());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Long getGid() {
        return this.gid;
    }

    public A withGid(Long gid) {
        this.gid = gid;
        return (A)((Object)this);
    }

    public boolean hasGid() {
        return this.gid != null;
    }

    public A addToSupplementalGroups(int index, Long item) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.add(index, item);
        return (A)((Object)this);
    }

    public A setToSupplementalGroups(int index, Long item) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.set(index, item);
        return (A)((Object)this);
    }

    public A addToSupplementalGroups(Long ... items) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        for (Long item : items) {
            this.supplementalGroups.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSupplementalGroups(Collection<Long> items) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        for (Long item : items) {
            this.supplementalGroups.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSupplementalGroups(Long ... items) {
        if (this.supplementalGroups == null) {
            return (A)((Object)this);
        }
        for (Long item : items) {
            this.supplementalGroups.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSupplementalGroups(Collection<Long> items) {
        if (this.supplementalGroups == null) {
            return (A)((Object)this);
        }
        for (Long item : items) {
            this.supplementalGroups.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    public Long getSupplementalGroup(int index) {
        return this.supplementalGroups.get(index);
    }

    public Long getFirstSupplementalGroup() {
        return this.supplementalGroups.get(0);
    }

    public Long getLastSupplementalGroup() {
        return this.supplementalGroups.get(this.supplementalGroups.size() - 1);
    }

    public Long getMatchingSupplementalGroup(Predicate<Long> predicate) {
        for (Long item : this.supplementalGroups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSupplementalGroup(Predicate<Long> predicate) {
        for (Long item : this.supplementalGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSupplementalGroups(List<Long> supplementalGroups) {
        if (supplementalGroups != null) {
            this.supplementalGroups = new ArrayList<Long>();
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        } else {
            this.supplementalGroups = null;
        }
        return (A)((Object)this);
    }

    public A withSupplementalGroups(Long ... supplementalGroups) {
        if (this.supplementalGroups != null) {
            this.supplementalGroups.clear();
            this._visitables.remove((Object)"supplementalGroups");
        }
        if (supplementalGroups != null) {
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSupplementalGroups() {
        return this.supplementalGroups != null && !this.supplementalGroups.isEmpty();
    }

    public Long getUid() {
        return this.uid;
    }

    public A withUid(Long uid) {
        this.uid = uid;
        return (A)((Object)this);
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LinuxContainerUserFluent that = (LinuxContainerUserFluent)((Object)o);
        if (!Objects.equals(this.gid, that.gid)) {
            return false;
        }
        if (!Objects.equals(this.supplementalGroups, that.supplementalGroups)) {
            return false;
        }
        if (!Objects.equals(this.uid, that.uid)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.gid, this.supplementalGroups, this.uid, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.gid != null) {
            sb.append("gid:");
            sb.append(this.gid + ",");
        }
        if (this.supplementalGroups != null && !this.supplementalGroups.isEmpty()) {
            sb.append("supplementalGroups:");
            sb.append(this.supplementalGroups + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

