/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.spark.sql.Artifact;
import org.apache.spark.sql.util.ArtifactUtils$;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.MavenUtils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public final class Artifact$ {
    public static final Artifact$ MODULE$ = new Artifact$();
    private static final Path CLASS_PREFIX = Paths.get("classes", new String[0]);
    private static final Path JAR_PREFIX = Paths.get("jars", new String[0]);
    private static final Path CACHE_PREFIX = Paths.get("cache", new String[0]);

    public Path CLASS_PREFIX() {
        return CLASS_PREFIX;
    }

    public Path JAR_PREFIX() {
        return JAR_PREFIX;
    }

    public Path CACHE_PREFIX() {
        return CACHE_PREFIX;
    }

    public Artifact newArtifactFromExtension(String fileName, Path targetFilePath, Artifact.LocalData storage) {
        String string = fileName;
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (string.endsWith(".jar")) {
            return this.newJarArtifact(targetFilePath, storage);
        }
        if (string.endsWith(".class")) {
            return this.newClassArtifact(targetFilePath, storage);
        }
        throw new UnsupportedOperationException("Unsupported file format: " + string);
    }

    public Seq<Artifact> parseArtifacts(URI uri) {
        String string = uri.getScheme();
        switch (string == null ? 0 : string.hashCode()) {
            case 104684: {
                if (!"ivy".equals(string)) break;
                return this.newIvyArtifacts(uri);
            }
            case 3143036: {
                if (!"file".equals(string)) break;
                Path path = Paths.get(uri);
                Artifact artifact = this.newArtifactFromExtension(((Object)path.getFileName()).toString(), path.getFileName(), new Artifact.LocalFile(path));
                return new .colon.colon((Object)artifact, (List)Nil$.MODULE$);
            }
        }
        throw new UnsupportedOperationException("Unsupported scheme: " + string);
    }

    public Artifact newJarArtifact(Path targetFilePath, Artifact.LocalData storage) {
        return this.newArtifact(this.JAR_PREFIX(), ".jar", targetFilePath, storage);
    }

    public Artifact newClassArtifact(Path targetFilePath, Artifact.LocalData storage) {
        return this.newArtifact(this.CLASS_PREFIX(), ".class", targetFilePath, storage);
    }

    public Artifact newCacheArtifact(String id, Artifact.LocalData storage) {
        return this.newArtifact(this.CACHE_PREFIX(), "", Paths.get(id, new String[0]), storage);
    }

    public Seq<Artifact> newIvyArtifacts(URI uri) {
        PrintStream printStream = System.err;
        String authority = uri.getAuthority();
        if (authority == null) {
            throw new IllegalArgumentException("Invalid Ivy URI authority in uri " + uri.toString() + ": Expected 'org:module:version', found null.");
        }
        if (authority.split(":").length != 3) {
            throw new IllegalArgumentException("Invalid Ivy URI authority in uri " + uri.toString() + ": Expected 'org:module:version', found " + authority + ".");
        }
        Tuple3 tuple3 = MavenUtils$.MODULE$.parseQueryParams(uri);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        boolean transitive = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
        String exclusions = (String)tuple3._2();
        String repos = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)transitive), (Object)exclusions, (Object)repos);
        boolean transitive2 = BoxesRunTime.unboxToBoolean((Object)tuple32._1());
        String exclusions2 = (String)tuple32._2();
        String repos2 = (String)tuple32._3();
        Nil$ exclusionsList = !StringUtils.isBlank((CharSequence)exclusions2) ? ArrayImplicits$.MODULE$.SparkArrayOps((Object)exclusions2.split(",")).toImmutableArraySeq() : Nil$.MODULE$;
        IvySettings ivySettings = MavenUtils$.MODULE$.buildIvySettings((Option)new Some((Object)repos2), (Option)None$.MODULE$, MavenUtils$.MODULE$.buildIvySettings$default$3(), printStream);
        String x$1 = authority;
        IvySettings x$2 = ivySettings;
        boolean x$3 = transitive2;
        Nil$ x$4 = exclusionsList;
        Option x$5 = MavenUtils$.MODULE$.resolveMavenCoordinates$default$3();
        boolean x$6 = MavenUtils$.MODULE$.resolveMavenCoordinates$default$6();
        Seq jars = MavenUtils$.MODULE$.resolveMavenCoordinates(x$1, x$2, x$5, x$3, (Seq)x$4, x$6, printStream);
        return (Seq)((IterableOps)jars.map((Function1 & Serializable)p -> Paths.get(p, new String[0]))).map((Function1 & Serializable)path -> MODULE$.newJarArtifact(path.getFileName(), new Artifact.LocalFile((Path)path)));
    }

    private Artifact newArtifact(Path prefix, String requiredSuffix, Path targetFilePath, Artifact.LocalData storage) {
        Predef$.MODULE$.require(((Object)targetFilePath).toString().endsWith(requiredSuffix));
        return new Artifact(ArtifactUtils$.MODULE$.concatenatePaths(prefix, targetFilePath), storage);
    }

    private Artifact$() {
    }
}

