/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.csv.CSVExprUtils$;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001\u0002\n\u0014\u0001\u0001B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u001d\u0001\u0006A1A\u0005\nECaA\u0015\u0001!\u0002\u00131\u0005bB*\u0001\u0005\u0004%I!\u0015\u0005\u0007)\u0002\u0001\u000b\u0011\u0002$\t\u000bU\u0003A\u0011\u0002,\t\u000bU\u0003A\u0011A0\t\rU\u0003A\u0011A\nc\u0011\u0019)\u0006\u0001\"\u0001\u0014m\u001eI\u0011qA\n\u0002\u0002#\u0005\u0011\u0011\u0002\u0004\t%M\t\t\u0011#\u0001\u0002\f!1\u0011j\u0004C\u0001\u0003\u001bA\u0011\"a\u0004\u0010#\u0003%\t!!\u0005\u0003!\r\u001bf\u000bS3bI\u0016\u00148\t[3dW\u0016\u0014(B\u0001\u000b\u0016\u0003\r\u00197O\u001e\u0006\u0003-]\t\u0001bY1uC2L8\u000f\u001e\u0006\u00031e\t1a]9m\u0015\tQ2$A\u0003ta\u0006\u00148N\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)W5\t\u0011F\u0003\u0002+3\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002-S\t9Aj\\4hS:<\u0017AB:dQ\u0016l\u0017\r\u0005\u00020e5\t\u0001G\u0003\u00022/\u0005)A/\u001f9fg&\u00111\u0007\r\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017aB8qi&|gn\u001d\t\u0003m]j\u0011aE\u0005\u0003qM\u0011!bQ*W\u001fB$\u0018n\u001c8t\u0003\u0019\u0019x.\u001e:dKB\u00111H\u0011\b\u0003y\u0001\u0003\"!P\u0012\u000e\u0003yR!aP\u0010\u0002\rq\u0012xn\u001c;?\u0013\t\t5%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007\u0012\u0013aa\u0015;sS:<'BA!$\u00035I7o\u0015;beR|eMR5mKB\u0011!eR\u0005\u0003\u0011\u000e\u0012qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0006\u00172kej\u0014\t\u0003m\u0001AQ!L\u0003A\u00029BQ\u0001N\u0003A\u0002UBQ!O\u0003A\u0002iBq!R\u0003\u0011\u0002\u0003\u0007a)A\u0007dCN,7+\u001a8tSRLg/Z\u000b\u0002\r\u0006q1-Y:f'\u0016t7/\u001b;jm\u0016\u0004\u0013!D3oM>\u00148-Z*dQ\u0016l\u0017-\u0001\bf]\u001a|'oY3TG\",W.\u0019\u0011\u0002-\rDWmY6IK\u0006$WM]\"pYVlgNT1nKN$\"a\u0016.\u0011\u0005\tB\u0016BA-$\u0005\u0011)f.\u001b;\t\u000bmS\u0001\u0019\u0001/\u0002\u0017\r|G.^7o\u001d\u0006lWm\u001d\t\u0004EuS\u0014B\u00010$\u0005\u0015\t%O]1z)\t9\u0006\rC\u0003b\u0017\u0001\u0007!(\u0001\u0003mS:,GCA,d\u0011\u0015!G\u00021\u0001f\u0003%!xn[3oSj,'\u000fE\u0002g_Fl\u0011a\u001a\u0006\u0003Q&\faaY8n[>t'B\u00016l\u0003\u001d\u0001\u0018M]:feNT!\u0001\\7\u0002\u0013Ut\u0017N^8dSRL(\"\u00018\u0002\u0007\r|W.\u0003\u0002qO\nq\u0011IY:ue\u0006\u001cG\u000fU1sg\u0016\u0014\bC\u0001:u\u001b\u0005\u0019(B\u0001\u000bj\u0013\t)8OA\tDgZ\u0004\u0016M]:feN+G\u000f^5oON$BaV<\u0002\u0006!)\u00010\u0004a\u0001s\u0006)A.\u001b8fgB\u0019!p \u001e\u000f\u0005mlhBA\u001f}\u0013\u0005!\u0013B\u0001@$\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0001\u0002\u0004\tA\u0011\n^3sCR|'O\u0003\u0002\u007fG!)A-\u0004a\u0001K\u0006\u00012i\u0015,IK\u0006$WM]\"iK\u000e\\WM\u001d\t\u0003m=\u0019\"aD\u0011\u0015\u0005\u0005%\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u0014)\u001aa)!\u0006,\u0005\u0005]\u0001\u0003BA\r\u0003Gi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\t$\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\tYBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class CSVHeaderChecker
implements Logging {
    private final StructType schema;
    private final CSVOptions options;
    private final String source;
    private final boolean isStartOfFile;
    private final boolean caseSensitive;
    private final boolean enforceSchema;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$4() {
        return CSVHeaderChecker$.MODULE$.$lessinit$greater$default$4();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean caseSensitive() {
        return this.caseSensitive;
    }

    private boolean enforceSchema() {
        return this.enforceSchema;
    }

    private void checkHeaderColumnNames(String[] columnNames) {
        if (columnNames != null) {
            IndexedSeq fieldNames = ((IterableOnceOps)this.schema.map((Function1 & Serializable)x$1 -> x$1.name())).toIndexedSeq();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(columnNames.length, fieldNames.length());
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int headerLen = sp2._1$mcI$sp();
            int schemaSize = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(headerLen, schemaSize);
            int headerLen2 = sp3._1$mcI$sp();
            int schemaSize2 = sp3._2$mcI$sp();
            None$ errorMessage = None$.MODULE$;
            if (headerLen2 == schemaSize2) {
                for (int i = 0; errorMessage.isEmpty() && i < headerLen2; ++i) {
                    Tuple2 tuple2 = new Tuple2(fieldNames.apply(i), (Object)columnNames[i]);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String nameInSchema = (String)tuple2._1();
                    String nameInHeader = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)nameInSchema, (Object)nameInHeader);
                    String nameInSchema2 = (String)tuple22._1();
                    String nameInHeader2 = (String)tuple22._2();
                    if (!this.caseSensitive()) {
                        nameInSchema2 = nameInSchema2.toLowerCase();
                        nameInHeader2 = nameInHeader2.toLowerCase();
                    }
                    String string = nameInHeader2;
                    String string2 = nameInSchema2;
                    if (!(string == null ? string2 != null : !string.equals(string2))) continue;
                    errorMessage = new Some((Object)this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"|CSV header does not conform to the schema.\n                    | Header: ", "\n                    | Schema: ", "\n                    |Expected: ", " but found: ", "\n                    |", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CSV_HEADER_COLUMN_NAMES$.MODULE$, (Object)Predef$.MODULE$.wrapRefArray((Object[])columnNames).mkString(", ")), new MDC((LogKey)LogKeys.CSV_SCHEMA_FIELD_NAMES$.MODULE$, (Object)fieldNames.mkString(", ")), new MDC((LogKey)LogKeys.CSV_SCHEMA_FIELD_NAME$.MODULE$, fieldNames.apply(i)), new MDC((LogKey)LogKeys.CSV_HEADER_COLUMN_NAME$.MODULE$, (Object)columnNames[i]), new MDC((LogKey)LogKeys.CSV_SOURCE$.MODULE$, (Object)this.source)})).stripMargin());
                }
            } else {
                errorMessage = new Some((Object)this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"|Number of column in CSV header is not equal to number of fields in the schema:\n                | Header length: ", ", schema size: ", "\n                |", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CSV_HEADER_LENGTH$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)headerLen2)), new MDC((LogKey)LogKeys.NUM_COLUMNS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)schemaSize2)), new MDC((LogKey)LogKeys.CSV_SOURCE$.MODULE$, (Object)this.source)})).stripMargin());
            }
            errorMessage.foreach((Function1 & Serializable)msg -> {
                CSVHeaderChecker.$anonfun$checkHeaderColumnNames$2(this, msg);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void checkHeaderColumnNames(String line) {
        if (this.options.headerFlag()) {
            CsvParser parser = new CsvParser(this.options.asParserSettings());
            this.checkHeaderColumnNames(parser.parseLine(line));
            return;
        }
    }

    public void checkHeaderColumnNames(AbstractParser<CsvParserSettings> tokenizer) {
        Predef$.MODULE$.assert(this.options.multiLine(), (Function0 & Serializable)() -> "This method should be executed with multiLine.");
        if (this.options.headerFlag()) {
            String[] firstRecord = tokenizer.parseNext();
            this.checkHeaderColumnNames(firstRecord);
            return;
        }
    }

    public void checkHeaderColumnNames(Iterator<String> lines, AbstractParser<CsvParserSettings> tokenizer) {
        Predef$.MODULE$.assert(!this.options.multiLine(), (Function0 & Serializable)() -> "This method should not be executed with multiline.");
        if (this.options.headerFlag() && this.isStartOfFile) {
            CSVExprUtils$.MODULE$.extractHeader(lines, this.options).foreach((Function1 & Serializable)header -> {
                this.checkHeaderColumnNames(tokenizer.parseLine(header));
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$checkHeaderColumnNames$2(CSVHeaderChecker $this, MessageWithContext msg) {
        if ($this.enforceSchema()) {
            $this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> msg));
            return;
        }
        throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3241", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)msg.message())})));
    }

    public CSVHeaderChecker(StructType schema, CSVOptions options, String source, boolean isStartOfFile) {
        this.schema = schema;
        this.options = options;
        this.source = source;
        this.isStartOfFile = isStartOfFile;
        Logging.$init$((Logging)this);
        this.caseSensitive = SQLConf$.MODULE$.get().caseSensitiveAnalysis();
        this.enforceSchema = options.enforceSchema();
    }
}

