/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression$;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.types.StringTypeBinaryLcase$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]a!\u0002\t\u0012\u0003\u0003q\u0002\"B\u0015\u0001\t\u0003Q\u0003\"\u0002\u0017\u0001\t\u0003j\u0003\"\u0002\u001b\u0001\r\u0003)\u0004\"B\"\u0001\r\u0003!\u0005\"\u0002*\u0001\t\u0003\u001a\u0006\u0002C2\u0001\u0011\u000b\u0007IQ\u00013\t\u0011!\u0004\u0001R1A\u0005\u0006\u0011D\u0001\"\u001b\u0001\t\u0006\u0004%IA\u001b\u0005\u0006W\u0002!\t\u0002\u001c\u0005\u0006]\u0002!\tb\u001c\u0005\u0006c\u0002!\tF]\u0004\u0007uFA\taE>\u0007\rA\t\u0002\u0012A\n}\u0011\u0019IS\u0002\"\u0001\u0002\u0002!9\u00111A\u0007\u0005\u0002\u0005\u0015!!F*ue&twMU3hKb,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0003%M\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011A#F\u0001\tG\u0006$\u0018\r\\=ti*\u0011acF\u0001\u0004gFd'B\u0001\r\u001a\u0003\u0015\u0019\b/\u0019:l\u0015\tQ2$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0005\u0019qN]4\u0004\u0001M!\u0001aH\u0012'!\t\u0001\u0013%D\u0001\u0012\u0013\t\u0011\u0013C\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0001\u0005J\u0005\u0003KE\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003A\u001dJ!\u0001K\t\u0003\u0013A\u0013X\rZ5dCR,\u0017A\u0002\u001fj]&$h\bF\u0001,!\t\u0001\u0003!\u0001\bok2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u0016\u00039\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012qAQ8pY\u0016\fg.\u0001\u0004fg\u000e\f\u0007/\u001a\u000b\u0003m\u0005\u0003\"a\u000e \u000f\u0005ab\u0004CA\u001d1\u001b\u0005Q$BA\u001e\u001e\u0003\u0019a$o\\8u}%\u0011Q\bM\u0001\u0007!J,G-\u001a4\n\u0005}\u0002%AB*ue&twM\u0003\u0002>a!)!i\u0001a\u0001m\u0005\ta/A\u0004nCR\u001c\u0007.Z:\u0015\u00079*\u0005\u000bC\u0003G\t\u0001\u0007q)A\u0003sK\u001e,\u0007\u0010\u0005\u0002I\u001d6\t\u0011J\u0003\u0002G\u0015*\u00111\nT\u0001\u0005kRLGNC\u0001N\u0003\u0011Q\u0017M^1\n\u0005=K%a\u0002)biR,'O\u001c\u0005\u0006#\u0012\u0001\rAN\u0001\u0004gR\u0014\u0018AC5oaV$H+\u001f9fgV\tA\u000bE\u0002V5vs!A\u0016-\u000f\u0005e:\u0016\"A\u0019\n\u0005e\u0003\u0014a\u00029bG.\fw-Z\u0005\u00037r\u00131aU3r\u0015\tI\u0006\u0007\u0005\u0002_C6\tqL\u0003\u0002a+\u0005)A/\u001f9fg&\u0011!m\u0018\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f1bY8mY\u0006$\u0018n\u001c8JIV\tQ\r\u0005\u00020M&\u0011q\r\r\u0002\u0004\u0013:$\u0018aE2pY2\fG/[8o%\u0016<W\r\u001f$mC\u001e\u001c\u0018!B2bG\",W#A$\u0002\u000f\r|W\u000e]5mKR\u0011q)\u001c\u0005\u0006#&\u0001\rAN\u0001\ba\u0006$H/\u001a:o)\t9\u0005\u000fC\u0003R\u0015\u0001\u0007a'\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002tmb\u0004\"a\f;\n\u0005U\u0004$aA!os\")qo\u0003a\u0001g\u00061\u0011N\u001c9viFBQ!_\u0006A\u0002M\fa!\u001b8qkR\u0014\u0014!F*ue&twMU3hKb,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003A5\u0019\"!D?\u0011\u0005=r\u0018BA@1\u0005\u0019\te.\u001f*fMR\t10\u0001\ffqB\u0014Xm]:j_:$v.R:dCB,7\t[1s)\u0011\t9!!\u0004\u0011\u0007=\nI!C\u0002\u0002\fA\u0012Aa\u00115be\"9\u0011qB\bA\u0002\u0005E\u0011!A3\u0011\u0007\u0001\n\u0019\"C\u0002\u0002\u0016E\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0001")
public abstract class StringRegexExpression
extends BinaryExpression
implements ImplicitCastInputTypes,
Predicate {
    private int collationId;
    private int collationRegexFlags;
    private Pattern cache;
    private volatile byte bitmap$0;

    public static char expressionToEscapeChar(Expression e) {
        return StringRegexExpression$.MODULE$.expressionToEscapeChar(e);
    }

    @Override
    public DataType dataType() {
        return Predicate.dataType$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    public abstract String escape(String var1);

    public abstract boolean matches(Pattern var1, String var2);

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeBinaryLcase$.MODULE$, (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$, (List)Nil$.MODULE$));
    }

    private int collationId$lzycompute() {
        StringRegexExpression stringRegexExpression = this;
        synchronized (stringRegexExpression) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.collationId = ((StringType)((Expression)this.left()).dataType()).collationId();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    private int collationRegexFlags$lzycompute() {
        StringRegexExpression stringRegexExpression = this;
        synchronized (stringRegexExpression) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.collationRegexFlags = CollationSupport.collationAwareRegexFlags((int)this.collationId());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.collationRegexFlags;
    }

    public final int collationRegexFlags() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.collationRegexFlags$lzycompute();
        }
        return this.collationRegexFlags;
    }

    private Pattern cache$lzycompute() {
        StringRegexExpression stringRegexExpression = this;
        synchronized (stringRegexExpression) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Expression expression;
                Expression expression2 = (Expression)this.right();
                this.cache = expression2 != null && (expression = expression2).foldable() ? this.compile(((UTF8String)expression.eval(expression.eval$default$1())).toString()) : null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.cache;
    }

    private Pattern cache() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.cache$lzycompute();
        }
        return this.cache;
    }

    public Pattern compile(String str) {
        Pattern pattern;
        if (str == null) {
            return null;
        }
        try {
            pattern = Pattern.compile(this.escape(str), this.collationRegexFlags());
        }
        catch (PatternSyntaxException e) {
            throw QueryExecutionErrors$.MODULE$.invalidPatternError(this.prettyName(), e.getPattern(), e);
        }
        return pattern;
    }

    public Pattern pattern(String str) {
        if (this.cache() == null) {
            return this.compile(str);
        }
        return this.cache();
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        Pattern regex = this.pattern(((UTF8String)input2).toString());
        if (regex == null) {
            return null;
        }
        return BoxesRunTime.boxToBoolean((boolean)this.matches(regex, ((UTF8String)input1).toString()));
    }

    public StringRegexExpression() {
        ExpectsInputTypes.$init$(this);
        Predicate.$init$(this);
    }
}

