/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import org.apache.hadoop.fs.Path;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangeDataReader;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangeDataReader$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.MatchError;
import scala.Tuple3;
import scala.Tuple4;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005m4A!\u0004\b\u0001;!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011a\u0002!\u0011!Q\u0001\neB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u0001\")q\t\u0001C\u0001\u0011\"9\u0011\u000b\u0001a\u0001\n#\u0012\u0006b\u00020\u0001\u0001\u0004%\tf\u0018\u0005\u0007K\u0002\u0001\u000b\u0015B*\t\u000b\u0019\u0004A\u0011I4\u0003I!#ei\u0015\"bG.,Gm\u0015;bi\u0016\u001cFo\u001c:f\u0007\"\fgnZ3ECR\f'+Z1eKJT!a\u0004\t\u0002\u000bM$\u0018\r^3\u000b\u0005E\u0011\u0012!C:ue\u0016\fW.\u001b8h\u0015\t\u0019B#A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QCF\u0001\u0004gFd'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\b\t\u0003?\u0001j\u0011AD\u0005\u0003C9\u0011!d\u0015;bi\u0016\u001cFo\u001c:f\u0007\"\fgnZ3ECR\f'+Z1eKJ\f!AZ7\u0011\u0005\u0011*S\"\u0001\t\n\u0005\u0019\u0002\"!F\"iK\u000e\\\u0007o\\5oi\u001aKG.Z'b]\u0006<WM]\u0001\u000egR\fG/\u001a'pG\u0006$\u0018n\u001c8\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013A\u00014t\u0015\ti\u0003$\u0001\u0004iC\u0012|w\u000e]\u0005\u0003_)\u0012A\u0001U1uQ\u0006a1\u000f^1siZ+'o]5p]B\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t!Aj\u001c8h\u0003))g\u000e\u001a,feNLwN\\\u0001\u0011G>l\u0007O]3tg&|gnQ8eK\u000e\u0004\"AO\u001f\u000e\u0003mR!\u0001\u0010\f\u0002\u0005%|\u0017B\u0001 <\u0005A\u0019u.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7-A\u0005lKf\u001c6\r[3nCB\u0011\u0011\tR\u0007\u0002\u0005*\u00111\tF\u0001\u0006if\u0004Xm]\u0005\u0003\u000b\n\u0013!b\u0015;sk\u000e$H+\u001f9f\u0003-1\u0018\r\\;f'\u000eDW-\\1\u0002\rqJg.\u001b;?)!I%j\u0013'N\u001d>\u0003\u0006CA\u0010\u0001\u0011\u0015\u0011\u0003\u00021\u0001$\u0011\u00159\u0003\u00021\u0001)\u0011\u0015\u0001\u0004\u00021\u00012\u0011\u00159\u0004\u00021\u00012\u0011\u0015A\u0004\u00021\u0001:\u0011\u0015y\u0004\u00021\u0001A\u0011\u00151\u0005\u00021\u0001A\u0003=\u0019\u0007.\u00198hK2|wmU;gM&DX#A*\u0011\u0005Q[fBA+Z!\t16'D\u0001X\u0015\tAF$\u0001\u0004=e>|GOP\u0005\u00035N\na\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!lM\u0001\u0014G\"\fgnZ3m_\u001e\u001cVO\u001a4jq~#S-\u001d\u000b\u0003A\u000e\u0004\"AM1\n\u0005\t\u001c$\u0001B+oSRDq\u0001\u001a\u0006\u0002\u0002\u0003\u00071+A\u0002yIE\n\u0001c\u00195b]\u001e,Gn\\4Tk\u001a4\u0017\u000e\u001f\u0011\u0002\u000f\u001d,GOT3yiR\t\u0001\u000e\u0005\u00043S.\u001c8/M\u0005\u0003UN\u0012a\u0001V;qY\u0016$\u0004C\u00017p\u001d\tyR.\u0003\u0002o\u001d\u0005Q!+Z2pe\u0012$\u0016\u0010]3\n\u0005A\f(!\u0002,bYV,\u0017B\u0001:4\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0011\u0005QLX\"A;\u000b\u0005Y<\u0018aC3yaJ,7o]5p]NT!\u0001\u001f\u000b\u0002\u0011\r\fG/\u00197zgRL!A_;\u0003\u0013Us7/\u00194f%><\b")
public class HDFSBackedStateStoreChangeDataReader
extends StateStoreChangeDataReader {
    private final StructType keySchema;
    private final StructType valueSchema;
    private String changelogSuffix;

    @Override
    public String changelogSuffix() {
        return this.changelogSuffix;
    }

    @Override
    public void changelogSuffix_$eq(String x$1) {
        this.changelogSuffix = x$1;
    }

    public Tuple4<Enumeration.Value, UnsafeRow, UnsafeRow, Object> getNext() {
        StateStoreChangelogReader reader = this.currentChangelogReader();
        if (reader == null) {
            return null;
        }
        Tuple3 tuple3 = (Tuple3)reader.next();
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Enumeration.Value recordType = (Enumeration.Value)tuple3._1();
        byte[] keyArray = (byte[])tuple3._2();
        byte[] valueArray = (byte[])tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)recordType, (Object)keyArray, (Object)valueArray);
        Enumeration.Value recordType2 = (Enumeration.Value)tuple32._1();
        byte[] keyArray2 = (byte[])tuple32._2();
        byte[] valueArray2 = (byte[])tuple32._3();
        UnsafeRow keyRow = new UnsafeRow(this.keySchema.fields().length);
        keyRow.pointTo(keyArray2, keyArray2.length);
        if (valueArray2 == null) {
            return new Tuple4((Object)recordType2, (Object)keyRow, null, (Object)BoxesRunTime.boxToLong((long)(this.currentChangelogVersion() - 1L)));
        }
        UnsafeRow valueRow = new UnsafeRow(this.valueSchema.fields().length);
        valueRow.pointTo(valueArray2, valueArray2.length / 8 * 8);
        return new Tuple4((Object)recordType2, (Object)keyRow, (Object)valueRow, (Object)BoxesRunTime.boxToLong((long)(this.currentChangelogVersion() - 1L)));
    }

    public HDFSBackedStateStoreChangeDataReader(CheckpointFileManager fm, Path stateLocation, long startVersion, long endVersion, CompressionCodec compressionCodec, StructType keySchema, StructType valueSchema) {
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        super(fm, stateLocation, startVersion, endVersion, compressionCodec, StateStoreChangeDataReader$.MODULE$.$lessinit$greater$default$6());
        this.changelogSuffix = "delta";
    }
}

