/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkException;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.UnsafeRowUtils$;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class StateStoreProvider$ {
    public static final StateStoreProvider$ MODULE$ = new StateStoreProvider$();

    public StateStoreProvider create(String providerClassName) {
        Class providerClass = Utils$.MODULE$.classForName(providerClassName, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        if (!StateStoreProvider.class.isAssignableFrom(providerClass)) {
            throw new SparkException("STATE_STORE_INVALID_PROVIDER", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputClass"), (Object)providerClassName)})), null);
        }
        return (StateStoreProvider)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public StateStoreProvider createAndInit(StateStoreProviderId providerId, StructType keySchema, StructType valueSchema, KeyStateEncoderSpec keyStateEncoderSpec, boolean useColumnFamilies, StateStoreConf storeConf, Configuration hadoopConf, boolean useMultipleValuesPerKey, Option<StateSchemaProvider> stateSchemaProvider) {
        hadoopConf.set(StreamExecution$.MODULE$.RUN_ID_KEY(), providerId.queryRunId().toString());
        StateStoreProvider provider = this.create(storeConf.providerClass());
        provider.init(providerId.storeId(), keySchema, valueSchema, keyStateEncoderSpec, useColumnFamilies, storeConf, hadoopConf, useMultipleValuesPerKey, stateSchemaProvider);
        return provider;
    }

    public void validateStateRowFormat(UnsafeRow keyRow, StructType keySchema, UnsafeRow valueRow, StructType valueSchema, StateStoreConf conf) {
        if (conf.formatValidationEnabled()) {
            Option validationError = UnsafeRowUtils$.MODULE$.validateStructuralIntegrityWithReason(keyRow, keySchema);
            validationError.foreach((Function1 & Serializable)error -> {
                throw StateStoreErrors$.MODULE$.keyRowFormatValidationFailure((String)error);
            });
            if (conf.formatValidationCheckValue()) {
                Option validationError2 = UnsafeRowUtils$.MODULE$.validateStructuralIntegrityWithReason(valueRow, valueSchema);
                validationError2.foreach((Function1 & Serializable)error -> {
                    throw StateStoreErrors$.MODULE$.valueRowFormatValidationFailure((String)error);
                });
                return;
            }
            return;
        }
    }

    private StateStoreProvider$() {
    }
}

