/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez.monitoring;

import java.text.DecimalFormat;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.Constants;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.PrintSummary;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.session.SessionState;

class QueryExecutionBreakdownSummary
implements PrintSummary {
    private static final String OPERATION_SUMMARY = "%-35s %9s";
    private static final String OPERATION = "OPERATION";
    private static final String DURATION = "DURATION";
    private DecimalFormat decimalFormat = new DecimalFormat("#0.00");
    private PerfLogger perfLogger;
    private final Long compileEndTime;
    private final Long dagSubmitStartTime;
    private final Long submitToRunningDuration;

    QueryExecutionBreakdownSummary(PerfLogger perfLogger) {
        this.perfLogger = perfLogger;
        this.compileEndTime = perfLogger.getEndTime("compile");
        this.dagSubmitStartTime = perfLogger.getStartTime("TezSubmitDag");
        this.submitToRunningDuration = perfLogger.getDuration("TezSubmitToRunningDag");
    }

    private String formatNumber(long number) {
        return this.decimalFormat.format((double)number / 1000.0) + "s";
    }

    private String format(String value, long number) {
        return String.format(OPERATION_SUMMARY, value, this.formatNumber(number));
    }

    @Override
    public void print(SessionState.LogHelper console) {
        console.printInfo("Query Execution Summary");
        String execBreakdownHeader = String.format(OPERATION_SUMMARY, OPERATION, DURATION);
        console.printInfo(Constants.SEPARATOR);
        console.printInfo(execBreakdownHeader);
        console.printInfo(Constants.SEPARATOR);
        long compile = this.compileEndTime - this.perfLogger.getStartTime("compile");
        console.printInfo(this.format("Compile Query", compile));
        long totalDAGPrep = this.dagSubmitStartTime - this.compileEndTime;
        console.printInfo(this.format("Prepare Plan", totalDAGPrep));
        long submitToAccept = this.perfLogger.getStartTime("TezRunDag") - this.dagSubmitStartTime;
        console.printInfo(this.format("Submit Plan", submitToAccept));
        console.printInfo(this.format("Start DAG", this.submitToRunningDuration));
        long startToEnd = this.submitToRunningDuration == 0L ? this.perfLogger.getDuration("TezRunDag") : this.perfLogger.getEndTime("TezRunDag") - this.perfLogger.getEndTime("TezSubmitToRunningDag");
        console.printInfo(this.format("Run DAG", startToEnd));
        console.printInfo(Constants.SEPARATOR);
        console.printInfo("");
    }
}

