/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.plan.DynamicValue;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicValueVectorExpression
extends VectorExpression {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicValueVectorExpression.class);
    private static final long serialVersionUID = 1L;
    DynamicValue dynamicValue;
    TypeInfo typeInfo;
    private transient boolean initialized = false;
    private int outputColumn;
    protected long longValue = 0L;
    private double doubleValue = 0.0;
    private byte[] bytesValue = null;
    private HiveDecimal decimalValue = null;
    private Timestamp timestampValue = null;
    private HiveIntervalDayTime intervalDayTimeValue = null;
    private boolean isNullValue = false;
    private ColumnVector.Type type;
    private int bytesValueLength = 0;

    public DynamicValueVectorExpression() {
    }

    public DynamicValueVectorExpression(int outputColumn, TypeInfo typeInfo, DynamicValue dynamicValue) {
        this();
        this.outputColumn = outputColumn;
        this.type = VectorizationContext.getColumnVectorTypeFromTypeInfo(typeInfo);
        this.dynamicValue = dynamicValue;
        this.typeInfo = typeInfo;
    }

    private void evaluateLong(VectorizedRowBatch vrg) {
        LongColumnVector cv = (LongColumnVector)vrg.cols[this.outputColumn];
        cv.isRepeating = true;
        boolean bl = cv.noNulls = !this.isNullValue;
        if (!this.isNullValue) {
            cv.vector[0] = this.longValue;
            cv.isNull[0] = false;
        } else {
            cv.isNull[0] = true;
        }
    }

    private void evaluateDouble(VectorizedRowBatch vrg) {
        DoubleColumnVector cv = (DoubleColumnVector)vrg.cols[this.outputColumn];
        cv.isRepeating = true;
        boolean bl = cv.noNulls = !this.isNullValue;
        if (!this.isNullValue) {
            cv.vector[0] = this.doubleValue;
            cv.isNull[0] = false;
        } else {
            cv.isNull[0] = true;
        }
    }

    private void evaluateBytes(VectorizedRowBatch vrg) {
        BytesColumnVector cv = (BytesColumnVector)vrg.cols[this.outputColumn];
        cv.isRepeating = true;
        cv.noNulls = !this.isNullValue;
        cv.initBuffer();
        if (!this.isNullValue) {
            cv.setVal(0, this.bytesValue, 0, this.bytesValueLength);
            cv.isNull[0] = false;
        } else {
            cv.isNull[0] = true;
        }
    }

    private void evaluateDecimal(VectorizedRowBatch vrg) {
        DecimalColumnVector dcv = (DecimalColumnVector)vrg.cols[this.outputColumn];
        dcv.isRepeating = true;
        boolean bl = dcv.noNulls = !this.isNullValue;
        if (!this.isNullValue) {
            dcv.vector[0].set(this.decimalValue);
            dcv.isNull[0] = false;
        } else {
            dcv.isNull[0] = true;
        }
    }

    private void evaluateTimestamp(VectorizedRowBatch vrg) {
        TimestampColumnVector dcv = (TimestampColumnVector)vrg.cols[this.outputColumn];
        dcv.isRepeating = true;
        boolean bl = dcv.noNulls = !this.isNullValue;
        if (!this.isNullValue) {
            dcv.set(0, this.timestampValue);
            dcv.isNull[0] = false;
        } else {
            dcv.isNull[0] = true;
        }
    }

    private void evaluateIntervalDayTime(VectorizedRowBatch vrg) {
        IntervalDayTimeColumnVector dcv = (IntervalDayTimeColumnVector)vrg.cols[this.outputColumn];
        dcv.isRepeating = true;
        boolean bl = dcv.noNulls = !this.isNullValue;
        if (!this.isNullValue) {
            dcv.set(0, this.intervalDayTimeValue);
            dcv.isNull[0] = false;
        } else {
            dcv.isNull[0] = true;
        }
    }

    private void initValue() {
        Object val = this.dynamicValue.getValue();
        if (val == null) {
            this.isNullValue = true;
        } else {
            PrimitiveObjectInspector poi = this.dynamicValue.getObjectInspector();
            switch (poi.getPrimitiveCategory()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    this.longValue = PrimitiveObjectInspectorUtils.getLong((Object)val, (PrimitiveObjectInspector)poi);
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    this.doubleValue = PrimitiveObjectInspectorUtils.getDouble((Object)val, (PrimitiveObjectInspector)poi);
                    break;
                }
                case STRING: 
                case CHAR: 
                case VARCHAR: {
                    byte[] bytesVal = PrimitiveObjectInspectorUtils.getString((Object)val, (PrimitiveObjectInspector)poi).getBytes();
                    this.setBytesValue(bytesVal);
                    break;
                }
                case BINARY: {
                    byte[] bytesVal = PrimitiveObjectInspectorUtils.getBinary((Object)val, (PrimitiveObjectInspector)poi).copyBytes();
                    this.setBytesValue(bytesVal);
                    break;
                }
                case DECIMAL: {
                    this.decimalValue = PrimitiveObjectInspectorUtils.getHiveDecimal((Object)val, (PrimitiveObjectInspector)poi);
                    break;
                }
                case DATE: {
                    this.longValue = DateWritable.dateToDays((Date)PrimitiveObjectInspectorUtils.getDate((Object)val, (PrimitiveObjectInspector)poi));
                }
                case TIMESTAMP: {
                    this.timestampValue = PrimitiveObjectInspectorUtils.getTimestamp((Object)val, (PrimitiveObjectInspector)poi);
                    break;
                }
                case INTERVAL_YEAR_MONTH: {
                    this.longValue = PrimitiveObjectInspectorUtils.getHiveIntervalYearMonth((Object)val, (PrimitiveObjectInspector)poi).getTotalMonths();
                    break;
                }
                case INTERVAL_DAY_TIME: {
                    this.intervalDayTimeValue = PrimitiveObjectInspectorUtils.getHiveIntervalDayTime((Object)val, (PrimitiveObjectInspector)poi);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported type " + poi.getPrimitiveCategory());
                }
            }
        }
        this.initialized = true;
    }

    @Override
    public void init(Configuration conf) {
        super.init(conf);
        this.dynamicValue.setConf(conf);
    }

    @Override
    public void evaluate(VectorizedRowBatch vrg) {
        if (!this.initialized) {
            this.initValue();
        }
        switch (this.type) {
            case LONG: {
                this.evaluateLong(vrg);
                break;
            }
            case DOUBLE: {
                this.evaluateDouble(vrg);
                break;
            }
            case BYTES: {
                this.evaluateBytes(vrg);
                break;
            }
            case DECIMAL: {
                this.evaluateDecimal(vrg);
                break;
            }
            case TIMESTAMP: {
                this.evaluateTimestamp(vrg);
                break;
            }
            case INTERVAL_DAY_TIME: {
                this.evaluateIntervalDayTime(vrg);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported type " + this.type);
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public byte[] getBytesValue() {
        return this.bytesValue;
    }

    public void setBytesValue(byte[] bytesValue) {
        this.bytesValue = (byte[])bytesValue.clone();
        this.bytesValueLength = bytesValue.length;
    }

    public void setDecimalValue(HiveDecimal decimalValue) {
        this.decimalValue = decimalValue;
    }

    public HiveDecimal getDecimalValue() {
        return this.decimalValue;
    }

    public void setTimestampValue(Timestamp timestampValue) {
        this.timestampValue = timestampValue;
    }

    public Timestamp getTimestampValue() {
        return this.timestampValue;
    }

    public void setIntervalDayTimeValue(HiveIntervalDayTime intervalDayTimeValue) {
        this.intervalDayTimeValue = intervalDayTimeValue;
    }

    public HiveIntervalDayTime getIntervalDayTimeValue() {
        return this.intervalDayTimeValue;
    }

    public String getTypeString() {
        return this.getOutputType();
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().build();
    }

    public DynamicValue getDynamicValue() {
        return this.dynamicValue;
    }

    public void setDynamicValue(DynamicValue dynamicValue) {
        this.dynamicValue = dynamicValue;
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public void setTypeInfo(TypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }
}

