/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.RequiredPrivileges;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLAuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLPrivTypeGrant;

public class GrantPrivAuthUtils {
    static void authorize(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, boolean grantOption, IMetaStoreClient metastoreClient, String userName, List<String> curRoles, boolean isAdmin) throws HiveAuthzPluginException, HiveAccessControlException {
        RequiredPrivileges reqPrivs = GrantPrivAuthUtils.getGrantRequiredPrivileges(hivePrivileges);
        GrantPrivAuthUtils.checkRequiredPrivileges(reqPrivs, hivePrivObject, metastoreClient, userName, curRoles, isAdmin, HiveOperationType.GRANT_PRIVILEGE);
    }

    private static void checkRequiredPrivileges(RequiredPrivileges reqPrivileges, HivePrivilegeObject hivePrivObject, IMetaStoreClient metastoreClient, String userName, List<String> curRoles, boolean isAdmin, HiveOperationType opType) throws HiveAuthzPluginException, HiveAccessControlException {
        RequiredPrivileges availPrivs = SQLAuthorizationUtils.getPrivilegesFromMetaStore(metastoreClient, userName, hivePrivObject, curRoles, isAdmin);
        ArrayList<String> deniedMessages = new ArrayList<String>();
        Collection<SQLPrivTypeGrant> missingPrivs = reqPrivileges.findMissingPrivs(availPrivs);
        SQLAuthorizationUtils.addMissingPrivMsg(missingPrivs, hivePrivObject, deniedMessages);
        SQLAuthorizationUtils.assertNoDeniedPermissions(new HivePrincipal(userName, HivePrincipal.HivePrincipalType.USER), opType, deniedMessages);
    }

    private static RequiredPrivileges getGrantRequiredPrivileges(List<HivePrivilege> hivePrivileges) throws HiveAuthzPluginException {
        RequiredPrivileges reqPrivs = new RequiredPrivileges();
        for (HivePrivilege hivePriv : hivePrivileges) {
            reqPrivs.addPrivilege(hivePriv.getName(), true);
        }
        return reqPrivs;
    }
}

