/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.Deploy$;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.StringContext;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class SparkCuratorUtil$
implements Logging {
    public static final SparkCuratorUtil$ MODULE$ = new SparkCuratorUtil$();
    private static final int ZK_CONNECTION_TIMEOUT_MILLIS;
    private static final int ZK_SESSION_TIMEOUT_MILLIS;
    private static final int RETRY_WAIT_MILLIS;
    private static final int MAX_RECONNECT_ATTEMPTS;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        ZK_CONNECTION_TIMEOUT_MILLIS = 15000;
        ZK_SESSION_TIMEOUT_MILLIS = 60000;
        RETRY_WAIT_MILLIS = 5000;
        MAX_RECONNECT_ATTEMPTS = 3;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int ZK_CONNECTION_TIMEOUT_MILLIS() {
        return ZK_CONNECTION_TIMEOUT_MILLIS;
    }

    private int ZK_SESSION_TIMEOUT_MILLIS() {
        return ZK_SESSION_TIMEOUT_MILLIS;
    }

    private int RETRY_WAIT_MILLIS() {
        return RETRY_WAIT_MILLIS;
    }

    private int MAX_RECONNECT_ATTEMPTS() {
        return MAX_RECONNECT_ATTEMPTS;
    }

    public CuratorFramework newClient(SparkConf conf, String zkUrlConf) {
        String ZK_URL = conf.get(zkUrlConf);
        CuratorFramework zk = CuratorFrameworkFactory.newClient((String)ZK_URL, (int)this.ZK_SESSION_TIMEOUT_MILLIS(), (int)this.ZK_CONNECTION_TIMEOUT_MILLIS(), (RetryPolicy)new ExponentialBackoffRetry(this.RETRY_WAIT_MILLIS(), this.MAX_RECONNECT_ATTEMPTS()));
        zk.start();
        return zk;
    }

    public String newClient$default$2() {
        return Deploy$.MODULE$.ZOOKEEPER_URL().key();
    }

    public void mkdir(CuratorFramework zk, String path) {
        if (zk.checkExists().forPath(path) == null) {
            try {
                zk.create().creatingParentsIfNeeded().forPath(path);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
            }
            catch (Exception e) {
                throw e;
            }
            return;
        }
    }

    public void deleteRecursive(CuratorFramework zk, String path) {
        if (zk.checkExists().forPath(path) != null) {
            CollectionConverters$.MODULE$.ListHasAsScala((List)zk.getChildren().forPath(path)).asScala().foreach((Function1 & Serializable)child -> (Void)zk.delete().forPath(path + "/" + child));
            zk.delete().forPath(path);
            return;
        }
    }

    private SparkCuratorUtil$() {
    }
}

