/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.resource;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.Python$;
import org.apache.spark.resource.ExecutorResourceRequest;
import org.apache.spark.resource.ExecutorResourceRequests;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceRequest;
import org.apache.spark.resource.ResourceUtils$;
import org.apache.spark.resource.TaskResourceRequest;
import org.apache.spark.resource.TaskResourceRequests;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class ResourceProfile$
implements Logging,
Serializable {
    public static final ResourceProfile$ MODULE$ = new ResourceProfile$();
    private static AtomicInteger nextProfileId;
    private static final String CPUS;
    private static final String CORES;
    private static final String MEMORY;
    private static final String OFFHEAP_MEM;
    private static final String OVERHEAD_MEM;
    private static final String PYSPARK_MEM;
    private static final int UNKNOWN_RESOURCE_PROFILE_ID;
    private static final int DEFAULT_RESOURCE_PROFILE_ID;
    private static final Object DEFAULT_PROFILE_LOCK;
    @GuardedBy(value="DEFAULT_PROFILE_LOCK")
    private static Option<ResourceProfile> defaultProfile;
    private static Option<ResourceProfile.DefaultProfileExecutorResources> defaultProfileExecutorResources;
    private static final String PYSPARK_MEMORY_LOCAL_PROPERTY;
    private static final String EXECUTOR_CORES_LOCAL_PROPERTY;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        CPUS = "cpus";
        CORES = "cores";
        MEMORY = "memory";
        OFFHEAP_MEM = "offHeap";
        OVERHEAD_MEM = "memoryOverhead";
        PYSPARK_MEM = "pyspark.memory";
        UNKNOWN_RESOURCE_PROFILE_ID = -1;
        DEFAULT_RESOURCE_PROFILE_ID = 0;
        DEFAULT_PROFILE_LOCK = new Object();
        defaultProfile = None$.MODULE$;
        defaultProfileExecutorResources = None$.MODULE$;
        PYSPARK_MEMORY_LOCAL_PROPERTY = "resource.pyspark.memory";
        EXECUTOR_CORES_LOCAL_PROPERTY = "resource.executor.cores";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String CPUS() {
        return CPUS;
    }

    public String CORES() {
        return CORES;
    }

    public String MEMORY() {
        return MEMORY;
    }

    public String OFFHEAP_MEM() {
        return OFFHEAP_MEM;
    }

    public String OVERHEAD_MEM() {
        return OVERHEAD_MEM;
    }

    public String PYSPARK_MEM() {
        return PYSPARK_MEM;
    }

    public String[] allSupportedExecutorResources() {
        return (String[])((Object[])new String[]{this.CORES(), this.MEMORY(), this.OVERHEAD_MEM(), this.PYSPARK_MEM(), this.OFFHEAP_MEM()});
    }

    public int UNKNOWN_RESOURCE_PROFILE_ID() {
        return UNKNOWN_RESOURCE_PROFILE_ID;
    }

    public int DEFAULT_RESOURCE_PROFILE_ID() {
        return DEFAULT_RESOURCE_PROFILE_ID;
    }

    private AtomicInteger nextProfileId$lzycompute() {
        ResourceProfile$ resourceProfile$ = this;
        synchronized (resourceProfile$) {
            if (!bitmap$0) {
                nextProfileId = new AtomicInteger(0);
                bitmap$0 = true;
            }
        }
        return nextProfileId;
    }

    private AtomicInteger nextProfileId() {
        if (!bitmap$0) {
            return this.nextProfileId$lzycompute();
        }
        return nextProfileId;
    }

    private Object DEFAULT_PROFILE_LOCK() {
        return DEFAULT_PROFILE_LOCK;
    }

    private Option<ResourceProfile> defaultProfile() {
        return defaultProfile;
    }

    private void defaultProfile_$eq(Option<ResourceProfile> x$1) {
        defaultProfile = x$1;
    }

    private Option<ResourceProfile.DefaultProfileExecutorResources> defaultProfileExecutorResources() {
        return defaultProfileExecutorResources;
    }

    private void defaultProfileExecutorResources_$eq(Option<ResourceProfile.DefaultProfileExecutorResources> x$1) {
        defaultProfileExecutorResources = x$1;
    }

    public int getNextProfileId() {
        return this.nextProfileId().getAndIncrement();
    }

    public ResourceProfile getOrCreateDefaultProfile(SparkConf conf) {
        ResourceProfile resourceProfile;
        Object object = this.DEFAULT_PROFILE_LOCK();
        synchronized (object) {
            ResourceProfile resourceProfile2;
            Option<ResourceProfile> option = this.defaultProfile();
            if (option instanceof Some) {
                ResourceProfile prof;
                Some some = (Some)option;
                resourceProfile2 = prof = (ResourceProfile)some.value();
            } else if (None$.MODULE$.equals(option)) {
                scala.collection.immutable.Map<String, TaskResourceRequest> taskResources = this.getDefaultTaskResources(conf);
                scala.collection.immutable.Map<String, ExecutorResourceRequest> executorResources = this.getDefaultExecutorResources(conf);
                ResourceProfile defProf = new ResourceProfile(executorResources, taskResources);
                defProf.setToDefaultProfile();
                this.defaultProfile_$eq((Option<ResourceProfile>)new Some((Object)defProf));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Default ResourceProfile created, executor resources: "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ", task resources: "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTOR_RESOURCES$.MODULE$, defProf.executorResources())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TASK_RESOURCES$.MODULE$, defProf.taskResources())})))));
                resourceProfile2 = defProf;
            } else {
                throw new MatchError(option);
            }
            resourceProfile = resourceProfile2;
        }
        return resourceProfile;
    }

    public ResourceProfile.DefaultProfileExecutorResources getDefaultProfileExecutorResources(SparkConf conf) {
        return (ResourceProfile.DefaultProfileExecutorResources)this.defaultProfileExecutorResources().getOrElse((Function0 & Serializable)() -> {
            MODULE$.getOrCreateDefaultProfile(conf);
            return (ResourceProfile.DefaultProfileExecutorResources)MODULE$.defaultProfileExecutorResources().get();
        });
    }

    private scala.collection.immutable.Map<String, TaskResourceRequest> getDefaultTaskResources(SparkConf conf) {
        int cpusPerTask = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.CPUS_PER_TASK()));
        TaskResourceRequests treqs = new TaskResourceRequests().cpus(cpusPerTask);
        ResourceUtils$.MODULE$.addTaskResourceRequests(conf, treqs);
        return treqs.requests();
    }

    private scala.collection.immutable.Map<String, ExecutorResourceRequest> getDefaultExecutorResources(SparkConf conf) {
        ExecutorResourceRequests ereqs = new ExecutorResourceRequests();
        boolean isStandalone = conf.getOption("spark.master").exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.startsWith("spark://")));
        boolean isLocalCluster = conf.getOption("spark.master").exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.startsWith("local-cluster")));
        Some cores = isStandalone || isLocalCluster ? conf.getOption(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES().key()).map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$12)))) : new Some(conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES()));
        cores.foreach((Function1 & Serializable)amount -> ereqs.cores(BoxesRunTime.unboxToInt((Object)amount)));
        long memory = isStandalone || isLocalCluster ? (long)SparkContext$.MODULE$.executorMemoryInMb(conf) : BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY()));
        ereqs.memory(Long.toString(memory));
        Option overheadMem = (Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD());
        overheadMem.map((Function1 & Serializable)mem -> ereqs.memoryOverhead(Long.toString(BoxesRunTime.unboxToLong((Object)mem))));
        Option pysparkMem = (Option)conf.get(Python$.MODULE$.PYSPARK_EXECUTOR_MEMORY());
        pysparkMem.map((Function1 & Serializable)mem -> ereqs.pysparkMemory(Long.toString(BoxesRunTime.unboxToLong((Object)mem))));
        int offheapMem = Utils$.MODULE$.executorOffHeapMemorySizeAsMb(conf);
        ereqs.offHeapMemory(Integer.toString(offheapMem));
        Seq<ResourceRequest> execReq = ResourceUtils$.MODULE$.parseAllResourceRequests(conf, org.apache.spark.internal.config.package$.MODULE$.SPARK_EXECUTOR_PREFIX());
        execReq.foreach((Function1 & Serializable)req -> ereqs.resource(req.id().resourceName(), req.amount(), req.discoveryScript().orElse(""), req.vendor().orElse("")));
        Set customResourceNames = ((IterableOnceOps)execReq.map((Function1 & Serializable)x$13 -> x$13.id().resourceName())).toSet();
        scala.collection.immutable.Map customResources = (scala.collection.immutable.Map)ereqs.requests().filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)customResourceNames.contains(v._1())));
        this.defaultProfileExecutorResources_$eq((Option<ResourceProfile.DefaultProfileExecutorResources>)new Some((Object)new ResourceProfile.DefaultProfileExecutorResources((Option<Object>)cores, memory, offheapMem, (Option<Object>)pysparkMem, (Option<Object>)overheadMem, (scala.collection.immutable.Map<String, ExecutorResourceRequest>)customResources)));
        return ereqs.requests();
    }

    public ResourceProfile reInitDefaultProfile(SparkConf conf) {
        this.clearDefaultProfile();
        return this.getOrCreateDefaultProfile(conf);
    }

    public void clearDefaultProfile() {
        Object object = this.DEFAULT_PROFILE_LOCK();
        synchronized (object) {
            this.defaultProfile_$eq((Option<ResourceProfile>)None$.MODULE$);
            this.defaultProfileExecutorResources_$eq((Option<ResourceProfile.DefaultProfileExecutorResources>)None$.MODULE$);
        }
    }

    public int getTaskCpusOrDefaultForProfile(ResourceProfile rp, SparkConf conf) {
        return BoxesRunTime.unboxToInt((Object)rp.getTaskCpus().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.CPUS_PER_TASK()))));
    }

    public long executorOffHeapMemorySizeAsMb(SparkConf sparkConf, ExecutorResourceRequest execRequest) {
        return Utils$.MODULE$.checkOffHeapEnabled(sparkConf, execRequest.amount());
    }

    public long calculateOverHeadMemory(Option<Object> overHeadMemFromConf, long minimumOverHeadMemoryFromConf, long executorMemoryMiB, double overheadFactor) {
        return BoxesRunTime.unboxToLong((Object)overHeadMemFromConf.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> package$.MODULE$.max((long)((int)(overheadFactor * (double)executorMemoryMiB)), minimumOverHeadMemoryFromConf)));
    }

    public ResourceProfile.ExecutorResourcesOrDefaults getResourcesForClusterManager(int rpId, scala.collection.immutable.Map<String, ExecutorResourceRequest> execResources, long minimumOverheadMemory, double overheadFactor, SparkConf conf, boolean isPythonApp, scala.collection.immutable.Map<String, String> resourceMappings) {
        scala.collection.immutable.Map map;
        ResourceProfile.DefaultProfileExecutorResources defaultResources = this.getDefaultProfileExecutorResources(conf);
        ObjectRef cores = ObjectRef.create(defaultResources.cores());
        LongRef executorMemoryMiB = LongRef.create((long)defaultResources.executorMemoryMiB());
        LongRef memoryOffHeapMiB = LongRef.create((long)defaultResources.memoryOffHeapMiB());
        LongRef pysparkMemoryMiB = LongRef.create((long)BoxesRunTime.unboxToLong((Object)defaultResources.pysparkMemoryMiB().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
        LongRef memoryOverheadMiB = LongRef.create((long)this.calculateOverHeadMemory(defaultResources.memoryOverheadMiB(), minimumOverheadMemory, executorMemoryMiB.elem, overheadFactor));
        if (rpId != this.DEFAULT_RESOURCE_PROFILE_ID()) {
            HashMap customResources = new HashMap();
            execResources.foreach((Function1 & Serializable)x0$1 -> {
                ResourceProfile$.$anonfun$getResourcesForClusterManager$2(executorMemoryMiB, memoryOverheadMiB, pysparkMemoryMiB, memoryOffHeapMiB, conf, cores, resourceMappings, customResources, x0$1);
                return BoxedUnit.UNIT;
            });
            map = customResources.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        } else {
            map = (scala.collection.immutable.Map)defaultResources.customResources().map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String rName = (String)tuple2._1();
                    ExecutorResourceRequest execReq = (ExecutorResourceRequest)tuple2._2();
                    String nameToUse = (String)resourceMappings.getOrElse((Object)rName, (Function0 & Serializable)() -> rName);
                    return new Tuple2((Object)nameToUse, (Object)execReq);
                }
                throw new MatchError((Object)tuple2);
            });
        }
        scala.collection.immutable.Map finalCustomResources = map;
        long pysparkMemToUseMiB = isPythonApp ? pysparkMemoryMiB.elem : 0L;
        long totalMemMiB = executorMemoryMiB.elem + memoryOverheadMiB.elem + memoryOffHeapMiB.elem + pysparkMemToUseMiB;
        return new ResourceProfile.ExecutorResourcesOrDefaults((Option<Object>)((Option)cores.elem), executorMemoryMiB.elem, memoryOffHeapMiB.elem, pysparkMemToUseMiB, memoryOverheadMiB.elem, totalMemMiB, (scala.collection.immutable.Map<String, ExecutorResourceRequest>)finalCustomResources);
    }

    public String PYSPARK_MEMORY_LOCAL_PROPERTY() {
        return PYSPARK_MEMORY_LOCAL_PROPERTY;
    }

    public String EXECUTOR_CORES_LOCAL_PROPERTY() {
        return EXECUTOR_CORES_LOCAL_PROPERTY;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ResourceProfile$.class);
    }

    public static final /* synthetic */ void $anonfun$getResourcesForClusterManager$2(LongRef executorMemoryMiB$2, LongRef memoryOverheadMiB$1, LongRef pysparkMemoryMiB$1, LongRef memoryOffHeapMiB$1, SparkConf conf$3, ObjectRef cores$1, scala.collection.immutable.Map resourceMappings$1, HashMap customResources$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String r = (String)tuple2._1();
            ExecutorResourceRequest execReq = (ExecutorResourceRequest)tuple2._2();
            String string = r;
            String string2 = MODULE$.MEMORY();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                executorMemoryMiB$2.elem = execReq.amount();
            } else {
                String string4 = MODULE$.OVERHEAD_MEM();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    memoryOverheadMiB$1.elem = execReq.amount();
                } else {
                    String string6 = MODULE$.PYSPARK_MEM();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        pysparkMemoryMiB$1.elem = execReq.amount();
                    } else {
                        String string8 = MODULE$.OFFHEAP_MEM();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            memoryOffHeapMiB$1.elem = MODULE$.executorOffHeapMemorySizeAsMb(conf$3, execReq);
                        } else {
                            String string10 = MODULE$.CORES();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                cores$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)((int)execReq.amount())));
                            } else {
                                String nameToUse = (String)resourceMappings$1.getOrElse((Object)string, (Function0 & Serializable)() -> string);
                                customResources$1.update((Object)nameToUse, (Object)execReq);
                            }
                        }
                    }
                }
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private ResourceProfile$() {
    }
}

