/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.rpc.netty.Dispatcher;
import org.apache.spark.rpc.netty.InboxMessage;
import org.apache.spark.rpc.netty.NettyRpcCallContext;
import org.apache.spark.rpc.netty.OnStart$;
import org.apache.spark.rpc.netty.OnStop$;
import org.apache.spark.rpc.netty.OneWayMessage;
import org.apache.spark.rpc.netty.RemoteProcessConnected;
import org.apache.spark.rpc.netty.RemoteProcessConnectionError;
import org.apache.spark.rpc.netty.RemoteProcessDisconnected;
import org.apache.spark.rpc.netty.RpcMessage;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rc!\u0002\r\u001a\u0001e\u0019\u0003\u0002\u0003\u0019\u0001\u0005\u000b\u0007I\u0011\u0001\u001a\t\u0011y\u0002!\u0011!Q\u0001\nMB\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u0003\")a\t\u0001C\u0001\u000f\"9A\n\u0001b\u0001\n#i\u0005BB-\u0001A\u0003%a\nC\u0004i\u0001\u0001\u0007I\u0011B5\t\u000f5\u0004\u0001\u0019!C\u0005]\"1A\u000f\u0001Q!\n)DqA\u001e\u0001A\u0002\u0013%\u0011\u000eC\u0004x\u0001\u0001\u0007I\u0011\u0002=\t\ri\u0004\u0001\u0015)\u0003k\u0011\u001da\b\u00011A\u0005\nuD\u0011\"a\u0001\u0001\u0001\u0004%I!!\u0002\t\u000f\u0005%\u0001\u0001)Q\u0005}\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u0019\t9\u0003\u0001C\u0001S\"9\u0011\u0011\u0006\u0001\u0005\u0012\u0005-\u0002bBA\u0018\u0001\u0011%\u0011\u0011\u0007\u0005\u0007\u0003\u0003\u0002A\u0011A?\u0003\u000b%s'm\u001c=\u000b\u0005iY\u0012!\u00028fiRL(B\u0001\u000f\u001e\u0003\r\u0011\bo\u0019\u0006\u0003=}\tQa\u001d9be.T!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0013aA8sON\u0019\u0001\u0001\n\u0016\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g!\tYc&D\u0001-\u0015\tiS$\u0001\u0005j]R,'O\\1m\u0013\tyCFA\u0004M_\u001e<\u0017N\\4\u0002\u0019\u0015tG\r]8j]Rt\u0015-\\3\u0004\u0001U\t1\u0007\u0005\u00025w9\u0011Q'\u000f\t\u0003m\u0019j\u0011a\u000e\u0006\u0003qE\na\u0001\u0010:p_Rt\u0014B\u0001\u001e'\u0003\u0019\u0001&/\u001a3fM&\u0011A(\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i2\u0013!D3oIB|\u0017N\u001c;OC6,\u0007%\u0001\u0005f]\u0012\u0004x.\u001b8u+\u0005\t\u0005C\u0001\"D\u001b\u0005Y\u0012B\u0001#\u001c\u0005-\u0011\u0006oY#oIB|\u0017N\u001c;\u0002\u0013\u0015tG\r]8j]R\u0004\u0013A\u0002\u001fj]&$h\bF\u0002I\u0015.\u0003\"!\u0013\u0001\u000e\u0003eAQ\u0001M\u0003A\u0002MBQaP\u0003A\u0002\u0005\u000b\u0001\"\\3tg\u0006<Wm]\u000b\u0002\u001dB\u0019q\n\u0016,\u000e\u0003AS!!\u0015*\u0002\tU$\u0018\u000e\u001c\u0006\u0002'\u0006!!.\u0019<b\u0013\t)\u0006K\u0001\u0006MS:\\W\r\u001a'jgR\u0004\"!S,\n\u0005aK\"\u0001D%oE>DX*Z:tC\u001e,\u0017!C7fgN\fw-Z:!Q\u001191,\u001a4\u0011\u0005q\u001bW\"A/\u000b\u0005y{\u0016AC2p]\u000e,(O]3oi*\u0011\u0001-Y\u0001\u000bC:tw\u000e^1uS>t'\"\u00012\u0002\u000b)\fg/\u0019=\n\u0005\u0011l&!C$vCJ$W\r\u001a\"z\u0003\u00151\u0018\r\\;fC\u00059\u0017\u0001\u0002;iSN\fqa\u001d;paB,G-F\u0001k!\t)3.\u0003\u0002mM\t9!i\\8mK\u0006t\u0017aC:u_B\u0004X\rZ0%KF$\"a\u001c:\u0011\u0005\u0015\u0002\u0018BA9'\u0005\u0011)f.\u001b;\t\u000fML\u0011\u0011!a\u0001U\u0006\u0019\u0001\u0010J\u0019\u0002\u0011M$x\u000e\u001d9fI\u0002BCAC.fM\u0006\u0001RM\\1cY\u0016\u001cuN\\2veJ,g\u000e^\u0001\u0015K:\f'\r\\3D_:\u001cWO\u001d:f]R|F%Z9\u0015\u0005=L\bbB:\r\u0003\u0003\u0005\rA[\u0001\u0012K:\f'\r\\3D_:\u001cWO\u001d:f]R\u0004\u0003\u0006B\u0007\\K\u001a\f\u0001C\\;n\u0003\u000e$\u0018N^3UQJ,\u0017\rZ:\u0016\u0003y\u0004\"!J@\n\u0007\u0005\u0005aEA\u0002J]R\fAC\\;n\u0003\u000e$\u0018N^3UQJ,\u0017\rZ:`I\u0015\fHcA8\u0002\b!91oDA\u0001\u0002\u0004q\u0018!\u00058v[\u0006\u001bG/\u001b<f)\"\u0014X-\u00193tA!\"\u0001cW3g\u0003\u001d\u0001(o\\2fgN$2a\\A\t\u0011\u001d\t\u0019\"\u0005a\u0001\u0003+\t!\u0002Z5ta\u0006$8\r[3s!\rI\u0015qC\u0005\u0004\u00033I\"A\u0003#jgB\fGo\u00195fe\u0006!\u0001o\\:u)\ry\u0017q\u0004\u0005\u0007\u0003C\u0011\u0002\u0019\u0001,\u0002\u000f5,7o]1hK\u0006!1\u000f^8q)\u0005y\u0017aB5t\u000b6\u0004H/_\u0001\u0007_:$%o\u001c9\u0015\u0007=\fi\u0003\u0003\u0004\u0002\"U\u0001\rAV\u0001\u000bg\u00064W\r\\=DC2dG\u0003BA\u001a\u0003\u007f!2a\\A\u001b\u0011!\t9D\u0006CA\u0002\u0005e\u0012AB1di&|g\u000e\u0005\u0003&\u0003wy\u0017bAA\u001fM\tAAHY=oC6,g\bC\u0003@-\u0001\u0007\u0011)A\nhKRtU/\\!di&4X\r\u00165sK\u0006$7\u000f")
public class Inbox
implements Logging {
    private final String endpointName;
    private final RpcEndpoint endpoint;
    @GuardedBy(value="this")
    private final LinkedList<InboxMessage> messages;
    @GuardedBy(value="this")
    private boolean stopped;
    @GuardedBy(value="this")
    private boolean enableConcurrent;
    @GuardedBy(value="this")
    private int numActiveThreads;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public RpcEndpoint endpoint() {
        return this.endpoint;
    }

    public LinkedList<InboxMessage> messages() {
        return this.messages;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private boolean enableConcurrent() {
        return this.enableConcurrent;
    }

    private void enableConcurrent_$eq(boolean x$1) {
        this.enableConcurrent = x$1;
    }

    private int numActiveThreads() {
        return this.numActiveThreads;
    }

    private void numActiveThreads_$eq(int x$1) {
        this.numActiveThreads = x$1;
    }

    public void process(Dispatcher dispatcher) {
        ObjectRef message;
        block10: {
            message = ObjectRef.create(null);
            Inbox inbox = this;
            synchronized (inbox) {
                block9: {
                    if (!this.enableConcurrent() && this.numActiveThreads() != 0) break block9;
                    message.elem = this.messages().poll();
                    if ((InboxMessage)message.elem == null) break block9;
                    this.numActiveThreads_$eq(this.numActiveThreads() + 1);
                    break block10;
                }
                return;
            }
        }
        while (true) {
            this.safelyCall(this.endpoint(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                InboxMessage inboxMessage = (InboxMessage)message$1.elem;
                if (inboxMessage instanceof RpcMessage) {
                    RpcMessage rpcMessage = (RpcMessage)inboxMessage;
                    RpcAddress _sender = rpcMessage.senderAddress();
                    Object content = rpcMessage.content();
                    NettyRpcCallContext context = rpcMessage.context();
                    try {
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)this.endpoint().receiveAndReply(context).applyOrElse(content, (Function1 & Serializable)msg -> {
                            throw new SparkException("Unsupported message " + (InboxMessage)message$1.elem + " from " + _sender);
                        });
                    }
                    catch (Throwable e) {
                        context.sendFailure(e);
                        throw e;
                    }
                    return;
                }
                if (inboxMessage instanceof OneWayMessage) {
                    OneWayMessage oneWayMessage = (OneWayMessage)inboxMessage;
                    RpcAddress _sender = oneWayMessage.senderAddress();
                    Object content = oneWayMessage.content();
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)this.endpoint().receive().applyOrElse(content, (Function1 & Serializable)msg -> {
                        throw new SparkException("Unsupported message " + (InboxMessage)message$1.elem + " from " + _sender);
                    });
                    return;
                }
                if (OnStart$.MODULE$.equals(inboxMessage)) {
                    this.endpoint().onStart();
                    if (!(this.endpoint() instanceof ThreadSafeRpcEndpoint)) {
                        Inbox inbox = this;
                        synchronized (inbox) {
                            if (!this.stopped()) {
                                this.enableConcurrent_$eq(true);
                            }
                        }
                        return;
                    }
                    return;
                }
                if (OnStop$.MODULE$.equals(inboxMessage)) {
                    int n;
                    Inbox inbox = this;
                    synchronized (inbox) {
                        n = this.numActiveThreads();
                    }
                    int activeThreads = n;
                    Predef$.MODULE$.assert(activeThreads == 1, (Function0 & Serializable)() -> "There should be only a single active thread but found " + activeThreads + " threads.");
                    dispatcher.removeRpcEndpointRef(this.endpoint());
                    this.endpoint().onStop();
                    Predef$.MODULE$.assert(this.isEmpty(), (Function0 & Serializable)() -> "OnStop should be the last message");
                    return;
                }
                if (inboxMessage instanceof RemoteProcessConnected) {
                    RemoteProcessConnected remoteProcessConnected = (RemoteProcessConnected)inboxMessage;
                    RpcAddress remoteAddress = remoteProcessConnected.remoteAddress();
                    this.endpoint().onConnected(remoteAddress);
                    return;
                }
                if (inboxMessage instanceof RemoteProcessDisconnected) {
                    RemoteProcessDisconnected remoteProcessDisconnected = (RemoteProcessDisconnected)inboxMessage;
                    RpcAddress remoteAddress = remoteProcessDisconnected.remoteAddress();
                    this.endpoint().onDisconnected(remoteAddress);
                    return;
                }
                if (inboxMessage instanceof RemoteProcessConnectionError) {
                    RemoteProcessConnectionError remoteProcessConnectionError = (RemoteProcessConnectionError)inboxMessage;
                    Throwable cause = remoteProcessConnectionError.cause();
                    RpcAddress remoteAddress = remoteProcessConnectionError.remoteAddress();
                    this.endpoint().onNetworkError(cause, remoteAddress);
                    return;
                }
                throw new MatchError((Object)inboxMessage);
            });
            Inbox inbox = this;
            synchronized (inbox) {
                if (!this.enableConcurrent() && this.numActiveThreads() != 1) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
                message.elem = this.messages().poll();
                if ((InboxMessage)message.elem == null) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
            }
        }
    }

    public void post(InboxMessage message) {
        Inbox inbox = this;
        synchronized (inbox) {
            if (this.stopped()) {
                this.onDrop(message);
                v0 = BoxedUnit.UNIT;
            } else {
                this.messages().add(message);
                v0 = BoxesRunTime.boxToBoolean((boolean)false);
            }
        }
    }

    public void stop() {
        Inbox inbox = this;
        synchronized (inbox) {
            if (!this.stopped()) {
                this.enableConcurrent_$eq(false);
                this.stopped_$eq(true);
                v0 = BoxesRunTime.boxToBoolean((boolean)this.messages().add(OnStop$.MODULE$));
            } else {
                v0 = BoxedUnit.UNIT;
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.messages().isEmpty();
    }

    public void onDrop(InboxMessage message) {
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Drop ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MESSAGE$.MODULE$, (Object)message)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"because endpoint ", " is stopped"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.END_POINT$.MODULE$, (Object)this.endpointName())})))));
    }

    private void safelyCall(RpcEndpoint endpoint, Function0<BoxedUnit> action) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                BoxedUnit boxedUnit;
                try {
                    endpoint.onError(throwable2);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable4) {
                    Throwable throwable5;
                    Throwable throwable6 = throwable4;
                    if (throwable6 != null && NonFatal$.MODULE$.apply(throwable5 = throwable6)) {
                        if (this.stopped()) {
                            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Ignoring error", throwable5);
                        } else {
                            this.logError((Function0<String>)(Function0 & Serializable)() -> "Ignoring error", throwable5);
                        }
                    } else if (throwable6 != null) {
                        Throwable throwable7 = throwable6;
                        this.dealWithFatalError$1(throwable7);
                    } else {
                        throw throwable4;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            if (throwable3 != null) {
                Throwable throwable8 = throwable3;
                this.dealWithFatalError$1(throwable8);
            }
            throw throwable;
        }
    }

    public synchronized int getNumActiveThreads() {
        return this.numActiveThreads();
    }

    private final void dealWithFatalError$1(Throwable fatal) {
        Inbox inbox = this;
        synchronized (inbox) {
            Predef$.MODULE$.assert(this.numActiveThreads() > 0, (Function0 & Serializable)() -> "The number of active threads should be positive.");
            this.numActiveThreads_$eq(this.numActiveThreads() - 1);
        }
        this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"An error happened while processing message in the inbox for"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.END_POINT$.MODULE$, (Object)this.endpointName())})))), fatal);
        throw fatal;
    }

    public Inbox(String endpointName, RpcEndpoint endpoint) {
        this.endpointName = endpointName;
        this.endpoint = endpoint;
        Logging.$init$((Logging)this);
        this.messages = new LinkedList();
        this.stopped = false;
        this.enableConcurrent = false;
        this.numActiveThreads = 0;
        Inbox inbox = this;
        synchronized (inbox) {
            this.messages().add(OnStart$.MODULE$);
        }
    }
}

