/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage.memory;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException$;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockInfoManager;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.memory.BlockEvictionHandler;
import org.apache.spark.storage.memory.DeserializedMemoryEntry;
import org.apache.spark.storage.memory.DeserializedValuesHolder;
import org.apache.spark.storage.memory.MemoryEntry;
import org.apache.spark.storage.memory.MemoryEntryBuilder;
import org.apache.spark.storage.memory.PartiallySerializedBlock;
import org.apache.spark.storage.memory.PartiallyUnrolledIterator;
import org.apache.spark.storage.memory.SerializedMemoryEntry;
import org.apache.spark.storage.memory.SerializedValuesHolder;
import org.apache.spark.storage.memory.ValuesHolder;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tUf!B\u0015+\u00019\"\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011\u001d\u0003!\u0011!Q\u0001\n!C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"A\u0011\f\u0001B\u0001B\u0003%!\fC\u0003_\u0001\u0011\u0005q\fC\u0004g\u0001\t\u0007I\u0011B4\t\rm\u0004\u0001\u0015!\u0003i\u0011%\t9\u0001\u0001b\u0001\n\u0013\tI\u0001\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\u0006\u0011%\t\u0019\u0003\u0001b\u0001\n\u0013\tI\u0001\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\u0006\u0011%\t9\u0003\u0001b\u0001\n\u0013\tI\u0003\u0003\u0005\u0002,\u0001\u0001\u000b\u0011BA\u000e\u0011\u001d\ti\u0003\u0001C\u0005\u0003SAq!a\f\u0001\t\u0013\tI\u0003C\u0004\u00022\u0001!I!!\u000b\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u00111\b\u0001\u0005\u0002\u0005u\u0002bBAD\u0001\u0011%\u0011\u0011\u0012\u0005\t\u0003\u000f\u0004A\u0011\u0001\u0017\u0002J\"A\u0011Q\u001d\u0001\u0005\u00021\n9\u000fC\u0004\u0003\u0004\u0001!\tA!\u0002\t\u000f\t=\u0001\u0001\"\u0001\u0003\u0012!9!\u0011\u0005\u0001\u0005\u0002\t\r\u0002b\u0002B!\u0001\u0011\u0005!1\t\u0005\b\u0005\u000f\u0002A\u0011\u0001B%\u0011\u001d\u0011Y\u0005\u0001C\u0005\u0005\u001bB\u0001B!\u0017\u0001\t\u0003q#1\f\u0005\b\u0005O\u0002A\u0011\u0003B5\u0011\u001d\u0011i\u0007\u0001C\u0001\u0005_BqAa\u001d\u0001\t\u0013\u0011)\bC\u0004\u0003x\u0001!\tA!\u001f\t\u000f\t\u0005\u0005\u0001\"\u0001\u0003\u0004\"I!\u0011\u0012\u0001\u0012\u0002\u0013\u0005!1\u0012\u0005\b\u0005C\u0003A\u0011AA\u0015\u0011\u001d\u0011\u0019\u000b\u0001C\u0001\u0003SAqA!*\u0001\t\u0013\u00119\u000bC\u0004\u0003*\u0002!IA!\u0013\t\u000f\t-\u0006\u0001\"\u0003\u0003.\nYQ*Z7pef\u001cFo\u001c:f\u0015\tYC&\u0001\u0004nK6|'/\u001f\u0006\u0003[9\nqa\u001d;pe\u0006<WM\u0003\u00020a\u0005)1\u000f]1sW*\u0011\u0011GM\u0001\u0007CB\f7\r[3\u000b\u0003M\n1a\u001c:h'\r\u0001Qg\u000f\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qzT\"A\u001f\u000b\u0005yr\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0001k$a\u0002'pO\u001eLgnZ\u0001\u0005G>tgm\u0001\u0001\u0011\u0005\u0011+U\"\u0001\u0018\n\u0005\u0019s#!C*qCJ\\7i\u001c8g\u0003A\u0011Gn\\2l\u0013:4w.T1oC\u001e,'\u000f\u0005\u0002J\u00156\tA&\u0003\u0002LY\t\u0001\"\t\\8dW&sgm\\'b]\u0006<WM]\u0001\u0012g\u0016\u0014\u0018.\u00197ju\u0016\u0014X*\u00198bO\u0016\u0014\bC\u0001(R\u001b\u0005y%B\u0001)/\u0003)\u0019XM]5bY&TXM]\u0005\u0003%>\u0013\u0011cU3sS\u0006d\u0017N_3s\u001b\u0006t\u0017mZ3s\u00035iW-\\8ss6\u000bg.Y4feB\u0011QkV\u0007\u0002-*\u00111FL\u0005\u00031Z\u0013Q\"T3n_JLX*\u00198bO\u0016\u0014\u0018\u0001\u00062m_\u000e\\WI^5di&|g\u000eS1oI2,'\u000f\u0005\u0002\\96\t!&\u0003\u0002^U\t!\"\t\\8dW\u00163\u0018n\u0019;j_:D\u0015M\u001c3mKJ\fa\u0001P5oSRtDC\u00021bE\u000e$W\r\u0005\u0002\\\u0001!)\u0011I\u0002a\u0001\u0007\")qI\u0002a\u0001\u0011\")AJ\u0002a\u0001\u001b\")1K\u0002a\u0001)\")\u0011L\u0002a\u00015\u00069QM\u001c;sS\u0016\u001cX#\u00015\u0011\t%t\u0007o]\u0007\u0002U*\u00111\u000e\\\u0001\u0005kRLGNC\u0001n\u0003\u0011Q\u0017M^1\n\u0005=T'!\u0004'j].,G\rS1tQ6\u000b\u0007\u000f\u0005\u0002Jc&\u0011!\u000f\f\u0002\b\u00052|7m[%ea\t!\u0018\u0010E\u0002\\k^L!A\u001e\u0016\u0003\u00175+Wn\u001c:z\u000b:$(/\u001f\t\u0003qfd\u0001\u0001B\u0005{\u0011\u0005\u0005\t\u0011!B\u0001y\n\u0019q\fJ\u0019\u0002\u0011\u0015tGO]5fg\u0002\n2!`A\u0001!\t1d0\u0003\u0002\u0000o\t9aj\u001c;iS:<\u0007c\u0001\u001c\u0002\u0004%\u0019\u0011QA\u001c\u0003\u0007\u0005s\u00170A\u000bp]\"+\u0017\r]+oe>dG.T3n_JLX*\u00199\u0016\u0005\u0005-\u0001\u0003CA\u0007\u0003/\tY\"a\u0007\u000e\u0005\u0005=!\u0002BA\t\u0003'\tq!\\;uC\ndWMC\u0002\u0002\u0016]\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI\"a\u0004\u0003\u000f!\u000b7\u000f['baB\u0019a'!\b\n\u0007\u0005}qG\u0001\u0003M_:<\u0017AF8o\u0011\u0016\f\u0007/\u00168s_2dW*Z7pefl\u0015\r\u001d\u0011\u0002-=4g\rS3baVs'o\u001c7m\u001b\u0016lwN]=NCB\fqc\u001c4g\u0011\u0016\f\u0007/\u00168s_2dW*Z7pefl\u0015\r\u001d\u0011\u0002+Ut'o\u001c7m\u001b\u0016lwN]=UQJ,7\u000f[8mIV\u0011\u00111D\u0001\u0017k:\u0014x\u000e\u001c7NK6|'/\u001f+ie\u0016\u001c\bn\u001c7eA\u0005IQ.\u0019=NK6|'/_\u0001\u000b[\u0016lwN]=Vg\u0016$\u0017\u0001\u00052m_\u000e\\7/T3n_JLXk]3e\u0003\u001d9W\r^*ju\u0016$B!a\u0007\u00028!1\u0011\u0011\b\nA\u0002A\fqA\u00197pG.LE-\u0001\u0005qkR\u0014\u0015\u0010^3t+\u0011\ty$a\u0017\u0015\u0015\u0005\u0005\u0013qLA1\u0003K\ny\u0007\u0006\u0003\u0002D\u0005%\u0003c\u0001\u001c\u0002F%\u0019\u0011qI\u001c\u0003\u000f\t{w\u000e\\3b]\"I\u00111J\n\u0002\u0002\u0003\u000f\u0011QJ\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004CBA(\u0003+\nI&\u0004\u0002\u0002R)\u0019\u00111K\u001c\u0002\u000fI,g\r\\3di&!\u0011qKA)\u0005!\u0019E.Y:t)\u0006<\u0007c\u0001=\u0002\\\u00111\u0011QL\nC\u0002q\u0014\u0011\u0001\u0016\u0005\u0007\u0003s\u0019\u0002\u0019\u00019\t\u000f\u0005\r4\u00031\u0001\u0002\u001c\u0005!1/\u001b>f\u0011\u001d\t9g\u0005a\u0001\u0003S\n!\"\\3n_JLXj\u001c3f!\r)\u00161N\u0005\u0004\u0003[2&AC'f[>\u0014\u00180T8eK\"9\u0011\u0011O\nA\u0002\u0005M\u0014AB0csR,7\u000fE\u00037\u0003k\nI(C\u0002\u0002x]\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\t\u0005m\u00141Q\u0007\u0003\u0003{RA!a \u0002\u0002\u0006\u0011\u0011n\u001c\u0006\u0003W:JA!!\"\u0002~\t\t2\t[;oW\u0016$')\u001f;f\u0005V4g-\u001a:\u0002\u0017A,H/\u0013;fe\u0006$xN]\u000b\u0005\u0003\u0017\u000b\u0019\f\u0006\u0007\u0002\u000e\u0006\u0015\u0016qUA[\u0003w\u000bi\f\u0005\u0005\u0002\u0010\u0006}\u00151DA\u000e\u001d\u0011\t\t*a'\u000f\t\u0005M\u0015\u0011T\u0007\u0003\u0003+S1!a&C\u0003\u0019a$o\\8u}%\t\u0001(C\u0002\u0002\u001e^\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\"\u0006\r&AB#ji\",'OC\u0002\u0002\u001e^Ba!!\u000f\u0015\u0001\u0004\u0001\bbBAU)\u0001\u0007\u00111V\u0001\u0007m\u0006dW/Z:\u0011\r\u0005=\u0015QVAY\u0013\u0011\ty+a)\u0003\u0011%#XM]1u_J\u00042\u0001_AZ\t\u0019\ti\u0006\u0006b\u0001y\"9\u0011q\u0017\u000bA\u0002\u0005e\u0016\u0001C2mCN\u001cH+Y4\u0011\r\u0005=\u0013QKAY\u0011\u001d\t9\u0007\u0006a\u0001\u0003SBq!a0\u0015\u0001\u0004\t\t-\u0001\u0007wC2,Xm\u001d%pY\u0012,'\u000fE\u0003\\\u0003\u0007\f\t,C\u0002\u0002F*\u0012ABV1mk\u0016\u001c\bj\u001c7eKJ\f1\u0003];u\u0013R,'/\u0019;pe\u0006\u001bh+\u00197vKN,B!a3\u0002XRQ\u0011QZAm\u00037\fy.!9\u0011\u0011\u0005=\u0015qTAh\u00037\u0001RaWAi\u0003+L1!a5+\u0005e\u0001\u0016M\u001d;jC2d\u00170\u00168s_2dW\rZ%uKJ\fGo\u001c:\u0011\u0007a\f9\u000e\u0002\u0004\u0002^U\u0011\r\u0001 \u0005\u0007\u0003s)\u0002\u0019\u00019\t\u000f\u0005%V\u00031\u0001\u0002^B1\u0011qRAW\u0003+Dq!a\u001a\u0016\u0001\u0004\tI\u0007C\u0004\u00028V\u0001\r!a9\u0011\r\u0005=\u0013QKAk\u0003I\u0001X\u000f^%uKJ\fGo\u001c:Bg\nKH/Z:\u0016\t\u0005%\u0018Q\u001f\u000b\u000b\u0003W\f90!?\u0002~\n\u0005\u0001\u0003CAH\u0003?\u000bi/a\u0007\u0011\u000bm\u000by/a=\n\u0007\u0005E(F\u0001\rQCJ$\u0018.\u00197msN+'/[1mSj,GM\u00117pG.\u00042\u0001_A{\t\u0019\tiF\u0006b\u0001y\"1\u0011\u0011\b\fA\u0002ADq!!+\u0017\u0001\u0004\tY\u0010\u0005\u0004\u0002\u0010\u00065\u00161\u001f\u0005\b\u0003o3\u0002\u0019AA\u0000!\u0019\ty%!\u0016\u0002t\"9\u0011q\r\fA\u0002\u0005%\u0014\u0001C4fi\nKH/Z:\u0015\t\t\u001d!Q\u0002\t\u0006m\t%\u0011\u0011P\u0005\u0004\u0005\u00179$AB(qi&|g\u000e\u0003\u0004\u0002:]\u0001\r\u0001]\u0001\nO\u0016$h+\u00197vKN$BAa\u0005\u0003 A)aG!\u0003\u0003\u0016A\"!q\u0003B\u000e!\u0019\ty)!,\u0003\u001aA\u0019\u0001Pa\u0007\u0005\u0015\tu\u0001$!A\u0001\u0002\u000b\u0005APA\u0002`IIBa!!\u000f\u0019\u0001\u0004\u0001\u0018a\u00044sK\u0016lU-\\8ss\u0016sGO]=\u0016\t\t\u0015\"1\u0007\u000b\u0005\u0005O\u0011i\u0003E\u00027\u0005SI1Aa\u000b8\u0005\u0011)f.\u001b;\t\u000f\t=\u0012\u00041\u0001\u00032\u0005)QM\u001c;ssB\u0019\u0001Pa\r\u0005\u000f\u0005u\u0013D1\u0001\u00036E\u0019QPa\u000e1\t\te\"Q\b\t\u00057V\u0014Y\u0004E\u0002y\u0005{!1Ba\u0010\u00034\u0005\u0005\t\u0011!B\u0001y\n\u0019q\fJ\u001a\u0002\rI,Wn\u001c<f)\u0011\t\u0019E!\u0012\t\r\u0005e\"\u00041\u0001q\u0003\u0015\u0019G.Z1s)\t\u00119#\u0001\u0005hKR\u0014F\rZ%e)\u0011\u0011yEa\u0016\u0011\u000bY\u0012IA!\u0015\u0011\u0007Y\u0012\u0019&C\u0002\u0003V]\u00121!\u00138u\u0011\u0019\tI\u0004\ba\u0001a\u00061RM^5di\ncwnY6t)>4%/Z3Ta\u0006\u001cW\r\u0006\u0005\u0002\u001c\tu#\u0011\rB3\u0011\u001d\tI$\ba\u0001\u0005?\u0002BA\u000eB\u0005a\"9!1M\u000fA\u0002\u0005m\u0011!B:qC\u000e,\u0007bBA4;\u0001\u0007\u0011\u0011N\u0001\u0010C\u001a$XM\u001d#s_B\f5\r^5p]R!!q\u0005B6\u0011\u0019\tID\ba\u0001a\u0006A1m\u001c8uC&t7\u000f\u0006\u0003\u0002D\tE\u0004BBA\u001d?\u0001\u0007\u0001/\u0001\u000bdkJ\u0014XM\u001c;UCN\\\u0017\t\u001e;f[B$\u0018\n\u001a\u000b\u0003\u00037\taD]3tKJ4X-\u00168s_2dW*Z7pef4uN\u001d+iSN$\u0016m]6\u0015\u0011\u0005\r#1\u0010B?\u0005\u007fBa!!\u000f\"\u0001\u0004\u0001\bBB\u0016\"\u0001\u0004\tY\u0002C\u0004\u0002h\u0005\u0002\r!!\u001b\u0002=I,G.Z1tKVs'o\u001c7m\u001b\u0016lwN]=G_J$\u0006.[:UCN\\GC\u0002B\u0014\u0005\u000b\u00139\tC\u0004\u0002h\t\u0002\r!!\u001b\t\u0011-\u0012\u0003\u0013!a\u0001\u00037\t\u0001F]3mK\u0006\u001cX-\u00168s_2dW*Z7pef4uN\u001d+iSN$\u0016m]6%I\u00164\u0017-\u001e7uII*\"A!$+\t\u0005m!qR\u0016\u0003\u0005#\u0003BAa%\u0003\u001e6\u0011!Q\u0013\u0006\u0005\u0005/\u0013I*A\u0005v]\u000eDWmY6fI*\u0019!1T\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003 \nU%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u00192-\u001e:sK:$XK\u001c:pY2lU-\\8ss\u0006q2-\u001e:sK:$XK\u001c:pY2lU-\\8ss\u001a{'\u000f\u00165jgR\u000b7o[\u0001\u0012]VlG+Y:lgVs'o\u001c7mS:<WC\u0001B)\u00039awnZ'f[>\u0014\u00180V:bO\u0016\fq\u0003\\8h+:\u0014x\u000e\u001c7GC&dWO]3NKN\u001c\u0018mZ3\u0015\r\t\u001d\"q\u0016BY\u0011\u0019\tI\u0004\u000ba\u0001a\"9!1\u0017\u0015A\u0002\u0005m\u0011a\u00044j]\u0006dg+Z2u_J\u001c\u0016N_3")
public class MemoryStore
implements Logging {
    private final SparkConf conf;
    private final BlockInfoManager blockInfoManager;
    private final SerializerManager serializerManager;
    private final MemoryManager memoryManager;
    private final BlockEvictionHandler blockEvictionHandler;
    private final LinkedHashMap<BlockId, MemoryEntry<?>> entries;
    private final HashMap<Object, Object> onHeapUnrollMemoryMap;
    private final HashMap<Object, Object> offHeapUnrollMemoryMap;
    private final long unrollMemoryThreshold;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private LinkedHashMap<BlockId, MemoryEntry<?>> entries() {
        return this.entries;
    }

    private HashMap<Object, Object> onHeapUnrollMemoryMap() {
        return this.onHeapUnrollMemoryMap;
    }

    private HashMap<Object, Object> offHeapUnrollMemoryMap() {
        return this.offHeapUnrollMemoryMap;
    }

    private long unrollMemoryThreshold() {
        return this.unrollMemoryThreshold;
    }

    private long maxMemory() {
        return this.memoryManager.maxOnHeapStorageMemory() + this.memoryManager.maxOffHeapStorageMemory();
    }

    private long memoryUsed() {
        return this.memoryManager.storageMemoryUsed();
    }

    private long blocksMemoryUsed() {
        long l;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            l = this.memoryUsed() - this.currentUnrollMemory();
        }
        return l;
    }

    public long getSize(BlockId blockId) {
        long l;
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
        synchronized (linkedHashMap) {
            l = this.entries().get(blockId).size();
        }
        return l;
    }

    public <T> boolean putBytes(BlockId blockId, long size, MemoryMode memoryMode, Function0<ChunkedByteBuffer> _bytes, ClassTag<T> evidence$2) {
        Predef$.MODULE$.require(!this.contains(blockId), (Function0 & Serializable)() -> "Block " + blockId + " is already present in the MemoryStore");
        if (this.memoryManager.acquireStorageMemory(blockId, size, memoryMode)) {
            ChunkedByteBuffer bytes = (ChunkedByteBuffer)_bytes.apply();
            Predef$.MODULE$.assert(bytes.size() == size);
            SerializedMemoryEntry entry = new SerializedMemoryEntry(bytes, memoryMode, (ClassTag)Predef$.MODULE$.implicitly(evidence$2));
            LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
            synchronized (linkedHashMap) {
                MemoryEntry cfr_ignored_0 = this.entries().put(blockId, entry);
            }
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Block ", " stored as bytes in memory "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BLOCK_ID$.MODULE$, (Object)blockId)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(estimated size ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SIZE$.MODULE$, (Object)Utils$.MODULE$.bytesToString(size))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"free ", ")"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MEMORY_SIZE$.MODULE$, (Object)Utils$.MODULE$.bytesToString(this.maxMemory() - this.blocksMemoryUsed()))})))));
            return true;
        }
        return false;
    }

    private <T> Either<Object, Object> putIterator(BlockId blockId, Iterator<T> values, ClassTag<T> classTag, MemoryMode memoryMode, ValuesHolder<T> valuesHolder) {
        Predef$.MODULE$.require(!this.contains(blockId), (Function0 & Serializable)() -> "Block " + blockId + " is already present in the MemoryStore");
        int elementsUnrolled = 0;
        boolean keepUnrolling = true;
        long initialMemoryThreshold = this.unrollMemoryThreshold();
        long memoryCheckPeriod = BoxesRunTime.unboxToLong((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.UNROLL_MEMORY_CHECK_PERIOD()));
        long memoryThreshold = initialMemoryThreshold;
        double memoryGrowthFactor = BoxesRunTime.unboxToDouble((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.UNROLL_MEMORY_GROWTH_FACTOR()));
        long unrollMemoryUsedByThisBlock = 0L;
        keepUnrolling = this.reserveUnrollMemoryForThisTask(blockId, initialMemoryThreshold, memoryMode);
        if (!keepUnrolling) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to reserve initial memory threshold of "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)Utils$.MODULE$.bytesToString(initialMemoryThreshold))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for computing block ", " in memory."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BLOCK_ID$.MODULE$, (Object)blockId)})))));
        } else {
            unrollMemoryUsedByThisBlock += initialMemoryThreshold;
        }
        boolean shouldCheckThreadInterruption = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).isDefined();
        while (values.hasNext() && keepUnrolling && (!shouldCheckThreadInterruption || !Thread.currentThread().isInterrupted())) {
            long currentSize;
            valuesHolder.storeValue(values.next());
            if ((long)elementsUnrolled % memoryCheckPeriod == 0L && (currentSize = valuesHolder.estimatedSize()) >= memoryThreshold) {
                long amountToRequest = (long)((double)currentSize * memoryGrowthFactor - (double)memoryThreshold);
                keepUnrolling = this.reserveUnrollMemoryForThisTask(blockId, amountToRequest, memoryMode);
                if (keepUnrolling) {
                    unrollMemoryUsedByThisBlock += amountToRequest;
                }
                memoryThreshold += amountToRequest;
            }
            ++elementsUnrolled;
        }
        if (shouldCheckThreadInterruption && Thread.currentThread().isInterrupted()) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to unroll block=", " since thread interrupt was received"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BLOCK_ID$.MODULE$, (Object)blockId)}))));
            return new Left((Object)BoxesRunTime.boxToLong((long)unrollMemoryUsedByThisBlock));
        }
        if (keepUnrolling) {
            long amountToRequest;
            MemoryEntryBuilder<T> entryBuilder = valuesHolder.getBuilder();
            long size = entryBuilder.preciseSize();
            if (size > unrollMemoryUsedByThisBlock && (keepUnrolling = this.reserveUnrollMemoryForThisTask(blockId, amountToRequest = size - unrollMemoryUsedByThisBlock, memoryMode))) {
                unrollMemoryUsedByThisBlock += amountToRequest;
            }
            if (keepUnrolling) {
                MemoryEntry entry = entryBuilder.build();
                MemoryManager memoryManager = this.memoryManager;
                synchronized (memoryManager) {
                    this.releaseUnrollMemoryForThisTask(memoryMode, unrollMemoryUsedByThisBlock);
                    boolean success = this.memoryManager.acquireStorageMemory(blockId, entry.size(), memoryMode);
                    Predef$.MODULE$.assert(success, (Function0 & Serializable)() -> "transferring unroll memory to storage memory failed");
                }
                LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
                synchronized (linkedHashMap) {
                    this.entries().put(blockId, entry);
                }
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Block ", " stored as values in memory "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BLOCK_ID$.MODULE$, (Object)blockId)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(estimated size ", ", free "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MEMORY_SIZE$.MODULE$, (Object)Utils$.MODULE$.bytesToString(entry.size()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ")"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FREE_MEMORY_SIZE$.MODULE$, (Object)Utils$.MODULE$.bytesToString(this.maxMemory() - this.blocksMemoryUsed()))})))));
                return new Right((Object)BoxesRunTime.boxToLong((long)entry.size()));
            }
            this.logUnrollFailureMessage(blockId, entryBuilder.preciseSize());
            return new Left((Object)BoxesRunTime.boxToLong((long)unrollMemoryUsedByThisBlock));
        }
        this.logUnrollFailureMessage(blockId, valuesHolder.estimatedSize());
        return new Left((Object)BoxesRunTime.boxToLong((long)unrollMemoryUsedByThisBlock));
    }

    public <T> Either<PartiallyUnrolledIterator<T>, Object> putIteratorAsValues(BlockId blockId, Iterator<T> values, MemoryMode memoryMode, ClassTag<T> classTag) {
        DeserializedValuesHolder<T> valuesHolder = new DeserializedValuesHolder<T>(classTag, memoryMode);
        Either<Object, Object> either = this.putIterator(blockId, values, classTag, memoryMode, valuesHolder);
        if (either instanceof Right) {
            Right right = (Right)either;
            long storedSize = BoxesRunTime.unboxToLong((Object)right.value());
            return new Right((Object)BoxesRunTime.boxToLong((long)storedSize));
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            long unrollMemoryUsedByThisBlock = BoxesRunTime.unboxToLong((Object)left.value());
            Iterator unrolledIterator = valuesHolder.vector() != null ? valuesHolder.vector().iterator() : ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.genericArrayOps(valuesHolder.arrayValues()));
            return new Left(new PartiallyUnrolledIterator<T>(this, memoryMode, unrollMemoryUsedByThisBlock, unrolledIterator, values));
        }
        throw new MatchError(either);
    }

    public <T> Either<PartiallySerializedBlock<T>, Object> putIteratorAsBytes(BlockId blockId, Iterator<T> values, ClassTag<T> classTag, MemoryMode memoryMode) {
        Right right;
        int n;
        Predef$.MODULE$.require(!this.contains(blockId), (Function0 & Serializable)() -> "Block " + blockId + " is already present in the MemoryStore");
        long initialMemoryThreshold = this.unrollMemoryThreshold();
        if (initialMemoryThreshold > 0x7FFFFFF0L) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Initial memory threshold of "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)Utils$.MODULE$.bytesToString(initialMemoryThreshold))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"is too large to be set as chunk size. Chunk size has been capped to "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MAX_SIZE$.MODULE$, (Object)Utils$.MODULE$.bytesToString(0x7FFFFFF0L))})))));
            n = 0x7FFFFFF0;
        } else {
            n = (int)initialMemoryThreshold;
        }
        int chunkSize = n;
        SerializedValuesHolder<T> valuesHolder = new SerializedValuesHolder<T>(blockId, chunkSize, classTag, memoryMode, this.serializerManager);
        Either<Object, Object> either = this.putIterator(blockId, values, classTag, memoryMode, valuesHolder);
        if (either instanceof Right) {
            Right right2 = (Right)either;
            long storedSize = BoxesRunTime.unboxToLong((Object)right2.value());
            right = new Right((Object)BoxesRunTime.boxToLong((long)storedSize));
        } else if (either instanceof Left) {
            Left left = (Left)either;
            long unrollMemoryUsedByThisBlock = BoxesRunTime.unboxToLong((Object)left.value());
            right = new Left(new PartiallySerializedBlock<T>(this, this.serializerManager, blockId, valuesHolder.serializationStream(), valuesHolder.redirectableStream(), unrollMemoryUsedByThisBlock, memoryMode, valuesHolder.bbos(), values, classTag));
        } else {
            throw new MatchError(either);
        }
        Right res = right;
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable)x$1 -> {
            x$1.killTaskIfInterrupted();
            return BoxedUnit.UNIT;
        });
        return res;
    }

    public Option<ChunkedByteBuffer> getBytes(BlockId blockId) {
        MemoryEntry<?> entry;
        MemoryEntry<?> memoryEntry;
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
        synchronized (linkedHashMap) {
            memoryEntry = this.entries().get(blockId);
        }
        MemoryEntry<?> memoryEntry2 = entry = memoryEntry;
        if (memoryEntry2 == null) {
            return None$.MODULE$;
        }
        if (memoryEntry2 instanceof DeserializedMemoryEntry) {
            throw SparkException$.MODULE$.internalError("should only call getBytes on serialized blocks", "STORAGE");
        }
        if (memoryEntry2 instanceof SerializedMemoryEntry) {
            SerializedMemoryEntry serializedMemoryEntry = (SerializedMemoryEntry)memoryEntry2;
            ChunkedByteBuffer bytes = serializedMemoryEntry.buffer();
            return new Some((Object)bytes);
        }
        throw new MatchError(memoryEntry2);
    }

    public Option<Iterator<Object>> getValues(BlockId blockId) {
        MemoryEntry<?> entry;
        MemoryEntry<?> memoryEntry;
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
        synchronized (linkedHashMap) {
            memoryEntry = this.entries().get(blockId);
        }
        MemoryEntry<?> memoryEntry2 = entry = memoryEntry;
        if (memoryEntry2 == null) {
            return None$.MODULE$;
        }
        if (memoryEntry2 instanceof SerializedMemoryEntry) {
            throw SparkException$.MODULE$.internalError("should only call getValues on deserialized blocks", "STORAGE");
        }
        if (memoryEntry2 instanceof DeserializedMemoryEntry) {
            DeserializedMemoryEntry deserializedMemoryEntry = (DeserializedMemoryEntry)memoryEntry2;
            Object values = deserializedMemoryEntry.value();
            Some x = new Some(values);
            return x.map((Function1 & Serializable)x$2 -> ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.genericArrayOps(x$2)));
        }
        throw new MatchError(memoryEntry2);
    }

    public <T extends MemoryEntry<?>> void freeMemoryEntry(T entry) {
        T t = entry;
        if (t instanceof SerializedMemoryEntry) {
            SerializedMemoryEntry serializedMemoryEntry = (SerializedMemoryEntry)t;
            ChunkedByteBuffer buffer = serializedMemoryEntry.buffer();
            buffer.dispose();
            return;
        }
        if (t instanceof DeserializedMemoryEntry) {
            DeserializedMemoryEntry deserializedMemoryEntry = (DeserializedMemoryEntry)t;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(deserializedMemoryEntry.value()), (Function1 & Serializable)x0$1 -> {
                MemoryStore.$anonfun$freeMemoryEntry$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(t);
    }

    public boolean remove(BlockId blockId) {
        boolean bl;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            boolean bl2;
            MemoryEntry memoryEntry;
            LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
            synchronized (linkedHashMap) {
                memoryEntry = (MemoryEntry)this.entries().remove(blockId);
            }
            MemoryEntry entry = memoryEntry;
            if (entry != null) {
                this.freeMemoryEntry(entry);
                this.memoryManager.releaseStorageMemory(entry.size(), entry.memoryMode());
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Block " + blockId + " of size " + entry.size() + " dropped from memory (free " + (this.maxMemory() - this.blocksMemoryUsed()) + ")");
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    public void clear() {
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
            synchronized (linkedHashMap) {
                CollectionConverters$.MODULE$.CollectionHasAsScala(this.entries().values()).asScala().foreach((Function1 & Serializable)entry -> {
                    this.freeMemoryEntry(entry);
                    return BoxedUnit.UNIT;
                });
                this.entries().clear();
            }
            this.onHeapUnrollMemoryMap().clear();
            this.offHeapUnrollMemoryMap().clear();
            this.memoryManager.releaseAllStorageMemory();
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "MemoryStore cleared");
        }
    }

    private Option<Object> getRddId(BlockId blockId) {
        return blockId.asRDDId().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.rddId()));
    }

    public long evictBlocksToFreeSpace(Option<BlockId> blockId2, long space, MemoryMode memoryMode) {
        long l;
        Predef$.MODULE$.assert(space > 0L);
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            long l2;
            LongRef freedMemory = LongRef.create((long)0L);
            Option rddToAdd = blockId2.flatMap((Function1 & Serializable)blockId -> this.getRddId((BlockId)blockId));
            ArrayBuffer selectedBlocks = new ArrayBuffer();
            LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
            synchronized (linkedHashMap) {
                java.util.Iterator<Map.Entry<BlockId, MemoryEntry<?>>> iterator = this.entries().entrySet().iterator();
                while (freedMemory.elem < space && iterator.hasNext()) {
                    MemoryEntry<?> entry;
                    Map.Entry<BlockId, MemoryEntry<?>> pair = iterator.next();
                    BlockId blockId3 = pair.getKey();
                    if (!this.blockIsEvictable$1(blockId3, entry = pair.getValue(), memoryMode, rddToAdd) || !this.blockInfoManager.lockForWriting(blockId3, false).isDefined()) continue;
                    selectedBlocks.$plus$eq((Object)blockId3);
                    freedMemory.elem += entry.size();
                }
            }
            if (freedMemory.elem >= space) {
                IntRef lastSuccessfulBlock = IntRef.create((int)-1);
                try {
                    this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " blocks selected for dropping "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BLOCKS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)selectedBlocks.size()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(", " bytes)"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MEMORY_SIZE$.MODULE$, (Object)Utils$.MODULE$.bytesToString(freedMemory$1.elem))})))));
                    selectedBlocks.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
                        MemoryEntry<?> memoryEntry;
                        BlockId blockId = (BlockId)selectedBlocks.apply(idx);
                        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
                        synchronized (linkedHashMap) {
                            memoryEntry = this.entries().get(blockId);
                        }
                        MemoryEntry<?> entry = memoryEntry;
                        if (entry != null) {
                            this.dropBlock$1(blockId, entry);
                            this.afterDropAction(blockId);
                        }
                        lastSuccessfulBlock$1.elem = idx;
                    });
                    this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"After dropping ", " blocks, free memory is"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BLOCKS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)selectedBlocks.size()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FREE_MEMORY_SIZE$.MODULE$, (Object)Utils$.MODULE$.bytesToString(this.maxMemory() - this.blocksMemoryUsed()))})))));
                    l2 = freedMemory.elem;
                }
                finally {
                    if (lastSuccessfulBlock.elem != selectedBlocks.size() - 1) {
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(lastSuccessfulBlock.elem + 1), selectedBlocks.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
                            BlockId blockId = (BlockId)selectedBlocks.apply(idx);
                            $this.blockInfoManager.unlock(blockId, $this.blockInfoManager.unlock$default$2());
                        });
                    }
                }
            } else {
                blockId2.foreach((Function1 & Serializable)id -> {
                    this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Will not store ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BLOCK_ID$.MODULE$, (Object)id)}))));
                    return BoxedUnit.UNIT;
                });
                selectedBlocks.foreach((Function1 & Serializable)id -> {
                    this.blockInfoManager.unlock(id, this.blockInfoManager.unlock$default$2());
                    return BoxedUnit.UNIT;
                });
                l2 = 0L;
            }
            l = l2;
        }
        return l;
    }

    public void afterDropAction(BlockId blockId) {
    }

    public boolean contains(BlockId blockId) {
        boolean bl;
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
        synchronized (linkedHashMap) {
            bl = this.entries().containsKey(blockId);
        }
        return bl;
    }

    private long currentTaskAttemptId() {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.taskAttemptId())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public boolean reserveUnrollMemoryForThisTask(BlockId blockId, long memory, MemoryMode memoryMode) {
        boolean bl;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            boolean success = this.memoryManager.acquireUnrollMemory(blockId, memory, memoryMode);
            if (success) {
                HashMap<Object, Object> hashMap;
                long taskAttemptId = this.currentTaskAttemptId();
                MemoryMode memoryMode2 = memoryMode;
                if (MemoryMode.ON_HEAP.equals(memoryMode2)) {
                    hashMap = this.onHeapUnrollMemoryMap();
                } else if (MemoryMode.OFF_HEAP.equals(memoryMode2)) {
                    hashMap = this.offHeapUnrollMemoryMap();
                } else {
                    throw new MatchError((Object)memoryMode2);
                }
                HashMap<Object, Object> unrollMemoryMap = hashMap;
                unrollMemoryMap.update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)unrollMemoryMap.getOrElse((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) + memory)));
            }
            bl = success;
        }
        return bl;
    }

    public void releaseUnrollMemoryForThisTask(MemoryMode memoryMode, long memory) {
        long taskAttemptId = this.currentTaskAttemptId();
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            HashMap<Object, Object> hashMap;
            MemoryMode memoryMode2 = memoryMode;
            if (MemoryMode.ON_HEAP.equals(memoryMode2)) {
                hashMap = this.onHeapUnrollMemoryMap();
            } else if (MemoryMode.OFF_HEAP.equals(memoryMode2)) {
                hashMap = this.offHeapUnrollMemoryMap();
            } else {
                throw new MatchError((Object)memoryMode2);
            }
            HashMap<Object, Object> unrollMemoryMap = hashMap;
            if (unrollMemoryMap.contains((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) {
                long memoryToRelease = package$.MODULE$.min(memory, BoxesRunTime.unboxToLong((Object)unrollMemoryMap.apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))));
                if (memoryToRelease > 0L) {
                    unrollMemoryMap.update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)unrollMemoryMap.apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) - memoryToRelease)));
                    this.memoryManager.releaseUnrollMemory(memoryToRelease, memoryMode);
                }
                v1 = BoxesRunTime.unboxToLong((Object)unrollMemoryMap.apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) == 0L ? unrollMemoryMap.remove((Object)BoxesRunTime.boxToLong((long)taskAttemptId)) : BoxedUnit.UNIT;
            } else {
                v1 = BoxedUnit.UNIT;
            }
        }
    }

    public long releaseUnrollMemoryForThisTask$default$2() {
        return Long.MAX_VALUE;
    }

    public long currentUnrollMemory() {
        long l;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            l = BoxesRunTime.unboxToLong((Object)this.onHeapUnrollMemoryMap().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) + BoxesRunTime.unboxToLong((Object)this.offHeapUnrollMemoryMap().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }
        return l;
    }

    public long currentUnrollMemoryForThisTask() {
        long l;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            l = BoxesRunTime.unboxToLong((Object)this.onHeapUnrollMemoryMap().getOrElse((Object)BoxesRunTime.boxToLong((long)this.currentTaskAttemptId()), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) + BoxesRunTime.unboxToLong((Object)this.offHeapUnrollMemoryMap().getOrElse((Object)BoxesRunTime.boxToLong((long)this.currentTaskAttemptId()), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        }
        return l;
    }

    private int numTasksUnrolling() {
        int n;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            n = ((IterableOnceOps)this.onHeapUnrollMemoryMap().keys().$plus$plus((IterableOnce)this.offHeapUnrollMemoryMap().keys())).toSet().size();
        }
        return n;
    }

    private void logMemoryUsage() {
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Memory use = ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CURRENT_MEMORY_SIZE$.MODULE$, (Object)Utils$.MODULE$.bytesToString(this.blocksMemoryUsed()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(blocks) + ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FREE_MEMORY_SIZE$.MODULE$, (Object)Utils$.MODULE$.bytesToString(this.currentUnrollMemory()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(scratch space shared across ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_TASKS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)this.numTasksUnrolling()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tasks(s)) = ", ". "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STORAGE_MEMORY_SIZE$.MODULE$, (Object)Utils$.MODULE$.bytesToString(this.memoryUsed()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Storage limit = ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MAX_MEMORY_SIZE$.MODULE$, (Object)Utils$.MODULE$.bytesToString(this.maxMemory()))})))));
    }

    private void logUnrollFailureMessage(BlockId blockId, long finalVectorSize) {
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Not enough space to cache ", " in memory! "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BLOCK_ID$.MODULE$, (Object)blockId)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(computed ", " so far)"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)Utils$.MODULE$.bytesToString(finalVectorSize))})))));
        this.logMemoryUsage();
    }

    public static final /* synthetic */ void $anonfun$freeMemoryEntry$1(MemoryStore $this, Object x0$1) {
        Object object = x0$1;
        if (object instanceof AutoCloseable) {
            BoxedUnit boxedUnit;
            AutoCloseable autoCloseable = (AutoCloseable)object;
            try {
                autoCloseable.close();
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 == null || !NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    throw throwable;
                }
                $this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Fail to close a memory entry", throwable2);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean blockIsEvictable$1(BlockId blockId, MemoryEntry entry, MemoryMode memoryMode$1, Option rddToAdd$1) {
        MemoryMode memoryMode = entry.memoryMode();
        MemoryMode memoryMode2 = memoryMode$1;
        if (memoryMode == null) {
            if (memoryMode2 != null) {
                return false;
            }
        } else if (!memoryMode.equals(memoryMode2)) return false;
        if (rddToAdd$1.isEmpty()) return true;
        Option option = rddToAdd$1;
        Option<Object> option2 = this.getRddId(blockId);
        if (option == null) {
            if (option2 == null) return false;
            return true;
        } else if (option.equals(option2)) return false;
        return true;
    }

    public static final /* synthetic */ Either $anonfun$evictBlocksToFreeSpace$2(Either data$1) {
        return data$1;
    }

    private final void dropBlock$1(BlockId blockId, MemoryEntry entry) {
        Left left;
        MemoryEntry memoryEntry = entry;
        if (memoryEntry instanceof DeserializedMemoryEntry) {
            DeserializedMemoryEntry deserializedMemoryEntry = (DeserializedMemoryEntry)memoryEntry;
            Object values = deserializedMemoryEntry.value();
            left = new Left(values);
        } else if (memoryEntry instanceof SerializedMemoryEntry) {
            SerializedMemoryEntry serializedMemoryEntry = (SerializedMemoryEntry)memoryEntry;
            ChunkedByteBuffer buffer = serializedMemoryEntry.buffer();
            left = new Right((Object)buffer);
        } else {
            throw new MatchError((Object)memoryEntry);
        }
        Left data = left;
        StorageLevel newEffectiveStorageLevel = this.blockEvictionHandler.dropFromMemory(blockId, (Function0<Either<Object, ChunkedByteBuffer>>)((Function0 & Serializable)() -> MemoryStore.$anonfun$evictBlocksToFreeSpace$2((Either)data)), entry.classTag());
        if (newEffectiveStorageLevel.isValid()) {
            this.blockInfoManager.unlock(blockId, this.blockInfoManager.unlock$default$2());
            return;
        }
        this.blockInfoManager.removeBlock(blockId);
    }

    public MemoryStore(SparkConf conf, BlockInfoManager blockInfoManager, SerializerManager serializerManager, MemoryManager memoryManager, BlockEvictionHandler blockEvictionHandler) {
        this.conf = conf;
        this.blockInfoManager = blockInfoManager;
        this.serializerManager = serializerManager;
        this.memoryManager = memoryManager;
        this.blockEvictionHandler = blockEvictionHandler;
        Logging.$init$((Logging)this);
        this.entries = new LinkedHashMap(32, 0.75f, true);
        this.onHeapUnrollMemoryMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.offHeapUnrollMemoryMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.unrollMemoryThreshold = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.STORAGE_UNROLL_MEMORY_THRESHOLD()));
        if (this.maxMemory() < this.unrollMemoryThreshold()) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Max memory ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.NUM_BYTES$.MODULE$, (Object)Utils$.MODULE$.bytesToString(this.maxMemory()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"is less than the initial memory "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"threshold ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MAX_SIZE$.MODULE$, (Object)Utils$.MODULE$.bytesToString(this.unrollMemoryThreshold()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"needed to store a block in memory. Please configure Spark with more memory."}))).log((Seq)Nil$.MODULE$))));
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MemoryStore started with capacity "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MEMORY_SIZE$.MODULE$, (Object)Utils$.MODULE$.bytesToString(this.maxMemory()))})))));
    }
}

