/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.scope;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.rdd.DeterministicLevel$;
import org.apache.spark.scheduler.StageInfo;
import org.apache.spark.storage.RDDInfo;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.ui.scope.RDDOperationCluster;
import org.apache.spark.ui.scope.RDDOperationEdge;
import org.apache.spark.ui.scope.RDDOperationGraph;
import org.apache.spark.ui.scope.RDDOperationNode;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.xml.Utility$;

public final class RDDOperationGraph$
implements Logging,
Serializable {
    public static final RDDOperationGraph$ MODULE$ = new RDDOperationGraph$();
    private static final String STAGE_CLUSTER_PREFIX;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        STAGE_CLUSTER_PREFIX = "stage_";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String STAGE_CLUSTER_PREFIX() {
        return STAGE_CLUSTER_PREFIX;
    }

    public RDDOperationGraph makeOperationGraph(StageInfo stage, int retainedNodes) {
        ListBuffer edges = new ListBuffer();
        HashMap nodes = new HashMap();
        HashMap clusters = new HashMap();
        String stageClusterId = this.STAGE_CLUSTER_PREFIX() + stage.stageId();
        String stageClusterName = "Stage " + stage.stageId() + (stage.attemptNumber() == 0 ? "" : " (attempt " + stage.attemptNumber() + ")");
        RDDOperationCluster rootCluster = new RDDOperationCluster(stageClusterId, false, stageClusterName);
        IntRef rootNodeCount = IntRef.create((int)0);
        HashSet addRDDIds = new HashSet();
        HashSet dropRDDIds = new HashSet();
        ((IterableOnceOps)stage.rddInfos().sortBy((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1 & Serializable)rdd -> {
            RDDOperationGraph$.$anonfun$makeOperationGraph$2(rootNodeCount, retainedNodes, addRDDIds, dropRDDIds, edges, nodes, rootCluster, clusters, rdd);
            return BoxedUnit.UNIT;
        });
        ListBuffer internalEdges = new ListBuffer();
        ListBuffer outgoingEdges = new ListBuffer();
        ListBuffer incomingEdges = new ListBuffer();
        edges.foreach((Function1 & Serializable)x0$1 -> {
            RDDOperationEdge rDDOperationEdge = x0$1;
            if (rDDOperationEdge != null) {
                boolean toThisGraph;
                RDDOperationEdge rDDOperationEdge2 = rDDOperationEdge;
                boolean fromThisGraph = nodes.contains((Object)BoxesRunTime.boxToInteger((int)rDDOperationEdge2.fromId()));
                Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(fromThisGraph, toThisGraph = nodes.contains((Object)BoxesRunTime.boxToInteger((int)rDDOperationEdge2.toId())));
                if (sp2 != null) {
                    boolean bl = sp2._1$mcZ$sp();
                    boolean bl2 = sp2._2$mcZ$sp();
                    if (bl && bl2) {
                        return internalEdges.$plus$eq((Object)rDDOperationEdge2);
                    }
                }
                if (sp2 != null) {
                    boolean bl = sp2._1$mcZ$sp();
                    boolean bl3 = sp2._2$mcZ$sp();
                    if (bl && !bl3) {
                        return outgoingEdges.$plus$eq((Object)rDDOperationEdge2);
                    }
                }
                if (sp2 != null) {
                    boolean bl = sp2._1$mcZ$sp();
                    boolean bl4 = sp2._2$mcZ$sp();
                    if (!bl && bl4) {
                        return incomingEdges.$plus$eq((Object)rDDOperationEdge2);
                    }
                }
                MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found an orphan edge in stage "}))).log((scala.collection.immutable.Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STAGE_ID$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)stage.stageId())), new MDC((LogKey)LogKeys.ERROR$.MODULE$, (Object)rDDOperationEdge2)})))));
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)rDDOperationEdge);
        });
        return new RDDOperationGraph((Seq<RDDOperationEdge>)internalEdges.toSeq(), (Seq<RDDOperationEdge>)outgoingEdges.toSeq(), (Seq<RDDOperationEdge>)incomingEdges.toSeq(), rootCluster);
    }

    public String makeDotFile(RDDOperationGraph graph) {
        StringBuilder dotFile = new StringBuilder();
        dotFile.append("digraph G {\n");
        String indent = "  ";
        String graphId = "graph_" + graph.rootCluster().id().replaceAll(this.STAGE_CLUSTER_PREFIX(), "");
        dotFile.append(indent).append("id=\"" + graphId + "\";\n");
        this.makeDotSubgraph(dotFile, graph.rootCluster(), indent, this.makeDotSubgraph$default$4());
        graph.edges().foreach((Function1 & Serializable)edge -> dotFile.append("  " + edge.fromId() + "->" + edge.toId() + ";\n"));
        dotFile.append("}");
        String result = dotFile.toString();
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> result);
        return result;
    }

    private String makeDotNode(RDDOperationNode node) {
        String string;
        String isCached = node.cached() ? " [Cached]" : "";
        String isBarrier = node.barrier() ? " [Barrier]" : "";
        Enumeration.Value value = node.outputDeterministicLevel();
        Enumeration.Value value2 = DeterministicLevel$.MODULE$.DETERMINATE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string = "";
        } else {
            Enumeration.Value value4 = DeterministicLevel$.MODULE$.INDETERMINATE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                string = " [Indeterminate]";
            } else {
                Enumeration.Value value6 = DeterministicLevel$.MODULE$.UNORDERED();
                Enumeration.Value value7 = value;
                string = !(value6 != null ? !value6.equals(value7) : value7 != null) ? " [Unordered]" : "";
            }
        }
        String outputDeterministicLevel = string;
        String escapedCallsite = Utility$.MODULE$.escape(node.callsite());
        String label = StringEscapeUtils.escapeJava((String)(node.name() + " [" + node.id() + "]" + isCached + isBarrier + outputDeterministicLevel + "<br>" + escapedCallsite));
        return node.id() + " [id=\"node_" + node.id() + "\" labelType=\"html\" label=\"" + label + "}\"]";
    }

    private void makeDotSubgraph(StringBuilder subgraph, RDDOperationCluster cluster, String indent, String prefix) {
        String clusterId = prefix + cluster.id();
        subgraph.append(indent).append("subgraph " + clusterId + " {\n").append(indent).append("  id=\"" + clusterId + "\";\n").append(indent).append("  isCluster=\"true\";\n").append(indent).append("  label=\"" + StringEscapeUtils.escapeJava((String)cluster.name()) + "\";\n");
        cluster.childNodes().foreach((Function1 & Serializable)node -> subgraph.append(indent).append("  " + MODULE$.makeDotNode((RDDOperationNode)node) + ";\n"));
        cluster.childClusters().foreach((Function1 & Serializable)cscope -> {
            RDDOperationGraph$.MODULE$.makeDotSubgraph(subgraph, cscope, indent + "  ", "cluster_");
            return BoxedUnit.UNIT;
        });
        subgraph.append(indent).append("}\n");
    }

    private String makeDotSubgraph$default$4() {
        return "graph_";
    }

    public RDDOperationGraph apply(Seq<RDDOperationEdge> edges, Seq<RDDOperationEdge> outgoingEdges, Seq<RDDOperationEdge> incomingEdges, RDDOperationCluster rootCluster) {
        return new RDDOperationGraph(edges, outgoingEdges, incomingEdges, rootCluster);
    }

    public Option<Tuple4<Seq<RDDOperationEdge>, Seq<RDDOperationEdge>, Seq<RDDOperationEdge>, RDDOperationCluster>> unapply(RDDOperationGraph x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4(x$0.edges(), x$0.outgoingEdges(), x$0.incomingEdges(), (Object)x$0.rootCluster()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RDDOperationGraph$.class);
    }

    public static final /* synthetic */ RDDOperationEdge $anonfun$makeOperationGraph$5(RDDInfo rdd$1, int x$8) {
        return new RDDOperationEdge(x$8, rdd$1.id());
    }

    public static final /* synthetic */ void $anonfun$makeOperationGraph$11(scala.collection.immutable.Seq pc) {
        if (pc.size() == 2) {
            RDDOperationCluster parentCluster = (RDDOperationCluster)pc.apply(0);
            RDDOperationCluster childCluster = (RDDOperationCluster)pc.apply(1);
            parentCluster.attachChildCluster(childCluster);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$makeOperationGraph$12(RDDOperationCluster rootCluster$1, RDDOperationCluster cluster) {
        if (!rootCluster$1.childClusters().contains((Object)cluster)) {
            rootCluster$1.attachChildCluster(cluster);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$makeOperationGraph$2(IntRef rootNodeCount$1, int retainedNodes$1, HashSet addRDDIds$1, HashSet dropRDDIds$1, ListBuffer edges$1, HashMap nodes$1, RDDOperationCluster rootCluster$1, HashMap clusters$1, RDDInfo rdd) {
        boolean isAllowed;
        scala.collection.immutable.Seq<Object> parentIds = rdd.parentIds();
        if (parentIds.isEmpty()) {
            ++rootNodeCount$1.elem;
            v0 = rootNodeCount$1.elem <= retainedNodes$1;
        } else {
            v0 = isAllowed = parentIds.exists((Function1)(JFunction1.mcZI.sp & Serializable)id -> addRDDIds$1.contains((Object)BoxesRunTime.boxToInteger((int)id)) || !dropRDDIds$1.contains((Object)BoxesRunTime.boxToInteger((int)id)));
        }
        if (isAllowed) {
            addRDDIds$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)rdd.id()));
            v1 = edges$1.$plus$plus$eq((IterableOnce)((IterableOps)parentIds.filter((Function1)(JFunction1.mcZI.sp & Serializable)id -> !dropRDDIds$1.contains((Object)BoxesRunTime.boxToInteger((int)id)))).map((Function1 & Serializable)x$8 -> RDDOperationGraph$.$anonfun$makeOperationGraph$5(rdd, BoxesRunTime.unboxToInt((Object)x$8))));
        } else {
            v1 = dropRDDIds$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)rdd.id()));
        }
        RDDOperationNode node = (RDDOperationNode)nodes$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rdd.id()), (Function0 & Serializable)() -> {
            StorageLevel storageLevel = rdd.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            return new RDDOperationNode(rdd.id(), rdd.name(), storageLevel == null ? storageLevel2 != null : !storageLevel.equals(storageLevel2), rdd.isBarrier(), rdd.callSite(), rdd.outputDeterministicLevel());
        });
        if (rdd.scope().isEmpty()) {
            if (isAllowed) {
                rootCluster$1.attachChildNode(node);
                return;
            }
            return;
        }
        scala.collection.immutable.Seq rddScopes = (scala.collection.immutable.Seq)rdd.scope().map((Function1 & Serializable)scope -> scope.getAllScopes()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
        scala.collection.immutable.Seq rddClusters = (scala.collection.immutable.Seq)rddScopes.map((Function1 & Serializable)scope -> {
            String clusterId = scope.id();
            String clusterName = scope.name().replaceAll("\\n", "\\\\n");
            return (RDDOperationCluster)clusters$1.getOrElseUpdate((Object)clusterId, (Function0 & Serializable)() -> new RDDOperationCluster(clusterId, false, clusterName));
        });
        rddClusters.sliding(2).foreach((Function1 & Serializable)pc -> {
            RDDOperationGraph$.$anonfun$makeOperationGraph$11(pc);
            return BoxedUnit.UNIT;
        });
        rddClusters.headOption().foreach((Function1 & Serializable)cluster -> {
            RDDOperationGraph$.$anonfun$makeOperationGraph$12(rootCluster$1, cluster);
            return BoxedUnit.UNIT;
        });
        if (isAllowed) {
            rddClusters.lastOption().foreach((Function1 & Serializable)cluster -> {
                cluster.attachChildNode(node);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private RDDOperationGraph$() {
    }
}

