/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanServer;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.util.KnownSizeEstimation;
import org.apache.spark.util.SizeEstimator;
import org.apache.spark.util.collection.OpenHashSet;
import org.apache.spark.util.collection.OpenHashSet$mcI$sp;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.guava.collect.MapMaker;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@DeveloperApi
public final class SizeEstimator$
implements Logging {
    public static final SizeEstimator$ MODULE$ = new SizeEstimator$();
    private static final int BYTE_SIZE;
    private static final int BOOLEAN_SIZE;
    private static final int CHAR_SIZE;
    private static final int SHORT_SIZE;
    private static final int INT_SIZE;
    private static final int LONG_SIZE;
    private static final int FLOAT_SIZE;
    private static final int DOUBLE_SIZE;
    private static final List<Object> fieldSizes;
    private static final int ALIGN_SIZE;
    private static final ConcurrentMap<Class<?>, SizeEstimator.ClassInfo> classInfos;
    private static boolean is64bit;
    private static boolean isCompressedOops;
    private static int pointerSize;
    private static int objectSize;
    private static final int ARRAY_SIZE_FOR_SAMPLING;
    private static final int ARRAY_SAMPLE_SIZE;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        BYTE_SIZE = 1;
        BOOLEAN_SIZE = 1;
        CHAR_SIZE = 2;
        SHORT_SIZE = 2;
        INT_SIZE = 4;
        LONG_SIZE = 8;
        FLOAT_SIZE = 4;
        DOUBLE_SIZE = 8;
        fieldSizes = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{8, 4, 2, 1}));
        ALIGN_SIZE = 8;
        classInfos = new MapMaker().weakKeys().makeMap();
        is64bit = false;
        isCompressedOops = false;
        pointerSize = 4;
        objectSize = 8;
        MODULE$.initialize();
        ARRAY_SIZE_FOR_SAMPLING = 400;
        ARRAY_SAMPLE_SIZE = 100;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long estimate(Object obj) {
        return this.estimate(obj, new IdentityHashMap<Object, Object>());
    }

    private int BYTE_SIZE() {
        return BYTE_SIZE;
    }

    private int BOOLEAN_SIZE() {
        return BOOLEAN_SIZE;
    }

    private int CHAR_SIZE() {
        return CHAR_SIZE;
    }

    private int SHORT_SIZE() {
        return SHORT_SIZE;
    }

    private int INT_SIZE() {
        return INT_SIZE;
    }

    private int LONG_SIZE() {
        return LONG_SIZE;
    }

    private int FLOAT_SIZE() {
        return FLOAT_SIZE;
    }

    private int DOUBLE_SIZE() {
        return DOUBLE_SIZE;
    }

    private List<Object> fieldSizes() {
        return fieldSizes;
    }

    private int ALIGN_SIZE() {
        return ALIGN_SIZE;
    }

    private ConcurrentMap<Class<?>, SizeEstimator.ClassInfo> classInfos() {
        return classInfos;
    }

    private boolean is64bit() {
        return is64bit;
    }

    private void is64bit_$eq(boolean x$1) {
        is64bit = x$1;
    }

    private boolean isCompressedOops() {
        return isCompressedOops;
    }

    private void isCompressedOops_$eq(boolean x$1) {
        isCompressedOops = x$1;
    }

    private int pointerSize() {
        return pointerSize;
    }

    private void pointerSize_$eq(int x$1) {
        pointerSize = x$1;
    }

    private int objectSize() {
        return objectSize;
    }

    private void objectSize_$eq(int x$1) {
        objectSize = x$1;
    }

    private void initialize() {
        String arch = System.getProperty("os.arch");
        this.is64bit_$eq(arch.contains("64") || arch.contains("s390x"));
        this.isCompressedOops_$eq(this.getIsCompressedOops());
        this.objectSize_$eq(!this.is64bit() ? 8 : (!this.isCompressedOops() ? 16 : 12));
        this.pointerSize_$eq(this.is64bit() && !this.isCompressedOops() ? 8 : 4);
        this.classInfos().clear();
        this.classInfos().put(Object.class, new SizeEstimator.ClassInfo(this.objectSize(), (List<Field>)Nil$.MODULE$));
    }

    private boolean getIsCompressedOops() {
        boolean bl;
        if (System.getProperty(Tests$.MODULE$.TEST_USE_COMPRESSED_OOPS_KEY()) != null) {
            return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(System.getProperty(Tests$.MODULE$.TEST_USE_COMPRESSED_OOPS_KEY())));
        }
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor.contains("IBM") || javaVendor.contains("OpenJ9")) {
            return System.getProperty("java.vm.info").contains("Compressed Ref");
        }
        try {
            String hotSpotMBeanName = "com.sun.management:type=HotSpotDiagnostic";
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Class<?> hotSpotMBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            Method getVMMethod = hotSpotMBeanClass.getDeclaredMethod("getVMOption", Class.forName("java.lang.String"));
            Object bean = ManagementFactory.newPlatformMXBeanProxy(server, hotSpotMBeanName, hotSpotMBeanClass);
            bl = getVMMethod.invoke(bean, "UseCompressedOops").toString().contains("true");
        }
        catch (Exception exception) {
            boolean guess = Runtime.getRuntime().maxMemory() < 0x800000000L;
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to check whether UseCompressedOops is set; "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"assuming "}))).log((Seq)Nil$.MODULE$)).$plus(guess ? MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"yes"}))).log((Seq)Nil$.MODULE$) : MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"not"}))).log((Seq)Nil$.MODULE$))));
            bl = guess;
        }
        return bl;
    }

    private long estimate(Object obj, IdentityHashMap<Object, Object> visited) {
        SizeEstimator.SearchState state = new SizeEstimator.SearchState(visited);
        state.enqueue(obj);
        while (!state.isFinished()) {
            this.visitSingleObject(state.dequeue(), state);
        }
        return state.size();
    }

    private void visitSingleObject(Object obj, SizeEstimator.SearchState state) {
        Class<?> cls = obj.getClass();
        if (cls.isArray()) {
            this.visitArray(obj, cls, state);
            return;
        }
        if (cls.getName().startsWith("scala.reflect")) {
            return;
        }
        if (obj instanceof ClassLoader || obj instanceof Class) {
            return;
        }
        Object object = obj;
        if (object instanceof KnownSizeEstimation) {
            KnownSizeEstimation knownSizeEstimation = (KnownSizeEstimation)object;
            state.size_$eq(state.size() + knownSizeEstimation.estimatedSize());
            return;
        }
        SizeEstimator.ClassInfo classInfo = this.getClassInfo(cls);
        state.size_$eq(state.size() + this.alignSize(classInfo.shellSize()));
        classInfo.pointerFields().foreach((Function1 & Serializable)field -> {
            state.enqueue(field.get(obj));
            return BoxedUnit.UNIT;
        });
    }

    private int ARRAY_SIZE_FOR_SAMPLING() {
        return ARRAY_SIZE_FOR_SAMPLING;
    }

    private int ARRAY_SAMPLE_SIZE() {
        return ARRAY_SAMPLE_SIZE;
    }

    private void visitArray(Object array, Class<?> arrayClass, SizeEstimator.SearchState state) {
        int length = ScalaRunTime$.MODULE$.array_length(array);
        Class<?> elementClass = arrayClass.getComponentType();
        long arrSize = this.alignSize(this.objectSize() + this.INT_SIZE());
        if (elementClass.isPrimitive()) {
            state.size_$eq(state.size() + (arrSize += this.alignSize((long)length * (long)this.primitiveSize(elementClass))));
            return;
        }
        state.size_$eq(state.size() + (arrSize += this.alignSize((long)length * (long)this.pointerSize())));
        if (length <= this.ARRAY_SIZE_FOR_SAMPLING()) {
            for (int arrayIndex = 0; arrayIndex < length; ++arrayIndex) {
                state.enqueue(ScalaRunTime$.MODULE$.array_apply(array, arrayIndex));
            }
            return;
        }
        Random rand = new Random(42L);
        OpenHashSet$mcI$sp drawn = new OpenHashSet$mcI$sp(2 * this.ARRAY_SAMPLE_SIZE(), (ClassTag<Object>)ClassTag$.MODULE$.Int());
        long s1 = this.sampleArray(array, state, rand, drawn, length);
        long s2 = this.sampleArray(array, state, rand, drawn, length);
        long size = scala.math.package$.MODULE$.min(s1, s2);
        state.size_$eq(state.size() + (scala.math.package$.MODULE$.max(s1, s2) + size * (long)((length - this.ARRAY_SAMPLE_SIZE()) / this.ARRAY_SAMPLE_SIZE())));
    }

    private long sampleArray(Object array, SizeEstimator.SearchState state, Random rand, OpenHashSet<Object> drawn, int length) {
        LongRef size = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.ARRAY_SAMPLE_SIZE()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int index = 0;
            while (drawn.contains$mcI$sp(index = rand.nextInt(length))) {
            }
            drawn.add$mcI$sp(index);
            Object obj = ScalaRunTime$.MODULE$.array_apply(array, index);
            if (obj != null) {
                size$1.elem += MODULE$.estimate(obj, state.visited());
                return;
            }
        });
        return size.elem;
    }

    private int primitiveSize(Class<?> cls) {
        Class<?> clazz = cls;
        Class<Byte> clazz2 = Byte.TYPE;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return this.BYTE_SIZE();
        }
        Class<?> clazz3 = cls;
        Class<Boolean> clazz4 = Boolean.TYPE;
        if (!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null)) {
            return this.BOOLEAN_SIZE();
        }
        Class<?> clazz5 = cls;
        Class<Character> clazz6 = Character.TYPE;
        if (!(clazz5 != null ? !clazz5.equals(clazz6) : clazz6 != null)) {
            return this.CHAR_SIZE();
        }
        Class<?> clazz7 = cls;
        Class<Short> clazz8 = Short.TYPE;
        if (!(clazz7 != null ? !clazz7.equals(clazz8) : clazz8 != null)) {
            return this.SHORT_SIZE();
        }
        Class<?> clazz9 = cls;
        Class<Integer> clazz10 = Integer.TYPE;
        if (!(clazz9 != null ? !clazz9.equals(clazz10) : clazz10 != null)) {
            return this.INT_SIZE();
        }
        Class<?> clazz11 = cls;
        Class<Long> clazz12 = Long.TYPE;
        if (!(clazz11 != null ? !clazz11.equals(clazz12) : clazz12 != null)) {
            return this.LONG_SIZE();
        }
        Class<?> clazz13 = cls;
        Class<Float> clazz14 = Float.TYPE;
        if (!(clazz13 != null ? !clazz13.equals(clazz14) : clazz14 != null)) {
            return this.FLOAT_SIZE();
        }
        Class<?> clazz15 = cls;
        Class<Double> clazz16 = Double.TYPE;
        if (!(clazz15 != null ? !clazz15.equals(clazz16) : clazz16 != null)) {
            return this.DOUBLE_SIZE();
        }
        throw new IllegalArgumentException("Non-primitive class " + cls + " passed to primitiveSize()");
    }

    private SizeEstimator.ClassInfo getClassInfo(Class<?> cls) {
        SizeEstimator.ClassInfo info = (SizeEstimator.ClassInfo)this.classInfos().get(cls);
        if (info != null) {
            return info;
        }
        SizeEstimator.ClassInfo parent = this.getClassInfo(cls.getSuperclass());
        LongRef shellSize = LongRef.create((long)parent.shellSize());
        ObjectRef pointerFields = ObjectRef.create(parent.pointerFields());
        int[] sizeCount = (int[])Array$.MODULE$.ofDim(BoxesRunTime.unboxToInt((Object)this.fieldSizes().max((Ordering)Ordering.Int$.MODULE$)) + 1, (ClassTag)ClassTag$.MODULE$.Int());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])cls.getDeclaredFields()), (Function1 & Serializable)field -> {
            SizeEstimator$.$anonfun$getClassInfo$1(sizeCount, pointerFields, field);
            return BoxedUnit.UNIT;
        });
        LongRef alignedSize = LongRef.create((long)shellSize.elem);
        this.fieldSizes().withFilter((Function1)(JFunction1.mcZI.sp & Serializable)size -> sizeCount[size] > 0).foreach((Function1)(JFunction1.mcVI.sp & Serializable)size -> {
            long count = sizeCount[size];
            alignedSize$1.elem = scala.math.package$.MODULE$.max(alignedSize$1.elem, MODULE$.alignSizeUp(shellSize$1.elem, size) + (long)size * count);
            shellSize$1.elem += (long)size * count;
        });
        shellSize.elem = this.alignSizeUp(alignedSize.elem, this.pointerSize());
        SizeEstimator.ClassInfo newInfo = new SizeEstimator.ClassInfo(shellSize.elem, (List<Field>)((List)pointerFields.elem));
        this.classInfos().put(cls, newInfo);
        return newInfo;
    }

    private long alignSize(long size) {
        return this.alignSizeUp(size, this.ALIGN_SIZE());
    }

    private long alignSizeUp(long size, int alignSize) {
        return size + (long)alignSize - 1L & (long)(~(alignSize - 1));
    }

    public static final /* synthetic */ void $anonfun$getClassInfo$1(int[] sizeCount$1, ObjectRef pointerFields$1, Field field) {
        if (!Modifier.isStatic(field.getModifiers())) {
            Class<?> fieldClass = field.getType();
            if (fieldClass.isPrimitive()) {
                int n = MODULE$.primitiveSize(fieldClass);
                sizeCount$1[n] = sizeCount$1[n] + 1;
                return;
            }
            try {
                if (field.trySetAccessible()) {
                    Field field2 = field;
                    pointerFields$1.elem = ((List)pointerFields$1.elem).$colon$colon((Object)field2);
                }
            }
            catch (SecurityException securityException) {}
            int n = MODULE$.pointerSize();
            sizeCount$1[n] = sizeCount$1[n] + 1;
            return;
        }
    }

    private SizeEstimator$() {
    }
}

