/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.continuous;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestampLike;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.LocalTimestamp;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.streaming.StreamingRelationV2;
import org.apache.spark.sql.catalyst.streaming.WriteToStream;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.UnspecifiedDistribution;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.streaming.ContinuousStream;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.PartitionOffset;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.SparkDataStream;
import org.apache.spark.sql.connector.write.RequiresDistributionAndOrdering;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.connector.write.streaming.StreamingWrite;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2ScanRelation;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2ScanRelation$;
import org.apache.spark.sql.execution.streaming.ACTIVE$;
import org.apache.spark.sql.execution.streaming.AcceptsLatestSeenOffsetHandler$;
import org.apache.spark.sql.execution.streaming.CommitMetadata;
import org.apache.spark.sql.execution.streaming.CommitMetadata$;
import org.apache.spark.sql.execution.streaming.ContinuousExecutionContext;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.IncrementalExecution;
import org.apache.spark.sql.execution.streaming.IncrementalExecution$;
import org.apache.spark.sql.execution.streaming.MicroBatchExecutionContext;
import org.apache.spark.sql.execution.streaming.OffsetSeq;
import org.apache.spark.sql.execution.streaming.OffsetSeq$;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger;
import org.apache.spark.sql.execution.streaming.RECONFIGURING$;
import org.apache.spark.sql.execution.streaming.State;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.execution.streaming.StreamExecutionContext;
import org.apache.spark.sql.execution.streaming.StreamProgress;
import org.apache.spark.sql.execution.streaming.TERMINATED$;
import org.apache.spark.sql.execution.streaming.WatermarkPropagator$;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution$;
import org.apache.spark.sql.execution.streaming.continuous.EpochCoordinatorRef$;
import org.apache.spark.sql.execution.streaming.continuous.IncrementAndGetEpoch$;
import org.apache.spark.sql.execution.streaming.continuous.StopContinuousExecutionWrites$;
import org.apache.spark.sql.execution.streaming.continuous.WriteToContinuousDataSource;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Clock;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t]a\u0001\u0002\u0015*\u0001aB\u0011\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010#\t\u0013\u0015\u0003!\u0011!Q\u0001\n\u0019[\u0005\"\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'T\u0011!!\u0006A!A!\u0002\u0013)\u0006\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011\u00024\t\u000b5\u0004A\u0011\u00018\t\u0011Y\u0004\u0001R1A\u0005\n]DQa\u001f\u0001\u0005BqDq! \u0001A\u0002\u0013Ea\u0010C\u0005\u0002$\u0001\u0001\r\u0011\"\u0005\u0002&!9\u00111\u0007\u0001!B\u0013y\b\u0002DA\u001f\u0001\u0001\u0007\t\u0019!C\u0001_\u0005}\u0002\u0002DA!\u0001\u0001\u0007\t\u0019!C\u0001_\u0005\r\u0003BCA$\u0001\u0001\u0007\t\u0011)Q\u0005E\"I\u0011\u0011\n\u0001C\u0002\u0013%\u00111\n\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002N!I\u00111\u000e\u0001C\u0002\u0013\u0005\u0013Q\u000e\u0005\t\u0003k\u0002\u0001\u0015!\u0003\u0002p!9\u0011q\u000f\u0001\u0005\n\u0005e\u0004bBAH\u0001\u0011%\u0011\u0011\u0013\u0005\n\u0003+\u0003!\u0019!C\u0005\u0003/C\u0001\"a(\u0001A\u0003%\u0011\u0011\u0014\u0005\b\u0003C\u0003A\u0011KAR\u0011\u001d\tI\u000b\u0001C\u0005\u0003WCq!a-\u0001\t\u0013\t)\fC\u0004\u0002<\u0002!\t!!0\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\"A\u0011q\u001c\u0001\u0005\u0002=\n\t\u000fC\u0004\u0002f\u0002!\t!a:\t\u000f\u0005\u0015\b\u0001\"\u0003\u0002n\"9\u0011q\u001e\u0001\u0005B\u00055\b\"DAy\u0001A\u0005\u0019\u0011!A\u0005\n\u0005MHiB\u0004\u0002v&B\t!a>\u0007\r!J\u0003\u0012AA}\u0011\u0019i'\u0005\"\u0001\u0003\u0002!I!1\u0001\u0012C\u0002\u0013\u0005!Q\u0001\u0005\t\u0005#\u0011\u0003\u0015!\u0003\u0003\b!I!1\u0003\u0012C\u0002\u0013\u0005!Q\u0001\u0005\t\u0005+\u0011\u0003\u0015!\u0003\u0003\b\t\u00192i\u001c8uS:,x.^:Fq\u0016\u001cW\u000f^5p]*\u0011!fK\u0001\u000bG>tG/\u001b8v_V\u001c(B\u0001\u0017.\u0003%\u0019HO]3b[&twM\u0003\u0002/_\u0005IQ\r_3dkRLwN\u001c\u0006\u0003aE\n1a]9m\u0015\t\u00114'A\u0003ta\u0006\u00148N\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<7\u0001A\n\u0003\u0001e\u0002\"AO\u001e\u000e\u0003-J!\u0001P\u0016\u0003\u001fM#(/Z1n\u000bb,7-\u001e;j_:\fAb\u001d9be.\u001cVm]:j_:\u0004\"a\u0010\"\u000e\u0003\u0001S!!Q\u0018\u0002\u000f\rd\u0017m]:jG&\u00111\t\u0011\u0002\r'B\f'o[*fgNLwN\\\u0005\u0003{m\nq\u0001\u001e:jO\u001e,'\u000f\u0005\u0002H\u00136\t\u0001J\u0003\u0002-_%\u0011!\n\u0013\u0002\b)JLwmZ3s\u0013\t)5(\u0001\u0007ue&<w-\u001a:DY>\u001c7\u000e\u0005\u0002O#6\tqJ\u0003\u0002Qc\u0005!Q\u000f^5m\u0013\t\u0011vJA\u0003DY>\u001c7.\u0003\u0002Mw\u0005aQ\r\u001f;sC>\u0003H/[8ogB!ak\u00182c\u001d\t9V\f\u0005\u0002Y76\t\u0011L\u0003\u0002[o\u00051AH]8pizR\u0011\u0001X\u0001\u0006g\u000e\fG.Y\u0005\u0003=n\u000ba\u0001\u0015:fI\u00164\u0017B\u00011b\u0005\ri\u0015\r\u001d\u0006\u0003=n\u0003\"AV2\n\u0005\u0011\f'AB*ue&tw-\u0001\u0003qY\u0006t\u0007CA4l\u001b\u0005A'B\u0001\u0017j\u0015\tQw&\u0001\u0005dCR\fG._:u\u0013\ta\u0007NA\u0007Xe&$X\rV8TiJ,\u0017-\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\r=\f(o\u001d;v!\t\u0001\b!D\u0001*\u0011\u0015id\u00011\u0001?\u0011\u0015)e\u00011\u0001G\u0011\u0015ae\u00011\u0001N\u0011\u0015!f\u00011\u0001V\u0011\u0015)g\u00011\u0001g\u0003Ya\u0017\r^3ti\u0016CXmY;uS>t7i\u001c8uKb$X#\u0001=\u0011\u0005iJ\u0018B\u0001>,\u0005Y\u0019FO]3b[\u0016CXmY;uS>t7i\u001c8uKb$\u0018!G4fi2\u000bG/Z:u\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR$\u0012\u0001_\u0001\bg>,(oY3t+\u0005y\bCBA\u0001\u0003\u0017\t\tB\u0004\u0003\u0002\u0004\u0005\u001dab\u0001-\u0002\u0006%\tA,C\u0002\u0002\nm\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u000e\u0005=!aA*fc*\u0019\u0011\u0011B.\u0011\t\u0005M\u0011qD\u0007\u0003\u0003+Q1\u0001LA\f\u0015\u0011\tI\"a\u0007\u0002\tI,\u0017\r\u001a\u0006\u0004\u0003;y\u0013!C2p]:,7\r^8s\u0013\u0011\t\t#!\u0006\u0003!\r{g\u000e^5ok>,8o\u0015;sK\u0006l\u0017aC:pkJ\u001cWm]0%KF$B!a\n\u00020A!\u0011\u0011FA\u0016\u001b\u0005Y\u0016bAA\u00177\n!QK\\5u\u0011!\t\tDCA\u0001\u0002\u0004y\u0018a\u0001=%c\u0005A1o\\;sG\u0016\u001c\b\u0005K\u0002\f\u0003o\u0001B!!\u000b\u0002:%\u0019\u00111H.\u0003\u0011Y|G.\u0019;jY\u0016\f\u0011dY;se\u0016tG/\u00129pG\"\u001cun\u001c:eS:\fGo\u001c:JIV\t!-A\u000fdkJ\u0014XM\u001c;Fa>\u001c\u0007nQ8pe\u0012Lg.\u0019;pe&#w\fJ3r)\u0011\t9#!\u0012\t\u0011\u0005ER\"!AA\u0002\t\f!dY;se\u0016tG/\u00129pG\"\u001cun\u001c:eS:\fGo\u001c:JI\u0002\nqAZ1jYV\u0014X-\u0006\u0002\u0002NA1\u0011qJA0\u0003Gj!!!\u0015\u000b\t\u0005M\u0013QK\u0001\u0007CR|W.[2\u000b\t\u0005]\u0013\u0011L\u0001\u000bG>t7-\u001e:sK:$(b\u0001)\u0002\\)\u0011\u0011QL\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002b\u0005E#aD!u_6L7MU3gKJ,gnY3\u0011\t\u0005\u0005\u0011QM\u0005\u0005\u0003O\nyAA\u0005UQJ|w/\u00192mK\u0006Aa-Y5mkJ,\u0007%A\u0006m_\u001eL7-\u00197QY\u0006tWCAA8!\r\u0001\u0018\u0011O\u0005\u0004\u0003gJ#aG,sSR,Gk\\\"p]RLg.^8vg\u0012\u000bG/Y*pkJ\u001cW-\u0001\u0007m_\u001eL7-\u00197QY\u0006t\u0007%A\u000eiCN$\u0015n\u001d;sS\n,H/[8o%\u0016\fX/\u001b:f[\u0016tGo\u001d\u000b\u0005\u0003w\n\t\t\u0005\u0003\u0002*\u0005u\u0014bAA@7\n9!i\\8mK\u0006t\u0007bBAB'\u0001\u0007\u0011QQ\u0001\u0006oJLG/\u001a\t\u0005\u0003\u000f\u000bY)\u0004\u0002\u0002\n*!\u00111QA\u000e\u0013\u0011\ti)!#\u0003\u000b]\u0013\u0018\u000e^3\u0002/!\f7o\u0014:eKJLgn\u001a*fcVL'/Z7f]R\u001cH\u0003BA>\u0003'Cq!a!\u0015\u0001\u0004\t))A\bue&<w-\u001a:Fq\u0016\u001cW\u000f^8s+\t\tI\nE\u0002;\u00037K1!!(,\u0005Y\u0001&o\\2fgNLgn\u001a+j[\u0016,\u00050Z2vi>\u0014\u0018\u0001\u0005;sS\u001e<WM]#yK\u000e,Ho\u001c:!\u0003I\u0011XO\\!di&4\u0018\r^3e'R\u0014X-Y7\u0015\t\u0005\u001d\u0012Q\u0015\u0005\u0007\u0003O;\u0002\u0019\u0001 \u0002+M\u0004\u0018M]6TKN\u001c\u0018n\u001c8G_J\u001cFO]3b[\u0006yq-\u001a;Ti\u0006\u0014Ho\u00144gg\u0016$8\u000f\u0006\u0002\u0002.B\u0019!(a,\n\u0007\u0005E6FA\u0005PM\u001a\u001cX\r^*fc\u0006i!/\u001e8D_:$\u0018N\\;pkN$B!a\n\u00028\"1\u0011\u0011X\rA\u0002y\nAc\u001d9be.\u001cVm]:j_:4uN])vKJL\u0018!C1eI>3gm]3u)!\t9#a0\u0002J\u00065\u0007bBAa5\u0001\u0007\u00111Y\u0001\u0006KB|7\r\u001b\t\u0005\u0003S\t)-C\u0002\u0002Hn\u0013A\u0001T8oO\"9\u00111\u001a\u000eA\u0002\u0005E\u0011AB:ue\u0016\fW\u000eC\u0004\u0002Pj\u0001\r!!5\u0002!A\f'\u000f^5uS>twJ\u001a4tKR\u001c\bCBA\u0001\u0003\u0017\t\u0019\u000e\u0005\u0003\u0002\u0014\u0005U\u0017\u0002BAl\u0003+\u0011q\u0002U1si&$\u0018n\u001c8PM\u001a\u001cX\r^\u0001\u0007G>lW.\u001b;\u0015\t\u0005\u001d\u0012Q\u001c\u0005\b\u0003\u0003\\\u0002\u0019AAb\u0003)\tw/Y5u\u000bB|7\r\u001b\u000b\u0005\u0003O\t\u0019\u000fC\u0004\u0002Br\u0001\r!a1\u0002\u001fM$x\u000e]%o\u001d\u0016<H\u000b\u001b:fC\u0012$B!a\n\u0002j\"9\u00111^\u000fA\u0002\u0005\r\u0014!B3se>\u0014HCAA\u0014\u0003\u0011\u0019Ho\u001c9\u0002%M,\b/\u001a:%gB\f'o[*fgNLwN\\\u000b\u0002}\u0005\u00192i\u001c8uS:,x.^:Fq\u0016\u001cW\u000f^5p]B\u0011\u0001OI\n\u0004E\u0005m\b\u0003BA\u0015\u0003{L1!a@\\\u0005\u0019\te.\u001f*fMR\u0011\u0011q_\u0001\u0010'R\u000b%\u000bV0F!>\u001b\u0005jX&F3V\u0011!q\u0001\t\u0005\u0005\u0013\u0011y!\u0004\u0002\u0003\f)!!QBA.\u0003\u0011a\u0017M\\4\n\u0007\u0011\u0014Y!\u0001\tT)\u0006\u0013FkX#Q\u001f\u000eCulS#ZA\u0005AR\tU(D\u0011~\u001buj\u0014*E\u0013:\u000bEk\u0014*`\u0013\u0012{6*R-\u00023\u0015\u0003vj\u0011%`\u0007>{%\u000bR%O\u0003R{%kX%E?.+\u0015\f\t")
public class ContinuousExecution
extends StreamExecution {
    private StreamExecutionContext latestExecutionContext;
    private volatile Seq<ContinuousStream> sources = (Seq)Nil$.MODULE$;
    private String currentEpochCoordinatorId;
    private final AtomicReference<Throwable> failure = new AtomicReference<Object>(null);
    private final WriteToContinuousDataSource logicalPlan;
    private final ProcessingTimeExecutor org$apache$spark$sql$execution$streaming$continuous$ContinuousExecution$$triggerExecutor;
    private volatile boolean bitmap$0;

    public static String EPOCH_COORDINATOR_ID_KEY() {
        return ContinuousExecution$.MODULE$.EPOCH_COORDINATOR_ID_KEY();
    }

    public static String START_EPOCH_KEY() {
        return ContinuousExecution$.MODULE$.START_EPOCH_KEY();
    }

    private /* synthetic */ SparkSession super$sparkSession() {
        return super.sparkSession();
    }

    private StreamExecutionContext latestExecutionContext$lzycompute() {
        ContinuousExecution continuousExecution = this;
        synchronized (continuousExecution) {
            if (!this.bitmap$0) {
                this.latestExecutionContext = new ContinuousExecutionContext(this.id(), this.runId(), this.name(), super.triggerClock(), this.sources(), this.sink(), this.progressReporter(), -1L, super.sparkSession());
                this.bitmap$0 = true;
            }
        }
        return this.latestExecutionContext;
    }

    private StreamExecutionContext latestExecutionContext() {
        if (!this.bitmap$0) {
            return this.latestExecutionContext$lzycompute();
        }
        return this.latestExecutionContext;
    }

    @Override
    public StreamExecutionContext getLatestExecutionContext() {
        return this.latestExecutionContext();
    }

    public Seq<ContinuousStream> sources() {
        return this.sources;
    }

    public void sources_$eq(Seq<ContinuousStream> x$1) {
        this.sources = x$1;
    }

    public String currentEpochCoordinatorId() {
        return this.currentEpochCoordinatorId;
    }

    public void currentEpochCoordinatorId_$eq(String x$1) {
        this.currentEpochCoordinatorId = x$1;
    }

    private AtomicReference<Throwable> failure() {
        return this.failure;
    }

    @Override
    public WriteToContinuousDataSource logicalPlan() {
        return this.logicalPlan;
    }

    private boolean hasDistributionRequirements(Write write) {
        RequiresDistributionAndOrdering requiresDistributionAndOrdering;
        Write write2 = write;
        if (write2 instanceof RequiresDistributionAndOrdering && (requiresDistributionAndOrdering = (RequiresDistributionAndOrdering)write2).requiredNumPartitions() == 0) {
            Distribution distribution = requiresDistributionAndOrdering.requiredDistribution();
            return !(distribution instanceof UnspecifiedDistribution);
        }
        return false;
    }

    private boolean hasOrderingRequirements(Write write) {
        RequiresDistributionAndOrdering requiresDistributionAndOrdering;
        Write write2 = write;
        return write2 instanceof RequiresDistributionAndOrdering && ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])(requiresDistributionAndOrdering = (RequiresDistributionAndOrdering)write2).requiredOrdering()));
    }

    public ProcessingTimeExecutor org$apache$spark$sql$execution$streaming$continuous$ContinuousExecution$$triggerExecutor() {
        return this.org$apache$spark$sql$execution$streaming$continuous$ContinuousExecution$$triggerExecutor;
    }

    @Override
    public void runActivatedStream(SparkSession sparkSessionForStream) {
        UnaryOperator<State> stateUpdate = new UnaryOperator<State>(null){

            public State apply(State s) {
                State state = s;
                if (RECONFIGURING$.MODULE$.equals(state)) {
                    return ACTIVE$.MODULE$;
                }
                return s;
            }
        };
        while (true) {
            this.runContinuous(sparkSessionForStream);
            State state = this.state().updateAndGet(stateUpdate);
            ACTIVE$ aCTIVE$ = ACTIVE$.MODULE$;
            if (state == null) {
                if (aCTIVE$ == null) continue;
                break;
            }
            if (!state.equals(aCTIVE$)) break;
        }
        this.stopSources();
    }

    private OffsetSeq getStartOffsets() {
        Some some;
        Tuple2 tuple2;
        ContinuousExecutionContext execCtx = (ContinuousExecutionContext)this.latestExecutionContext();
        Option option = this.commitLog().getLatest();
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            long latestEpochId = tuple2._1$mcJ$sp();
            execCtx.updateStatusMessage("Starting new streaming query and getting offsets from latest epoch " + latestEpochId);
            OffsetSeq nextOffsets = (OffsetSeq)this.offsetLog().get(latestEpochId).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalStateException("Batch " + latestEpochId + " was committed without end epoch offsets!");
            });
            this.committedOffsets_$eq(nextOffsets.toStreamProgress(this.sources()));
            execCtx.batchId_$eq(latestEpochId + 1L);
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Resuming at epoch " + execCtx.batchId() + " with start offsets " + execCtx.startOffsets());
            return nextOffsets;
        }
        if (None$.MODULE$.equals(option)) {
            execCtx.updateStatusMessage("Starting new streaming query");
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Starting new streaming query.");
            execCtx.batchId_$eq(0L);
            return OffsetSeq$.MODULE$.fill((Seq<Offset>)((Seq)this.sources().map((Function1 & Serializable)x$2 -> null)));
        }
        throw new MatchError(option);
    }

    private void runContinuous(SparkSession sparkSessionForQuery) {
        block9: {
            OffsetSeq offsets = this.getStartOffsets();
            StreamExecutionContext execCtx = this.latestExecutionContext();
            if (execCtx.batchId() > 0L) {
                AcceptsLatestSeenOffsetHandler$.MODULE$.setLatestSeenOffsetOnSources((Option<OffsetSeq>)new Some((Object)offsets), this.sources());
            }
            LogicalPlan withNewSources = (LogicalPlan)this.logicalPlan().transform((PartialFunction)new Serializable(null, offsets){
                private static final long serialVersionUID = 0L;
                private final OffsetSeq offsets$1;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof StreamingDataSourceV2ScanRelation) {
                        StreamingDataSourceV2ScanRelation streamingDataSourceV2ScanRelation = (StreamingDataSourceV2ScanRelation)A1;
                        Option loggedOffset = (Option)this.offsets$1.offsets().apply(0);
                        Option realOffset = loggedOffset.map((Function1 & Serializable)off -> streamingDataSourceV2ScanRelation.stream().deserializeOffset(off.json()));
                        Offset startOffset = (Offset)realOffset.getOrElse((Function0 & Serializable)() -> streamingDataSourceV2ScanRelation.stream().initialOffset());
                        Some x$1 = new Some((Object)startOffset);
                        StreamingDataSourceV2Relation x$2 = streamingDataSourceV2ScanRelation.copy$default$1();
                        Scan x$3 = streamingDataSourceV2ScanRelation.copy$default$2();
                        Seq x$4 = streamingDataSourceV2ScanRelation.copy$default$3();
                        SparkDataStream x$5 = streamingDataSourceV2ScanRelation.copy$default$4();
                        Option x$6 = streamingDataSourceV2ScanRelation.copy$default$6();
                        return (B1)streamingDataSourceV2ScanRelation.copy(x$2, x$3, x$4, x$5, (Option)x$1, x$6);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan2 = x1;
                    return logicalPlan2 instanceof StreamingDataSourceV2ScanRelation;
                }
                {
                    this.offsets$1 = offsets$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2ScanRelation org.apache.spark.sql.connector.read.streaming.Offset ), $anonfun$applyOrElse$4(org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2ScanRelation )}, serializedLambda);
                }
            });
            withNewSources.transformAllExpressionsWithPruning((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.containsPattern(TreePattern$.MODULE$.CURRENT_LIKE())), withNewSources.transformAllExpressionsWithPruning$default$2(), (PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof CurrentTimestampLike ? true : (A1 instanceof CurrentDate ? true : A1 instanceof LocalTimestamp)) {
                        throw new IllegalStateException("CurrentTimestamp, Now, CurrentDate and LocalTimestamp not yet supported for continuous processing");
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Expression x2) {
                    Expression expression = x2;
                    return expression instanceof CurrentTimestampLike ? true : (expression instanceof CurrentDate ? true : expression instanceof LocalTimestamp);
                }
            });
            execCtx.reportTimeTaken("queryPlanning", (Function0 & Serializable)() -> {
                execCtx.executionPlan_$eq(new IncrementalExecution(sparkSessionForQuery, withNewSources, this.outputMode(), this.checkpointFile("state"), this.id(), this.runId(), execCtx.batchId(), (Option<OffsetSeqMetadata>)None$.MODULE$, execCtx.offsetSeqMetadata(), WatermarkPropagator$.MODULE$.noop(), false, IncrementalExecution$.MODULE$.$lessinit$greater$default$12(), IncrementalExecution$.MODULE$.$lessinit$greater$default$13(), IncrementalExecution$.MODULE$.$lessinit$greater$default$14(), IncrementalExecution$.MODULE$.$lessinit$greater$default$15()));
                return execCtx.executionPlan().executedPlan();
            });
            ContinuousStream stream = (ContinuousStream)withNewSources.collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1 instanceof StreamingDataSourceV2ScanRelation) {
                        StreamingDataSourceV2ScanRelation streamingDataSourceV2ScanRelation = (StreamingDataSourceV2ScanRelation)A1;
                        return (B1)((ContinuousStream)streamingDataSourceV2ScanRelation.stream());
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(LogicalPlan x3) {
                    LogicalPlan logicalPlan2 = x3;
                    return logicalPlan2 instanceof StreamingDataSourceV2ScanRelation;
                }
            }).head();
            sparkSessionForQuery.sparkContext().setLocalProperty(StreamExecution$.MODULE$.IS_CONTINUOUS_PROCESSING(), Boolean.toString(true));
            sparkSessionForQuery.sparkContext().setLocalProperty(ContinuousExecution$.MODULE$.START_EPOCH_KEY(), Long.toString(execCtx.batchId()));
            String epochCoordinatorId = this.runId() + "--" + UUID.randomUUID();
            this.currentEpochCoordinatorId_$eq(epochCoordinatorId);
            sparkSessionForQuery.sparkContext().setLocalProperty(ContinuousExecution$.MODULE$.EPOCH_COORDINATOR_ID_KEY(), epochCoordinatorId);
            RpcEndpointRef epochEndpoint = EpochCoordinatorRef$.MODULE$.create(this.logicalPlan().write(), stream, this, epochCoordinatorId, execCtx.batchId(), super.sparkSession(), SparkEnv$.MODULE$.get());
            Thread epochUpdateThread = new Thread(new Runnable(this, execCtx, stream, epochEndpoint){
                private final /* synthetic */ ContinuousExecution $outer;
                private final StreamExecutionContext execCtx$2;
                private final ContinuousStream stream$1;
                private final RpcEndpointRef epochEndpoint$1;

                public void run() {
                    try {
                        this.$outer.org$apache$spark$sql$execution$streaming$continuous$ContinuousExecution$$triggerExecutor().execute((Function1<MicroBatchExecutionContext, Object>)(Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)$anon$2.$anonfun$run$1(this, x$4)));
                    }
                    catch (InterruptedException interruptedException) {}
                }

                public static final /* synthetic */ boolean $anonfun$run$1($anon$2 $this, MicroBatchExecutionContext x$4) {
                    $this.execCtx$2.startTrigger();
                    if ($this.stream$1.needsReconfiguration() && $this.$outer.state().compareAndSet(ACTIVE$.MODULE$, RECONFIGURING$.MODULE$)) {
                        if ($this.$outer.queryExecutionThread().isAlive()) {
                            $this.$outer.queryExecutionThread().interrupt();
                        }
                        return false;
                    }
                    if ($this.$outer.isActive()) {
                        $this.execCtx$2.batchId_$eq(BoxesRunTime.unboxToLong((Object)$this.epochEndpoint$1.askSync((Object)IncrementAndGetEpoch$.MODULE$, (ClassTag)ClassTag$.MODULE$.Long())));
                        $this.$outer.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"New epoch ", " is starting."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BATCH_ID$.MODULE$, (Object)BoxesRunTime.boxToLong((long)$this.execCtx$2.batchId()))}))));
                        return true;
                    }
                    return false;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.execCtx$2 = execCtx$2;
                    this.stream$1 = stream$1;
                    this.epochEndpoint$1 = epochEndpoint$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution$$anon$2 org.apache.spark.sql.execution.streaming.MicroBatchExecutionContext ), $anonfun$run$2(org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution$$anon$2 )}, serializedLambda);
                }
            }, "epoch update thread for " + this.prettyIdString());
            try {
                try {
                    epochUpdateThread.setDaemon(true);
                    epochUpdateThread.start();
                    execCtx.updateStatusMessage("Running");
                    execCtx.reportTimeTaken("runContinuous", (Function0 & Serializable)() -> (RDD)SQLExecution$.MODULE$.withNewExecutionId(this.lastExecution(), SQLExecution$.MODULE$.withNewExecutionId$default$2(), (Function0 & Serializable)() -> this.lastExecution().executedPlan().execute()));
                    Throwable f = this.failure().get();
                    if (f != null) {
                        throw f;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && StreamExecution$.MODULE$.isInterruptionException(throwable2 = throwable3, super.sparkSession().sparkContext())) {
                        State state = this.state().get();
                        RECONFIGURING$ rECONFIGURING$ = RECONFIGURING$.MODULE$;
                        if (!(state != null ? !state.equals(rECONFIGURING$) : rECONFIGURING$ != null)) {
                            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Query ", " ignoring exception from reconfiguring: "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.QUERY_ID$.MODULE$, (Object)this.id())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.ERROR$.MODULE$, (Object)throwable2)})))));
                            break block9;
                        }
                    }
                    throw throwable;
                }
            }
            finally {
                this.queryExecutionThread().runUninterruptibly((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    try {
                        epochEndpoint.askSync((Object)StopContinuousExecutionWrites$.MODULE$, (ClassTag)ClassTag$.MODULE$.Unit());
                    }
                    finally {
                        SparkEnv$.MODULE$.get().rpcEnv().stop(epochEndpoint);
                        epochUpdateThread.interrupt();
                        epochUpdateThread.join();
                        this.super$sparkSession().sparkContext().cancelJobGroup(this.runId().toString(), "Continuous execution finished for query " + this.prettyIdString());
                    }
                });
                Thread.interrupted();
            }
        }
    }

    public void addOffset(long epoch, ContinuousStream stream, Seq<PartitionOffset> partitionOffsets) {
        Option option;
        Predef$.MODULE$.assert(this.sources().length() == 1, (Function0 & Serializable)() -> "only one continuous source supported currently");
        Offset globalOffset = stream.mergeOffsets((PartitionOffset[])partitionOffsets.toArray(ClassTag$.MODULE$.apply(PartitionOffset.class)));
        ContinuousExecution continuousExecution = this;
        synchronized (continuousExecution) {
            this.offsetLog().add(epoch, OffsetSeq$.MODULE$.fill((Seq<Offset>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Offset[]{globalOffset})));
            option = this.offsetLog().get(epoch - 1L);
        }
        Option oldOffset = option;
        if (oldOffset.contains((Object)OffsetSeq$.MODULE$.fill((Seq<Offset>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Offset[]{globalOffset})))) {
            this.noNewData_$eq(true);
        }
        this.awaitProgressLock().lock();
        try {
            this.awaitProgressLockCondition().signalAll();
        }
        finally {
            this.awaitProgressLock().unlock();
        }
    }

    public void commit(long epoch) {
        block8: {
            ContinuousExecutionContext execCtx = (ContinuousExecutionContext)this.latestExecutionContext();
            execCtx.updateStatusMessage("Committing epoch " + epoch);
            Predef$.MODULE$.assert(this.sources().length() == 1, (Function0 & Serializable)() -> "only one continuous source supported currently");
            Predef$.MODULE$.assert(this.offsetLog().get(epoch).isDefined(), (Function0 & Serializable)() -> "offset for epoch " + epoch + " not reported before commit");
            ContinuousExecution continuousExecution = this;
            synchronized (continuousExecution) {
                block7: {
                    execCtx.recordTriggerOffsets(execCtx.startOffsets(), execCtx.endOffsets(), execCtx.latestOffsets());
                    if (!this.queryExecutionThread().isAlive()) break block7;
                    this.commitLog().add(epoch, new CommitMetadata(CommitMetadata$.MODULE$.apply$default$1(), CommitMetadata$.MODULE$.apply$default$2()));
                    Offset offset = ((SparkDataStream)this.sources().apply(0)).deserializeOffset(((Offset)((Option)((OffsetSeq)this.offsetLog().get(epoch).get()).offsets().apply(0)).get()).json());
                    this.committedOffsets_$eq((StreamProgress)this.committedOffsets().$plus$plus((IterableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.sources().apply(0)), (Object)offset), (List)Nil$.MODULE$)));
                    ((SparkDataStream)this.sources().apply(0)).commit(offset);
                    break block8;
                }
                return;
            }
        }
        if ((long)this.minLogEntriesToMaintain() <= epoch) {
            this.purge(epoch + 1L - (long)this.minLogEntriesToMaintain());
        }
        this.awaitProgressLock().lock();
        try {
            this.awaitProgressLockCondition().signalAll();
        }
        finally {
            this.awaitProgressLock().unlock();
        }
    }

    public void awaitEpoch(long epoch) {
        while (this.notDone$1(epoch)) {
            this.awaitProgressLock().lock();
            try {
                this.awaitProgressLockCondition().await(100L, TimeUnit.MILLISECONDS);
                if (this.streamDeathCause() == null) continue;
                throw this.streamDeathCause();
            }
            finally {
                this.awaitProgressLock().unlock();
            }
        }
    }

    public void stopInNewThread(Throwable error) {
        if (this.failure().compareAndSet(null, error)) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Query ", " received exception "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PRETTY_ID_STRING$.MODULE$, (Object)this.prettyIdString())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.ERROR$.MODULE$, (Object)error)})))));
            this.stopInNewThread();
            return;
        }
    }

    private void stopInNewThread() {
        new Thread(this){
            private final /* synthetic */ ContinuousExecution $outer;

            public void run() {
                try {
                    this.$outer.stop();
                }
                catch (Throwable e) {
                    this.$outer.logError((Function0<String>)(Function0 & Serializable)() -> e.getMessage(), e);
                    throw e;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("stop-continuous-execution");
                this.setDaemon(true);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$3(java.lang.Throwable )}, serializedLambda);
            }
        }.start();
    }

    public void stop() {
        this.state().set(TERMINATED$.MODULE$);
        if (this.queryExecutionThread().isAlive()) {
            this.interruptAndAwaitExecutionThreadTermination();
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Query ", " was stopped"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PRETTY_ID_STRING$.MODULE$, (Object)this.prettyIdString())}))));
    }

    private final boolean notDone$1(long epoch$2) {
        Some some;
        Tuple2 tuple2;
        Option latestCommit = this.commitLog().getLatest();
        Option option = latestCommit;
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            long latestEpoch = tuple2._1$mcJ$sp();
            return latestEpoch < epoch$2;
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError(option);
    }

    public ContinuousExecution(SparkSession sparkSession, Trigger trigger, Clock triggerClock, scala.collection.immutable.Map<String, String> extraOptions, WriteToStream plan) {
        super(sparkSession, plan.name(), plan.resolvedCheckpointLocation(), plan.inputQuery(), plan.sink(), trigger, triggerClock, plan.outputMode(), plan.deleteCheckpointOnStop());
        Map v2ToRelationMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        IntRef nextSourceId = IntRef.create((int)0);
        LogicalPlan _logicalPlan = (LogicalPlan)this.analyzedPlan().transform((PartialFunction)new Serializable(this, v2ToRelationMap, nextSourceId){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ContinuousExecution $outer;
            private final Map v2ToRelationMap$1;
            private final IntRef nextSourceId$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof StreamingRelationV2) {
                    StreamingRelationV2 streamingRelationV2 = (StreamingRelationV2)A1;
                    Option ds = streamingRelationV2.source();
                    String sourceName = streamingRelationV2.sourceName();
                    Table table = streamingRelationV2.table();
                    CaseInsensitiveStringMap options = streamingRelationV2.extraOptions();
                    Seq output = streamingRelationV2.output();
                    Option catalog = streamingRelationV2.catalog();
                    Option identifier = streamingRelationV2.identifier();
                    if (table instanceof SupportsRead) {
                        String dsStr;
                        SupportsRead supportsRead = (SupportsRead)table;
                        String string = dsStr = ds.nonEmpty() ? "[" + ds.get() + "]" : "";
                        if (!DataSourceV2Implicits$.MODULE$.TableHelper((Table)supportsRead).supports(TableCapability.CONTINUOUS_READ)) {
                            throw QueryExecutionErrors$.MODULE$.continuousProcessingUnsupportedByDataSourceError(sourceName);
                        }
                        return (B1)this.v2ToRelationMap$1.getOrElseUpdate((Object)streamingRelationV2, (Function0 & Serializable)() -> {
                            String metadataPath = $this.$outer.resolvedCheckpointRoot() + "/sources/" + $this.nextSourceId$1.elem;
                            ++$this.nextSourceId$1.elem;
                            $this.$outer.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Reading table [", "] "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STREAMING_TABLE$.MODULE$, (Object)supportsRead)})).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"from DataSourceV2 named '", "' "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STREAMING_DATA_SOURCE_NAME$.MODULE$, (Object)sourceName)}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.STREAMING_DATA_SOURCE_DESCRIPTION$.MODULE$, (Object)dsStr)})))));
                            Scan scan = supportsRead.newScanBuilder(options).build();
                            ContinuousStream stream = scan.toContinuousStream(metadataPath);
                            StreamingDataSourceV2Relation relation = new StreamingDataSourceV2Relation((Table)supportsRead, output, catalog, identifier, options, metadataPath);
                            return new StreamingDataSourceV2ScanRelation(relation, scan, output, (SparkDataStream)stream, StreamingDataSourceV2ScanRelation$.MODULE$.apply$default$5(), StreamingDataSourceV2ScanRelation$.MODULE$.apply$default$6());
                        });
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                StreamingRelationV2 streamingRelationV2;
                Table table;
                LogicalPlan logicalPlan2 = x1;
                return logicalPlan2 instanceof StreamingRelationV2 && (table = (streamingRelationV2 = (StreamingRelationV2)logicalPlan2).table()) instanceof SupportsRead;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.v2ToRelationMap$1 = v2ToRelationMap$1;
                this.nextSourceId$1 = nextSourceId$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution$$anonfun$1 org.apache.spark.sql.connector.catalog.SupportsRead java.lang.String java.lang.String org.apache.spark.sql.util.CaseInsensitiveStringMap scala.collection.immutable.Seq scala.Option scala.Option ), $anonfun$applyOrElse$2(org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution$$anonfun$1 org.apache.spark.sql.connector.catalog.SupportsRead java.lang.String java.lang.String )}, serializedLambda);
            }
        });
        this.sources_$eq((Seq<ContinuousStream>)_logicalPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof StreamingDataSourceV2ScanRelation) {
                    StreamingDataSourceV2ScanRelation streamingDataSourceV2ScanRelation = (StreamingDataSourceV2ScanRelation)A1;
                    return (B1)((ContinuousStream)streamingDataSourceV2ScanRelation.stream());
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(LogicalPlan x2) {
                LogicalPlan logicalPlan2 = x2;
                return logicalPlan2 instanceof StreamingDataSourceV2ScanRelation;
            }
        }));
        this.uniqueSources_$eq((scala.collection.immutable.Map<SparkDataStream, ReadLimit>)((IterableOnceOps)((IterableOps)this.sources().distinct()).map((Function1 & Serializable)s -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(s), (Object)ReadLimit.allAvailable()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Write write = this.createWrite((SupportsWrite)plan.sink(), extraOptions, _logicalPlan);
        if (this.hasDistributionRequirements(write) || this.hasOrderingRequirements(write)) {
            throw QueryCompilationErrors$.MODULE$.writeDistributionAndOrderingNotSupportedInContinuousExecution();
        }
        StreamingWrite streamingWrite = write.toStreaming();
        ArraySeq customMetrics = ArrayImplicits$.MODULE$.SparkArrayOps((Object)write.supportedCustomMetrics()).toImmutableArraySeq();
        this.logicalPlan = new WriteToContinuousDataSource(streamingWrite, _logicalPlan, (Seq<CustomMetric>)customMetrics);
        Trigger trigger2 = super.trigger();
        if (!(trigger2 instanceof ContinuousTrigger)) {
            throw new IllegalStateException("Unsupported type of trigger: " + super.trigger());
        }
        ContinuousTrigger continuousTrigger = (ContinuousTrigger)trigger2;
        long t = continuousTrigger.intervalMs();
        this.org$apache$spark$sql$execution$streaming$continuous$ContinuousExecution$$triggerExecutor = new ProcessingTimeExecutor(new ProcessingTimeTrigger(t), super.triggerClock());
    }
}

