/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Extract;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.NullOrdering;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.MySQLDialect$;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r]g\u0001\u0002\"D\t:CQA\u001c\u0001\u0005\u0002=DQ!\u001d\u0001\u0005BID\u0011\"!\u0001\u0001\u0005\u0004%I!a\u0001\t\u0011\u0005\r\u0002\u0001)A\u0005\u0003\u000bA\u0011\"!\n\u0001\u0005\u0004%I!a\u0001\t\u0011\u0005\u001d\u0002\u0001)A\u0005\u0003\u000bA\u0011\"!\u000b\u0001\u0005\u0004%I!a\u0001\t\u0011\u0005-\u0002\u0001)A\u0005\u0003\u000bAq!!\f\u0001\t\u0003\ny\u0003C\u0004\u00026\u0001!\t%a\u000e\u0007\r\u0005\u001d\u0003\u0001AA%\u0011\u0019q7\u0002\"\u0001\u0002T!9\u0011qK\u0006\u0005B\u0005e\u0003bBA8\u0017\u0011\u0005\u0013\u0011\u000f\u0005\b\u0003\u007fZA\u0011IAA\u0011\u001d\tYj\u0003C!\u0003;Cq!a*\f\t\u0003\nI\u000bC\u0004\u00020.!\t%!-\t\u000f\u0005]6\u0002\"\u0011\u0002:\"9\u00111\u0019\u0001\u0005B\u0005\u0015\u0007bBAl\u0001\u0011\u0005\u0013\u0011\u001c\u0005\b\u0005\u000b\u0001A\u0011\tB\u0004\u0011\u001d\u0011i\u0001\u0001C!\u0005\u001fAqA!\u000e\u0001\t\u0003\u00129\u0004C\u0004\u0003@\u0001!\tE!\u0011\t\u000f\t\u0015\u0003\u0001\"\u0011\u0003H!9!Q\n\u0001\u0005B\t=\u0003b\u0002B/\u0001\u0011\u0005#q\f\u0005\b\u0005[\u0002A\u0011\tB8\u0011\u001d\u0011I\b\u0001C!\u0005wBqA!\"\u0001\t\u0003\u00129\tC\u0004\u0003\u0016\u0002!\tEa&\t\u000f\tu\u0005\u0001\"\u0011\u0003 \"9!1\u0015\u0001\u0005B\t\u0015\u0006b\u0002Bo\u0001\u0011\u0005#q\u001c\u0005\b\u0005S\u0004A\u0011\tBv\u0011\u001d\u0011\t\u0010\u0001C!\u0005gDqa!\u0003\u0001\t\u0003\u001aY\u0001C\u0004\u00048\u0001!\te!\u000f\u0007\r\r\u0005\u0003\u0001AB\"\u0011%\u0019Y\u0005\u000bB\u0001B\u0003%q\n\u0003\u0006\u0003\u001e!\u0012\t\u0011)A\u0005\u0005?AaA\u001c\u0015\u0005\u0002\r5\u0003bBB+Q\u0011\u00053q\u000b\u0005\b\u00073\u0002A\u0011IB.\u0011\u001d\u0019y\u0006\u0001C!\u0007CBqaa\u0019\u0001\t\u0003\u001a\t\u0007C\u0004\u0004f\u0001!\te!\u0019\t\u0011\r\u001d\u0004!!A\u0005\u0002=D\u0011b!\u001b\u0001\u0003\u0003%\tea\u001b\t\u0013\r5\u0004!!A\u0005\u0002\r=\u0004\"CB9\u0001\u0005\u0005I\u0011AB:\u0011%\u0019y\bAA\u0001\n\u0003\u001a\t\tC\u0005\u0004\f\u0002\t\t\u0011\"\u0001\u0004\u000e\"I1\u0011\u0013\u0001\u0002\u0002\u0013\u000531\u0013\u0005\n\u0007/\u0003\u0011\u0011!C!\u00073C\u0011ba'\u0001\u0003\u0003%\te!(\t\u0013\r}\u0005!!A\u0005B\r\u0005v!CBS\u0007\u0006\u0005\t\u0012BBT\r!\u00115)!A\t\n\r%\u0006B\u00028=\t\u0003\u0019\t\rC\u0005\u0004\u001cr\n\t\u0011\"\u0012\u0004\u001e\"A11\u0019\u001f\u0002\u0002\u0013\u0005u\u000eC\u0005\u0004Fr\n\t\u0011\"!\u0004H\"I1Q\u001a\u001f\u0002\u0002\u0013%1q\u001a\u0002\r\u001bf\u001c\u0016\u000b\u0014#jC2,7\r\u001e\u0006\u0003\t\u0016\u000bAA\u001b3cG*\u0011aiR\u0001\u0004gFd'B\u0001%J\u0003\u0015\u0019\b/\u0019:l\u0015\tQ5*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0019\u0006\u0019qN]4\u0004\u0001M1\u0001aT*Z9\n\u0004\"\u0001U)\u000e\u0003\rK!AU\"\u0003\u0017)#'m\u0019#jC2,7\r\u001e\t\u0003)^k\u0011!\u0016\u0006\u0003-\u0016\u000b\u0001bY1uC2L8\u000f^\u0005\u00031V\u0013QbU)M\u0007>tg\rS3ma\u0016\u0014\bC\u0001)[\u0013\tY6IA\tO_2+w-Y2z\u0015\u0012\u00135)\u0012:s_J\u0004\"!\u00181\u000e\u0003yS\u0011aX\u0001\u0006g\u000e\fG.Y\u0005\u0003Cz\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002dW:\u0011A-\u001b\b\u0003K\"l\u0011A\u001a\u0006\u0003O6\u000ba\u0001\u0010:p_Rt\u0014\"A0\n\u0005)t\u0016a\u00029bG.\fw-Z\u0005\u0003Y6\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!A\u001b0\u0002\rqJg.\u001b;?)\u0005\u0001\bC\u0001)\u0001\u0003%\u0019\u0017M\u001c%b]\u0012dW\r\u0006\u0002tmB\u0011Q\f^\u0005\u0003kz\u0013qAQ8pY\u0016\fg\u000eC\u0003x\u0005\u0001\u0007\u00010A\u0002ve2\u0004\"!_?\u000f\u0005i\\\bCA3_\u0013\tah,\u0001\u0004Qe\u0016$WMZ\u0005\u0003}~\u0014aa\u0015;sS:<'B\u0001?_\u0003\u0015\"\u0017n\u001d;j]\u000e$XK\\:vaB|'\u000f^3e\u0003\u001e<'/Z4bi\u00164UO\\2uS>t7/\u0006\u0002\u0002\u0006A1\u0011qAA\t\u0003+i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\nS6lW\u000f^1cY\u0016T1!a\u0004_\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003'\tIAA\u0002TKR\u0004B!a\u0006\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"\u0001\u0003mC:<'BAA\u0010\u0003\u0011Q\u0017M^1\n\u0007y\fI\"\u0001\u0014eSN$\u0018N\\2u+:\u001cX\u000f\u001d9peR,G-Q4he\u0016<\u0017\r^3Gk:\u001cG/[8og\u0002\n1d];qa>\u0014H/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u001c\u0018\u0001H:vaB|'\u000f^3e\u0003\u001e<'/Z4bi\u00164UO\\2uS>t7\u000fI\u0001\u0013gV\u0004\bo\u001c:uK\u00124UO\\2uS>t7/A\ntkB\u0004xN\u001d;fI\u001a+hn\u0019;j_:\u001c\b%A\njgN+\b\u000f]8si\u0016$g)\u001e8di&|g\u000eF\u0002t\u0003cAa!a\r\n\u0001\u0004A\u0018\u0001\u00034v]\u000et\u0015-\\3\u00023%\u001cxJ\u00196fGRtu\u000e\u001e$pk:$W\t_2faRLwN\u001c\u000b\u0004g\u0006e\u0002bBA\u001e\u0015\u0001\u0007\u0011QH\u0001\u0002KB!\u0011qHA\"\u001b\t\t\tEC\u0002G\u0003;IA!!\u0012\u0002B\ta1+\u0015'Fq\u000e,\u0007\u000f^5p]\nyQ*_*R\u0019N\u000bFJQ;jY\u0012,'oE\u0002\f\u0003\u0017\u0002B!!\u0014\u0002P5\t\u0001!C\u0002\u0002RE\u0013aB\u0013#C\u0007N\u000bFJQ;jY\u0012,'\u000f\u0006\u0002\u0002VA\u0019\u0011QJ\u0006\u0002\u0019YL7/\u001b;FqR\u0014\u0018m\u0019;\u0015\u0007a\fY\u0006C\u0004\u0002^5\u0001\r!a\u0018\u0002\u000f\u0015DHO]1diB!\u0011\u0011MA6\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014aC3yaJ,7o]5p]NT1!!\u001bF\u0003%\u0019wN\u001c8fGR|'/\u0003\u0003\u0002n\u0005\r$aB#yiJ\f7\r^\u0001\u0011m&\u001c\u0018\u000e^*R\u0019\u001a+hn\u0019;j_:$R\u0001_A:\u0003kBa!a\r\u000f\u0001\u0004A\bbBA<\u001d\u0001\u0007\u0011\u0011P\u0001\u0007S:\u0004X\u000f^:\u0011\tu\u000bY\b_\u0005\u0004\u0003{r&!B!se\u0006L\u0018A\u0004<jg&$8k\u001c:u\u001fJ$WM\u001d\u000b\bq\u0006\r\u0015qQAI\u0011\u0019\t)i\u0004a\u0001q\u000691o\u001c:u\u0017\u0016L\bbBAE\u001f\u0001\u0007\u00111R\u0001\u000eg>\u0014H\u000fR5sK\u000e$\u0018n\u001c8\u0011\t\u0005\u0005\u0014QR\u0005\u0005\u0003\u001f\u000b\u0019GA\u0007T_J$H)\u001b:fGRLwN\u001c\u0005\b\u0003'{\u0001\u0019AAK\u00031qW\u000f\u001c7Pe\u0012,'/\u001b8h!\u0011\t\t'a&\n\t\u0005e\u00151\r\u0002\r\u001dVdGn\u0014:eKJLgnZ\u0001\u0010m&\u001c\u0018\u000e^*uCJ$8oV5uQR)\u00010a(\u0002$\"1\u0011\u0011\u0015\tA\u0002a\f\u0011\u0001\u001c\u0005\u0007\u0003K\u0003\u0002\u0019\u0001=\u0002\u0003I\fQB^5tSR,e\u000eZ:XSRDG#\u0002=\u0002,\u00065\u0006BBAQ#\u0001\u0007\u0001\u0010\u0003\u0004\u0002&F\u0001\r\u0001_\u0001\u000em&\u001c\u0018\u000e^\"p]R\f\u0017N\\:\u0015\u000ba\f\u0019,!.\t\r\u0005\u0005&\u00031\u0001y\u0011\u0019\t)K\u0005a\u0001q\u00061b/[:ji\u0006;wM]3hCR,g)\u001e8di&|g\u000eF\u0004y\u0003w\u000bi,!1\t\r\u0005M2\u00031\u0001y\u0011\u0019\tyl\u0005a\u0001g\u0006Q\u0011n\u001d#jgRLgn\u0019;\t\u000f\u0005]4\u00031\u0001\u0002z\u0005\t2m\\7qS2,W\t\u001f9sKN\u001c\u0018n\u001c8\u0015\t\u0005\u001d\u0017Q\u001a\t\u0005;\u0006%\u00070C\u0002\u0002Lz\u0013aa\u00149uS>t\u0007bBAh)\u0001\u0007\u0011\u0011[\u0001\u0005Kb\u0004(\u000f\u0005\u0003\u0002b\u0005M\u0017\u0002BAk\u0003G\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003=9W\r^\"bi\u0006d\u0017p\u001d;UsB,GCCAn\u0003S\f\u00190a>\u0002|B)Q,!3\u0002^B!\u0011q\\As\u001b\t\t\tOC\u0002\u0002d\u0016\u000bQ\u0001^=qKNLA!a:\u0002b\nAA)\u0019;b)f\u0004X\rC\u0004\u0002lV\u0001\r!!<\u0002\u000fM\fH\u000eV=qKB\u0019Q,a<\n\u0007\u0005EhLA\u0002J]RDa!!>\u0016\u0001\u0004A\u0018\u0001\u0003;za\u0016t\u0015-\\3\t\u000f\u0005eX\u00031\u0001\u0002n\u0006!1/\u001b>f\u0011\u001d\ti0\u0006a\u0001\u0003\u007f\f!!\u001c3\u0011\t\u0005}'\u0011A\u0005\u0005\u0005\u0007\t\tOA\bNKR\fG-\u0019;b\u0005VLG\u000eZ3s\u0003=\tXo\u001c;f\u0013\u0012,g\u000e^5gS\u0016\u0014Hc\u0001=\u0003\n!1!1\u0002\fA\u0002a\fqaY8m\u001d\u0006lW-A\u0007tG\",W.Y:Fq&\u001cHo\u001d\u000b\bg\nE!1\u0004B\u0019\u0011\u001d\u0011\u0019b\u0006a\u0001\u0005+\tAaY8o]B!\u0011q\bB\f\u0013\u0011\u0011I\"!\u0011\u0003\u0015\r{gN\\3di&|g\u000eC\u0004\u0003\u001e]\u0001\rAa\b\u0002\u000f=\u0004H/[8ogB!!\u0011\u0005B\u0017\u001b\t\u0011\u0019CC\u0002E\u0005KQAAa\n\u0003*\u0005YA-\u0019;bg>,(oY3t\u0015\r\u0011Y#R\u0001\nKb,7-\u001e;j_:LAAa\f\u0003$\tY!\n\u0012\"D\u001fB$\u0018n\u001c8t\u0011\u0019\u0011\u0019d\u0006a\u0001q\u000611o\u00195f[\u0006\f1\u0002\\5tiN\u001b\u0007.Z7bgR1!\u0011\bB\u001e\u0005{\u0001R!XA>\u0003sBqAa\u0005\u0019\u0001\u0004\u0011)\u0002C\u0004\u0003\u001ea\u0001\rAa\b\u00021%\u001c8)Y:dC\u0012Lgn\u001a+sk:\u001c\u0017\r^3UC\ndW\r\u0006\u0002\u0003DA!Q,!3t\u0003]I7oU=oi\u0006DXI\u001d:pe\n+7\u000f^#gM>\u0014H\u000fF\u0002t\u0005\u0013BqAa\u0013\u001b\u0001\u0004\ti$A\u0005fq\u000e,\u0007\u000f^5p]\u0006Ar-\u001a;Va\u0012\fG/Z\"pYVlg\u000eV=qKF+XM]=\u0015\u000fa\u0014\tF!\u0016\u0003Z!1!1K\u000eA\u0002a\f\u0011\u0002^1cY\u0016t\u0015-\\3\t\r\t]3\u00041\u0001y\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\u0005\u0007\u00057Z\u0002\u0019\u0001=\u0002\u00179,w\u000fR1uCRK\b/Z\u0001\u0015O\u0016$(+\u001a8b[\u0016\u001cu\u000e\\;n]F+XM]=\u0015\u0013a\u0014\tGa\u0019\u0003f\t%\u0004B\u0002B*9\u0001\u0007\u0001\u0010\u0003\u0004\u0003Xq\u0001\r\u0001\u001f\u0005\u0007\u0005Ob\u0002\u0019\u0001=\u0002\u000f9,wOT1nK\"9!1\u000e\u000fA\u0002\u00055\u0018A\u00043c\u001b\u0006TwN\u001d,feNLwN\\\u0001 O\u0016$X\u000b\u001d3bi\u0016\u001cu\u000e\\;n]:+H\u000e\\1cS2LG/_)vKJLHc\u0002=\u0003r\tM$Q\u000f\u0005\u0007\u0005'j\u0002\u0019\u0001=\t\r\t]S\u00041\u0001y\u0011\u0019\u00119(\ba\u0001g\u0006Q\u0011n\u001d(vY2\f'\r\\3\u0002)\u001d,G\u000fV1cY\u0016\u001cu.\\7f]R\fV/\u001a:z)\u0015A(Q\u0010BA\u0011\u0019\u0011yH\ba\u0001q\u0006)A/\u00192mK\"1!1\u0011\u0010A\u0002a\fqaY8n[\u0016tG/A\u0006hKRTEIQ\"UsB,G\u0003\u0002BE\u0005#\u0003R!XAe\u0005\u0017\u00032\u0001\u0015BG\u0013\r\u0011yi\u0011\u0002\t\u0015\u0012\u00147\rV=qK\"9!1S\u0010A\u0002\u0005u\u0017A\u00013u\u0003U9W\r^*dQ\u0016l\u0017mQ8n[\u0016tG/U;fef$R\u0001\u001fBM\u00057CaAa\r!\u0001\u0004A\bB\u0002BBA\u0001\u0007\u00010\u0001\rsK6|g/Z*dQ\u0016l\u0017mQ8n[\u0016tG/U;fef$2\u0001\u001fBQ\u0011\u0019\u0011\u0019$\ta\u0001q\u0006Y1M]3bi\u0016Le\u000eZ3y)-A(q\u0015BV\u0005w\u00139M!7\t\r\t%&\u00051\u0001y\u0003%Ig\u000eZ3y\u001d\u0006lW\rC\u0004\u0003.\n\u0002\rAa,\u0002\u0015Q\f'\r\\3JI\u0016tG\u000f\u0005\u0003\u00032\n]VB\u0001BZ\u0015\u0011\u0011),a\u001a\u0002\u000f\r\fG/\u00197pO&!!\u0011\u0018BZ\u0005)IE-\u001a8uS\u001aLWM\u001d\u0005\b\u0005{\u0013\u0003\u0019\u0001B`\u0003\u001d\u0019w\u000e\\;n]N\u0004R!XA>\u0005\u0003\u0004B!!\u0019\u0003D&!!QYA2\u00059q\u0015-\\3e%\u00164WM]3oG\u0016DqA!3#\u0001\u0004\u0011Y-A\td_2,XN\\:Qe>\u0004XM\u001d;jKN\u0004\u0002B!4\u0003T\n\u0005'q[\u0007\u0003\u0005\u001fTAA!5\u0002\u001e\u0005!Q\u000f^5m\u0013\u0011\u0011)Na4\u0003\u00075\u000b\u0007\u000f\u0005\u0004\u0003N\nM\u0007\u0010\u001f\u0005\b\u00057\u0014\u0003\u0019\u0001Bl\u0003)\u0001(o\u001c9feRLWm]\u0001\fS:$W\r_#ySN$8\u000fF\u0005t\u0005C\u0014\u0019O!:\u0003h\"9!1C\u0012A\u0002\tU\u0001B\u0002BUG\u0001\u0007\u0001\u0010C\u0004\u0003.\u000e\u0002\rAa,\t\u000f\tu1\u00051\u0001\u0003 \u0005IAM]8q\u0013:$W\r\u001f\u000b\u0006q\n5(q\u001e\u0005\u0007\u0005S#\u0003\u0019\u0001=\t\u000f\t5F\u00051\u0001\u00030\u0006YA.[:u\u0013:$W\r_3t)!\u0011)pa\u0001\u0004\u0006\r\u001d\u0001#B/\u0002|\t]\b\u0003\u0002B}\u0005\u007fl!Aa?\u000b\t\tu(1W\u0001\u0006S:$W\r_\u0005\u0005\u0007\u0003\u0011YP\u0001\u0006UC\ndW-\u00138eKbDqAa\u0005&\u0001\u0004\u0011)\u0002C\u0004\u0003.\u0016\u0002\rAa,\t\u000f\tuQ\u00051\u0001\u0003 \u0005\t2\r\\1tg&4\u00170\u0012=dKB$\u0018n\u001c8\u0015\u0019\r51\u0011EB\u0012\u0007O\u0019yca\r\u0013\r\r=11CB\r\r\u0019\u0019\t\u0002\u0001\u0001\u0004\u000e\taAH]3gS:,W.\u001a8u}A\u00191m!\u0006\n\u0007\r]QNA\u0005UQJ|w/\u00192mKB!11DB\u000f\u001b\u00059\u0015bAB\u0010\u000f\nq1\u000b]1sWRC'o\\<bE2,\u0007bBA\u001eM\u0001\u000711\u0003\u0005\u0007\u0007K1\u0003\u0019\u0001=\u0002\u0013\r|g\u000eZ5uS>t\u0007bBB\u0015M\u0001\u000711F\u0001\u0012[\u0016\u001c8/Y4f!\u0006\u0014\u0018-\\3uKJ\u001c\b#B=\u0004.aD\u0018b\u0001Bk\u007f\"11\u0011\u0007\u0014A\u0002a\f1\u0002Z3tGJL\u0007\u000f^5p]\"11Q\u0007\u0014A\u0002M\f\u0011\"[:Sk:$\u0018.\\3\u0002\u0015\u0011\u0014x\u000e]*dQ\u0016l\u0017\rF\u0003y\u0007w\u0019i\u0004\u0003\u0004\u00034\u001d\u0002\r\u0001\u001f\u0005\u0007\u0007\u007f9\u0003\u0019A:\u0002\u000f\r\f7oY1eK\n!R*_*R\u0019N\u000bF*U;fef\u0014U/\u001b7eKJ\u001c2\u0001KB#!\r\u00016qI\u0005\u0004\u0007\u0013\u001a%a\u0005&eE\u000e\u001c\u0016\u000bT)vKJL()^5mI\u0016\u0014\u0018a\u00023jC2,7\r\u001e\u000b\u0007\u0007\u001f\u001a\tfa\u0015\u0011\u0007\u00055\u0003\u0006\u0003\u0004\u0004L-\u0002\ra\u0014\u0005\b\u0005;Y\u0003\u0019\u0001B\u0010\u0003\u0015\u0011W/\u001b7e)\u0005A\u0018AF4fi*#'mY*R\u0019F+XM]=Ck&dG-\u001a:\u0015\t\r\u00153Q\f\u0005\b\u0005;i\u0003\u0019\u0001B\u0010\u00035\u0019X\u000f\u001d9peR\u001cH*[7jiV\t1/\u0001\btkB\u0004xN\u001d;t\u001f\u001a47/\u001a;\u0002\u0019M,\b\u000f]8siND\u0015N\u001c;\u0002\t\r|\u0007/_\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005U\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAAw\u00039\u0001(o\u001c3vGR,E.Z7f]R$Ba!\u001e\u0004|A\u0019Qla\u001e\n\u0007\redLA\u0002B]fD\u0011b! 5\u0003\u0003\u0005\r!!<\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019\u0019\t\u0005\u0004\u0004\u0006\u000e\u001d5QO\u0007\u0003\u0003\u001bIAa!#\u0002\u000e\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\u00198q\u0012\u0005\n\u0007{2\u0014\u0011!a\u0001\u0007k\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011QCBK\u0011%\u0019ihNA\u0001\u0002\u0004\ti/\u0001\u0005iCND7i\u001c3f)\t\ti/\u0001\u0005u_N#(/\u001b8h)\t\t)\"\u0001\u0004fcV\fGn\u001d\u000b\u0004g\u000e\r\u0006\"CB?u\u0005\u0005\t\u0019AB;\u00031i\u0015pU)M\t&\fG.Z2u!\t\u0001FhE\u0003=\u0007W\u001b9\fE\u0003\u0004.\u000eM\u0006/\u0004\u0002\u00040*\u00191\u0011\u00170\u0002\u000fI,h\u000e^5nK&!1QWBX\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\r\t\u0005\u0007s\u001by,\u0004\u0002\u0004<*!1QXA\u000f\u0003\tIw.C\u0002m\u0007w#\"aa*\u0002\u000b\u0005\u0004\b\u000f\\=\u0002\u000fUt\u0017\r\u001d9msR\u00191o!3\t\u0011\r-\u0007)!AA\u0002A\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019\t\u000e\u0005\u0003\u0002\u0018\rM\u0017\u0002BBk\u00033\u0011aa\u00142kK\u000e$\b")
public class MySQLDialect
extends JdbcDialect
implements SQLConfHelper,
NoLegacyJDBCError,
Product {
    private final Set<String> org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    public static boolean unapply(MySQLDialect x$0) {
        return MySQLDialect$.MODULE$.unapply(x$0);
    }

    public static MySQLDialect apply() {
        return MySQLDialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:mysql");
    }

    public Set<String> org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public boolean isObjectNotFoundException(SQLException e) {
        return e.getErrorCode() == 1146;
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        MySQLSQLBuilder mysqlSQLBuilder = new MySQLSQLBuilder(this);
        try {
            some = new Some((Object)mysqlSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        boolean bl = false;
        int n = 0;
        int n2 = sqlType;
        if (-3 == n2 && "BIT".equalsIgnoreCase(typeName) && size != 1) {
            return this.getCatalystTypeForBitArray$1(md);
        }
        if (-7 == n2 && size > 1) {
            return this.getCatalystTypeForBitArray$1(md);
        }
        if (12 == n2 && "TINYTEXT".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ((12 == n2 ? true : 1 == n2) && "JSON".equalsIgnoreCase(typeName)) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (-6 == n2) {
            if (md.build().getBoolean("isSigned")) {
                return new Some((Object)ByteType$.MODULE$);
            }
            return new Some((Object)ShortType$.MODULE$);
        }
        if (5 == n2) {
            if (md.build().getBoolean("isSigned")) {
                return new Some((Object)ShortType$.MODULE$);
            }
            return new Some((Object)IntegerType$.MODULE$);
        }
        if (4 == n2 && "MEDIUMINT UNSIGNED".equalsIgnoreCase(typeName)) {
            return new Some((Object)IntegerType$.MODULE$);
        }
        if (7 == n2 ? true : 6 == n2) {
            if (md.build().getBoolean("isSigned")) {
                return new Some((Object)FloatType$.MODULE$);
            }
            return new Some((Object)DoubleType$.MODULE$);
        }
        if (93 == n2) {
            bl = true;
            n = n2;
            if ("DATETIME".equalsIgnoreCase(typeName)) {
                return new Some((Object)this.getTimestampType(md.build()));
            }
        }
        if (bl && !this.conf().legacyMySqlTimestampNTZMappingEnabled()) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        return None$.MODULE$;
    }

    @Override
    public String quoteIdentifier(String colName) {
        return "`" + colName + "`";
    }

    @Override
    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        return ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])this.listSchemas(conn, options)), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MySQLDialect.$anonfun$schemasExists$1(schema, x$1)));
    }

    @Override
    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, "SHOW SCHEMAS", (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                MySQLDialect.$anonfun$listSchemas$1(schemaBuilder, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot show schemas.");
        }
        return (String[][])schemaBuilder.result();
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public boolean isSyntaxErrorBestEffort(SQLException exception) {
        return "42000".equals(exception.getSQLState());
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " MODIFY COLUMN " + this.quoteIdentifier(columnName) + " " + newDataType;
    }

    @Override
    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        if (dbMajorVersion >= 8) {
            return "ALTER TABLE " + tableName + " RENAME COLUMN " + this.quoteIdentifier(columnName) + " TO " + this.quoteIdentifier(newName);
        }
        throw QueryExecutionErrors$.MODULE$.renameColumnUnsupportedForOlderMySQLError();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        throw QueryExecutionErrors$.MODULE$.unsupportedUpdateColumnNullabilityError();
    }

    @Override
    public String getTableCommentQuery(String table, String comment) {
        return "ALTER TABLE " + table + " COMMENT = '" + comment + "'";
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (FloatType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("FLOAT", 6));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("LONGTEXT", -1));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("TINYINT", -6));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("SMALLINT", 5));
        }
        if (TimestampNTZType$.MODULE$.equals(dataType) && !this.conf().legacyMySqlTimestampNTZMappingEnabled()) {
            return Option$.MODULE$.apply((Object)new JdbcType("DATETIME", 93));
        }
        return JdbcUtils$.MODULE$.getCommonJDBCType(dt);
    }

    @Override
    public String getSchemaCommentQuery(String schema, String comment) {
        throw QueryExecutionErrors$.MODULE$.unsupportedCommentNamespaceError(schema);
    }

    @Override
    public String removeSchemaCommentQuery(String schema) {
        throw QueryExecutionErrors$.MODULE$.unsupportedRemoveNamespaceCommentError(schema);
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String[] columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> this.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
        Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "mysql");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String indexType = (String)tuple2._1();
        String[] indexPropertyList = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indexType, (Object)indexPropertyList);
        String indexType2 = (String)tuple22._1();
        String[] indexPropertyList2 = (String[])tuple22._2();
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " " + indexType2 + " ON " + this.quoteIdentifier(tableIdent.name()) + " (" + Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ") + ") " + Predef$.MODULE$.wrapRefArray((Object[])indexPropertyList2).mkString(" ");
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = "SHOW INDEXES FROM " + this.quoteIdentifier(tableIdent.name()) + " WHERE key_name = '" + indexName + "'";
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return "DROP INDEX " + this.quoteIdentifier(indexName) + " ON " + tableIdent.name();
    }

    @Override
    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        String sql = "SHOW INDEXES FROM " + tableIdent.name();
        ObjectRef indexMap = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, sql, (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                MySQLDialect.$anonfun$listIndexes$1(indexMap, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot retrieved index info.");
        }
        return (TableIndex[])((scala.collection.immutable.Map)indexMap.elem).values().toArray(ClassTag$.MODULE$.apply(TableIndex.class));
    }

    @Override
    public Throwable classifyException(Throwable e, String condition, scala.collection.immutable.Map<String, String> messageParameters, String description, boolean isRuntime) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 1050: {
                    String string = condition;
                    String string2 = "FAILED_JDBC.RENAME_TABLE";
                    if (string != null ? !string.equals(string2) : string2 != null) break;
                    String newTable = (String)messageParameters.apply((Object)"newName");
                    throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                }
                case 1061: {
                    String string = condition;
                    String string3 = "FAILED_JDBC.CREATE_INDEX";
                    if (string != null ? !string.equals(string3) : string3 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new IndexAlreadyExistsException(indexName, tableName, (Option)new Some((Object)e));
                }
                case 1091: {
                    String string = condition;
                    String string4 = "FAILED_JDBC.DROP_INDEX";
                    if (string != null ? !string.equals(string4) : string4 != null) break;
                    String indexName = (String)messageParameters.apply((Object)"indexName");
                    String tableName = (String)messageParameters.apply((Object)"tableName");
                    throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
                }
            }
            return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
        }
        if (throwable instanceof UnsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
            throw unsupportedOperationException;
        }
        return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
    }

    @Override
    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return "DROP SCHEMA " + this.quoteIdentifier(schema);
        }
        throw QueryExecutionErrors$.MODULE$.unsupportedDropNamespaceError(schema);
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new MySQLSQLQueryBuilder(this, this, options);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsHint() {
        return true;
    }

    public MySQLDialect copy() {
        return new MySQLDialect();
    }

    public String productPrefix() {
        return "MySQLDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MySQLDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof MySQLDialect && ((MySQLDialect)x$1).canEqual(this);
    }

    private final Option getCatalystTypeForBitArray$1(MetadataBuilder md$1) {
        md$1.putLong("binarylong", 1L);
        if (this.conf().legacyMySqlBitArrayMappingEnabled()) {
            return new Some((Object)LongType$.MODULE$);
        }
        return new Some((Object)BinaryType$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$schemasExists$1(String schema$1, String[] x$1) {
        Object object = ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$1));
        String string = schema$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$listSchemas$1(ArrayBuilder schemaBuilder$1, ResultSet rs) {
        while (rs.next()) {
            schemaBuilder$1.$plus$eq((Object)new String[]{rs.getString("Database")});
        }
    }

    public static final /* synthetic */ void $anonfun$listIndexes$1(ObjectRef indexMap$1, ResultSet rs) {
        while (rs.next()) {
            String indexName = rs.getString("key_name");
            String colName = rs.getString("column_name");
            String indexType = rs.getString("index_type");
            String indexComment = rs.getString("index_comment");
            if (((scala.collection.immutable.Map)indexMap$1.elem).contains((Object)indexName)) {
                TableIndex index = (TableIndex)((scala.collection.immutable.Map)indexMap$1.elem).get((Object)indexName).get();
                TableIndex newIndex = new TableIndex(indexName, indexType, (NamedReference[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])index.columns()), (Object)FieldReference$.MODULE$.apply(colName), ClassTag$.MODULE$.apply(NamedReference.class)), index.columnProperties(), index.properties());
                indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)newIndex));
                continue;
            }
            Properties properties = new Properties();
            Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(indexComment)) ? properties.put("COMMENT", indexComment) : BoxedUnit.UNIT;
            TableIndex index = new TableIndex(indexName, indexType, (NamedReference[])((Object[])new NamedReference[]{FieldReference$.MODULE$.apply(colName)}), new HashMap(), properties);
            indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)index));
        }
    }

    public MySQLDialect() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}));
        this.supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG"}))).$plus$plus(this.org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = (Set)this.supportedAggregateFunctions().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DATE_ADD", "DATE_DIFF"})));
    }

    public class MySQLSQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        public String visitExtract(Extract extract2) {
            String field;
            block12: {
                field = extract2.field();
                String string = field;
                switch (string == null ? 0 : string.hashCode()) {
                    case -1852950412: {
                        if ("SECOND".equals(string)) {
                            break;
                        }
                        break block12;
                    }
                    case -1351979174: {
                        if ("YEAR_OF_WEEK".equals(string)) {
                            break;
                        }
                        break block12;
                    }
                    case 2660340: {
                        if ("WEEK".equals(string)) {
                            return "WEEKOFYEAR(" + this.build(extract2.source()) + ")";
                        }
                        break block12;
                    }
                    case 2074232729: {
                        if ("DAY_OF_WEEK".equals(string)) {
                            return "(WEEKDAY(" + this.build(extract2.source()) + ") + 1)";
                        }
                        break block12;
                    }
                    case 2074292194: {
                        if ("DAY_OF_YEAR".equals(string)) {
                            return "DAYOFYEAR(" + this.build(extract2.source()) + ")";
                        }
                        break block12;
                    }
                    default: {
                        break block12;
                    }
                }
                return this.visitUnexpectedExpr((Expression)extract2);
            }
            return super.visitExtract(field, this.build(extract2.source()));
        }

        @Override
        public String visitSQLFunction(String funcName, String[] inputs) {
            String string = funcName;
            switch (string == null ? 0 : string.hashCode()) {
                case -1728155146: {
                    if (!"DATE_DIFF".equals(string)) break;
                    return "DATEDIFF(" + inputs[0] + ", " + inputs[1] + ")";
                }
                case -1718317968: {
                    if (!"DATE_ADD".equals(string)) break;
                    return "DATE_ADD(" + inputs[0] + ", INTERVAL " + inputs[1] + " DAY)";
                }
            }
            return super.visitSQLFunction(funcName, inputs);
        }

        public String visitSortOrder(String sortKey, SortDirection sortDirection, NullOrdering nullOrdering) {
            Tuple2 tuple2 = new Tuple2((Object)sortDirection, (Object)nullOrdering);
            if (tuple2 != null) {
                SortDirection sortDirection2 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering2 = (NullOrdering)tuple2._2();
                if (SortDirection.ASCENDING.equals(sortDirection2) && NullOrdering.NULLS_FIRST.equals(nullOrdering2)) {
                    return sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection3 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering3 = (NullOrdering)tuple2._2();
                if (SortDirection.ASCENDING.equals(sortDirection3) && NullOrdering.NULLS_LAST.equals(nullOrdering3)) {
                    return "CASE WHEN " + sortKey + " IS NULL THEN 1 ELSE 0 END, " + sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection4 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering4 = (NullOrdering)tuple2._2();
                if (SortDirection.DESCENDING.equals(sortDirection4) && NullOrdering.NULLS_FIRST.equals(nullOrdering4)) {
                    return "CASE WHEN " + sortKey + " IS NULL THEN 0 ELSE 1 END, " + sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection5 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering5 = (NullOrdering)tuple2._2();
                if (SortDirection.DESCENDING.equals(sortDirection5) && NullOrdering.NULLS_LAST.equals(nullOrdering5)) {
                    return sortKey + " " + sortDirection;
                }
            }
            throw new MatchError((Object)tuple2);
        }

        public String visitStartsWith(String l, String r) {
            String value = r.substring(1, r.length() - 1);
            return l + " LIKE '" + this.escapeSpecialCharsForLikePattern(value) + "%' ESCAPE '\\\\'";
        }

        public String visitEndsWith(String l, String r) {
            String value = r.substring(1, r.length() - 1);
            return l + " LIKE '%" + this.escapeSpecialCharsForLikePattern(value) + "' ESCAPE '\\\\'";
        }

        public String visitContains(String l, String r) {
            String value = r.substring(1, r.length() - 1);
            return l + " LIKE '%" + this.escapeSpecialCharsForLikePattern(value) + "%' ESCAPE '\\\\'";
        }

        @Override
        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (isDistinct && this.org$apache$spark$sql$jdbc$MySQLDialect$MySQLSQLBuilder$$$outer().org$apache$spark$sql$jdbc$MySQLDialect$$distinctUnsupportedAggregateFunctions().contains((Object)funcName)) {
                throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3184", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
            }
            return super.visitAggregateFunction(funcName, isDistinct, inputs);
        }

        public /* synthetic */ MySQLDialect org$apache$spark$sql$jdbc$MySQLDialect$MySQLSQLBuilder$$$outer() {
            return (MySQLDialect)this.$outer;
        }

        public MySQLSQLBuilder(MySQLDialect $outer) {
        }
    }

    public class MySQLSQLQueryBuilder
    extends JdbcSQLQueryBuilder {
        private final JdbcDialect dialect;
        private final JDBCOptions options;
        public final /* synthetic */ MySQLDialect $outer;

        @Override
        public String build() {
            String limitOrOffsetStmt = this.limit() > 0 ? (this.offset() > 0 ? "LIMIT " + this.offset() + ", " + this.limit() : this.dialect.getLimitClause(Predef$.MODULE$.int2Integer(this.limit()))) : (this.offset() > 0 ? "LIMIT " + this.offset() + ", 18446744073709551615" : "");
            return this.options.prepareQuery() + "SELECT " + this.hintClause() + this.columnList() + " FROM " + this.options.tableOrQuery() + " " + this.tableSampleClause() + " " + this.whereClause() + " " + this.groupByClause() + " " + this.orderByClause() + " " + limitOrOffsetStmt;
        }

        public /* synthetic */ MySQLDialect org$apache$spark$sql$jdbc$MySQLDialect$MySQLSQLQueryBuilder$$$outer() {
            return this.$outer;
        }

        public MySQLSQLQueryBuilder(MySQLDialect $outer, JdbcDialect dialect, JDBCOptions options) {
            this.dialect = dialect;
            this.options = options;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(dialect, options);
        }
    }
}

