/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.annotation.Unstable;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.resource.ResourceUtils$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.DependencyUtils$;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Unstable
@DeveloperApi
public final class KubernetesUtils$
implements Logging {
    public static final KubernetesUtils$ MODULE$ = new KubernetesUtils$();
    private static SecureRandom RNG;
    private static final SystemClock systemClock;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        systemClock = new SystemClock();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SystemClock systemClock() {
        return systemClock;
    }

    private SecureRandom RNG$lzycompute() {
        KubernetesUtils$ kubernetesUtils$ = this;
        synchronized (kubernetesUtils$) {
            if (!bitmap$0) {
                RNG = new SecureRandom();
                bitmap$0 = true;
            }
        }
        return RNG;
    }

    private SecureRandom RNG() {
        if (!bitmap$0) {
            return this.RNG$lzycompute();
        }
        return RNG;
    }

    public scala.collection.immutable.Map<String, String> parsePrefixedKeyValuePairs(SparkConf sparkConf, String prefix) {
        return Predef$.MODULE$.wrapRefArray((Object[])sparkConf.getAllWithPrefix(prefix)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void requireBothOrNeitherDefined(Option<?> opt1, Option<?> opt2, String errMessageWhenFirstIsMissing, String errMessageWhenSecondIsMissing) {
        this.requireSecondIfFirstIsDefined(opt1, opt2, errMessageWhenSecondIsMissing);
        this.requireSecondIfFirstIsDefined(opt2, opt1, errMessageWhenFirstIsMissing);
    }

    public void requireSecondIfFirstIsDefined(Option<?> opt1, Option<?> opt2, String errMessageWhenSecondIsMissing) {
        opt1.foreach((Function1 & Serializable)x$1 -> {
            Predef$.MODULE$.require(opt2.isDefined(), (Function0 & Serializable)() -> errMessageWhenSecondIsMissing$1);
            return BoxedUnit.UNIT;
        });
    }

    public void requireNandDefined(Option<?> opt1, Option<?> opt2, String errMessage) {
        opt1.foreach((Function1 & Serializable)x$2 -> {
            Predef$.MODULE$.require(opt2.isEmpty(), (Function0 & Serializable)() -> errMessage$1);
            return BoxedUnit.UNIT;
        });
        opt2.foreach((Function1 & Serializable)x$3 -> {
            Predef$.MODULE$.require(opt1.isEmpty(), (Function0 & Serializable)() -> errMessage$1);
            return BoxedUnit.UNIT;
        });
    }

    public SparkPod loadPodFromTemplate(KubernetesClient kubernetesClient, String templateFileName, Option<String> containerName, SparkConf conf) {
        SparkPod sparkPod;
        try {
            Configuration hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(conf);
            String localFile = DependencyUtils$.MODULE$.downloadFile(templateFileName, Utils$.MODULE$.createTempDir(), conf, hadoopConf);
            File templateFile = new File(new URI(localFile).getPath());
            Pod pod = (Pod)((Resource)kubernetesClient.pods().load(templateFile)).item();
            sparkPod = this.selectSparkContainer(pod, containerName);
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> "Encountered exception while attempting to load initial pod spec from file", (Throwable)e);
            throw new SparkException("Could not load pod from template file.", (Throwable)e);
        }
        return sparkPod;
    }

    public SparkPod selectSparkContainer(Pod pod, Option<String> containerName) {
        List containers = CollectionConverters$.MODULE$.ListHasAsScala(pod.getSpec().getContainers()).asScala().toList();
        return (SparkPod)containerName.flatMap((Function1 & Serializable)x$5 -> this.selectNamedContainer$1(containers, (String)x$5)).orElse((Function0 & Serializable)() -> containers.headOption().map((Function1 & Serializable)x$6 -> new Tuple2(x$6, containers.tail()))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Container sparkContainer = (Container)tuple2._1();
                List rest = (List)tuple2._2();
                if (sparkContainer != null) {
                    Container container = sparkContainer;
                    if (rest != null) {
                        List list = rest;
                        return new SparkPod(((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod).editSpec().withContainers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)list).asJava())).endSpec()).build(), container);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }).getOrElse((Function0 & Serializable)() -> new SparkPod(pod, new ContainerBuilder().build()));
    }

    public String parseMasterUrl(String url) {
        return url.substring("k8s://".length());
    }

    public String formatPairsBundle(scala.collection.immutable.Seq<Tuple2<String, String>> pairs, int indent) {
        String indentStr = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\t"), indent);
        return ((IterableOnceOps)pairs.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return "\n" + indentStr + " " + k + ": " + Option$.MODULE$.apply((Object)v).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$7)))).getOrElse((Function0 & Serializable)() -> "N/A");
            }
            throw new MatchError((Object)tuple2);
        })).mkString("");
    }

    public int formatPairsBundle$default$2() {
        return 1;
    }

    public String formatPodState(Pod pod) {
        scala.collection.immutable.Seq details = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"pod name", (Object)pod.getMetadata().getName()), new Tuple2((Object)"namespace", (Object)pod.getMetadata().getNamespace()), new Tuple2((Object)"labels", (Object)CollectionConverters$.MODULE$.MapHasAsScala(pod.getMetadata().getLabels()).asScala().mkString(", ")), new Tuple2((Object)"pod uid", (Object)pod.getMetadata().getUid()), new Tuple2((Object)"creation time", (Object)this.formatTime(pod.getMetadata().getCreationTimestamp())), new Tuple2((Object)"service account name", (Object)pod.getSpec().getServiceAccountName()), new Tuple2((Object)"volumes", (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(pod.getSpec().getVolumes()).asScala().map((Function1 & Serializable)x$8 -> x$8.getName())).mkString(", ")), new Tuple2((Object)"node name", (Object)pod.getSpec().getNodeName()), new Tuple2((Object)"start time", (Object)this.formatTime(pod.getStatus().getStartTime())), new Tuple2((Object)"phase", (Object)pod.getStatus().getPhase()), new Tuple2((Object)"container status", (Object)this.containersDescription(pod, 2))}));
        return this.formatPairsBundle((scala.collection.immutable.Seq<Tuple2<String, String>>)details, this.formatPairsBundle$default$2());
    }

    public String containersDescription(Pod p2, int indent) {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(p2.getStatus().getContainerStatuses()).asScala().map((Function1 & Serializable)status -> (scala.collection.immutable.Seq)new .colon.colon((Object)new Tuple2((Object)"container name", (Object)status.getName()), (List)new .colon.colon((Object)new Tuple2((Object)"container image", (Object)status.getImage()), (List)Nil$.MODULE$)).$plus$plus(MODULE$.containerStatusDescription((ContainerStatus)status)))).map((Function1 & Serializable)p -> MODULE$.formatPairsBundle((scala.collection.immutable.Seq<Tuple2<String, String>>)p, indent))).mkString("\n\n");
    }

    public int containersDescription$default$2() {
        return 1;
    }

    public scala.collection.immutable.Seq<Tuple2<String, String>> containerStatusDescription(ContainerStatus containerStatus) {
        ContainerState state = containerStatus.getState();
        return (scala.collection.immutable.Seq)Option$.MODULE$.apply((Object)state.getRunning()).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)state.getTerminated())).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)state.getWaiting())).map((Function1 & Serializable)x0$1 -> {
            KubernetesResource kubernetesResource = x0$1;
            if (kubernetesResource instanceof ContainerStateRunning) {
                ContainerStateRunning containerStateRunning = (ContainerStateRunning)kubernetesResource;
                return new .colon.colon((Object)new Tuple2((Object)"container state", (Object)"running"), (List)new .colon.colon((Object)new Tuple2((Object)"container started at", (Object)MODULE$.formatTime(containerStateRunning.getStartedAt())), (List)Nil$.MODULE$));
            }
            if (kubernetesResource instanceof ContainerStateWaiting) {
                ContainerStateWaiting containerStateWaiting = (ContainerStateWaiting)kubernetesResource;
                return new .colon.colon((Object)new Tuple2((Object)"container state", (Object)"waiting"), (List)new .colon.colon((Object)new Tuple2((Object)"pending reason", (Object)containerStateWaiting.getReason()), (List)Nil$.MODULE$));
            }
            if (kubernetesResource instanceof ContainerStateTerminated) {
                ContainerStateTerminated containerStateTerminated = (ContainerStateTerminated)kubernetesResource;
                return new .colon.colon((Object)new Tuple2((Object)"container state", (Object)"terminated"), (List)new .colon.colon((Object)new Tuple2((Object)"container started at", (Object)MODULE$.formatTime(containerStateTerminated.getStartedAt())), (List)new .colon.colon((Object)new Tuple2((Object)"container finished at", (Object)MODULE$.formatTime(containerStateTerminated.getFinishedAt())), (List)new .colon.colon((Object)new Tuple2((Object)"exit code", (Object)containerStateTerminated.getExitCode().toString()), (List)new .colon.colon((Object)new Tuple2((Object)"termination reason", (Object)containerStateTerminated.getReason()), (List)Nil$.MODULE$)))));
            }
            throw new SparkException("Unexpected container status type " + kubernetesResource.getClass() + ".");
        }).getOrElse((Function0 & Serializable)() -> new .colon.colon((Object)new Tuple2((Object)"container state", (Object)"N/A"), (List)Nil$.MODULE$));
    }

    public String formatTime(String time) {
        if (time != null) {
            return time;
        }
        return "N/A";
    }

    public String uniqueID(Clock clock) {
        byte[] random = new byte[3];
        KubernetesUtils$ kubernetesUtils$ = this;
        synchronized (kubernetesUtils$) {
            this.RNG().nextBytes(random);
        }
        String time = Long.toHexString(clock.getTimeMillis() & 0xFFFFFFFFFFL);
        return Hex.encodeHexString((byte[])random) + time;
    }

    public Clock uniqueID$default$1() {
        return this.systemClock();
    }

    public scala.collection.immutable.Map<String, Quantity> buildResourcesQuantities(String componentName, SparkConf sparkConf) {
        scala.collection.immutable.Seq requests = ResourceUtils$.MODULE$.parseAllResourceRequests(sparkConf, componentName);
        return ((IterableOnceOps)requests.map((Function1 & Serializable)request -> {
            if (!request.vendor().isPresent()) {
                throw new SparkException("Resource: " + request.id().resourceName() + " was requested, but vendor was not specified.");
            }
            String vendorDomain = (String)request.vendor().get();
            Quantity quantity = new Quantity(Long.toString(request.amount()));
            return new Tuple2((Object)KubernetesConf$.MODULE$.buildKubernetesResourceName(vendorDomain, request.id().resourceName()), (Object)quantity);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Iterable<String> uploadAndTransformFileUris(Iterable<String> fileUris, Option<SparkConf> conf) {
        return (Iterable)fileUris.map((Function1 & Serializable)uri -> MODULE$.uploadFileUri((String)uri, conf));
    }

    public Option<SparkConf> uploadAndTransformFileUris$default$2() {
        return None$.MODULE$;
    }

    private boolean isLocalDependency(URI uri) {
        block6: {
            String string = uri.getScheme();
            switch (string == null ? 0 : string.hashCode()) {
                case 0: {
                    if (string == null) {
                        break;
                    }
                    break block6;
                }
                case 3143036: {
                    if ("file".equals(string)) {
                        break;
                    }
                    break block6;
                }
                default: {
                    break block6;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isLocalAndResolvable(String resource) {
        String string = resource;
        String string2 = "spark-internal";
        return (string == null ? string2 != null : !string.equals(string2)) && this.isLocalDependency(Utils$.MODULE$.resolveURI(resource));
    }

    public String renameMainAppResource(String resource, Option<SparkConf> conf, boolean shouldUploadLocal) {
        if (this.isLocalAndResolvable(resource)) {
            if (shouldUploadLocal) {
                return this.uploadFileUri(resource, conf);
            }
            return "spark-internal";
        }
        return resource;
    }

    public Option<SparkConf> renameMainAppResource$default$2() {
        return None$.MODULE$;
    }

    public String uploadFileUri(String uri, Option<SparkConf> conf) {
        Option<SparkConf> option = conf;
        if (option instanceof Some) {
            Some some = (Some)option;
            SparkConf sConf = (SparkConf)some.value();
            if (((Option)sConf.get(Config$.MODULE$.KUBERNETES_FILE_UPLOAD_PATH())).isDefined()) {
                String string;
                URI fileUri = Utils$.MODULE$.resolveURI(uri);
                try {
                    Configuration hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(sConf);
                    String uploadPath = (String)((Option)sConf.get(Config$.MODULE$.KUBERNETES_FILE_UPLOAD_PATH())).get();
                    FileSystem fs = Utils$.MODULE$.getHadoopFileSystem(Utils$.MODULE$.resolveURI(uploadPath), hadoopConf);
                    String randomDirName = "spark-upload-" + UUID.randomUUID();
                    fs.mkdirs(new Path(uploadPath + "/" + randomDirName));
                    String targetUri = uploadPath + "/" + randomDirName + "/" + ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])fileUri.getPath().split("/")));
                    this.log().info("Uploading file: " + fileUri.getPath() + " to dest: " + targetUri + "...");
                    this.uploadFileToHadoopCompatibleFS(new Path(fileUri), new Path(targetUri), fs, this.uploadFileToHadoopCompatibleFS$default$4(), this.uploadFileToHadoopCompatibleFS$default$5());
                    string = targetUri;
                }
                catch (Exception e) {
                    throw new SparkException("Uploading file " + fileUri.getPath() + " failed...", (Throwable)e);
                }
                return string;
            }
            throw new SparkException("Please specify spark.kubernetes.file.upload.path property.");
        }
        throw new SparkException("Spark configuration is missing...");
    }

    public Option<SparkConf> uploadFileUri$default$2() {
        return None$.MODULE$;
    }

    private void uploadFileToHadoopCompatibleFS(Path src, Path dest, FileSystem fs, boolean delSrc, boolean overwrite) {
        try {
            fs.copyFromLocalFile(delSrc, overwrite, src, dest);
        }
        catch (IOException e) {
            throw new SparkException("Error uploading file " + src.getName(), (Throwable)e);
        }
    }

    private boolean uploadFileToHadoopCompatibleFS$default$4() {
        return false;
    }

    private boolean uploadFileToHadoopCompatibleFS$default$5() {
        return true;
    }

    public Option<Pod> buildPodWithServiceAccount(Option<String> serviceAccount, SparkPod pod) {
        return serviceAccount.map((Function1 & Serializable)account -> ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(pod.pod()).editOrNewSpec().withServiceAccount(account).withServiceAccountName(account)).endSpec()).build());
    }

    public void addOwnerReference(Pod pod, scala.collection.immutable.Seq<HasMetadata> resources) {
        if (pod != null) {
            OwnerReference reference = ((OwnerReferenceBuilder)new OwnerReferenceBuilder().withName(pod.getMetadata().getName()).withApiVersion(pod.getApiVersion()).withUid(pod.getMetadata().getUid()).withKind(pod.getKind()).withController(Predef$.MODULE$.boolean2Boolean(true))).build();
            resources.foreach((Function1 & Serializable)resource -> {
                KubernetesUtils$.$anonfun$addOwnerReference$1(reference, resource);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public scala.collection.immutable.Seq<EnvVar> buildEnvVars(scala.collection.immutable.Seq<Tuple2<String, String>> env) {
        return (scala.collection.immutable.Seq)((IterableOps)env.filterNot((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)KubernetesUtils$.$anonfun$buildEnvVars$1(x$9)))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return ((EnvVarBuilder)new EnvVarBuilder().withName(k).withValue(v)).build();
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public scala.collection.immutable.Seq<EnvVar> buildEnvVarsWithFieldRef(scala.collection.immutable.Seq<Tuple3<String, String, String>> env) {
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)env.filterNot((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)KubernetesUtils$.$anonfun$buildEnvVarsWithFieldRef$1(x$10)))).filterNot((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)KubernetesUtils$.$anonfun$buildEnvVarsWithFieldRef$2(x$11)))).map((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                String key = (String)tuple3._1();
                String apiVersion = (String)tuple3._2();
                String fieldPath = (String)tuple3._3();
                return ((EnvVarBuilder)new EnvVarBuilder().withName(key).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withNewFieldRef(apiVersion, fieldPath)).build())).build();
            }
            throw new MatchError((Object)tuple3);
        });
    }

    public static final /* synthetic */ boolean $anonfun$selectSparkContainer$1(String name$1, Container x$4) {
        String string = x$4.getName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Option selectNamedContainer$1(List containers, String name) {
        Tuple2 tuple2 = containers.partition((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KubernetesUtils$.$anonfun$selectSparkContainer$1(name, x$4)));
        if (tuple2 != null) {
            List list = (List)tuple2._1();
            List rest = (List)tuple2._2();
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                Container sparkContainer = (Container)colon2.head();
                List list2 = colon2.next$access$1();
                if (Nil$.MODULE$.equals(list2)) {
                    return new Some((Object)new Tuple2((Object)sparkContainer, (Object)rest));
                }
            }
        }
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"specified container ", " not found on pod template, "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.POD_ID$.MODULE$, (Object)name)})).$plus(MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"falling back to taking the first container"}))).log((scala.collection.immutable.Seq)Nil$.MODULE$))));
        return Option$.MODULE$.empty();
    }

    public static final /* synthetic */ void $anonfun$addOwnerReference$1(OwnerReference reference$1, HasMetadata resource) {
        ObjectMeta originalMetadata = resource.getMetadata();
        originalMetadata.setOwnerReferences(Collections.singletonList(reference$1));
    }

    public static final /* synthetic */ boolean $anonfun$buildEnvVars$1(Tuple2 x$9) {
        return x$9._2() == null;
    }

    public static final /* synthetic */ boolean $anonfun$buildEnvVarsWithFieldRef$1(Tuple3 x$10) {
        return x$10._2() == null;
    }

    public static final /* synthetic */ boolean $anonfun$buildEnvVarsWithFieldRef$2(Tuple3 x$11) {
        return x$11._3() == null;
    }

    private KubernetesUtils$() {
    }
}

