/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.pipelines;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.SparkException;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.ScalaRunTime$;

public final class DataflowGraphRegistry$ {
    public static final DataflowGraphRegistry$ MODULE$ = new DataflowGraphRegistry$();
    private static final ConcurrentHashMap<String, GraphRegistrationContext> dataflowGraphs = new ConcurrentHashMap();

    private ConcurrentHashMap<String, GraphRegistrationContext> dataflowGraphs() {
        return dataflowGraphs;
    }

    public String createDataflowGraph(String defaultCatalog, String defaultDatabase, Map<String, String> defaultSqlConf) {
        String graphId = UUID.randomUUID().toString();
        this.dataflowGraphs().put(graphId, new GraphRegistrationContext(defaultCatalog, defaultDatabase, defaultSqlConf));
        return graphId;
    }

    public Option<GraphRegistrationContext> getDataflowGraph(String graphId) {
        return Option$.MODULE$.apply((Object)this.dataflowGraphs().get(graphId));
    }

    public GraphRegistrationContext getDataflowGraphOrThrow(String dataflowGraphId) {
        return (GraphRegistrationContext)this.getDataflowGraph(dataflowGraphId).getOrElse((Function0 & Serializable)() -> {
            throw new SparkException("DATAFLOW_GRAPH_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"graphId"), (Object)dataflowGraphId)})), null);
        });
    }

    public void dropDataflowGraph(String graphId) {
        this.dataflowGraphs().remove(graphId);
    }

    public Seq<GraphRegistrationContext> getAllDataflowGraphs() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(this.dataflowGraphs().values()).asScala().toSeq();
    }

    public void dropAllDataflowGraphs() {
        this.dataflowGraphs().clear();
    }

    private DataflowGraphRegistry$() {
    }
}

