/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.spark.sql.catalyst.analysis.GetViewColumnByNameAndOrdinal;
import org.apache.spark.sql.catalyst.analysis.MultiInstanceRelation;
import org.apache.spark.sql.catalyst.analysis.ResolvedInlineTable;
import org.apache.spark.sql.catalyst.analysis.resolver.AttributeScopeStack;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionIdAssigner$;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolutionValidator;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.CTERelationDef;
import org.apache.spark.sql.catalyst.plans.logical.CTERelationRef;
import org.apache.spark.sql.catalyst.plans.logical.Distinct;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.GlobalLimit;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LocalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Offset;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Range;
import org.apache.spark.sql.catalyst.plans.logical.Repartition;
import org.apache.spark.sql.catalyst.plans.logical.SetOperation;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.plans.logical.SupervisingCommand;
import org.apache.spark.sql.catalyst.plans.logical.Tail;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.plans.logical.WithCTE;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Eh\u0001B\u0010!\u0001=BQA\u000e\u0001\u0005\u0002]BqA\u000f\u0001C\u0002\u0013%1\b\u0003\u0004@\u0001\u0001\u0006I\u0001\u0010\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u0011\u0019)\u0005\u0001)A\u0005\u0005\")a\t\u0001C\u0001w!)q\t\u0001C\u0001\u0011\")a\u000b\u0001C\u0001/\")!\f\u0001C\u00057\")\u0011\r\u0001C\u0005E\")\u0001\u000e\u0001C\u0005S\")q\u000e\u0001C\u0005a\")a\u000f\u0001C\u0005o\")Q\u0010\u0001C\u0005}\"9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0001bBA\f\u0001\u0011%\u0011\u0011\u0004\u0005\b\u0003K\u0001A\u0011BA\u0014\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003kAq!!\u0011\u0001\t\u0013\t\u0019\u0005C\u0004\u0002P\u0001!I!!\u0015\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`!9\u00111\u000e\u0001\u0005\n\u00055\u0004bBA>\u0001\u0011%\u0011Q\u0010\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!a&\u0001\t\u0013\tI\nC\u0004\u0002&\u0002!I!a*\t\u000f\u0005M\u0006\u0001\"\u0003\u00026\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0007bBAd\u0001\u0011%\u0011\u0011\u001a\u0002\u0014%\u0016\u001cx\u000e\\;uS>tg+\u00197jI\u0006$xN\u001d\u0006\u0003C\t\n\u0001B]3t_24XM\u001d\u0006\u0003G\u0011\n\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003K\u0019\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003O!\n1a]9m\u0015\tI#&A\u0003ta\u0006\u00148N\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00019!\tI\u0004!D\u0001!\u0003M\tG\u000f\u001e:jEV$XmU2pa\u0016\u001cF/Y2l+\u0005a\u0004CA\u001d>\u0013\tq\u0004EA\nBiR\u0014\u0018NY;uKN\u001bw\u000e]3Ti\u0006\u001c7.\u0001\u000bbiR\u0014\u0018NY;uKN\u001bw\u000e]3Ti\u0006\u001c7\u000eI\u0001\u001eKb\u0004(/Z:tS>t'+Z:pYV$\u0018n\u001c8WC2LG-\u0019;peV\t!\t\u0005\u0002:\u0007&\u0011A\t\t\u0002\u001e\u000bb\u0004(/Z:tS>t'+Z:pYV$\u0018n\u001c8WC2LG-\u0019;pe\u0006qR\r\u001f9sKN\u001c\u0018n\u001c8SKN|G.\u001e;j_:4\u0016\r\\5eCR|'\u000fI\u0001\u0017O\u0016$\u0018\t\u001e;sS\n,H/Z*d_B,7\u000b^1dW\u0006aa/\u00197jI\u0006$X\r\u00157b]R\u0011\u0011\n\u0014\t\u0003c)K!a\u0013\u001a\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001b\u001e\u0001\rAT\u0001\u0005a2\fg\u000e\u0005\u0002P)6\t\u0001K\u0003\u0002R%\u00069An\\4jG\u0006d'BA*%\u0003\u0015\u0001H.\u00198t\u0013\t)\u0006KA\u0006M_\u001eL7-\u00197QY\u0006t\u0017\u0001\u0003<bY&$\u0017\r^3\u0015\u0005%C\u0006\"B-\t\u0001\u0004q\u0015\u0001C8qKJ\fGo\u001c:\u0002\u0019Y\fG.\u001b3bi\u0016<\u0016\u000e\u001e5\u0015\u0005%c\u0006\"B/\n\u0001\u0004q\u0016aB<ji\"\u001cE/\u001a\t\u0003\u001f~K!\u0001\u0019)\u0003\u000f]KG\u000f[\"U\u000b\u00061b/\u00197jI\u0006$Xm\u0011;f%\u0016d\u0017\r^5p]\u0012+g\r\u0006\u0002JG\")AM\u0003a\u0001K\u0006q1\r^3SK2\fG/[8o\t\u00164\u0007CA(g\u0013\t9\u0007K\u0001\bD)\u0016\u0013V\r\\1uS>tG)\u001a4\u0002-Y\fG.\u001b3bi\u0016\u001cE/\u001a*fY\u0006$\u0018n\u001c8SK\u001a$\"!\u00136\t\u000b-\\\u0001\u0019\u00017\u0002\u001d\r$XMU3mCRLwN\u001c*fMB\u0011q*\\\u0005\u0003]B\u0013ab\u0011+F%\u0016d\u0017\r^5p]J+g-A\twC2LG-\u0019;f\u0003\u001e<'/Z4bi\u0016$\"!S9\t\u000bId\u0001\u0019A:\u0002\u0013\u0005<wM]3hCR,\u0007CA(u\u0013\t)\bKA\u0005BO\u001e\u0014XmZ1uK\u0006ya/\u00197jI\u0006$X\r\u0015:pU\u0016\u001cG\u000f\u0006\u0002Jq\")\u00110\u0004a\u0001u\u00069\u0001O]8kK\u000e$\bCA(|\u0013\ta\bKA\u0004Qe>TWm\u0019;\u0002\u001dY\fG.\u001b3bi\u00164\u0015\u000e\u001c;feR\u0011\u0011j \u0005\b\u0003\u0003q\u0001\u0019AA\u0002\u0003\u00191\u0017\u000e\u001c;feB\u0019q*!\u0002\n\u0007\u0005\u001d\u0001K\u0001\u0004GS2$XM]\u0001\u0016m\u0006d\u0017\u000eZ1uKN+(-];fef\fE.[1t)\rI\u0015Q\u0002\u0005\b\u0003\u001fy\u0001\u0019AA\t\u00035\u0019XOY9vKJL\u0018\t\\5bgB\u0019q*a\u0005\n\u0007\u0005U\u0001KA\u0007Tk\n\fX/\u001a:z\u00032L\u0017m]\u0001\rm\u0006d\u0017\u000eZ1uKZKWm\u001e\u000b\u0004\u0013\u0006m\u0001bBA\u000f!\u0001\u0007\u0011qD\u0001\u0005m&,w\u000fE\u0002P\u0003CI1!a\tQ\u0005\u00111\u0016.Z<\u0002'Y\fG.\u001b3bi\u0016<En\u001c2bY2KW.\u001b;\u0015\u0007%\u000bI\u0003C\u0004\u0002,E\u0001\r!!\f\u0002\u0017\u001ddwNY1m\u0019&l\u0017\u000e\u001e\t\u0004\u001f\u0006=\u0012bAA\u0019!\nYq\t\\8cC2d\u0015.\\5u\u0003I1\u0018\r\\5eCR,Gj\\2bY2KW.\u001b;\u0015\u0007%\u000b9\u0004C\u0004\u0002:I\u0001\r!a\u000f\u0002\u00151|7-\u00197MS6LG\u000fE\u0002P\u0003{I1!a\u0010Q\u0005)aunY1m\u0019&l\u0017\u000e^\u0001\u000fm\u0006d\u0017\u000eZ1uK>3gm]3u)\rI\u0015Q\t\u0005\b\u0003\u000f\u001a\u0002\u0019AA%\u0003\u0019ygMZ:fiB\u0019q*a\u0013\n\u0007\u00055\u0003K\u0001\u0004PM\u001a\u001cX\r^\u0001\rm\u0006d\u0017\u000eZ1uKR\u000b\u0017\u000e\u001c\u000b\u0004\u0013\u0006M\u0003bBA+)\u0001\u0007\u0011qK\u0001\u0005i\u0006LG\u000eE\u0002P\u00033J1!a\u0017Q\u0005\u0011!\u0016-\u001b7\u0002!Y\fG.\u001b3bi\u0016$\u0015n\u001d;j]\u000e$HcA%\u0002b!9\u00111M\u000bA\u0002\u0005\u0015\u0014\u0001\u00033jgRLgn\u0019;\u0011\u0007=\u000b9'C\u0002\u0002jA\u0013\u0001\u0002R5ti&t7\r^\u0001\u0014m\u0006d\u0017\u000eZ1uK&sG.\u001b8f)\u0006\u0014G.\u001a\u000b\u0004\u0013\u0006=\u0004bBA9-\u0001\u0007\u00111O\u0001\fS:d\u0017N\\3UC\ndW\r\u0005\u0003\u0002v\u0005]T\"\u0001\u0012\n\u0007\u0005e$EA\nSKN|GN^3e\u0013:d\u0017N\\3UC\ndW-\u0001\twC2LG-\u0019;f%\u0016d\u0017\r^5p]R\u0019\u0011*a \t\r\u0005\u0005u\u00031\u0001O\u0003!\u0011X\r\\1uS>t\u0017\u0001\u0007<bY&$\u0017\r^3TKR|\u0005/\u001a:bi&|g\u000eT5lKR\u0019\u0011*a\"\t\u000b5C\u0002\u0019\u0001(\u0002\u0019Y\fG.\u001b3bi\u0016\u001cvN\u001d;\u0015\u0007%\u000bi\tC\u0004\u0002\u0010f\u0001\r!!%\u0002\tM|'\u000f\u001e\t\u0004\u001f\u0006M\u0015bAAK!\n!1k\u001c:u\u0003M1\u0018\r\\5eCR,'+\u001a9beRLG/[8o)\rI\u00151\u0014\u0005\b\u0003;S\u0002\u0019AAP\u0003-\u0011X\r]1si&$\u0018n\u001c8\u0011\u0007=\u000b\t+C\u0002\u0002$B\u00131BU3qCJ$\u0018\u000e^5p]\u0006aa/\u00197jI\u0006$XMS8j]R\u0019\u0011*!+\t\u000f\u0005-6\u00041\u0001\u0002.\u0006!!n\\5o!\ry\u0015qV\u0005\u0004\u0003c\u0003&\u0001\u0002&pS:\f!D^1mS\u0012\fG/Z*va\u0016\u0014h/[:j]\u001e\u001cu.\\7b]\u0012$2!SA\\\u0011\u001d\tI\f\ba\u0001\u0003w\u000b!c];qKJ4\u0018n]5oO\u000e{W.\\1oIB\u0019q*!0\n\u0007\u0005}\u0006K\u0001\nTkB,'O^5tS:<7i\\7nC:$\u0017\u0001\u00065b]\u0012dWm\u00149fe\u0006$xN](viB,H\u000fF\u0002J\u0003\u000bDQ!W\u000fA\u00029\u000b!b\u001e:ba\u0016\u0013(o\u001c:t+\u0011\tY-!8\u0015\t\u00055\u0017q\u001e\u000b\u0004\u0013\u0006=\u0007\u0002CAi=\u0011\u0005\r!a5\u0002\t\t|G-\u001f\t\u0006c\u0005U\u0017\u0011\\\u0005\u0004\u0003/\u0014$\u0001\u0003\u001fcs:\fW.\u001a \u0011\t\u0005m\u0017Q\u001c\u0007\u0001\t\u001d\tyN\bb\u0001\u0003C\u0014\u0011AU\t\u0005\u0003G\fI\u000fE\u00022\u0003KL1!a:3\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!MAv\u0013\r\tiO\r\u0002\u0004\u0003:L\b\"B'\u001f\u0001\u0004q\u0005")
public class ResolutionValidator {
    private final AttributeScopeStack attributeScopeStack = new AttributeScopeStack();
    private final ExpressionResolutionValidator expressionResolutionValidator = new ExpressionResolutionValidator(this);

    private AttributeScopeStack attributeScopeStack() {
        return this.attributeScopeStack;
    }

    private ExpressionResolutionValidator expressionResolutionValidator() {
        return this.expressionResolutionValidator;
    }

    public AttributeScopeStack getAttributeScopeStack() {
        return this.attributeScopeStack();
    }

    public void validatePlan(LogicalPlan plan2) {
        this.wrapErrors(plan2, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.validate(plan2));
    }

    public void validate(LogicalPlan operator) {
        LogicalPlan logicalPlan = operator;
        if (logicalPlan instanceof WithCTE) {
            WithCTE withCTE = (WithCTE)logicalPlan;
            this.validateWith(withCTE);
        } else if (logicalPlan instanceof CTERelationDef) {
            CTERelationDef cTERelationDef = (CTERelationDef)logicalPlan;
            this.validateCteRelationDef(cTERelationDef);
        } else if (logicalPlan instanceof CTERelationRef) {
            CTERelationRef cTERelationRef = (CTERelationRef)logicalPlan;
            this.validateCteRelationRef(cTERelationRef);
        } else if (logicalPlan instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)logicalPlan;
            this.validateAggregate(aggregate);
        } else if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            this.validateProject(project);
        } else if (logicalPlan instanceof Filter) {
            Filter filter = (Filter)logicalPlan;
            this.validateFilter(filter);
        } else if (logicalPlan instanceof SubqueryAlias) {
            SubqueryAlias subqueryAlias = (SubqueryAlias)logicalPlan;
            this.validateSubqueryAlias(subqueryAlias);
        } else if (logicalPlan instanceof View) {
            View view = (View)logicalPlan;
            this.validateView(view);
        } else if (logicalPlan instanceof GlobalLimit) {
            GlobalLimit globalLimit = (GlobalLimit)logicalPlan;
            this.validateGlobalLimit(globalLimit);
        } else if (logicalPlan instanceof LocalLimit) {
            LocalLimit localLimit = (LocalLimit)logicalPlan;
            this.validateLocalLimit(localLimit);
        } else if (logicalPlan instanceof Offset) {
            Offset offset = (Offset)logicalPlan;
            this.validateOffset(offset);
        } else if (logicalPlan instanceof Tail) {
            Tail tail = (Tail)logicalPlan;
            this.validateTail(tail);
        } else if (logicalPlan instanceof Distinct) {
            Distinct distinct = (Distinct)logicalPlan;
            this.validateDistinct(distinct);
        } else if (logicalPlan instanceof ResolvedInlineTable) {
            ResolvedInlineTable resolvedInlineTable = (ResolvedInlineTable)logicalPlan;
            this.validateInlineTable(resolvedInlineTable);
        } else if (logicalPlan instanceof LocalRelation) {
            LocalRelation localRelation = (LocalRelation)logicalPlan;
            this.validateRelation(localRelation);
        } else if (logicalPlan instanceof OneRowRelation) {
            OneRowRelation oneRowRelation = (OneRowRelation)logicalPlan;
            this.validateRelation(oneRowRelation);
        } else if (logicalPlan instanceof Range) {
            Range range = (Range)logicalPlan;
            this.validateRelation(range);
        } else if (logicalPlan instanceof Union ? true : logicalPlan instanceof SetOperation) {
            this.validateSetOperationLike(logicalPlan);
        } else if (logicalPlan instanceof Sort) {
            Sort sort = (Sort)logicalPlan;
            this.validateSort(sort);
        } else if (logicalPlan instanceof Join) {
            Join join = (Join)logicalPlan;
            this.validateJoin(join);
        } else if (logicalPlan instanceof Repartition) {
            Repartition repartition = (Repartition)logicalPlan;
            this.validateRepartition(repartition);
        } else if (logicalPlan instanceof MultiInstanceRelation) {
            LogicalPlan logicalPlan2 = logicalPlan;
            this.validateRelation(logicalPlan2);
        } else if (logicalPlan instanceof SupervisingCommand) {
            SupervisingCommand supervisingCommand = (SupervisingCommand)((Object)logicalPlan);
            this.validateSupervisingCommand(supervisingCommand);
        } else {
            throw new MatchError((Object)logicalPlan);
        }
        LogicalPlan logicalPlan3 = operator;
        if (logicalPlan3 instanceof WithCTE) {
            return;
        }
        ExpressionIdAssigner$.MODULE$.assertOutputsHaveNoConflictingExpressionIds((Seq<Seq<Attribute>>)((Seq)operator.children().map((Function1 & Serializable)x$1 -> x$1.output())));
    }

    private void validateWith(WithCTE withCte) {
        HashSet knownCteDefIds = new HashSet(withCte.cteDefs().length());
        withCte.cteDefs().foreach((Function1 & Serializable)cteDef -> BoxesRunTime.boxToBoolean((boolean)ResolutionValidator.$anonfun$validateWith$1(this, knownCteDefIds, cteDef)));
        this.validate(withCte.plan());
    }

    private void validateCteRelationDef(CTERelationDef cteRelationDef) {
        this.validate(cteRelationDef.child());
    }

    private void validateCteRelationRef(CTERelationRef cteRelationRef) {
        this.handleOperatorOutput(cteRelationRef);
    }

    private void validateAggregate(Aggregate aggregate) {
        this.attributeScopeStack().pushScope(this.attributeScopeStack().pushScope$default$1());
        try {
            this.validate(aggregate.child());
            this.expressionResolutionValidator().validateProjectList(aggregate.aggregateExpressions());
            aggregate.groupingExpressions().foreach((Function1 & Serializable)expression -> {
                ResolutionValidator.$anonfun$validateAggregate$1(this, expression);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.attributeScopeStack().popScope();
        }
        this.handleOperatorOutput(aggregate);
    }

    private void validateProject(Project project) {
        this.attributeScopeStack().pushScope(this.attributeScopeStack().pushScope$default$1());
        try {
            this.validate(project.child());
            this.expressionResolutionValidator().validateProjectList(project.projectList());
        }
        finally {
            this.attributeScopeStack().popScope();
        }
        this.handleOperatorOutput(project);
    }

    private void validateFilter(Filter filter) {
        this.validate(filter.child());
        DataType dataType = filter.condition().dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        Predef$.MODULE$.assert(!(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null), (Function0 & Serializable)() -> "Output type of a filter must be a boolean, but got: " + filter.condition().dataType().typeName());
        this.expressionResolutionValidator().validate(filter.condition());
    }

    private void validateSubqueryAlias(SubqueryAlias subqueryAlias) {
        this.validate(subqueryAlias.child());
        this.handleOperatorOutput(subqueryAlias);
    }

    private void validateView(View view) {
        this.validate(view.child());
        LogicalPlan logicalPlan = view.child();
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            Predef$.MODULE$.assert(!project.projectList().exists((Function1 & Serializable)expression -> BoxesRunTime.boxToBoolean((boolean)ResolutionValidator.$anonfun$validateView$1(expression))), (Function0 & Serializable)() -> "Resolved Project operator under a view cannot contain GetViewColumnByNameAndOrdinal");
        }
        this.handleOperatorOutput(view);
    }

    private void validateGlobalLimit(GlobalLimit globalLimit) {
        this.validate(globalLimit.child());
        this.expressionResolutionValidator().validate(globalLimit.limitExpr());
    }

    private void validateLocalLimit(LocalLimit localLimit) {
        this.validate(localLimit.child());
        this.expressionResolutionValidator().validate(localLimit.limitExpr());
    }

    private void validateOffset(Offset offset) {
        this.validate(offset.child());
        this.expressionResolutionValidator().validate(offset.offsetExpr());
    }

    private void validateTail(Tail tail) {
        this.validate(tail.child());
        this.expressionResolutionValidator().validate(tail.limitExpr());
    }

    private void validateDistinct(Distinct distinct) {
        this.validate(distinct.child());
    }

    private void validateInlineTable(ResolvedInlineTable inlineTable) {
        inlineTable.rows().foreach((Function1 & Serializable)row -> {
            row.foreach((Function1 & Serializable)expression -> {
                ResolutionValidator.$anonfun$validateInlineTable$2($this, expression);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.handleOperatorOutput(inlineTable);
    }

    private void validateRelation(LogicalPlan relation) {
        this.handleOperatorOutput(relation);
    }

    private void validateSetOperationLike(LogicalPlan plan2) {
        plan2.children().foreach((Function1 & Serializable)operator -> {
            this.validate(operator);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(plan2.children().length() > 1, (Function0 & Serializable)() -> plan2.nodeName() + " operator has to have at least 2 children");
        Seq<Attribute> firstChildOutput = ((QueryPlan)plan2.children().head()).output();
        ((IterableOnceOps)plan2.children().tail()).foreach((Function1 & Serializable)child -> {
            ResolutionValidator.$anonfun$validateSetOperationLike$3(firstChildOutput, plan2, child);
            return BoxedUnit.UNIT;
        });
        this.handleOperatorOutput(plan2);
    }

    private void validateSort(Sort sort) {
        this.validate(sort.child());
        sort.order().foreach((Function1 & Serializable)sortOrder -> {
            ResolutionValidator.$anonfun$validateSort$1(this, sortOrder);
            return BoxedUnit.UNIT;
        });
    }

    private void validateRepartition(Repartition repartition) {
        this.validate(repartition.child());
    }

    private void validateJoin(Join join) {
        block9: {
            this.attributeScopeStack().pushScope(this.attributeScopeStack().pushScope$default$1());
            try {
                this.attributeScopeStack().pushScope(this.attributeScopeStack().pushScope$default$1());
                try {
                    this.validate(join.left());
                    this.validate(join.right());
                    Predef$.MODULE$.assert(join.left().outputSet().intersect(join.right().outputSet()).isEmpty());
                }
                finally {
                    this.attributeScopeStack().popScope();
                }
                this.attributeScopeStack().overwriteCurrent((Seq<Attribute>)((Seq)join.left().output().$plus$plus(join.right().output())));
                Option<Expression> option = join.condition();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Expression condition = (Expression)some.value();
                    this.expressionResolutionValidator().validate(condition);
                    break block9;
                }
                if (None$.MODULE$.equals(option)) {
                    break block9;
                }
                throw new MatchError(option);
            }
            finally {
                this.attributeScopeStack().popScope();
            }
        }
        this.handleOperatorOutput(join);
    }

    private void validateSupervisingCommand(SupervisingCommand supervisingCommand) {
    }

    private void handleOperatorOutput(LogicalPlan operator) {
        this.attributeScopeStack().overwriteCurrent(operator.output());
        operator.output().foreach((Function1 & Serializable)attribute -> {
            ResolutionValidator.$anonfun$handleOperatorOutput$1(this, attribute);
            return BoxedUnit.UNIT;
        });
    }

    private <R> void wrapErrors(LogicalPlan plan2, Function0<R> body) {
        try {
            body.apply();
        }
        catch (Throwable ex) {
            throw QueryCompilationErrors$.MODULE$.resolutionValidationError(ex, plan2);
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateWith$1(ResolutionValidator $this, HashSet knownCteDefIds$1, CTERelationDef cteDef) {
        Predef$.MODULE$.assert(!knownCteDefIds$1.contains(BoxesRunTime.boxToLong((long)cteDef.id())), (Function0 & Serializable)() -> "Duplicate CTE definition id: " + cteDef.id());
        $this.validate(cteDef);
        return knownCteDefIds$1.add(BoxesRunTime.boxToLong((long)cteDef.id()));
    }

    public static final /* synthetic */ void $anonfun$validateAggregate$1(ResolutionValidator $this, Expression expression) {
        $this.expressionResolutionValidator().validate(expression);
    }

    public static final /* synthetic */ boolean $anonfun$validateView$1(NamedExpression expression) {
        return expression instanceof GetViewColumnByNameAndOrdinal;
    }

    public static final /* synthetic */ void $anonfun$validateInlineTable$2(ResolutionValidator $this, Expression expression) {
        $this.expressionResolutionValidator().validate(expression);
    }

    public static final /* synthetic */ void $anonfun$validateSetOperationLike$3(Seq firstChildOutput$1, LogicalPlan plan$2, LogicalPlan child) {
        Seq<Attribute> childOutput = child.output();
        Predef$.MODULE$.assert(childOutput.length() == firstChildOutput$1.length(), (Function0 & Serializable)() -> "Unexpected output length for " + plan$2.nodeName() + " child " + child);
    }

    public static final /* synthetic */ void $anonfun$validateSort$1(ResolutionValidator $this, SortOrder sortOrder) {
        $this.expressionResolutionValidator().validate(sortOrder.child());
    }

    public static final /* synthetic */ void $anonfun$handleOperatorOutput$1(ResolutionValidator $this, Attribute attribute) {
        Predef$.MODULE$.assert(attribute instanceof AttributeReference, (Function0 & Serializable)() -> "Output of an operator must be a reference to an attribute, but got: " + attribute.getClass().getSimpleName());
        $this.expressionResolutionValidator().validate(attribute);
    }
}

