/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.pipelines.graph.PipelineTableProperty;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PipelinesTableProperties$ {
    public static final PipelinesTableProperties$ MODULE$ = new PipelinesTableProperties$();
    private static final String pipelinesPrefix = "pipelines.";
    private static final HashMap<String, PipelineTableProperty<?>> entries = HashMap$.MODULE$.empty();
    private static final PipelineTableProperty<Object> resetAllowed = MODULE$.buildProp("pipelines.reset.allowed", true);

    public String pipelinesPrefix() {
        return pipelinesPrefix;
    }

    private HashMap<String, PipelineTableProperty<?>> entries() {
        return entries;
    }

    public PipelineTableProperty<Object> resetAllowed() {
        return resetAllowed;
    }

    public Map<String, String> validateAndCanonicalize(Map<String, String> rawProps, Function1<String, BoxedUnit> warnFunction) {
        return (Map)rawProps.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String originalCaseKey = (String)tuple2._1();
                String value = (String)tuple2._2();
                String k = originalCaseKey.toLowerCase(Locale.ROOT);
                if (k.startsWith(MODULE$.pipelinesPrefix())) {
                    Option option = MODULE$.entries().get((Object)k);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        PipelineTableProperty prop = (PipelineTableProperty)some.value();
                        prop.fromMap(rawProps);
                        return Option$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)prop.key()), (Object)value));
                    }
                    if (None$.MODULE$.equals(option)) {
                        warnFunction.apply((Object)("Unknown pipelines table property '" + originalCaseKey + "'."));
                        return None$.MODULE$;
                    }
                    throw new MatchError((Object)option);
                }
                Option similarProp = MODULE$.entries().get((Object)(MODULE$.pipelinesPrefix() + k));
                similarProp.foreach((Function1 & Serializable)c -> {
                    warnFunction.apply((Object)("You are trying to set table property '" + originalCaseKey + "', which has a similar name to Pipelines table property '" + c.key() + "'. If you are trying to set the Pipelines table property, please include the correct prefix."));
                    return BoxedUnit.UNIT;
                });
                return Option$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)originalCaseKey), (Object)value));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private <T> PipelineTableProperty<T> buildProp(String key, String string, Function1<String, T> fromString) {
        PipelineTableProperty<T> prop = new PipelineTableProperty<T>(key, string, fromString);
        this.entries().put((Object)key.toLowerCase(Locale.ROOT), prop);
        return prop;
    }

    private PipelineTableProperty<Object> buildProp(String key, boolean bl) {
        return this.buildProp(key, Boolean.toString(bl), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$1))));
    }

    private PipelinesTableProperties$() {
    }
}

