/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.FailureStoppingFlow;
import org.apache.spark.sql.pipelines.graph.Flow;
import org.apache.spark.sql.pipelines.graph.FlowExecution;
import org.apache.spark.sql.pipelines.graph.GraphExecution;
import org.apache.spark.sql.pipelines.graph.GraphExecution$;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContext;
import org.apache.spark.sql.pipelines.graph.PipelinesErrors$;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.graph.RunCompletion;
import org.apache.spark.sql.pipelines.graph.RunTerminationException;
import org.apache.spark.sql.pipelines.graph.RunTerminationReason;
import org.apache.spark.sql.pipelines.graph.TriggeredFailureInfo;
import org.apache.spark.sql.pipelines.graph.TriggeredGraphExecution$;
import org.apache.spark.sql.pipelines.graph.TriggeredGraphExecution$StreamState$CANCELED$;
import org.apache.spark.sql.pipelines.graph.TriggeredGraphExecution$StreamState$EXCLUDED$;
import org.apache.spark.sql.pipelines.graph.TriggeredGraphExecution$StreamState$IDLE$;
import org.apache.spark.sql.pipelines.graph.TriggeredGraphExecution$StreamState$QUEUED$;
import org.apache.spark.sql.pipelines.graph.TriggeredGraphExecution$StreamState$RUNNING$;
import org.apache.spark.sql.pipelines.graph.TriggeredGraphExecution$StreamState$SKIPPED$;
import org.apache.spark.sql.pipelines.graph.TriggeredGraphExecution$StreamState$SUCCESSFUL$;
import org.apache.spark.sql.pipelines.graph.TriggeredGraphExecution$StreamState$TERMINATED_WITH_ERROR$;
import org.apache.spark.sql.pipelines.graph.UncaughtExceptionHandler$;
import org.apache.spark.sql.pipelines.graph.UnexpectedRunFailure;
import org.apache.spark.sql.pipelines.logging.FlowProgressEventLogger;
import org.apache.spark.sql.pipelines.util.ExponentialBackoffStrategy;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.concurrent.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.LinkedHashSet;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r\rgaBA\u0005\u0003\u0017\u0001\u0011Q\u0005\u0005\r\u0003_\u0001!\u0011!Q\u0001\n\u0005E\u0012q\u0007\u0005\u000b\u0003s\u0001!\u0011!Q\u0001\n\u0005m\u0002BCA!\u0001\t\u0005\t\u0015!\u0003\u0002D!Q\u00111\f\u0001\u0003\u0002\u0003\u0006I!!\u0018\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!Y\u0011q\u000f\u0001C\u0002\u0013\u0005\u0011qBA=\u0011!\u0019)\u0001\u0001Q\u0001\n\u0005m\u0004\"CB\u0004\u0001\t\u0007I\u0011BB\u0005\u0011!\u0019\u0019\u0002\u0001Q\u0001\n\r-\u0001\"CB\u000b\u0001\t\u0007I\u0011BB\f\u0011!\u0019\u0019\u0003\u0001Q\u0001\n\re\u0001bBB\u0013\u0001\u0011\u00053q\u0005\u0005\n\u0007\u007f\u0001\u0001\u0019!C\u0005\u0007\u0003B\u0011ba\u0014\u0001\u0001\u0004%Ia!\u0015\t\u0011\rU\u0003\u0001)Q\u0005\u0007\u0007Bqaa\u0016\u0001\t\u0013\u0019I\u0006C\u0004\u0004\\\u0001!\te!\u0018\t\u0013\r}\u0003A1A\u0005\n\r\u0005\u0004\u0002CB8\u0001\u0001\u0006Iaa\u0019\t\u000f\rE\u0004\u0001\"\u0003\u0004^!911\u000f\u0001\u0005\n\rU\u0004bBB>\u0001\u0011%1Q\u0010\u0005\b\u0007\u0017\u0003A\u0011BBG\u0011\u001d\u0019\t\n\u0001C\u0005\u0007'Cqaa'\u0001\t\u0013\u0019i\nC\u0004\u0004 \u0002!Ia!)\t\u000f\r-\u0006\u0001\"\u0003\u0004.\"911\u0017\u0001\u0005B\ru\u0003bBB[\u0001\u0011\u00053Q\f\u0005\b\u0007o\u0003A\u0011IB]\u00119\u0019Y\f\u0001I\u0001\u0004\u0003\u0005I\u0011BB/\u0007{Caba0\u0001!\u0003\r\t\u0011!C\u0005\u0007\u0003\f9d\u0002\u0005\u0002:\u0006-\u0001\u0012AA^\r!\tI!a\u0003\t\u0002\u0005u\u0006bBA5E\u0011\u0005\u0011Q\u0019\u0004\n\u0003\u000f\u0014\u0003\u0013aI\u0011\u0003\u0013<qAa4#\u0011\u0003\t\u0019NB\u0004\u0002H\nB\t!a4\t\u000f\u0005%d\u0005\"\u0001\u0002R\u001e9\u0011q\u001b\u0014\t\u0002\u0006egaBAoM!\u0005\u0015q\u001c\u0005\b\u0003SJC\u0011AA~\u0011%\ti0KA\u0001\n\u0003\ny\u0010C\u0005\u0003\u0012%\n\t\u0011\"\u0001\u0003\u0014!I!1D\u0015\u0002\u0002\u0013\u0005!Q\u0004\u0005\n\u0005SI\u0013\u0011!C!\u0005WA\u0011B!\u000e*\u0003\u0003%\tAa\u000e\t\u0013\t\u0005\u0013&!A\u0005B\t\r\u0003\"\u0003B#S\u0005\u0005I\u0011\tB$\u0011%\u0011I%KA\u0001\n\u0013\u0011YeB\u0004\u0003T\u0019B\tI!\u0016\u0007\u000f\t]c\u0005#!\u0003Z!9\u0011\u0011\u000e\u001b\u0005\u0002\tm\u0003\"CA\u007fi\u0005\u0005I\u0011IA\u0000\u0011%\u0011\t\u0002NA\u0001\n\u0003\u0011\u0019\u0002C\u0005\u0003\u001cQ\n\t\u0011\"\u0001\u0003^!I!\u0011\u0006\u001b\u0002\u0002\u0013\u0005#1\u0006\u0005\n\u0005k!\u0014\u0011!C\u0001\u0005CB\u0011B!\u00115\u0003\u0003%\tEa\u0011\t\u0013\t\u0015C'!A\u0005B\t\u001d\u0003\"\u0003B%i\u0005\u0005I\u0011\u0002B&\u000f\u001d\u0011)G\nEA\u0005O2qA!\u001b'\u0011\u0003\u0013Y\u0007C\u0004\u0002j}\"\tA!\u001c\t\u0013\u0005ux(!A\u0005B\u0005}\b\"\u0003B\t\u007f\u0005\u0005I\u0011\u0001B\n\u0011%\u0011YbPA\u0001\n\u0003\u0011y\u0007C\u0005\u0003*}\n\t\u0011\"\u0011\u0003,!I!QG \u0002\u0002\u0013\u0005!1\u000f\u0005\n\u0005\u0003z\u0014\u0011!C!\u0005\u0007B\u0011B!\u0012@\u0003\u0003%\tEa\u0012\t\u0013\t%s(!A\u0005\n\t-sa\u0002B<M!\u0005%\u0011\u0010\u0004\b\u0005w2\u0003\u0012\u0011B?\u0011\u001d\tIG\u0013C\u0001\u0005\u007fB\u0011\"!@K\u0003\u0003%\t%a@\t\u0013\tE!*!A\u0005\u0002\tM\u0001\"\u0003B\u000e\u0015\u0006\u0005I\u0011\u0001BA\u0011%\u0011ICSA\u0001\n\u0003\u0012Y\u0003C\u0005\u00036)\u000b\t\u0011\"\u0001\u0003\u0006\"I!\u0011\t&\u0002\u0002\u0013\u0005#1\t\u0005\n\u0005\u000bR\u0015\u0011!C!\u0005\u000fB\u0011B!\u0013K\u0003\u0003%IAa\u0013\b\u000f\t%e\u0005#!\u0003\f\u001a9!Q\u0012\u0014\t\u0002\n=\u0005bBA5+\u0012\u0005!\u0011\u0013\u0005\n\u0003{,\u0016\u0011!C!\u0003\u007fD\u0011B!\u0005V\u0003\u0003%\tAa\u0005\t\u0013\tmQ+!A\u0005\u0002\tM\u0005\"\u0003B\u0015+\u0006\u0005I\u0011\tB\u0016\u0011%\u0011)$VA\u0001\n\u0003\u00119\nC\u0005\u0003BU\u000b\t\u0011\"\u0011\u0003D!I!QI+\u0002\u0002\u0013\u0005#q\t\u0005\n\u0005\u0013*\u0016\u0011!C\u0005\u0005\u0017:qAa''\u0011\u0003\u0013iJB\u0004\u0003 \u001aB\tI!)\t\u000f\u0005%\u0004\r\"\u0001\u0003$\"I\u0011Q 1\u0002\u0002\u0013\u0005\u0013q \u0005\n\u0005#\u0001\u0017\u0011!C\u0001\u0005'A\u0011Ba\u0007a\u0003\u0003%\tA!*\t\u0013\t%\u0002-!A\u0005B\t-\u0002\"\u0003B\u001bA\u0006\u0005I\u0011\u0001BU\u0011%\u0011\t\u0005YA\u0001\n\u0003\u0012\u0019\u0005C\u0005\u0003F\u0001\f\t\u0011\"\u0011\u0003H!I!\u0011\n1\u0002\u0002\u0013%!1J\u0004\b\u0005[3\u0003\u0012\u0011BX\r\u001d\tiM\nEA\u0005\u0007Dq!!\u001bl\t\u0003\u0011)\rC\u0005\u0002~.\f\t\u0011\"\u0011\u0002\u0000\"I!\u0011C6\u0002\u0002\u0013\u0005!1\u0003\u0005\n\u00057Y\u0017\u0011!C\u0001\u0005\u000fD\u0011B!\u000bl\u0003\u0003%\tEa\u000b\t\u0013\tU2.!A\u0005\u0002\t-\u0007\"\u0003B!W\u0006\u0005I\u0011\tB\"\u0011%\u0011)e[A\u0001\n\u0003\u00129\u0005C\u0005\u0003J-\f\t\u0011\"\u0003\u0003L\u001d9!\u0011\u0017\u0014\t\u0002\nMfa\u0002B[M!\u0005%q\u0017\u0005\b\u0003S2H\u0011\u0001B]\u0011%\tiP^A\u0001\n\u0003\ny\u0010C\u0005\u0003\u0012Y\f\t\u0011\"\u0001\u0003\u0014!I!1\u0004<\u0002\u0002\u0013\u0005!1\u0018\u0005\n\u0005S1\u0018\u0011!C!\u0005WA\u0011B!\u000ew\u0003\u0003%\tAa0\t\u0013\t\u0005c/!A\u0005B\t\r\u0003\"\u0003B#m\u0006\u0005I\u0011\tB$\u0011%\u0011IE^A\u0001\n\u0013\u0011Y\u0005C\u0005\u0003R\n\u0012\r\u0011\"\u0003\u0003T\"A!Q\u001d\u0012!\u0002\u0013\u0011)\u000eC\u0005\u0003h\n\n\n\u0011\"\u0001\u0003j\"I!q \u0012\u0012\u0002\u0013\u00051\u0011\u0001\u0002\u0018)JLwmZ3sK\u0012<%/\u00199i\u000bb,7-\u001e;j_:TA!!\u0004\u0002\u0010\u0005)qM]1qQ*!\u0011\u0011CA\n\u0003%\u0001\u0018\u000e]3mS:,7O\u0003\u0003\u0002\u0016\u0005]\u0011aA:rY*!\u0011\u0011DA\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\u0011\ti\"a\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\t#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0003O\u0001B!!\u000b\u0002,5\u0011\u00111B\u0005\u0005\u0003[\tYA\u0001\bHe\u0006\u0004\b.\u0012=fGV$\u0018n\u001c8\u0002#\u001d\u0014\u0018\r\u001d5G_J,\u00050Z2vi&|g\u000e\u0005\u0003\u0002*\u0005M\u0012\u0002BA\u001b\u0003\u0017\u0011Q\u0002R1uC\u001adwn^$sCBD\u0017\u0002BA\u0018\u0003W\t1!\u001a8w!\u0011\tI#!\u0010\n\t\u0005}\u00121\u0002\u0002\u0016!&\u0004X\r\\5oKV\u0003H-\u0019;f\u0007>tG/\u001a=u\u00031ygnQ8na2,G/[8o!!\t)%a\u0013\u0002P\u0005USBAA$\u0015\t\tI%A\u0003tG\u0006d\u0017-\u0003\u0003\u0002N\u0005\u001d#!\u0003$v]\u000e$\u0018n\u001c82!\u0011\tI#!\u0015\n\t\u0005M\u00131\u0002\u0002\u0015%VtG+\u001a:nS:\fG/[8o%\u0016\f7o\u001c8\u0011\t\u0005\u0015\u0013qK\u0005\u0005\u00033\n9E\u0001\u0003V]&$\u0018!B2m_\u000e\\\u0007\u0003BA0\u0003Kj!!!\u0019\u000b\t\u0005\r\u0014qC\u0001\u0005kRLG.\u0003\u0003\u0002h\u0005\u0005$!B\"m_\u000e\\\u0017A\u0002\u001fj]&$h\b\u0006\u0006\u0002n\u0005=\u0014\u0011OA:\u0003k\u00022!!\u000b\u0001\u0011\u001d\ty#\u0002a\u0001\u0003cAq!!\u000f\u0006\u0001\u0004\tY\u0004C\u0005\u0002B\u0015\u0001\n\u00111\u0001\u0002D!I\u00111L\u0003\u0011\u0002\u0003\u0007\u0011QL\u0001\u000ea&\u0004X\r\\5oKN#\u0018\r^3\u0016\u0005\u0005m\u0004\u0003CA?\u0003\u000f\u000bY)a&\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b!bY8oGV\u0014(/\u001a8u\u0015\u0011\t))a\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\n\u0006}$aA'baB!\u0011QRAJ\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005U\u0015q\u0012\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5feB\u0019\u0011\u0011\u0014\u0013\u000f\u0007\u0005m\u0015E\u0004\u0003\u0002\u001e\u0006]f\u0002BAP\u0003ksA!!)\u00024:!\u00111UAY\u001d\u0011\t)+a,\u000f\t\u0005\u001d\u0016QV\u0007\u0003\u0003SSA!a+\u0002$\u00051AH]8pizJ!!!\t\n\t\u0005u\u0011qD\u0005\u0005\u00033\tY\"\u0003\u0003\u0002\u0016\u0005]\u0011\u0002BA\t\u0003'IA!!\u0004\u0002\u0010\u00059BK]5hO\u0016\u0014X\rZ$sCBDW\t_3dkRLwN\u001c\t\u0004\u0003S\u00113c\u0001\u0012\u0002@B!\u0011QIAa\u0013\u0011\t\u0019-a\u0012\u0003\r\u0005s\u0017PU3g)\t\tYLA\u0006TiJ,\u0017-\\*uCR,7c\u0001\u0013\u0002@&JAe[ KSQ*f\u000f\u0019\u0002\t\u0007\u0006s5)\u0012'F\tN\u0019a%a0\u0015\u0005\u0005M\u0007cAAkM5\t!%\u0001\u0004R+\u0016+V\t\u0012\t\u0004\u00037LS\"\u0001\u0014\u0003\rE+V)V#E'%I\u0013qXAq\u0003G\fI\u000fE\u0002\u0002V\u0012\u0002B!!\u0012\u0002f&!\u0011q]A$\u0005\u001d\u0001&o\u001c3vGR\u0004B!a;\u0002v:!\u0011Q^Ay\u001d\u0011\t9+a<\n\u0005\u0005%\u0013\u0002BAz\u0003\u000f\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002x\u0006e(\u0001D*fe&\fG.\u001b>bE2,'\u0002BAz\u0003\u000f\"\"!!7\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011\t\u0001\u0005\u0003\u0003\u0004\t5QB\u0001B\u0003\u0015\u0011\u00119A!\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0005\u0017\tAA[1wC&!!q\u0002B\u0003\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!Q\u0003\t\u0005\u0003\u000b\u00129\"\u0003\u0003\u0003\u001a\u0005\u001d#aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u0010\u0005K\u0001B!!\u0012\u0003\"%!!1EA$\u0005\r\te.\u001f\u0005\n\u0005Oi\u0013\u0011!a\u0001\u0005+\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0017!\u0019\u0011yC!\r\u0003 5\u0011\u00111Q\u0005\u0005\u0005g\t\u0019I\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u001d\u0005\u007f\u0001B!!\u0012\u0003<%!!QHA$\u0005\u001d\u0011un\u001c7fC:D\u0011Ba\n0\u0003\u0003\u0005\rAa\b\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!\u0006\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\u0001\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t5\u0003\u0003\u0002B\u0002\u0005\u001fJAA!\u0015\u0003\u0006\t1qJ\u00196fGR\fqAU+O\u001d&su\tE\u0002\u0002\\R\u0012qAU+O\u001d&suiE\u00055\u0003\u007f\u000b\t/a9\u0002jR\u0011!Q\u000b\u000b\u0005\u0005?\u0011y\u0006C\u0005\u0003(a\n\t\u00111\u0001\u0003\u0016Q!!\u0011\bB2\u0011%\u00119COA\u0001\u0002\u0004\u0011y\"\u0001\u0005F1\u000ecU\u000bR#E!\r\tYn\u0010\u0002\t\u000bb\u001bE*\u0016#F\tNIq(a0\u0002b\u0006\r\u0018\u0011\u001e\u000b\u0003\u0005O\"BAa\b\u0003r!I!qE\"\u0002\u0002\u0003\u0007!Q\u0003\u000b\u0005\u0005s\u0011)\bC\u0005\u0003(\u0015\u000b\t\u00111\u0001\u0003 \u0005!\u0011\n\u0012'F!\r\tYN\u0013\u0002\u0005\u0013\u0012cUiE\u0005K\u0003\u007f\u000b\t/a9\u0002jR\u0011!\u0011\u0010\u000b\u0005\u0005?\u0011\u0019\tC\u0005\u0003(9\u000b\t\u00111\u0001\u0003\u0016Q!!\u0011\bBD\u0011%\u00119\u0003UA\u0001\u0002\u0004\u0011y\"A\u0004T\u0017&\u0003\u0006+\u0012#\u0011\u0007\u0005mWKA\u0004T\u0017&\u0003\u0006+\u0012#\u0014\u0013U\u000by,!9\u0002d\u0006%HC\u0001BF)\u0011\u0011yB!&\t\u0013\t\u001d\u0012,!AA\u0002\tUA\u0003\u0002B\u001d\u00053C\u0011Ba\n\\\u0003\u0003\u0005\rAa\b\u0002+Q+%+T%O\u0003R+EiX,J)\"{VI\u0015*P%B\u0019\u00111\u001c1\u0003+Q+%+T%O\u0003R+EiX,J)\"{VI\u0015*P%NI\u0001-a0\u0002b\u0006\r\u0018\u0011\u001e\u000b\u0003\u0005;#BAa\b\u0003(\"I!q\u00053\u0002\u0002\u0003\u0007!Q\u0003\u000b\u0005\u0005s\u0011Y\u000bC\u0005\u0003(\u0019\f\t\u00111\u0001\u0003 \u0005A1)\u0011(D\u000b2+E\tE\u0002\u0002\\.\f!bU+D\u0007\u0016\u001b6KR+M!\r\tYN\u001e\u0002\u000b'V\u001b5)R*T\rVc5#\u0003<\u0002@\u0006\u0005\u00181]Au)\t\u0011\u0019\f\u0006\u0003\u0003 \tu\u0006\"\u0003B\u0014u\u0006\u0005\t\u0019\u0001B\u000b)\u0011\u0011ID!1\t\u0013\t\u001dB0!AA\u0002\t}1#C6\u0002@\u0006\u0005\u00181]Au)\t\u0011y\u000b\u0006\u0003\u0003 \t%\u0007\"\u0003B\u0014_\u0006\u0005\t\u0019\u0001B\u000b)\u0011\u0011ID!4\t\u0013\t\u001d\u0012/!AA\u0002\t}\u0011aC*ue\u0016\fWn\u0015;bi\u0016\f!\u0005V#S\u001b&s\u0015\tT0O\u001f:{f)Q%M+J+ul\u0015+S\u000b\u0006kul\u0015+B)\u0016\u001bVC\u0001Bk!\u0019\u00119Na8\u0002b:!!\u0011\u001cBn!\u0011\t9+a\u0012\n\t\tu\u0017qI\u0001\u0007!J,G-\u001a4\n\t\t\u0005(1\u001d\u0002\u0004'\u0016$(\u0002\u0002Bo\u0003\u000f\n1\u0005V#S\u001b&s\u0015\tT0O\u001f:{f)Q%M+J+ul\u0015+S\u000b\u0006kul\u0015+B)\u0016\u001b\u0006%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0005WTC!a\u0011\u0003n.\u0012!q\u001e\t\u0005\u0005c\u0014Y0\u0004\u0002\u0003t*!!Q\u001fB|\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003z\u0006\u001d\u0013AC1o]>$\u0018\r^5p]&!!Q Bz\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r\r!\u0006BA/\u0005[\fa\u0002]5qK2Lg.Z*uCR,\u0007%\u0001\bgC&dWO]3Ue\u0006\u001c7.\u001a:\u0016\u0005\r-\u0001\u0003CA?\u0003\u000f\u000bYi!\u0004\u0011\t\u0005%2qB\u0005\u0005\u0007#\tYA\u0001\u000bUe&<w-\u001a:fI\u001a\u000b\u0017\u000e\\;sK&sgm\\\u0001\u0010M\u0006LG.\u001e:f)J\f7m[3sA\u0005y!-Y2l_\u001a47\u000b\u001e:bi\u0016<\u00170\u0006\u0002\u0004\u001aA!11DB\u0010\u001b\t\u0019iB\u0003\u0003\u0002d\u0005=\u0011\u0002BB\u0011\u0007;\u0011!$\u0012=q_:,g\u000e^5bY\n\u000b7m[8gMN#(/\u0019;fOf\f\u0001CY1dW>4gm\u0015;sCR,w-\u001f\u0011\u0002\u001bM$(/Z1n)JLwmZ3s)\u0011\u0019Ic!\u000e\u0011\t\r-2\u0011G\u0007\u0003\u0007[QAaa\f\u0002\u0014\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0005\u0007g\u0019iCA\u0004Ue&<w-\u001a:\t\u000f\r]B\u00021\u0001\u0004:\u0005!a\r\\8x!\u0011\tIca\u000f\n\t\ru\u00121\u0002\u0002\u0005\r2|w/\u0001\u000eu_B|Gn\\4jG\u0006dW\t_3dkRLwN\u001c+ie\u0016\fG-\u0006\u0002\u0004DA1\u0011QIB#\u0007\u0013JAaa\u0012\u0002H\t1q\n\u001d;j_:\u0004BAa\u0001\u0004L%!1Q\nB\u0003\u0005\u0019!\u0006N]3bI\u0006qBo\u001c9pY><\u0017nY1m\u000bb,7-\u001e;j_:$\u0006N]3bI~#S-\u001d\u000b\u0005\u0003+\u001a\u0019\u0006C\u0005\u0003(9\t\t\u00111\u0001\u0004D\u0005YBo\u001c9pY><\u0017nY1m\u000bb,7-\u001e;j_:$\u0006N]3bI\u0002\nqDY;jY\u0012$v\u000e]8m_\u001eL7-\u00197Fq\u0016\u001cW\u000f^5p]RC'/Z1e)\t\u0019I%A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002V\u0005\u00012m\u001c8dkJ\u0014XM\\2z\u0019&l\u0017\u000e^\u000b\u0003\u0007G\u0002Ba!\u001a\u0004l5\u00111q\r\u0006\u0005\u0003\u0003\u001bIG\u0003\u0003\u0002d\t%\u0011\u0002BB7\u0007O\u0012\u0011bU3nCBDwN]3\u0002#\r|gnY;se\u0016t7-\u001f'j[&$\b%\u0001\u000bu_B|Gn\\4jG\u0006dW\t_3dkRLwN\\\u0001\u000ee\u0016\u001cwN\u001d3Tk\u000e\u001cWm]:\u0015\t\u0005U3q\u000f\u0005\b\u0007s*\u0002\u0019AAF\u000391Gn\\<JI\u0016tG/\u001b4jKJ\fAB]3d_J$g)Y5mK\u0012$b!!\u0016\u0004\u0000\r\u0005\u0005bBB=-\u0001\u0007\u00111\u0012\u0005\b\u0007\u00073\u0002\u0019ABC\u0003\u0005)\u0007\u0003BAv\u0007\u000fKAa!#\u0002z\nIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u0018e\u0016\u001cwN\u001d3TW&\u0004\b/\u001a3JMN+G.Z2uK\u0012$B!!\u0016\u0004\u0010\"91\u0011P\fA\u0002\u0005-\u0015A\u00044m_^\u001cx+\u001b;i'R\fG/\u001a\u000b\u0005\u0007+\u001b9\n\u0005\u0004\u0003X\n}\u00171\u0012\u0005\b\u00073C\u0002\u0019AAL\u0003\u0015\u0019H/\u0019;f\u0003M1Gn\\<t#V,W/\u001a3G_J\u0014V\r\u001e:z)\t\u0019)*A\u0007oKb$(+\u001a;ssRKW.\u001a\u000b\u0005\u0007G\u001bI\u000b\u0005\u0003\u0002F\r\u0015\u0016\u0002BBT\u0003\u000f\u0012A\u0001T8oO\"91\u0011\u0010\u000eA\u0002\u0005-\u0015\u0001D:u_BLe\u000e^3s]\u0006dG\u0003BA+\u0007_Cqa!-\u001c\u0001\u0004\u0011I$\u0001\u0010ti>\u0004Hk\u001c9pY><\u0017nY1m\u000bb,7-\u001e;j_:$\u0006N]3bI\u0006y\u0011m^1ji\u000e{W\u000e\u001d7fi&|g.\u0001\u0003ti>\u0004\u0018aF4fiJ+h\u000eV3s[&t\u0017\r^5p]J+\u0017m]8o+\t\ty%\u0001\u0006tkB,'\u000fJ:u_BLAa!.\u0002,\u000592/\u001e9fe\u0012:'/\u00199i\r>\u0014X\t_3dkRLwN\\\u000b\u0003\u0003c\u0001")
public class TriggeredGraphExecution
extends GraphExecution {
    private final PipelineUpdateContext env;
    private final Function1<RunTerminationReason, BoxedUnit> onCompletion;
    private final Clock clock;
    private final Map<TableIdentifier, StreamState> pipelineState;
    private final Map<TableIdentifier, TriggeredFailureInfo> failureTracker;
    private final ExponentialBackoffStrategy backoffStrategy;
    private Option<Thread> topologicalExecutionThread;
    private final Semaphore concurrencyLimit;

    public static Clock $lessinit$greater$default$4() {
        return TriggeredGraphExecution$.MODULE$.$lessinit$greater$default$4();
    }

    public static Function1<RunTerminationReason, BoxedUnit> $lessinit$greater$default$3() {
        return TriggeredGraphExecution$.MODULE$.$lessinit$greater$default$3();
    }

    public /* synthetic */ void org$apache$spark$sql$pipelines$graph$TriggeredGraphExecution$$super$stop() {
        super.stop();
    }

    private /* synthetic */ DataflowGraph super$graphForExecution() {
        return super.graphForExecution();
    }

    public Map<TableIdentifier, StreamState> pipelineState() {
        return this.pipelineState;
    }

    private Map<TableIdentifier, TriggeredFailureInfo> failureTracker() {
        return this.failureTracker;
    }

    private ExponentialBackoffStrategy backoffStrategy() {
        return this.backoffStrategy;
    }

    @Override
    public Trigger streamTrigger(Flow flow) {
        return Trigger.AvailableNow();
    }

    private Option<Thread> topologicalExecutionThread() {
        return this.topologicalExecutionThread;
    }

    private void topologicalExecutionThread_$eq(Option<Thread> x$1) {
        this.topologicalExecutionThread = x$1;
    }

    private Thread buildTopologicalExecutionThread() {
        return new Thread(this){
            private final /* synthetic */ TriggeredGraphExecution $outer;

            public void run() {
                try {
                    this.$outer.org$apache$spark$sql$pipelines$graph$TriggeredGraphExecution$$topologicalExecution();
                }
                finally {
                    this.$outer.org$apache$spark$sql$pipelines$graph$TriggeredGraphExecution$$super$stop();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("Topological Execution");
            }
        };
    }

    @Override
    public void start() {
        super.start();
        this.env.refreshFlows().filter(super.graphForExecution().materializedFlows()).foreach((Function1 & Serializable)f -> {
            $this.env.flowProgressEventLogger().recordQueued((ResolvedFlow)f);
            return this.pipelineState().put((Object)f.identifier(), (Object)TriggeredGraphExecution$StreamState$QUEUED$.MODULE$);
        });
        this.env.refreshFlows().filterNot(super.graphForExecution().materializedFlows()).foreach((Function1 & Serializable)f -> {
            $this.env.flowProgressEventLogger().recordExcluded((ResolvedFlow)f);
            return this.pipelineState().put((Object)f.identifier(), (Object)TriggeredGraphExecution$StreamState$EXCLUDED$.MODULE$);
        });
        Thread thread = this.buildTopologicalExecutionThread();
        UncaughtExceptionHandler$.MODULE$.addHandler(thread, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable)x0$1 -> {
            TriggeredGraphExecution.$anonfun$start$3(this, x0$1);
            return BoxedUnit.UNIT;
        });
        thread.start();
        this.topologicalExecutionThread_$eq((Option<Thread>)Option$.MODULE$.apply((Object)thread));
    }

    private Semaphore concurrencyLimit() {
        return this.concurrencyLimit;
    }

    public void org$apache$spark$sql$pipelines$graph$TriggeredGraphExecution$$topologicalExecution() {
        LinkedHashSet runnableFlows = new LinkedHashSet();
        while (!Thread.interrupted() && !this.allFlowsDone$1()) {
            Tuple2.mcII.sp sp2;
            this.flowsWithState(TriggeredGraphExecution$StreamState$RUNNING$.MODULE$).foreach((Function1 & Serializable)flowIdentifier -> {
                TriggeredGraphExecution.$anonfun$topologicalExecution$1(this, flowIdentifier);
                return BoxedUnit.UNIT;
            });
            Semaphore semaphore = this.concurrencyLimit();
            synchronized (semaphore) {
                sp2 = new Tuple2.mcII.sp(this.flowsWithState(TriggeredGraphExecution$StreamState$RUNNING$.MODULE$).size(), this.concurrencyLimit().availablePermits());
            }
            Tuple2.mcII.sp sp3 = sp2;
            if (sp3 == null) {
                throw new MatchError((Object)sp3);
            }
            int runningFlows = sp3._1$mcI$sp();
            int availablePermits = sp3._2$mcI$sp();
            Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(runningFlows, availablePermits);
            int runningFlows2 = sp4._1$mcI$sp();
            int availablePermits2 = sp4._2$mcI$sp();
            if (runningFlows2 + availablePermits2 < this.env.spark().sessionState().conf().maxConcurrentFlows()) {
                String errorStr = "The max concurrency is " + this.env.spark().sessionState().conf().maxConcurrentFlows() + ", but there are only " + availablePermits2 + " permits available with " + runningFlows2 + " flows running. If this happens consistently, it's possible we're leaking permits.";
                this.logError((Function0<String>)(Function0 & Serializable)() -> errorStr);
                if (Utils$.MODULE$.isTesting()) {
                    throw new IllegalStateException(errorStr);
                }
            }
            Set queuedForRetry = (Set)this.flowsQueuedForRetry().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TriggeredGraphExecution.$anonfun$topologicalExecution$3(this, x$3)));
            runnableFlows.$plus$plus$eq((IterableOnce)queuedForRetry.$plus$plus(this.flowsWithState(TriggeredGraphExecution$StreamState$QUEUED$.MODULE$)).filter((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)TriggeredGraphExecution.$anonfun$topologicalExecution$4(this, id))));
            ArrayBuffer flowsToStart = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (runnableFlows.nonEmpty() && this.concurrencyLimit().tryAcquire()) {
                TableIdentifier flowIdentifier2 = (TableIdentifier)runnableFlows.head();
                runnableFlows.remove((Object)flowIdentifier2);
                flowsToStart.append(super.graphForExecution().resolvedFlow().apply((Object)flowIdentifier2));
            }
            flowsToStart.foreach((Function1 & Serializable)flow -> {
                this.startFlow$1(flow);
                return BoxedUnit.UNIT;
            });
            try {
                Thread.sleep(this.env.spark().sessionState().conf().streamStatePollingInterval() * 1000L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        if (this.allFlowsDone$1()) {
            this.onCompletion.apply((Object)this.getRunTerminationReason());
            return;
        }
    }

    private void recordSuccess(TableIdentifier flowIdentifier) {
        Semaphore semaphore = this.concurrencyLimit();
        synchronized (semaphore) {
            this.concurrencyLimit().release();
            this.pipelineState().put((Object)flowIdentifier, (Object)TriggeredGraphExecution$StreamState$SUCCESSFUL$.MODULE$);
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Flow ", " has COMPLETED "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FLOW_NAME$.MODULE$, (Object)flowIdentifier)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"in TriggeredFlowExecution."}))).log((Seq)Nil$.MODULE$))));
    }

    private void recordFailed(TableIdentifier flowIdentifier2, Throwable e) {
        this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Flow ", " failed"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FLOW_NAME$.MODULE$, (Object)flowIdentifier2)}))), e);
        Semaphore semaphore = this.concurrencyLimit();
        synchronized (semaphore) {
            this.concurrencyLimit().release();
            this.pipelineState().put((Object)flowIdentifier2, (Object)TriggeredGraphExecution$StreamState$TERMINATED_WITH_ERROR$.MODULE$);
        }
        int prevFailureCount = BoxesRunTime.unboxToInt((Object)this.failureTracker().get((Object)flowIdentifier2).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.numFailures())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        ResolvedFlow flow = (ResolvedFlow)super.graphForExecution().resolvedFlow().apply((Object)flowIdentifier2);
        this.failureTracker().put((Object)flowIdentifier2, (Object)new TriggeredFailureInfo(this.clock.getTimeMillis(), prevFailureCount + 1, e, GraphExecution$.MODULE$.determineFlowExecutionActionFromError((Function0<Throwable>)(Function0 & Serializable)() -> e, (Function0<String>)(Function0 & Serializable)() -> flow.displayName(), (Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> prevFailureCount + 1, (Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> this.maxRetryAttemptsForFlow(flowIdentifier2))));
        if (((ResolvedFlow)super.graphForExecution().resolvedFlow().apply((Object)flow.identifier())).df().isStreaming()) {
            PipelinesErrors$.MODULE$.checkStreamingErrorsAndRetry(e, this.env, this, flow, false, prevFailureCount, this.maxRetryAttemptsForFlow(flowIdentifier2), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                FlowProgressEventLogger qual$1 = $this.env.flowProgressEventLogger();
                ResolvedFlow x$1 = flow;
                Throwable x$2 = e;
                boolean x$3 = true;
                Option<String> x$4 = qual$1.recordFailed$default$4();
                qual$1.recordFailed(x$1, x$2, true, x$4);
            });
        }
        if (!this.flowsQueuedForRetry().contains((Object)flowIdentifier2)) {
            super.graphForExecution().downstreamFlows(flowIdentifier2).intersect(super.graphForExecution().materializedFlowIdentifiers()).foreach((Function1 & Serializable)flowIdentifier -> {
                this.recordSkippedIfSelected(flowIdentifier);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void recordSkippedIfSelected(TableIdentifier flowIdentifier) {
        Object object = this.pipelineState().apply((Object)flowIdentifier);
        TriggeredGraphExecution$StreamState$EXCLUDED$ triggeredGraphExecution$StreamState$EXCLUDED$ = TriggeredGraphExecution$StreamState$EXCLUDED$.MODULE$;
        if (object == null ? triggeredGraphExecution$StreamState$EXCLUDED$ != null : !object.equals(triggeredGraphExecution$StreamState$EXCLUDED$)) {
            ResolvedFlow flow = (ResolvedFlow)super.graphForExecution().resolvedFlow().apply((Object)flowIdentifier);
            this.pipelineState().put((Object)flowIdentifier, (Object)TriggeredGraphExecution$StreamState$SKIPPED$.MODULE$);
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Flow ", " SKIPPED due "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FLOW_NAME$.MODULE$, (Object)flowIdentifier)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to upstream failure(s)."}))).log((Seq)Nil$.MODULE$))));
            this.env.flowProgressEventLogger().recordSkippedOnUpStreamFailure(flow);
            return;
        }
    }

    private Set<TableIdentifier> flowsWithState(StreamState state) {
        return ((MapOps)this.pipelineState().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TriggeredGraphExecution.$anonfun$flowsWithState$1(state, x0$1)))).keySet().toSet();
    }

    private Set<TableIdentifier> flowsQueuedForRetry() {
        return (Set)this.flowsWithState(TriggeredGraphExecution$StreamState$TERMINATED_WITH_ERROR$.MODULE$).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TriggeredGraphExecution.$anonfun$flowsQueuedForRetry$1(this, x$5)));
    }

    private long nextRetryTime(TableIdentifier flowIdentifier) {
        return BoxesRunTime.unboxToLong((Object)this.failureTracker().get((Object)flowIdentifier).map((Function1 & Serializable)failureInfo -> BoxesRunTime.boxToLong((long)TriggeredGraphExecution.$anonfun$nextRetryTime$1(this, failureInfo))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    private void stopInternal(boolean stopTopologicalExecutionThread) {
        super.stop();
        if (stopTopologicalExecutionThread) {
            this.topologicalExecutionThread().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isAlive())).foreach((Function1 & Serializable)t -> {
                TriggeredGraphExecution.$anonfun$stopInternal$2(this, t);
                return BoxedUnit.UNIT;
            });
        }
        this.flowsWithState(TriggeredGraphExecution$StreamState$QUEUED$.MODULE$).foreach((Function1 & Serializable)flowIdentifier -> {
            this.recordSkippedIfSelected(flowIdentifier);
            return BoxedUnit.UNIT;
        });
        Seq flowsFailedToStop = (Seq)((IterableOps)((IterableOps)ThreadUtils$.MODULE$.parmap(this.flowsWithState(TriggeredGraphExecution$StreamState$RUNNING$.MODULE$).toSeq(), "stop-flow", 10, (Function1 & Serializable)flowName -> {
            this.pipelineState().put(flowName, (Object)TriggeredGraphExecution$StreamState$CANCELED$.MODULE$);
            return this.flowExecutions().get(flowName).map((Function1 & Serializable)f -> new Tuple2((Object)f.identifier(), (Object)Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.stopFlow((FlowExecution)f))));
        }).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.nonEmpty()))).filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TriggeredGraphExecution.$anonfun$stopInternal$8(x$8)))).map((Function1 & Serializable)x$9 -> (TableIdentifier)((Tuple2)x$9.get())._1());
        if (flowsFailedToStop.nonEmpty()) {
            throw new RunTerminationException(new FailureStoppingFlow((Seq<TableIdentifier>)flowsFailedToStop));
        }
    }

    @Override
    public void awaitCompletion() {
        this.topologicalExecutionThread().foreach((Function1 & Serializable)x$10 -> {
            x$10.join();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void stop() {
        this.stopInternal(true);
    }

    @Override
    public RunTerminationReason getRunTerminationReason() {
        boolean success = this.pipelineState().valuesIterator().forall((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)TriggeredGraphExecution.$anonfun$getRunTerminationReason$1(elem)));
        if (success) {
            return new RunCompletion();
        }
        Option executionFailureOpt = this.failureTracker().iterator().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TableIdentifier flowIdentifier = (TableIdentifier)tuple2._1();
                TriggeredFailureInfo failureInfo = (TriggeredFailureInfo)tuple2._2();
                return new Tuple3(this.super$graphForExecution().flow().apply((Object)flowIdentifier), (Object)failureInfo.lastException(), (Object)failureInfo.lastExceptionAction());
            }
            throw new MatchError((Object)tuple2);
        }).collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple3<Flow, Throwable, GraphExecution.FlowExecutionAction>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                GraphExecution.FlowExecutionAction flowExecutionAction;
                A1 A1 = x1;
                if (A1 != null && (flowExecutionAction = (GraphExecution.FlowExecutionAction)A1._3()) instanceof GraphExecution.StopFlowExecution) {
                    GraphExecution.StopFlowExecution stopFlowExecution = (GraphExecution.StopFlowExecution)flowExecutionAction;
                    GraphExecution.FlowExecutionStopReason reason = stopFlowExecution.reason();
                    return (B1)reason.runTerminationReason();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple3<Flow, Throwable, GraphExecution.FlowExecutionAction> x1) {
                GraphExecution.FlowExecutionAction flowExecutionAction;
                Tuple3<Flow, Throwable, GraphExecution.FlowExecutionAction> tuple3 = x1;
                return tuple3 != null && (flowExecutionAction = (GraphExecution.FlowExecutionAction)tuple3._3()) instanceof GraphExecution.StopFlowExecution;
            }
        });
        return (RunTerminationReason)executionFailureOpt.getOrElse((Function0 & Serializable)() -> new UnexpectedRunFailure());
    }

    public static final /* synthetic */ void $anonfun$start$3(TriggeredGraphExecution $this, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof InterruptedException) {
            return;
        }
        try {
            BoxedUnit boxedUnit;
            try {
                $this.stopInternal(false);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable ex) {
                $this.logError((Function0<String>)(Function0 & Serializable)() -> "Exception thrown while stopping the update...", ex);
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        finally {
            $this.onCompletion.apply((Object)new UnexpectedRunFailure());
        }
    }

    private final boolean allFlowsDone$1() {
        return this.flowsWithState(TriggeredGraphExecution$StreamState$QUEUED$.MODULE$).isEmpty() && this.flowsWithState(TriggeredGraphExecution$StreamState$RUNNING$.MODULE$).isEmpty() && this.flowsQueuedForRetry().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$topologicalExecution$1(TriggeredGraphExecution $this, TableIdentifier flowIdentifier) {
        FlowExecution flowExecution = (FlowExecution)$this.flowExecutions().apply((Object)flowIdentifier);
        if (!flowExecution.isCompleted()) {
            return;
        }
        if (flowExecution.isCompleted() && flowExecution.exception().isEmpty()) {
            $this.recordSuccess(flowIdentifier);
            return;
        }
        $this.recordFailed(flowIdentifier, (Throwable)flowExecution.exception().get());
    }

    public static final /* synthetic */ boolean $anonfun$topologicalExecution$3(TriggeredGraphExecution $this, TableIdentifier x$3) {
        return $this.nextRetryTime(x$3) <= $this.clock.getTimeMillis();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$topologicalExecution$5(TriggeredGraphExecution $this, TableIdentifier id) {
        Object object = $this.pipelineState().apply((Object)id);
        TriggeredGraphExecution$StreamState$SUCCESSFUL$ triggeredGraphExecution$StreamState$SUCCESSFUL$ = TriggeredGraphExecution$StreamState$SUCCESSFUL$.MODULE$;
        if (object == null) {
            if (triggeredGraphExecution$StreamState$SUCCESSFUL$ == null) return true;
        } else if (object.equals(triggeredGraphExecution$StreamState$SUCCESSFUL$)) return true;
        Object object2 = $this.pipelineState().apply((Object)id);
        TriggeredGraphExecution$StreamState$EXCLUDED$ triggeredGraphExecution$StreamState$EXCLUDED$ = TriggeredGraphExecution$StreamState$EXCLUDED$.MODULE$;
        if (object2 == null) {
            if (triggeredGraphExecution$StreamState$EXCLUDED$ == null) return true;
        } else if (object2.equals(triggeredGraphExecution$StreamState$EXCLUDED$)) return true;
        Object object3 = $this.pipelineState().apply((Object)id);
        TriggeredGraphExecution$StreamState$IDLE$ triggeredGraphExecution$StreamState$IDLE$ = TriggeredGraphExecution$StreamState$IDLE$.MODULE$;
        if (object3 != null) {
            if (!object3.equals(triggeredGraphExecution$StreamState$IDLE$)) return false;
            return true;
        }
        if (triggeredGraphExecution$StreamState$IDLE$ == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$topologicalExecution$4(TriggeredGraphExecution $this, TableIdentifier id2) {
        return $this.super$graphForExecution().upstreamFlows(id2).intersect($this.super$graphForExecution().materializedFlowIdentifiers()).forall((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)TriggeredGraphExecution.$anonfun$topologicalExecution$5($this, id)));
    }

    private final void startFlow$1(ResolvedFlow flow) {
        TableIdentifier flowIdentifier = flow.identifier();
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting flow ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FLOW_NAME$.MODULE$, (Object)flow.identifier())}))));
        this.env.flowProgressEventLogger().recordPlanningForBatchFlow(flow);
        try {
            Option<FlowExecution> flowStarted = this.planAndStartFlow(flow);
            if (flowStarted.nonEmpty()) {
                this.pipelineState().put((Object)flowIdentifier, (Object)TriggeredGraphExecution$StreamState$RUNNING$.MODULE$);
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Flow ", " started."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.FLOW_NAME$.MODULE$, (Object)flowIdentifier)}))));
            } else if (flow.once()) {
                this.env.flowProgressEventLogger().recordIdle(flow);
                this.pipelineState().put((Object)flowIdentifier, (Object)TriggeredGraphExecution$StreamState$IDLE$.MODULE$);
                this.concurrencyLimit().release();
            } else {
                this.env.flowProgressEventLogger().recordSkipped(flow);
                this.concurrencyLimit().release();
                this.pipelineState().put((Object)flowIdentifier, (Object)TriggeredGraphExecution$StreamState$SKIPPED$.MODULE$);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.recordFailed(flowIdentifier, throwable2);
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ boolean $anonfun$flowsWithState$1(StreamState state$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StreamState flowState;
            StreamState streamState = flowState = (StreamState)tuple2._2();
            StreamState streamState2 = state$1;
            return !(streamState != null ? !streamState.equals(streamState2) : streamState2 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$flowsQueuedForRetry$1(TriggeredGraphExecution $this, TableIdentifier x$5) {
        return !((TriggeredFailureInfo)$this.failureTracker().apply((Object)x$5)).nonRetryable();
    }

    public static final /* synthetic */ long $anonfun$nextRetryTime$1(TriggeredGraphExecution $this, TriggeredFailureInfo failureInfo) {
        return failureInfo.lastFailTimestamp() + $this.backoffStrategy().waitDuration(failureInfo.numFailures()).toMillis();
    }

    public static final /* synthetic */ void $anonfun$stopInternal$2(TriggeredGraphExecution $this, Thread t) {
        t.interrupt();
        $this.stopThread(t);
    }

    public static final /* synthetic */ boolean $anonfun$stopInternal$8(Option x$8) {
        return ((Try)((Tuple2)x$8.get())._2()).isFailure();
    }

    public static final /* synthetic */ boolean $anonfun$getRunTerminationReason$1(StreamState elem) {
        return TriggeredGraphExecution$.MODULE$.org$apache$spark$sql$pipelines$graph$TriggeredGraphExecution$$TERMINAL_NON_FAILURE_STREAM_STATES().contains((Object)elem);
    }

    public TriggeredGraphExecution(DataflowGraph graphForExecution, PipelineUpdateContext env, Function1<RunTerminationReason, BoxedUnit> onCompletion, Clock clock) {
        this.env = env;
        this.onCompletion = onCompletion;
        this.clock = clock;
        super(graphForExecution, env);
        this.pipelineState = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.failureTracker = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.backoffStrategy = new ExponentialBackoffStrategy(new package.DurationLong(package$.MODULE$.DurationLong(env.spark().sessionState().conf().watchdogMaxRetryTimeInSeconds() * 1000L)).millis(), new package.DurationLong(package$.MODULE$.DurationLong(env.spark().sessionState().conf().watchdogMinRetryTimeInSeconds() * 1000L)).millis());
        this.topologicalExecutionThread = None$.MODULE$;
        this.concurrencyLimit = new Semaphore(env.spark().sessionState().conf().maxConcurrentFlows());
    }

    public static interface StreamState {
    }
}

