/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rdd;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.rdd.InputFileBlockHolder;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Predef$;

public final class InputFileBlockHolder$ {
    public static final InputFileBlockHolder$ MODULE$ = new InputFileBlockHolder$();
    private static final InheritableThreadLocal<AtomicReference<InputFileBlockHolder.FileBlock>> inputBlock = new InheritableThreadLocal<AtomicReference<InputFileBlockHolder.FileBlock>>(){

        public AtomicReference<InputFileBlockHolder.FileBlock> initialValue() {
            return new AtomicReference<InputFileBlockHolder.FileBlock>(new InputFileBlockHolder.FileBlock());
        }
    };

    public void setThreadLocalValue(Object ref) {
        inputBlock.set((AtomicReference)ref);
    }

    public Object getThreadLocalValue() {
        return inputBlock.get();
    }

    public UTF8String getInputFilePath() {
        return ((InputFileBlockHolder.FileBlock)((AtomicReference)inputBlock.get()).get()).filePath();
    }

    public long getStartOffset() {
        return ((InputFileBlockHolder.FileBlock)((AtomicReference)inputBlock.get()).get()).startOffset();
    }

    public long getLength() {
        return ((InputFileBlockHolder.FileBlock)((AtomicReference)inputBlock.get()).get()).length();
    }

    public void set(String filePath, long startOffset, long length) {
        Predef$.MODULE$.require(filePath != null, (Function0 & Serializable)() -> "filePath cannot be null");
        Predef$.MODULE$.require(startOffset >= 0L, (Function0 & Serializable)() -> "startOffset (" + startOffset + ") cannot be negative");
        Predef$.MODULE$.require(length >= -1L, (Function0 & Serializable)() -> "length (" + length + ") cannot be smaller than -1");
        ((AtomicReference)inputBlock.get()).set(new InputFileBlockHolder.FileBlock(UTF8String.fromString((String)filePath), startOffset, length));
    }

    public void unset() {
        inputBlock.remove();
    }

    public void initialize() {
        inputBlock.get();
    }

    private InputFileBlockHolder$() {
    }
}

