/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringInstr$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.internal.types.StringTypeNonCSAICollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, substr) - Returns the (1-based) index of the first occurrence of `substr` in `str`.", examples="\n    Examples:\n      > SELECT _FUNC_('SparkSQL', 'SQL');\n       6\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001\u0002\u0012$\u0001BB\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0001\u000b\u0001BK\u0002\u0013\u00051\n\u0003\u0005R\u0001\tE\t\u0015!\u0003M\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u00159\u0006\u0001\"\u0011Y\u0011!a\u0006\u0001#b\u0001\n\u000bi\u0006\"B1\u0001\t\u0003Z\u0005\"\u00022\u0001\t\u0003Z\u0005\"B2\u0001\t\u0003\"\u0007\"B6\u0001\t\u0003b\u0007\"B:\u0001\t\u0003B\u0006\"\u0002;\u0001\t\u0003*\b\"B?\u0001\t\u0003r\bbBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u0003[\u0001A\u0011KA\u0018\u0011%\tI\u0004AA\u0001\n\u0003\tY\u0004C\u0005\u0002B\u0001\t\n\u0011\"\u0001\u0002D!I\u0011\u0011\f\u0001\u0012\u0002\u0013\u0005\u00111\t\u0005\n\u00037\u0002\u0011\u0011!C!\u0003;B\u0001\"!\u001c\u0001\u0003\u0003%\t!\u0018\u0005\n\u0003_\u0002\u0011\u0011!C\u0001\u0003cB\u0011\"a\u001e\u0001\u0003\u0003%\t%!\u001f\t\u0013\u0005\u001d\u0005!!A\u0005\u0002\u0005%\u0005\"CAG\u0001\u0005\u0005I\u0011IAH\u0011%\t\u0019\nAA\u0001\n\u0003\n)jB\u0005\u0002:\u000e\n\t\u0011#\u0001\u0002<\u001aA!eIA\u0001\u0012\u0003\ti\f\u0003\u0004S9\u0011\u0005\u0011Q\u001b\u0005\n\u0003/d\u0012\u0011!C#\u00033D\u0011\"a7\u001d\u0003\u0003%\t)!8\t\u0013\u0005\rH$!A\u0005\u0002\u0006\u0015\b\"CA|9\u0005\u0005I\u0011BA}\u0005-\u0019FO]5oO&s7\u000f\u001e:\u000b\u0005\u0011*\u0013aC3yaJ,7o]5p]NT!AJ\u0014\u0002\u0011\r\fG/\u00197zgRT!\u0001K\u0015\u0002\u0007M\fHN\u0003\u0002+W\u0005)1\u000f]1sW*\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u00196qy\u0002\"AM\u001a\u000e\u0003\rJ!\u0001N\u0012\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001a7\u0013\t94E\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u001d\u0001&o\u001c3vGR\u0004\"aP$\u000f\u0005\u0001+eBA!E\u001b\u0005\u0011%BA\"0\u0003\u0019a$o\\8u}%\t1(\u0003\u0002Gu\u00059\u0001/Y2lC\u001e,\u0017B\u0001%J\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t1%(A\u0002tiJ,\u0012\u0001\u0014\t\u0003e5K!AT\u0012\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0003tiJ\u0004\u0013AB:vEN$(/A\u0004tk\n\u001cHO\u001d\u0011\u0002\rqJg.\u001b;?)\r!VK\u0016\t\u0003e\u0001AQAS\u0003A\u00021CQ\u0001U\u0003A\u00021\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001Z!\tI$,\u0003\u0002\\u\t9!i\\8mK\u0006t\u0017aC2pY2\fG/[8o\u0013\u0012,\u0012A\u0018\t\u0003s}K!\u0001\u0019\u001e\u0003\u0007%sG/\u0001\u0003mK\u001a$\u0018!\u0002:jO\"$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\u0015\u0004\"AZ5\u000e\u0003\u001dT!\u0001[\u0014\u0002\u000bQL\b/Z:\n\u0005)<'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001n!\ryd\u000e]\u0005\u0003_&\u00131aU3r!\t1\u0017/\u0003\u0002sO\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u001bG>tG/\u001a=u\u0013:$W\r]3oI\u0016tGOR8mI\u0006\u0014G.Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004mf\\\bCA\u001dx\u0013\tA(HA\u0002B]fDQA_\u0007A\u0002Y\faa\u001d;sS:<\u0007\"\u0002?\u000e\u0001\u00041\u0018aA:vE\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003}\u0004B!!\u0001\u0002\n9!\u00111AA\u0003!\t\t%(C\u0002\u0002\bi\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0006\u0003\u001b\u0011aa\u0015;sS:<'bAA\u0004u\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003'\ty\"!\u000b\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007$\u0003\u001d\u0019w\u000eZ3hK:LA!!\b\u0002\u0018\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\"=\u0001\r!a\t\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\u0016\u0005\u0015\u0012\u0002BA\u0014\u0003/\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002,=\u0001\r!a\u0005\u0002\u0005\u00154\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015!\u0016\u0011GA\u001b\u0011\u0019\t\u0019\u0004\u0005a\u0001\u0019\u00069a.Z<MK\u001a$\bBBA\u001c!\u0001\u0007A*\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000bQ\u000bi$a\u0010\t\u000f)\u000b\u0002\u0013!a\u0001\u0019\"9\u0001+\u0005I\u0001\u0002\u0004a\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000bR3\u0001TA$W\t\tI\u0005\u0005\u0003\u0002L\u0005USBAA'\u0015\u0011\ty%!\u0015\u0002\u0013Ut7\r[3dW\u0016$'bAA*u\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0013Q\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005}\u0003\u0003BA1\u0003Wj!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\u0005Y\u0006twM\u0003\u0002\u0002j\u0005!!.\u0019<b\u0013\u0011\tY!a\u0019\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019a/a\u001d\t\u0011\u0005Ud#!AA\u0002y\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA>!\u0015\ti(a!w\u001b\t\tyHC\u0002\u0002\u0002j\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t))a \u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u00043\u0006-\u0005\u0002CA;1\u0005\u0005\t\u0019\u0001<\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003?\n\t\n\u0003\u0005\u0002ve\t\t\u00111\u0001_\u0003\u0019)\u0017/^1mgR\u0019\u0011,a&\t\u0011\u0005U$$!AA\u0002YD3\u0003AAN\u0003C\u000b\u0019+a*\u0002*\u00065\u0016qVAZ\u0003k\u00032AMAO\u0013\r\tyj\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t)+A0`\rVs5i\u0018\u0015tiJd\u0003e];cgR\u0014\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t\u00152[\t\f7/\u001a3*A%tG-\u001a=!_\u001a\u0004C\u000f[3!M&\u00148\u000f\u001e\u0011pG\u000e,(O]3oG\u0016\u0004sN\u001a\u0011agV\u00147\u000f\u001e:aA%t\u0007\u0005Y:ue\u0002t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005-\u0016\u0001\u0012\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003\u0018M]6T#2;C\u0006I\u0014T#2;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00117\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAY\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\t\t9,\u0001\u0007tiJLgnZ0gk:\u001c7/A\u0006TiJLgnZ%ogR\u0014\bC\u0001\u001a\u001d'\u0015a\u0012qXAf!\u001d\t\t-a2M\u0019Rk!!a1\u000b\u0007\u0005\u0015'(A\u0004sk:$\u0018.\\3\n\t\u0005%\u00171\u0019\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAg\u0003'l!!a4\u000b\t\u0005E\u0017qM\u0001\u0003S>L1\u0001SAh)\t\tY,\u0001\u0005u_N#(/\u001b8h)\t\ty&A\u0003baBd\u0017\u0010F\u0003U\u0003?\f\t\u000fC\u0003K?\u0001\u0007A\nC\u0003Q?\u0001\u0007A*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u001d\u00181\u001f\t\u0006s\u0005%\u0018Q^\u0005\u0004\u0003WT$AB(qi&|g\u000eE\u0003:\u0003_dE*C\u0002\u0002rj\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CA{A\u0005\u0005\t\u0019\u0001+\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002|B!\u0011\u0011MA\u007f\u0013\u0011\ty0a\u0019\u0003\r=\u0013'.Z2u\u0001")
public class StringInstr
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private int collationId;
    private final Expression str;
    private final Expression substr;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(StringInstr x$0) {
        return StringInstr$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, StringInstr> tupled() {
        return StringInstr$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, StringInstr>> curried() {
        return StringInstr$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression substr() {
        return this.substr;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    private int collationId$lzycompute() {
        StringInstr stringInstr = this;
        synchronized (stringInstr) {
            if (!this.bitmap$0) {
                this.collationId = ((StringType)this.left().dataType()).collationId();
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Expression left() {
        return this.str();
    }

    @Override
    public Expression right() {
        return this.substr();
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)Nil$.MODULE$));
    }

    @Override
    public boolean contextIndependentFoldable() {
        return super.contextIndependentFoldable();
    }

    @Override
    public Object nullSafeEval(Object string, Object sub) {
        return BoxesRunTime.boxToInteger((int)(CollationSupport.StringInstr.exec((UTF8String)((UTF8String)string), (UTF8String)((UTF8String)sub), (int)this.collationId()) + 1));
    }

    @Override
    public String prettyName() {
        return "instr";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(string, substring) -> CollationSupport.StringInstr.genCode((String)string, (String)substring, (int)this.collationId()) + " + 1");
    }

    @Override
    public StringInstr withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public StringInstr copy(Expression str, Expression substr) {
        return new StringInstr(str, substr);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.substr();
    }

    @Override
    public String productPrefix() {
        return "StringInstr";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.substr();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringInstr;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "str";
            }
            case 1: {
                return "substr";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringInstr)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringInstr stringInstr = (StringInstr)x$1;
        Expression expression = this.str();
        Expression expression2 = stringInstr.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.substr();
        Expression expression4 = stringInstr.substr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringInstr.canEqual(this)) return false;
        return true;
    }

    public StringInstr(Expression str, Expression substr) {
        this.str = str;
        this.substr = substr;
        ExpectsInputTypes.$init$(this);
    }
}

