// DO NOT EDIT.
// swift-format-ignore-file
// swiftlint:disable all
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: spark/connect/relations.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

//
// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import Foundation
import SwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: SwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: SwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

/// The main [[Relation]] type. Fundamentally, a relation is a typed container
/// that has exactly one explicit relation type set.
///
/// When adding new relation types, they have to be registered here.
struct Spark_Connect_Relation: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var common: Spark_Connect_RelationCommon {
    get {return _storage._common ?? Spark_Connect_RelationCommon()}
    set {_uniqueStorage()._common = newValue}
  }
  /// Returns true if `common` has been explicitly set.
  var hasCommon: Bool {return _storage._common != nil}
  /// Clears the value of `common`. Subsequent reads from it will return its default value.
  mutating func clearCommon() {_uniqueStorage()._common = nil}

  var relType: OneOf_RelType? {
    get {return _storage._relType}
    set {_uniqueStorage()._relType = newValue}
  }

  var read: Spark_Connect_Read {
    get {
      if case .read(let v)? = _storage._relType {return v}
      return Spark_Connect_Read()
    }
    set {_uniqueStorage()._relType = .read(newValue)}
  }

  var project: Spark_Connect_Project {
    get {
      if case .project(let v)? = _storage._relType {return v}
      return Spark_Connect_Project()
    }
    set {_uniqueStorage()._relType = .project(newValue)}
  }

  var filter: Spark_Connect_Filter {
    get {
      if case .filter(let v)? = _storage._relType {return v}
      return Spark_Connect_Filter()
    }
    set {_uniqueStorage()._relType = .filter(newValue)}
  }

  var join: Spark_Connect_Join {
    get {
      if case .join(let v)? = _storage._relType {return v}
      return Spark_Connect_Join()
    }
    set {_uniqueStorage()._relType = .join(newValue)}
  }

  var setOp: Spark_Connect_SetOperation {
    get {
      if case .setOp(let v)? = _storage._relType {return v}
      return Spark_Connect_SetOperation()
    }
    set {_uniqueStorage()._relType = .setOp(newValue)}
  }

  var sort: Spark_Connect_Sort {
    get {
      if case .sort(let v)? = _storage._relType {return v}
      return Spark_Connect_Sort()
    }
    set {_uniqueStorage()._relType = .sort(newValue)}
  }

  var limit: Spark_Connect_Limit {
    get {
      if case .limit(let v)? = _storage._relType {return v}
      return Spark_Connect_Limit()
    }
    set {_uniqueStorage()._relType = .limit(newValue)}
  }

  var aggregate: Spark_Connect_Aggregate {
    get {
      if case .aggregate(let v)? = _storage._relType {return v}
      return Spark_Connect_Aggregate()
    }
    set {_uniqueStorage()._relType = .aggregate(newValue)}
  }

  var sql: Spark_Connect_SQL {
    get {
      if case .sql(let v)? = _storage._relType {return v}
      return Spark_Connect_SQL()
    }
    set {_uniqueStorage()._relType = .sql(newValue)}
  }

  var localRelation: Spark_Connect_LocalRelation {
    get {
      if case .localRelation(let v)? = _storage._relType {return v}
      return Spark_Connect_LocalRelation()
    }
    set {_uniqueStorage()._relType = .localRelation(newValue)}
  }

  var sample: Spark_Connect_Sample {
    get {
      if case .sample(let v)? = _storage._relType {return v}
      return Spark_Connect_Sample()
    }
    set {_uniqueStorage()._relType = .sample(newValue)}
  }

  var offset: Spark_Connect_Offset {
    get {
      if case .offset(let v)? = _storage._relType {return v}
      return Spark_Connect_Offset()
    }
    set {_uniqueStorage()._relType = .offset(newValue)}
  }

  var deduplicate: Spark_Connect_Deduplicate {
    get {
      if case .deduplicate(let v)? = _storage._relType {return v}
      return Spark_Connect_Deduplicate()
    }
    set {_uniqueStorage()._relType = .deduplicate(newValue)}
  }

  var range: Spark_Connect_Range {
    get {
      if case .range(let v)? = _storage._relType {return v}
      return Spark_Connect_Range()
    }
    set {_uniqueStorage()._relType = .range(newValue)}
  }

  var subqueryAlias: Spark_Connect_SubqueryAlias {
    get {
      if case .subqueryAlias(let v)? = _storage._relType {return v}
      return Spark_Connect_SubqueryAlias()
    }
    set {_uniqueStorage()._relType = .subqueryAlias(newValue)}
  }

  var repartition: Spark_Connect_Repartition {
    get {
      if case .repartition(let v)? = _storage._relType {return v}
      return Spark_Connect_Repartition()
    }
    set {_uniqueStorage()._relType = .repartition(newValue)}
  }

  var toDf: Spark_Connect_ToDF {
    get {
      if case .toDf(let v)? = _storage._relType {return v}
      return Spark_Connect_ToDF()
    }
    set {_uniqueStorage()._relType = .toDf(newValue)}
  }

  var withColumnsRenamed: Spark_Connect_WithColumnsRenamed {
    get {
      if case .withColumnsRenamed(let v)? = _storage._relType {return v}
      return Spark_Connect_WithColumnsRenamed()
    }
    set {_uniqueStorage()._relType = .withColumnsRenamed(newValue)}
  }

  var showString: Spark_Connect_ShowString {
    get {
      if case .showString(let v)? = _storage._relType {return v}
      return Spark_Connect_ShowString()
    }
    set {_uniqueStorage()._relType = .showString(newValue)}
  }

  var drop: Spark_Connect_Drop {
    get {
      if case .drop(let v)? = _storage._relType {return v}
      return Spark_Connect_Drop()
    }
    set {_uniqueStorage()._relType = .drop(newValue)}
  }

  var tail: Spark_Connect_Tail {
    get {
      if case .tail(let v)? = _storage._relType {return v}
      return Spark_Connect_Tail()
    }
    set {_uniqueStorage()._relType = .tail(newValue)}
  }

  var withColumns: Spark_Connect_WithColumns {
    get {
      if case .withColumns(let v)? = _storage._relType {return v}
      return Spark_Connect_WithColumns()
    }
    set {_uniqueStorage()._relType = .withColumns(newValue)}
  }

  var hint: Spark_Connect_Hint {
    get {
      if case .hint(let v)? = _storage._relType {return v}
      return Spark_Connect_Hint()
    }
    set {_uniqueStorage()._relType = .hint(newValue)}
  }

  var unpivot: Spark_Connect_Unpivot {
    get {
      if case .unpivot(let v)? = _storage._relType {return v}
      return Spark_Connect_Unpivot()
    }
    set {_uniqueStorage()._relType = .unpivot(newValue)}
  }

  var toSchema: Spark_Connect_ToSchema {
    get {
      if case .toSchema(let v)? = _storage._relType {return v}
      return Spark_Connect_ToSchema()
    }
    set {_uniqueStorage()._relType = .toSchema(newValue)}
  }

  var repartitionByExpression: Spark_Connect_RepartitionByExpression {
    get {
      if case .repartitionByExpression(let v)? = _storage._relType {return v}
      return Spark_Connect_RepartitionByExpression()
    }
    set {_uniqueStorage()._relType = .repartitionByExpression(newValue)}
  }

  var mapPartitions: Spark_Connect_MapPartitions {
    get {
      if case .mapPartitions(let v)? = _storage._relType {return v}
      return Spark_Connect_MapPartitions()
    }
    set {_uniqueStorage()._relType = .mapPartitions(newValue)}
  }

  var collectMetrics: Spark_Connect_CollectMetrics {
    get {
      if case .collectMetrics(let v)? = _storage._relType {return v}
      return Spark_Connect_CollectMetrics()
    }
    set {_uniqueStorage()._relType = .collectMetrics(newValue)}
  }

  var parse: Spark_Connect_Parse {
    get {
      if case .parse(let v)? = _storage._relType {return v}
      return Spark_Connect_Parse()
    }
    set {_uniqueStorage()._relType = .parse(newValue)}
  }

  var groupMap: Spark_Connect_GroupMap {
    get {
      if case .groupMap(let v)? = _storage._relType {return v}
      return Spark_Connect_GroupMap()
    }
    set {_uniqueStorage()._relType = .groupMap(newValue)}
  }

  var coGroupMap: Spark_Connect_CoGroupMap {
    get {
      if case .coGroupMap(let v)? = _storage._relType {return v}
      return Spark_Connect_CoGroupMap()
    }
    set {_uniqueStorage()._relType = .coGroupMap(newValue)}
  }

  var withWatermark: Spark_Connect_WithWatermark {
    get {
      if case .withWatermark(let v)? = _storage._relType {return v}
      return Spark_Connect_WithWatermark()
    }
    set {_uniqueStorage()._relType = .withWatermark(newValue)}
  }

  var applyInPandasWithState: Spark_Connect_ApplyInPandasWithState {
    get {
      if case .applyInPandasWithState(let v)? = _storage._relType {return v}
      return Spark_Connect_ApplyInPandasWithState()
    }
    set {_uniqueStorage()._relType = .applyInPandasWithState(newValue)}
  }

  var htmlString: Spark_Connect_HtmlString {
    get {
      if case .htmlString(let v)? = _storage._relType {return v}
      return Spark_Connect_HtmlString()
    }
    set {_uniqueStorage()._relType = .htmlString(newValue)}
  }

  var cachedLocalRelation: Spark_Connect_CachedLocalRelation {
    get {
      if case .cachedLocalRelation(let v)? = _storage._relType {return v}
      return Spark_Connect_CachedLocalRelation()
    }
    set {_uniqueStorage()._relType = .cachedLocalRelation(newValue)}
  }

  var cachedRemoteRelation: Spark_Connect_CachedRemoteRelation {
    get {
      if case .cachedRemoteRelation(let v)? = _storage._relType {return v}
      return Spark_Connect_CachedRemoteRelation()
    }
    set {_uniqueStorage()._relType = .cachedRemoteRelation(newValue)}
  }

  var commonInlineUserDefinedTableFunction: Spark_Connect_CommonInlineUserDefinedTableFunction {
    get {
      if case .commonInlineUserDefinedTableFunction(let v)? = _storage._relType {return v}
      return Spark_Connect_CommonInlineUserDefinedTableFunction()
    }
    set {_uniqueStorage()._relType = .commonInlineUserDefinedTableFunction(newValue)}
  }

  var asOfJoin: Spark_Connect_AsOfJoin {
    get {
      if case .asOfJoin(let v)? = _storage._relType {return v}
      return Spark_Connect_AsOfJoin()
    }
    set {_uniqueStorage()._relType = .asOfJoin(newValue)}
  }

  var commonInlineUserDefinedDataSource: Spark_Connect_CommonInlineUserDefinedDataSource {
    get {
      if case .commonInlineUserDefinedDataSource(let v)? = _storage._relType {return v}
      return Spark_Connect_CommonInlineUserDefinedDataSource()
    }
    set {_uniqueStorage()._relType = .commonInlineUserDefinedDataSource(newValue)}
  }

  var withRelations: Spark_Connect_WithRelations {
    get {
      if case .withRelations(let v)? = _storage._relType {return v}
      return Spark_Connect_WithRelations()
    }
    set {_uniqueStorage()._relType = .withRelations(newValue)}
  }

  var transpose: Spark_Connect_Transpose {
    get {
      if case .transpose(let v)? = _storage._relType {return v}
      return Spark_Connect_Transpose()
    }
    set {_uniqueStorage()._relType = .transpose(newValue)}
  }

  var unresolvedTableValuedFunction: Spark_Connect_UnresolvedTableValuedFunction {
    get {
      if case .unresolvedTableValuedFunction(let v)? = _storage._relType {return v}
      return Spark_Connect_UnresolvedTableValuedFunction()
    }
    set {_uniqueStorage()._relType = .unresolvedTableValuedFunction(newValue)}
  }

  var lateralJoin: Spark_Connect_LateralJoin {
    get {
      if case .lateralJoin(let v)? = _storage._relType {return v}
      return Spark_Connect_LateralJoin()
    }
    set {_uniqueStorage()._relType = .lateralJoin(newValue)}
  }

  /// NA functions
  var fillNa: Spark_Connect_NAFill {
    get {
      if case .fillNa(let v)? = _storage._relType {return v}
      return Spark_Connect_NAFill()
    }
    set {_uniqueStorage()._relType = .fillNa(newValue)}
  }

  var dropNa: Spark_Connect_NADrop {
    get {
      if case .dropNa(let v)? = _storage._relType {return v}
      return Spark_Connect_NADrop()
    }
    set {_uniqueStorage()._relType = .dropNa(newValue)}
  }

  var replace: Spark_Connect_NAReplace {
    get {
      if case .replace(let v)? = _storage._relType {return v}
      return Spark_Connect_NAReplace()
    }
    set {_uniqueStorage()._relType = .replace(newValue)}
  }

  /// stat functions
  var summary: Spark_Connect_StatSummary {
    get {
      if case .summary(let v)? = _storage._relType {return v}
      return Spark_Connect_StatSummary()
    }
    set {_uniqueStorage()._relType = .summary(newValue)}
  }

  var crosstab: Spark_Connect_StatCrosstab {
    get {
      if case .crosstab(let v)? = _storage._relType {return v}
      return Spark_Connect_StatCrosstab()
    }
    set {_uniqueStorage()._relType = .crosstab(newValue)}
  }

  var describe: Spark_Connect_StatDescribe {
    get {
      if case .describe(let v)? = _storage._relType {return v}
      return Spark_Connect_StatDescribe()
    }
    set {_uniqueStorage()._relType = .describe(newValue)}
  }

  var cov: Spark_Connect_StatCov {
    get {
      if case .cov(let v)? = _storage._relType {return v}
      return Spark_Connect_StatCov()
    }
    set {_uniqueStorage()._relType = .cov(newValue)}
  }

  var corr: Spark_Connect_StatCorr {
    get {
      if case .corr(let v)? = _storage._relType {return v}
      return Spark_Connect_StatCorr()
    }
    set {_uniqueStorage()._relType = .corr(newValue)}
  }

  var approxQuantile: Spark_Connect_StatApproxQuantile {
    get {
      if case .approxQuantile(let v)? = _storage._relType {return v}
      return Spark_Connect_StatApproxQuantile()
    }
    set {_uniqueStorage()._relType = .approxQuantile(newValue)}
  }

  var freqItems: Spark_Connect_StatFreqItems {
    get {
      if case .freqItems(let v)? = _storage._relType {return v}
      return Spark_Connect_StatFreqItems()
    }
    set {_uniqueStorage()._relType = .freqItems(newValue)}
  }

  var sampleBy: Spark_Connect_StatSampleBy {
    get {
      if case .sampleBy(let v)? = _storage._relType {return v}
      return Spark_Connect_StatSampleBy()
    }
    set {_uniqueStorage()._relType = .sampleBy(newValue)}
  }

  /// Catalog API (experimental / unstable)
  var catalog: Spark_Connect_Catalog {
    get {
      if case .catalog(let v)? = _storage._relType {return v}
      return Spark_Connect_Catalog()
    }
    set {_uniqueStorage()._relType = .catalog(newValue)}
  }

  /// ML relation
  var mlRelation: Spark_Connect_MlRelation {
    get {
      if case .mlRelation(let v)? = _storage._relType {return v}
      return Spark_Connect_MlRelation()
    }
    set {_uniqueStorage()._relType = .mlRelation(newValue)}
  }

  /// This field is used to mark extensions to the protocol. When plugins generate arbitrary
  /// relations they can add them here. During the planning the correct resolution is done.
  var `extension`: SwiftProtobuf.Google_Protobuf_Any {
    get {
      if case .extension(let v)? = _storage._relType {return v}
      return SwiftProtobuf.Google_Protobuf_Any()
    }
    set {_uniqueStorage()._relType = .extension(newValue)}
  }

  var unknown: Spark_Connect_Unknown {
    get {
      if case .unknown(let v)? = _storage._relType {return v}
      return Spark_Connect_Unknown()
    }
    set {_uniqueStorage()._relType = .unknown(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_RelType: Equatable, Sendable {
    case read(Spark_Connect_Read)
    case project(Spark_Connect_Project)
    case filter(Spark_Connect_Filter)
    case join(Spark_Connect_Join)
    case setOp(Spark_Connect_SetOperation)
    case sort(Spark_Connect_Sort)
    case limit(Spark_Connect_Limit)
    case aggregate(Spark_Connect_Aggregate)
    case sql(Spark_Connect_SQL)
    case localRelation(Spark_Connect_LocalRelation)
    case sample(Spark_Connect_Sample)
    case offset(Spark_Connect_Offset)
    case deduplicate(Spark_Connect_Deduplicate)
    case range(Spark_Connect_Range)
    case subqueryAlias(Spark_Connect_SubqueryAlias)
    case repartition(Spark_Connect_Repartition)
    case toDf(Spark_Connect_ToDF)
    case withColumnsRenamed(Spark_Connect_WithColumnsRenamed)
    case showString(Spark_Connect_ShowString)
    case drop(Spark_Connect_Drop)
    case tail(Spark_Connect_Tail)
    case withColumns(Spark_Connect_WithColumns)
    case hint(Spark_Connect_Hint)
    case unpivot(Spark_Connect_Unpivot)
    case toSchema(Spark_Connect_ToSchema)
    case repartitionByExpression(Spark_Connect_RepartitionByExpression)
    case mapPartitions(Spark_Connect_MapPartitions)
    case collectMetrics(Spark_Connect_CollectMetrics)
    case parse(Spark_Connect_Parse)
    case groupMap(Spark_Connect_GroupMap)
    case coGroupMap(Spark_Connect_CoGroupMap)
    case withWatermark(Spark_Connect_WithWatermark)
    case applyInPandasWithState(Spark_Connect_ApplyInPandasWithState)
    case htmlString(Spark_Connect_HtmlString)
    case cachedLocalRelation(Spark_Connect_CachedLocalRelation)
    case cachedRemoteRelation(Spark_Connect_CachedRemoteRelation)
    case commonInlineUserDefinedTableFunction(Spark_Connect_CommonInlineUserDefinedTableFunction)
    case asOfJoin(Spark_Connect_AsOfJoin)
    case commonInlineUserDefinedDataSource(Spark_Connect_CommonInlineUserDefinedDataSource)
    case withRelations(Spark_Connect_WithRelations)
    case transpose(Spark_Connect_Transpose)
    case unresolvedTableValuedFunction(Spark_Connect_UnresolvedTableValuedFunction)
    case lateralJoin(Spark_Connect_LateralJoin)
    /// NA functions
    case fillNa(Spark_Connect_NAFill)
    case dropNa(Spark_Connect_NADrop)
    case replace(Spark_Connect_NAReplace)
    /// stat functions
    case summary(Spark_Connect_StatSummary)
    case crosstab(Spark_Connect_StatCrosstab)
    case describe(Spark_Connect_StatDescribe)
    case cov(Spark_Connect_StatCov)
    case corr(Spark_Connect_StatCorr)
    case approxQuantile(Spark_Connect_StatApproxQuantile)
    case freqItems(Spark_Connect_StatFreqItems)
    case sampleBy(Spark_Connect_StatSampleBy)
    /// Catalog API (experimental / unstable)
    case catalog(Spark_Connect_Catalog)
    /// ML relation
    case mlRelation(Spark_Connect_MlRelation)
    /// This field is used to mark extensions to the protocol. When plugins generate arbitrary
    /// relations they can add them here. During the planning the correct resolution is done.
    case `extension`(SwiftProtobuf.Google_Protobuf_Any)
    case unknown(Spark_Connect_Unknown)

  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Relation to represent ML world
struct Spark_Connect_MlRelation: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var mlType: OneOf_MlType? {
    get {return _storage._mlType}
    set {_uniqueStorage()._mlType = newValue}
  }

  var transform: Spark_Connect_MlRelation.Transform {
    get {
      if case .transform(let v)? = _storage._mlType {return v}
      return Spark_Connect_MlRelation.Transform()
    }
    set {_uniqueStorage()._mlType = .transform(newValue)}
  }

  var fetch: Spark_Connect_Fetch {
    get {
      if case .fetch(let v)? = _storage._mlType {return v}
      return Spark_Connect_Fetch()
    }
    set {_uniqueStorage()._mlType = .fetch(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_MlType: Equatable, Sendable {
    case transform(Spark_Connect_MlRelation.Transform)
    case fetch(Spark_Connect_Fetch)

  }

  /// Relation to represent transform(input) of the operator
  /// which could be a cached model or a new transformer
  struct Transform: @unchecked Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var `operator`: OneOf_Operator? {
      get {return _storage._operator}
      set {_uniqueStorage()._operator = newValue}
    }

    /// Object reference
    var objRef: Spark_Connect_ObjectRef {
      get {
        if case .objRef(let v)? = _storage._operator {return v}
        return Spark_Connect_ObjectRef()
      }
      set {_uniqueStorage()._operator = .objRef(newValue)}
    }

    /// Could be an ML transformer like VectorAssembler
    var transformer: Spark_Connect_MlOperator {
      get {
        if case .transformer(let v)? = _storage._operator {return v}
        return Spark_Connect_MlOperator()
      }
      set {_uniqueStorage()._operator = .transformer(newValue)}
    }

    /// the input dataframe
    var input: Spark_Connect_Relation {
      get {return _storage._input ?? Spark_Connect_Relation()}
      set {_uniqueStorage()._input = newValue}
    }
    /// Returns true if `input` has been explicitly set.
    var hasInput: Bool {return _storage._input != nil}
    /// Clears the value of `input`. Subsequent reads from it will return its default value.
    mutating func clearInput() {_uniqueStorage()._input = nil}

    /// the operator specific parameters
    var params: Spark_Connect_MlParams {
      get {return _storage._params ?? Spark_Connect_MlParams()}
      set {_uniqueStorage()._params = newValue}
    }
    /// Returns true if `params` has been explicitly set.
    var hasParams: Bool {return _storage._params != nil}
    /// Clears the value of `params`. Subsequent reads from it will return its default value.
    mutating func clearParams() {_uniqueStorage()._params = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    enum OneOf_Operator: Equatable, Sendable {
      /// Object reference
      case objRef(Spark_Connect_ObjectRef)
      /// Could be an ML transformer like VectorAssembler
      case transformer(Spark_Connect_MlOperator)

    }

    init() {}

    fileprivate var _storage = _StorageClass.defaultInstance
  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Message for fetching attribute from object on the server side.
/// Fetch can be represented as a Relation or a ML command
/// Command: model.coefficients, model.summary.weightedPrecision which
/// returns the final literal result
/// Relation: model.summary.roc which returns a DataFrame (Relation)
struct Spark_Connect_Fetch: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) reference to the object on the server side
  var objRef: Spark_Connect_ObjectRef {
    get {return _objRef ?? Spark_Connect_ObjectRef()}
    set {_objRef = newValue}
  }
  /// Returns true if `objRef` has been explicitly set.
  var hasObjRef: Bool {return self._objRef != nil}
  /// Clears the value of `objRef`. Subsequent reads from it will return its default value.
  mutating func clearObjRef() {self._objRef = nil}

  /// (Required) the calling method chains
  var methods: [Spark_Connect_Fetch.Method] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  /// Represents a method with inclusion of method name and its arguments
  struct Method: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) the method name
    var method: String = String()

    /// (Optional) the arguments of the method
    var args: [Spark_Connect_Fetch.Method.Args] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    struct Args: Sendable {
      // SwiftProtobuf.Message conformance is added in an extension below. See the
      // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
      // methods supported on all messages.

      var argsType: Spark_Connect_Fetch.Method.Args.OneOf_ArgsType? = nil

      var param: Spark_Connect_Expression.Literal {
        get {
          if case .param(let v)? = argsType {return v}
          return Spark_Connect_Expression.Literal()
        }
        set {argsType = .param(newValue)}
      }

      var input: Spark_Connect_Relation {
        get {
          if case .input(let v)? = argsType {return v}
          return Spark_Connect_Relation()
        }
        set {argsType = .input(newValue)}
      }

      var unknownFields = SwiftProtobuf.UnknownStorage()

      enum OneOf_ArgsType: Equatable, Sendable {
        case param(Spark_Connect_Expression.Literal)
        case input(Spark_Connect_Relation)

      }

      init() {}
    }

    init() {}
  }

  init() {}

  fileprivate var _objRef: Spark_Connect_ObjectRef? = nil
}

/// Used for testing purposes only.
struct Spark_Connect_Unknown: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// Common metadata of all relations.
struct Spark_Connect_RelationCommon: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Shared relation metadata.
  ///
  /// NOTE: This field was marked as deprecated in the .proto file.
  var sourceInfo: String = String()

  /// (Optional) A per-client globally unique id for a given connect plan.
  var planID: Int64 {
    get {return _planID ?? 0}
    set {_planID = newValue}
  }
  /// Returns true if `planID` has been explicitly set.
  var hasPlanID: Bool {return self._planID != nil}
  /// Clears the value of `planID`. Subsequent reads from it will return its default value.
  mutating func clearPlanID() {self._planID = nil}

  /// (Optional) Keep the information of the origin for this expression such as stacktrace.
  var origin: Spark_Connect_Origin {
    get {return _origin ?? Spark_Connect_Origin()}
    set {_origin = newValue}
  }
  /// Returns true if `origin` has been explicitly set.
  var hasOrigin: Bool {return self._origin != nil}
  /// Clears the value of `origin`. Subsequent reads from it will return its default value.
  mutating func clearOrigin() {self._origin = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _planID: Int64? = nil
  fileprivate var _origin: Spark_Connect_Origin? = nil
}

/// Relation that uses a SQL query to generate the output.
struct Spark_Connect_SQL: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The SQL query.
  var query: String = String()

  /// (Optional) A map of parameter names to literal expressions.
  ///
  /// NOTE: This field was marked as deprecated in the .proto file.
  var args: Dictionary<String,Spark_Connect_Expression.Literal> = [:]

  /// (Optional) A sequence of literal expressions for positional parameters in the SQL query text.
  ///
  /// NOTE: This field was marked as deprecated in the .proto file.
  var posArgs: [Spark_Connect_Expression.Literal] = []

  /// (Optional) A map of parameter names to expressions.
  /// It cannot coexist with `pos_arguments`.
  var namedArguments: Dictionary<String,Spark_Connect_Expression> = [:]

  /// (Optional) A sequence of expressions for positional parameters in the SQL query text.
  /// It cannot coexist with `named_arguments`.
  var posArguments: [Spark_Connect_Expression] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// Relation of type [[WithRelations]].
///
/// This relation contains a root plan, and one or more references that are used by the root plan.
/// There are two ways of referencing a relation, by name (through a subquery alias), or by plan_id
/// (using RelationCommon.plan_id).
///
/// This relation can be used to implement CTEs, describe DAGs, or to reduce tree depth.
struct Spark_Connect_WithRelations: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Plan at the root of the query tree. This plan is expected to contain one or more
  /// references. Those references get expanded later on by the engine.
  var root: Spark_Connect_Relation {
    get {return _storage._root ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._root = newValue}
  }
  /// Returns true if `root` has been explicitly set.
  var hasRoot: Bool {return _storage._root != nil}
  /// Clears the value of `root`. Subsequent reads from it will return its default value.
  mutating func clearRoot() {_uniqueStorage()._root = nil}

  /// (Required) Plans referenced by the root plan. Relations in this list are also allowed to
  /// contain references to other relations in this list, as long they do not form cycles.
  var references: [Spark_Connect_Relation] {
    get {return _storage._references}
    set {_uniqueStorage()._references = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Relation that reads from a file / table or other data source. Does not have additional
/// inputs.
struct Spark_Connect_Read: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var readType: Spark_Connect_Read.OneOf_ReadType? = nil

  var namedTable: Spark_Connect_Read.NamedTable {
    get {
      if case .namedTable(let v)? = readType {return v}
      return Spark_Connect_Read.NamedTable()
    }
    set {readType = .namedTable(newValue)}
  }

  var dataSource: Spark_Connect_Read.DataSource {
    get {
      if case .dataSource(let v)? = readType {return v}
      return Spark_Connect_Read.DataSource()
    }
    set {readType = .dataSource(newValue)}
  }

  /// (Optional) Indicates if this is a streaming read.
  var isStreaming: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_ReadType: Equatable, Sendable {
    case namedTable(Spark_Connect_Read.NamedTable)
    case dataSource(Spark_Connect_Read.DataSource)

  }

  struct NamedTable: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) Unparsed identifier for the table.
    var unparsedIdentifier: String = String()

    /// Options for the named table. The map key is case insensitive.
    var options: Dictionary<String,String> = [:]

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct DataSource: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Optional) Supported formats include: parquet, orc, text, json, parquet, csv, avro.
    ///
    /// If not set, the value from SQL conf 'spark.sql.sources.default' will be used.
    var format: String {
      get {return _format ?? String()}
      set {_format = newValue}
    }
    /// Returns true if `format` has been explicitly set.
    var hasFormat: Bool {return self._format != nil}
    /// Clears the value of `format`. Subsequent reads from it will return its default value.
    mutating func clearFormat() {self._format = nil}

    /// (Optional) If not set, Spark will infer the schema.
    ///
    /// This schema string should be either DDL-formatted or JSON-formatted.
    var schema: String {
      get {return _schema ?? String()}
      set {_schema = newValue}
    }
    /// Returns true if `schema` has been explicitly set.
    var hasSchema: Bool {return self._schema != nil}
    /// Clears the value of `schema`. Subsequent reads from it will return its default value.
    mutating func clearSchema() {self._schema = nil}

    /// Options for the data source. The context of this map varies based on the
    /// data source format. This options could be empty for valid data source format.
    /// The map key is case insensitive.
    var options: Dictionary<String,String> = [:]

    /// (Optional) A list of path for file-system backed data sources.
    var paths: [String] = []

    /// (Optional) Condition in the where clause for each partition.
    ///
    /// This is only supported by the JDBC data source.
    var predicates: [String] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _format: String? = nil
    fileprivate var _schema: String? = nil
  }

  init() {}
}

/// Projection of a bag of expressions for a given input relation.
///
/// The input relation must be specified.
/// The projected expression can be an arbitrary expression.
struct Spark_Connect_Project: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Optional) Input relation is optional for Project.
  ///
  /// For example, `SELECT ABS(-1)` is valid plan without an input plan.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) A Project requires at least one expression.
  var expressions: [Spark_Connect_Expression] {
    get {return _storage._expressions}
    set {_uniqueStorage()._expressions = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Relation that applies a boolean expression `condition` on each row of `input` to produce
/// the output result.
struct Spark_Connect_Filter: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Input relation for a Filter.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) A Filter must have a condition expression.
  var condition: Spark_Connect_Expression {
    get {return _storage._condition ?? Spark_Connect_Expression()}
    set {_uniqueStorage()._condition = newValue}
  }
  /// Returns true if `condition` has been explicitly set.
  var hasCondition: Bool {return _storage._condition != nil}
  /// Clears the value of `condition`. Subsequent reads from it will return its default value.
  mutating func clearCondition() {_uniqueStorage()._condition = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Relation of type [[Join]].
///
/// `left` and `right` must be present.
struct Spark_Connect_Join: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Left input relation for a Join.
  var left: Spark_Connect_Relation {
    get {return _storage._left ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._left = newValue}
  }
  /// Returns true if `left` has been explicitly set.
  var hasLeft: Bool {return _storage._left != nil}
  /// Clears the value of `left`. Subsequent reads from it will return its default value.
  mutating func clearLeft() {_uniqueStorage()._left = nil}

  /// (Required) Right input relation for a Join.
  var right: Spark_Connect_Relation {
    get {return _storage._right ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._right = newValue}
  }
  /// Returns true if `right` has been explicitly set.
  var hasRight: Bool {return _storage._right != nil}
  /// Clears the value of `right`. Subsequent reads from it will return its default value.
  mutating func clearRight() {_uniqueStorage()._right = nil}

  /// (Optional) The join condition. Could be unset when `using_columns` is utilized.
  ///
  /// This field does not co-exist with using_columns.
  var joinCondition: Spark_Connect_Expression {
    get {return _storage._joinCondition ?? Spark_Connect_Expression()}
    set {_uniqueStorage()._joinCondition = newValue}
  }
  /// Returns true if `joinCondition` has been explicitly set.
  var hasJoinCondition: Bool {return _storage._joinCondition != nil}
  /// Clears the value of `joinCondition`. Subsequent reads from it will return its default value.
  mutating func clearJoinCondition() {_uniqueStorage()._joinCondition = nil}

  /// (Required) The join type.
  var joinType: Spark_Connect_Join.JoinType {
    get {return _storage._joinType}
    set {_uniqueStorage()._joinType = newValue}
  }

  /// Optional. using_columns provides a list of columns that should present on both sides of
  /// the join inputs that this Join will join on. For example A JOIN B USING col_name is
  /// equivalent to A JOIN B on A.col_name = B.col_name.
  ///
  /// This field does not co-exist with join_condition.
  var usingColumns: [String] {
    get {return _storage._usingColumns}
    set {_uniqueStorage()._usingColumns = newValue}
  }

  /// (Optional) Only used by joinWith. Set the left and right join data types.
  var joinDataType: Spark_Connect_Join.JoinDataType {
    get {return _storage._joinDataType ?? Spark_Connect_Join.JoinDataType()}
    set {_uniqueStorage()._joinDataType = newValue}
  }
  /// Returns true if `joinDataType` has been explicitly set.
  var hasJoinDataType: Bool {return _storage._joinDataType != nil}
  /// Clears the value of `joinDataType`. Subsequent reads from it will return its default value.
  mutating func clearJoinDataType() {_uniqueStorage()._joinDataType = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum JoinType: SwiftProtobuf.Enum, Swift.CaseIterable {
    typealias RawValue = Int
    case unspecified // = 0
    case inner // = 1
    case fullOuter // = 2
    case leftOuter // = 3
    case rightOuter // = 4
    case leftAnti // = 5
    case leftSemi // = 6
    case cross // = 7
    case UNRECOGNIZED(Int)

    init() {
      self = .unspecified
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .unspecified
      case 1: self = .inner
      case 2: self = .fullOuter
      case 3: self = .leftOuter
      case 4: self = .rightOuter
      case 5: self = .leftAnti
      case 6: self = .leftSemi
      case 7: self = .cross
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .unspecified: return 0
      case .inner: return 1
      case .fullOuter: return 2
      case .leftOuter: return 3
      case .rightOuter: return 4
      case .leftAnti: return 5
      case .leftSemi: return 6
      case .cross: return 7
      case .UNRECOGNIZED(let i): return i
      }
    }

    // The compiler won't synthesize support with the UNRECOGNIZED case.
    static let allCases: [Spark_Connect_Join.JoinType] = [
      .unspecified,
      .inner,
      .fullOuter,
      .leftOuter,
      .rightOuter,
      .leftAnti,
      .leftSemi,
      .cross,
    ]

  }

  struct JoinDataType: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// If the left data type is a struct.
    var isLeftStruct: Bool = false

    /// If the right data type is a struct.
    var isRightStruct: Bool = false

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Relation of type [[SetOperation]]
struct Spark_Connect_SetOperation: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Left input relation for a Set operation.
  var leftInput: Spark_Connect_Relation {
    get {return _storage._leftInput ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._leftInput = newValue}
  }
  /// Returns true if `leftInput` has been explicitly set.
  var hasLeftInput: Bool {return _storage._leftInput != nil}
  /// Clears the value of `leftInput`. Subsequent reads from it will return its default value.
  mutating func clearLeftInput() {_uniqueStorage()._leftInput = nil}

  /// (Required) Right input relation for a Set operation.
  var rightInput: Spark_Connect_Relation {
    get {return _storage._rightInput ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._rightInput = newValue}
  }
  /// Returns true if `rightInput` has been explicitly set.
  var hasRightInput: Bool {return _storage._rightInput != nil}
  /// Clears the value of `rightInput`. Subsequent reads from it will return its default value.
  mutating func clearRightInput() {_uniqueStorage()._rightInput = nil}

  /// (Required) The Set operation type.
  var setOpType: Spark_Connect_SetOperation.SetOpType {
    get {return _storage._setOpType}
    set {_uniqueStorage()._setOpType = newValue}
  }

  /// (Optional) If to remove duplicate rows.
  ///
  /// True to preserve all results.
  /// False to remove duplicate rows.
  var isAll: Bool {
    get {return _storage._isAll ?? false}
    set {_uniqueStorage()._isAll = newValue}
  }
  /// Returns true if `isAll` has been explicitly set.
  var hasIsAll: Bool {return _storage._isAll != nil}
  /// Clears the value of `isAll`. Subsequent reads from it will return its default value.
  mutating func clearIsAll() {_uniqueStorage()._isAll = nil}

  /// (Optional) If to perform the Set operation based on name resolution.
  ///
  /// Only UNION supports this option.
  var byName: Bool {
    get {return _storage._byName ?? false}
    set {_uniqueStorage()._byName = newValue}
  }
  /// Returns true if `byName` has been explicitly set.
  var hasByName: Bool {return _storage._byName != nil}
  /// Clears the value of `byName`. Subsequent reads from it will return its default value.
  mutating func clearByName() {_uniqueStorage()._byName = nil}

  /// (Optional) If to perform the Set operation and allow missing columns.
  ///
  /// Only UNION supports this option.
  var allowMissingColumns: Bool {
    get {return _storage._allowMissingColumns ?? false}
    set {_uniqueStorage()._allowMissingColumns = newValue}
  }
  /// Returns true if `allowMissingColumns` has been explicitly set.
  var hasAllowMissingColumns: Bool {return _storage._allowMissingColumns != nil}
  /// Clears the value of `allowMissingColumns`. Subsequent reads from it will return its default value.
  mutating func clearAllowMissingColumns() {_uniqueStorage()._allowMissingColumns = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum SetOpType: SwiftProtobuf.Enum, Swift.CaseIterable {
    typealias RawValue = Int
    case unspecified // = 0
    case intersect // = 1
    case union // = 2
    case except // = 3
    case UNRECOGNIZED(Int)

    init() {
      self = .unspecified
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .unspecified
      case 1: self = .intersect
      case 2: self = .union
      case 3: self = .except
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .unspecified: return 0
      case .intersect: return 1
      case .union: return 2
      case .except: return 3
      case .UNRECOGNIZED(let i): return i
      }
    }

    // The compiler won't synthesize support with the UNRECOGNIZED case.
    static let allCases: [Spark_Connect_SetOperation.SetOpType] = [
      .unspecified,
      .intersect,
      .union,
      .except,
    ]

  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Relation of type [[Limit]] that is used to `limit` rows from the input relation.
struct Spark_Connect_Limit: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Input relation for a Limit.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) the limit.
  var limit: Int32 {
    get {return _storage._limit}
    set {_uniqueStorage()._limit = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Relation of type [[Offset]] that is used to read rows staring from the `offset` on
/// the input relation.
struct Spark_Connect_Offset: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Input relation for an Offset.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) the limit.
  var offset: Int32 {
    get {return _storage._offset}
    set {_uniqueStorage()._offset = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Relation of type [[Tail]] that is used to fetch `limit` rows from the last of the input relation.
struct Spark_Connect_Tail: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Input relation for an Tail.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) the limit.
  var limit: Int32 {
    get {return _storage._limit}
    set {_uniqueStorage()._limit = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Relation of type [[Aggregate]].
struct Spark_Connect_Aggregate: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Input relation for a RelationalGroupedDataset.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) How the RelationalGroupedDataset was built.
  var groupType: Spark_Connect_Aggregate.GroupType {
    get {return _storage._groupType}
    set {_uniqueStorage()._groupType = newValue}
  }

  /// (Required) Expressions for grouping keys
  var groupingExpressions: [Spark_Connect_Expression] {
    get {return _storage._groupingExpressions}
    set {_uniqueStorage()._groupingExpressions = newValue}
  }

  /// (Required) List of values that will be translated to columns in the output DataFrame.
  var aggregateExpressions: [Spark_Connect_Expression] {
    get {return _storage._aggregateExpressions}
    set {_uniqueStorage()._aggregateExpressions = newValue}
  }

  /// (Optional) Pivots a column of the current `DataFrame` and performs the specified aggregation.
  var pivot: Spark_Connect_Aggregate.Pivot {
    get {return _storage._pivot ?? Spark_Connect_Aggregate.Pivot()}
    set {_uniqueStorage()._pivot = newValue}
  }
  /// Returns true if `pivot` has been explicitly set.
  var hasPivot: Bool {return _storage._pivot != nil}
  /// Clears the value of `pivot`. Subsequent reads from it will return its default value.
  mutating func clearPivot() {_uniqueStorage()._pivot = nil}

  /// (Optional) List of values that will be translated to columns in the output DataFrame.
  var groupingSets: [Spark_Connect_Aggregate.GroupingSets] {
    get {return _storage._groupingSets}
    set {_uniqueStorage()._groupingSets = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum GroupType: SwiftProtobuf.Enum, Swift.CaseIterable {
    typealias RawValue = Int
    case unspecified // = 0
    case groupby // = 1
    case rollup // = 2
    case cube // = 3
    case pivot // = 4
    case groupingSets // = 5
    case UNRECOGNIZED(Int)

    init() {
      self = .unspecified
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .unspecified
      case 1: self = .groupby
      case 2: self = .rollup
      case 3: self = .cube
      case 4: self = .pivot
      case 5: self = .groupingSets
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .unspecified: return 0
      case .groupby: return 1
      case .rollup: return 2
      case .cube: return 3
      case .pivot: return 4
      case .groupingSets: return 5
      case .UNRECOGNIZED(let i): return i
      }
    }

    // The compiler won't synthesize support with the UNRECOGNIZED case.
    static let allCases: [Spark_Connect_Aggregate.GroupType] = [
      .unspecified,
      .groupby,
      .rollup,
      .cube,
      .pivot,
      .groupingSets,
    ]

  }

  struct Pivot: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The column to pivot
    var col: Spark_Connect_Expression {
      get {return _col ?? Spark_Connect_Expression()}
      set {_col = newValue}
    }
    /// Returns true if `col` has been explicitly set.
    var hasCol: Bool {return self._col != nil}
    /// Clears the value of `col`. Subsequent reads from it will return its default value.
    mutating func clearCol() {self._col = nil}

    /// (Optional) List of values that will be translated to columns in the output DataFrame.
    ///
    /// Note that if it is empty, the server side will immediately trigger a job to collect
    /// the distinct values of the column.
    var values: [Spark_Connect_Expression.Literal] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _col: Spark_Connect_Expression? = nil
  }

  struct GroupingSets: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) Individual grouping set
    var groupingSet: [Spark_Connect_Expression] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Relation of type [[Sort]].
struct Spark_Connect_Sort: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Input relation for a Sort.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) The ordering expressions
  var order: [Spark_Connect_Expression.SortOrder] {
    get {return _storage._order}
    set {_uniqueStorage()._order = newValue}
  }

  /// (Optional) if this is a global sort.
  var isGlobal: Bool {
    get {return _storage._isGlobal ?? false}
    set {_uniqueStorage()._isGlobal = newValue}
  }
  /// Returns true if `isGlobal` has been explicitly set.
  var hasIsGlobal: Bool {return _storage._isGlobal != nil}
  /// Clears the value of `isGlobal`. Subsequent reads from it will return its default value.
  mutating func clearIsGlobal() {_uniqueStorage()._isGlobal = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Drop specified columns.
struct Spark_Connect_Drop: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Optional) columns to drop.
  var columns: [Spark_Connect_Expression] {
    get {return _storage._columns}
    set {_uniqueStorage()._columns = newValue}
  }

  /// (Optional) names of columns to drop.
  var columnNames: [String] {
    get {return _storage._columnNames}
    set {_uniqueStorage()._columnNames = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Relation of type [[Deduplicate]] which have duplicate rows removed, could consider either only
/// the subset of columns or all the columns.
struct Spark_Connect_Deduplicate: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Input relation for a Deduplicate.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Optional) Deduplicate based on a list of column names.
  ///
  /// This field does not co-use with `all_columns_as_keys`.
  var columnNames: [String] {
    get {return _storage._columnNames}
    set {_uniqueStorage()._columnNames = newValue}
  }

  /// (Optional) Deduplicate based on all the columns of the input relation.
  ///
  /// This field does not co-use with `column_names`.
  var allColumnsAsKeys: Bool {
    get {return _storage._allColumnsAsKeys ?? false}
    set {_uniqueStorage()._allColumnsAsKeys = newValue}
  }
  /// Returns true if `allColumnsAsKeys` has been explicitly set.
  var hasAllColumnsAsKeys: Bool {return _storage._allColumnsAsKeys != nil}
  /// Clears the value of `allColumnsAsKeys`. Subsequent reads from it will return its default value.
  mutating func clearAllColumnsAsKeys() {_uniqueStorage()._allColumnsAsKeys = nil}

  /// (Optional) Deduplicate within the time range of watermark.
  var withinWatermark: Bool {
    get {return _storage._withinWatermark ?? false}
    set {_uniqueStorage()._withinWatermark = newValue}
  }
  /// Returns true if `withinWatermark` has been explicitly set.
  var hasWithinWatermark: Bool {return _storage._withinWatermark != nil}
  /// Clears the value of `withinWatermark`. Subsequent reads from it will return its default value.
  mutating func clearWithinWatermark() {_uniqueStorage()._withinWatermark = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// A relation that does not need to be qualified by name.
struct Spark_Connect_LocalRelation: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Optional) Local collection data serialized into Arrow IPC streaming format which contains
  /// the schema of the data.
  var data: Data {
    get {return _data ?? Data()}
    set {_data = newValue}
  }
  /// Returns true if `data` has been explicitly set.
  var hasData: Bool {return self._data != nil}
  /// Clears the value of `data`. Subsequent reads from it will return its default value.
  mutating func clearData() {self._data = nil}

  /// (Optional) The schema of local data.
  /// It should be either a DDL-formatted type string or a JSON string.
  ///
  /// The server side will update the column names and data types according to this schema.
  /// If the 'data' is not provided, then this schema will be required.
  var schema: String {
    get {return _schema ?? String()}
    set {_schema = newValue}
  }
  /// Returns true if `schema` has been explicitly set.
  var hasSchema: Bool {return self._schema != nil}
  /// Clears the value of `schema`. Subsequent reads from it will return its default value.
  mutating func clearSchema() {self._schema = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _data: Data? = nil
  fileprivate var _schema: String? = nil
}

/// A local relation that has been cached already.
struct Spark_Connect_CachedLocalRelation: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) A sha-256 hash of the serialized local relation in proto, see LocalRelation.
  var hash: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// Represents a remote relation that has been cached on server.
struct Spark_Connect_CachedRemoteRelation: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) ID of the remote related (assigned by the service).
  var relationID: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// Relation of type [[Sample]] that samples a fraction of the dataset.
struct Spark_Connect_Sample: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Input relation for a Sample.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) lower bound.
  var lowerBound: Double {
    get {return _storage._lowerBound}
    set {_uniqueStorage()._lowerBound = newValue}
  }

  /// (Required) upper bound.
  var upperBound: Double {
    get {return _storage._upperBound}
    set {_uniqueStorage()._upperBound = newValue}
  }

  /// (Optional) Whether to sample with replacement.
  var withReplacement: Bool {
    get {return _storage._withReplacement ?? false}
    set {_uniqueStorage()._withReplacement = newValue}
  }
  /// Returns true if `withReplacement` has been explicitly set.
  var hasWithReplacement: Bool {return _storage._withReplacement != nil}
  /// Clears the value of `withReplacement`. Subsequent reads from it will return its default value.
  mutating func clearWithReplacement() {_uniqueStorage()._withReplacement = nil}

  /// (Required) The random seed.
  /// This field is required to avoid generating mutable dataframes (see SPARK-48184 for details),
  /// however, still keep it 'optional' here for backward compatibility.
  var seed: Int64 {
    get {return _storage._seed ?? 0}
    set {_uniqueStorage()._seed = newValue}
  }
  /// Returns true if `seed` has been explicitly set.
  var hasSeed: Bool {return _storage._seed != nil}
  /// Clears the value of `seed`. Subsequent reads from it will return its default value.
  mutating func clearSeed() {_uniqueStorage()._seed = nil}

  /// (Required) Explicitly sort the underlying plan to make the ordering deterministic or cache it.
  /// This flag is true when invoking `dataframe.randomSplit` to randomly splits DataFrame with the
  /// provided weights. Otherwise, it is false.
  var deterministicOrder: Bool {
    get {return _storage._deterministicOrder}
    set {_uniqueStorage()._deterministicOrder = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Relation of type [[Range]] that generates a sequence of integers.
struct Spark_Connect_Range: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Optional) Default value = 0
  var start: Int64 {
    get {return _start ?? 0}
    set {_start = newValue}
  }
  /// Returns true if `start` has been explicitly set.
  var hasStart: Bool {return self._start != nil}
  /// Clears the value of `start`. Subsequent reads from it will return its default value.
  mutating func clearStart() {self._start = nil}

  /// (Required)
  var end: Int64 = 0

  /// (Required)
  var step: Int64 = 0

  /// Optional. Default value is assigned by 1) SQL conf "spark.sql.leafNodeDefaultParallelism" if
  /// it is set, or 2) spark default parallelism.
  var numPartitions: Int32 {
    get {return _numPartitions ?? 0}
    set {_numPartitions = newValue}
  }
  /// Returns true if `numPartitions` has been explicitly set.
  var hasNumPartitions: Bool {return self._numPartitions != nil}
  /// Clears the value of `numPartitions`. Subsequent reads from it will return its default value.
  mutating func clearNumPartitions() {self._numPartitions = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _start: Int64? = nil
  fileprivate var _numPartitions: Int32? = nil
}

/// Relation alias.
struct Spark_Connect_SubqueryAlias: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation of SubqueryAlias.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) The alias.
  var alias: String {
    get {return _storage._alias}
    set {_uniqueStorage()._alias = newValue}
  }

  /// (Optional) Qualifier of the alias.
  var qualifier: [String] {
    get {return _storage._qualifier}
    set {_uniqueStorage()._qualifier = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Relation repartition.
struct Spark_Connect_Repartition: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation of Repartition.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) Must be positive.
  var numPartitions: Int32 {
    get {return _storage._numPartitions}
    set {_uniqueStorage()._numPartitions = newValue}
  }

  /// (Optional) Default value is false.
  var shuffle: Bool {
    get {return _storage._shuffle ?? false}
    set {_uniqueStorage()._shuffle = newValue}
  }
  /// Returns true if `shuffle` has been explicitly set.
  var hasShuffle: Bool {return _storage._shuffle != nil}
  /// Clears the value of `shuffle`. Subsequent reads from it will return its default value.
  mutating func clearShuffle() {_uniqueStorage()._shuffle = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Compose the string representing rows for output.
/// It will invoke 'Dataset.showString' to compute the results.
struct Spark_Connect_ShowString: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) Number of rows to show.
  var numRows: Int32 {
    get {return _storage._numRows}
    set {_uniqueStorage()._numRows = newValue}
  }

  /// (Required) If set to more than 0, truncates strings to
  /// `truncate` characters and all cells will be aligned right.
  var truncate: Int32 {
    get {return _storage._truncate}
    set {_uniqueStorage()._truncate = newValue}
  }

  /// (Required) If set to true, prints output rows vertically (one line per column value).
  var vertical: Bool {
    get {return _storage._vertical}
    set {_uniqueStorage()._vertical = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Compose the string representing rows for output.
/// It will invoke 'Dataset.htmlString' to compute the results.
struct Spark_Connect_HtmlString: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) Number of rows to show.
  var numRows: Int32 {
    get {return _storage._numRows}
    set {_uniqueStorage()._numRows = newValue}
  }

  /// (Required) If set to more than 0, truncates strings to
  /// `truncate` characters and all cells will be aligned right.
  var truncate: Int32 {
    get {return _storage._truncate}
    set {_uniqueStorage()._truncate = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Computes specified statistics for numeric and string columns.
/// It will invoke 'Dataset.summary' (same as 'StatFunctions.summary')
/// to compute the results.
struct Spark_Connect_StatSummary: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Optional) Statistics from to be computed.
  ///
  /// Available statistics are:
  ///  count
  ///  mean
  ///  stddev
  ///  min
  ///  max
  ///  arbitrary approximate percentiles specified as a percentage (e.g. 75%)
  ///  count_distinct
  ///  approx_count_distinct
  ///
  /// If no statistics are given, this function computes 'count', 'mean', 'stddev', 'min',
  /// 'approximate quartiles' (percentiles at 25%, 50%, and 75%), and 'max'.
  var statistics: [String] {
    get {return _storage._statistics}
    set {_uniqueStorage()._statistics = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Computes basic statistics for numeric and string columns, including count, mean, stddev, min,
/// and max. If no columns are given, this function computes statistics for all numerical or
/// string columns.
struct Spark_Connect_StatDescribe: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Optional) Columns to compute statistics on.
  var cols: [String] {
    get {return _storage._cols}
    set {_uniqueStorage()._cols = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Computes a pair-wise frequency table of the given columns. Also known as a contingency table.
/// It will invoke 'Dataset.stat.crosstab' (same as 'StatFunctions.crossTabulate')
/// to compute the results.
struct Spark_Connect_StatCrosstab: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) The name of the first column.
  ///
  /// Distinct items will make the first item of each row.
  var col1: String {
    get {return _storage._col1}
    set {_uniqueStorage()._col1 = newValue}
  }

  /// (Required) The name of the second column.
  ///
  /// Distinct items will make the column names of the DataFrame.
  var col2: String {
    get {return _storage._col2}
    set {_uniqueStorage()._col2 = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Calculate the sample covariance of two numerical columns of a DataFrame.
/// It will invoke 'Dataset.stat.cov' (same as 'StatFunctions.calculateCov') to compute the results.
struct Spark_Connect_StatCov: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) The name of the first column.
  var col1: String {
    get {return _storage._col1}
    set {_uniqueStorage()._col1 = newValue}
  }

  /// (Required) The name of the second column.
  var col2: String {
    get {return _storage._col2}
    set {_uniqueStorage()._col2 = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Calculates the correlation of two columns of a DataFrame. Currently only supports the Pearson
/// Correlation Coefficient. It will invoke 'Dataset.stat.corr' (same as
/// 'StatFunctions.pearsonCorrelation') to compute the results.
struct Spark_Connect_StatCorr: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) The name of the first column.
  var col1: String {
    get {return _storage._col1}
    set {_uniqueStorage()._col1 = newValue}
  }

  /// (Required) The name of the second column.
  var col2: String {
    get {return _storage._col2}
    set {_uniqueStorage()._col2 = newValue}
  }

  /// (Optional) Default value is 'pearson'.
  ///
  /// Currently only supports the Pearson Correlation Coefficient.
  var method: String {
    get {return _storage._method ?? String()}
    set {_uniqueStorage()._method = newValue}
  }
  /// Returns true if `method` has been explicitly set.
  var hasMethod: Bool {return _storage._method != nil}
  /// Clears the value of `method`. Subsequent reads from it will return its default value.
  mutating func clearMethod() {_uniqueStorage()._method = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Calculates the approximate quantiles of numerical columns of a DataFrame.
/// It will invoke 'Dataset.stat.approxQuantile' (same as 'StatFunctions.approxQuantile')
/// to compute the results.
struct Spark_Connect_StatApproxQuantile: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) The names of the numerical columns.
  var cols: [String] {
    get {return _storage._cols}
    set {_uniqueStorage()._cols = newValue}
  }

  /// (Required) A list of quantile probabilities.
  ///
  /// Each number must belong to [0, 1].
  /// For example 0 is the minimum, 0.5 is the median, 1 is the maximum.
  var probabilities: [Double] {
    get {return _storage._probabilities}
    set {_uniqueStorage()._probabilities = newValue}
  }

  /// (Required) The relative target precision to achieve (greater than or equal to 0).
  ///
  /// If set to zero, the exact quantiles are computed, which could be very expensive.
  /// Note that values greater than 1 are accepted but give the same result as 1.
  var relativeError: Double {
    get {return _storage._relativeError}
    set {_uniqueStorage()._relativeError = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Finding frequent items for columns, possibly with false positives.
/// It will invoke 'Dataset.stat.freqItems' (same as 'StatFunctions.freqItems')
/// to compute the results.
struct Spark_Connect_StatFreqItems: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) The names of the columns to search frequent items in.
  var cols: [String] {
    get {return _storage._cols}
    set {_uniqueStorage()._cols = newValue}
  }

  /// (Optional) The minimum frequency for an item to be considered `frequent`.
  /// Should be greater than 1e-4.
  var support: Double {
    get {return _storage._support ?? 0}
    set {_uniqueStorage()._support = newValue}
  }
  /// Returns true if `support` has been explicitly set.
  var hasSupport: Bool {return _storage._support != nil}
  /// Clears the value of `support`. Subsequent reads from it will return its default value.
  mutating func clearSupport() {_uniqueStorage()._support = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Returns a stratified sample without replacement based on the fraction
/// given on each stratum.
/// It will invoke 'Dataset.stat.freqItems' (same as 'StatFunctions.freqItems')
/// to compute the results.
struct Spark_Connect_StatSampleBy: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) The column that defines strata.
  var col: Spark_Connect_Expression {
    get {return _storage._col ?? Spark_Connect_Expression()}
    set {_uniqueStorage()._col = newValue}
  }
  /// Returns true if `col` has been explicitly set.
  var hasCol: Bool {return _storage._col != nil}
  /// Clears the value of `col`. Subsequent reads from it will return its default value.
  mutating func clearCol() {_uniqueStorage()._col = nil}

  /// (Required) Sampling fraction for each stratum.
  ///
  /// If a stratum is not specified, we treat its fraction as zero.
  var fractions: [Spark_Connect_StatSampleBy.Fraction] {
    get {return _storage._fractions}
    set {_uniqueStorage()._fractions = newValue}
  }

  /// (Required) The random seed.
  /// This field is required to avoid generating mutable dataframes (see SPARK-48184 for details),
  /// however, still keep it 'optional' here for backward compatibility.
  var seed: Int64 {
    get {return _storage._seed ?? 0}
    set {_uniqueStorage()._seed = newValue}
  }
  /// Returns true if `seed` has been explicitly set.
  var hasSeed: Bool {return _storage._seed != nil}
  /// Clears the value of `seed`. Subsequent reads from it will return its default value.
  mutating func clearSeed() {_uniqueStorage()._seed = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  struct Fraction: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The stratum.
    var stratum: Spark_Connect_Expression.Literal {
      get {return _stratum ?? Spark_Connect_Expression.Literal()}
      set {_stratum = newValue}
    }
    /// Returns true if `stratum` has been explicitly set.
    var hasStratum: Bool {return self._stratum != nil}
    /// Clears the value of `stratum`. Subsequent reads from it will return its default value.
    mutating func clearStratum() {self._stratum = nil}

    /// (Required) The fraction value. Must be in [0, 1].
    var fraction: Double = 0

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _stratum: Spark_Connect_Expression.Literal? = nil
  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Replaces null values.
/// It will invoke 'Dataset.na.fill' (same as 'DataFrameNaFunctions.fill') to compute the results.
/// Following 3 parameter combinations are supported:
///  1, 'values' only contains 1 item, 'cols' is empty:
///    replaces null values in all type-compatible columns.
///  2, 'values' only contains 1 item, 'cols' is not empty:
///    replaces null values in specified columns.
///  3, 'values' contains more than 1 items, then 'cols' is required to have the same length:
///    replaces each specified column with corresponding value.
struct Spark_Connect_NAFill: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Optional) Optional list of column names to consider.
  var cols: [String] {
    get {return _storage._cols}
    set {_uniqueStorage()._cols = newValue}
  }

  /// (Required) Values to replace null values with.
  ///
  /// Should contain at least 1 item.
  /// Only 4 data types are supported now: bool, long, double, string
  var values: [Spark_Connect_Expression.Literal] {
    get {return _storage._values}
    set {_uniqueStorage()._values = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Drop rows containing null values.
/// It will invoke 'Dataset.na.drop' (same as 'DataFrameNaFunctions.drop') to compute the results.
struct Spark_Connect_NADrop: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Optional) Optional list of column names to consider.
  ///
  /// When it is empty, all the columns in the input relation will be considered.
  var cols: [String] {
    get {return _storage._cols}
    set {_uniqueStorage()._cols = newValue}
  }

  /// (Optional) The minimum number of non-null and non-NaN values required to keep.
  ///
  /// When not set, it is equivalent to the number of considered columns, which means
  /// a row will be kept only if all columns are non-null.
  ///
  /// 'how' options ('all', 'any') can be easily converted to this field:
  ///   - 'all' -> set 'min_non_nulls' 1;
  ///   - 'any' -> keep 'min_non_nulls' unset;
  var minNonNulls: Int32 {
    get {return _storage._minNonNulls ?? 0}
    set {_uniqueStorage()._minNonNulls = newValue}
  }
  /// Returns true if `minNonNulls` has been explicitly set.
  var hasMinNonNulls: Bool {return _storage._minNonNulls != nil}
  /// Clears the value of `minNonNulls`. Subsequent reads from it will return its default value.
  mutating func clearMinNonNulls() {_uniqueStorage()._minNonNulls = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Replaces old values with the corresponding values.
/// It will invoke 'Dataset.na.replace' (same as 'DataFrameNaFunctions.replace')
/// to compute the results.
struct Spark_Connect_NAReplace: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Optional) List of column names to consider.
  ///
  /// When it is empty, all the type-compatible columns in the input relation will be considered.
  var cols: [String] {
    get {return _storage._cols}
    set {_uniqueStorage()._cols = newValue}
  }

  /// (Optional) The value replacement mapping.
  var replacements: [Spark_Connect_NAReplace.Replacement] {
    get {return _storage._replacements}
    set {_uniqueStorage()._replacements = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  struct Replacement: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The old value.
    ///
    /// Only 4 data types are supported now: null, bool, double, string.
    var oldValue: Spark_Connect_Expression.Literal {
      get {return _oldValue ?? Spark_Connect_Expression.Literal()}
      set {_oldValue = newValue}
    }
    /// Returns true if `oldValue` has been explicitly set.
    var hasOldValue: Bool {return self._oldValue != nil}
    /// Clears the value of `oldValue`. Subsequent reads from it will return its default value.
    mutating func clearOldValue() {self._oldValue = nil}

    /// (Required) The new value.
    ///
    /// Should be of the same data type with the old value.
    var newValue: Spark_Connect_Expression.Literal {
      get {return _newValue ?? Spark_Connect_Expression.Literal()}
      set {_newValue = newValue}
    }
    /// Returns true if `newValue` has been explicitly set.
    var hasNewValue: Bool {return self._newValue != nil}
    /// Clears the value of `newValue`. Subsequent reads from it will return its default value.
    mutating func clearNewValue() {self._newValue = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _oldValue: Spark_Connect_Expression.Literal? = nil
    fileprivate var _newValue: Spark_Connect_Expression.Literal? = nil
  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Rename columns on the input relation by the same length of names.
struct Spark_Connect_ToDF: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation of RenameColumnsBySameLengthNames.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required)
  ///
  /// The number of columns of the input relation must be equal to the length
  /// of this field. If this is not true, an exception will be returned.
  var columnNames: [String] {
    get {return _storage._columnNames}
    set {_uniqueStorage()._columnNames = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Rename columns on the input relation by a map with name to name mapping.
struct Spark_Connect_WithColumnsRenamed: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Optional)
  ///
  /// Renaming column names of input relation from A to B where A is the map key
  /// and B is the map value. This is a no-op if schema doesn't contain any A. It
  /// does not require that all input relation column names to present as keys.
  /// duplicated B are not allowed.
  ///
  /// NOTE: This field was marked as deprecated in the .proto file.
  var renameColumnsMap: Dictionary<String,String> {
    get {return _storage._renameColumnsMap}
    set {_uniqueStorage()._renameColumnsMap = newValue}
  }

  var renames: [Spark_Connect_WithColumnsRenamed.Rename] {
    get {return _storage._renames}
    set {_uniqueStorage()._renames = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  struct Rename: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The existing column name.
    var colName: String = String()

    /// (Required) The new column name.
    var newColName: String = String()

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Adding columns or replacing the existing columns that have the same names.
struct Spark_Connect_WithColumns: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required)
  ///
  /// Given a column name, apply the corresponding expression on the column. If column
  /// name exists in the input relation, then replace the column. If the column name
  /// does not exist in the input relation, then adds it as a new column.
  ///
  /// Only one name part is expected from each Expression.Alias.
  ///
  /// An exception is thrown when duplicated names are present in the mapping.
  var aliases: [Spark_Connect_Expression.Alias] {
    get {return _storage._aliases}
    set {_uniqueStorage()._aliases = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

struct Spark_Connect_WithWatermark: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) Name of the column containing event time.
  var eventTime: String {
    get {return _storage._eventTime}
    set {_uniqueStorage()._eventTime = newValue}
  }

  /// (Required)
  var delayThreshold: String {
    get {return _storage._delayThreshold}
    set {_uniqueStorage()._delayThreshold = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Specify a hint over a relation. Hint should have a name and optional parameters.
struct Spark_Connect_Hint: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) Hint name.
  ///
  /// Supported Join hints include BROADCAST, MERGE, SHUFFLE_HASH, SHUFFLE_REPLICATE_NL.
  ///
  /// Supported partitioning hints include COALESCE, REPARTITION, REPARTITION_BY_RANGE.
  var name: String {
    get {return _storage._name}
    set {_uniqueStorage()._name = newValue}
  }

  /// (Optional) Hint parameters.
  var parameters: [Spark_Connect_Expression] {
    get {return _storage._parameters}
    set {_uniqueStorage()._parameters = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Unpivot a DataFrame from wide format to long format, optionally leaving identifier columns set.
struct Spark_Connect_Unpivot: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) Id columns.
  var ids: [Spark_Connect_Expression] {
    get {return _storage._ids}
    set {_uniqueStorage()._ids = newValue}
  }

  /// (Optional) Value columns to unpivot.
  var values: Spark_Connect_Unpivot.Values {
    get {return _storage._values ?? Spark_Connect_Unpivot.Values()}
    set {_uniqueStorage()._values = newValue}
  }
  /// Returns true if `values` has been explicitly set.
  var hasValues: Bool {return _storage._values != nil}
  /// Clears the value of `values`. Subsequent reads from it will return its default value.
  mutating func clearValues() {_uniqueStorage()._values = nil}

  /// (Required) Name of the variable column.
  var variableColumnName: String {
    get {return _storage._variableColumnName}
    set {_uniqueStorage()._variableColumnName = newValue}
  }

  /// (Required) Name of the value column.
  var valueColumnName: String {
    get {return _storage._valueColumnName}
    set {_uniqueStorage()._valueColumnName = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  struct Values: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var values: [Spark_Connect_Expression] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Transpose a DataFrame, switching rows to columns.
/// Transforms the DataFrame such that the values in the specified index column
/// become the new columns of the DataFrame.
struct Spark_Connect_Transpose: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Optional) A list of columns that will be treated as the indices.
  /// Only single column is supported now.
  var indexColumns: [Spark_Connect_Expression] {
    get {return _storage._indexColumns}
    set {_uniqueStorage()._indexColumns = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

struct Spark_Connect_UnresolvedTableValuedFunction: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) name (or unparsed name for user defined function) for the unresolved function.
  var functionName: String = String()

  /// (Optional) Function arguments. Empty arguments are allowed.
  var arguments: [Spark_Connect_Expression] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct Spark_Connect_ToSchema: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) The user provided schema.
  ///
  /// The Sever side will update the dataframe with this schema.
  var schema: Spark_Connect_DataType {
    get {return _storage._schema ?? Spark_Connect_DataType()}
    set {_uniqueStorage()._schema = newValue}
  }
  /// Returns true if `schema` has been explicitly set.
  var hasSchema: Bool {return _storage._schema != nil}
  /// Clears the value of `schema`. Subsequent reads from it will return its default value.
  mutating func clearSchema() {_uniqueStorage()._schema = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

struct Spark_Connect_RepartitionByExpression: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) The partitioning expressions.
  var partitionExprs: [Spark_Connect_Expression] {
    get {return _storage._partitionExprs}
    set {_uniqueStorage()._partitionExprs = newValue}
  }

  /// (Optional) number of partitions, must be positive.
  var numPartitions: Int32 {
    get {return _storage._numPartitions ?? 0}
    set {_uniqueStorage()._numPartitions = newValue}
  }
  /// Returns true if `numPartitions` has been explicitly set.
  var hasNumPartitions: Bool {return _storage._numPartitions != nil}
  /// Clears the value of `numPartitions`. Subsequent reads from it will return its default value.
  mutating func clearNumPartitions() {_uniqueStorage()._numPartitions = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

struct Spark_Connect_MapPartitions: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Input relation for a mapPartitions-equivalent API: mapInPandas, mapInArrow.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) Input user-defined function.
  var `func`: Spark_Connect_CommonInlineUserDefinedFunction {
    get {return _storage._func ?? Spark_Connect_CommonInlineUserDefinedFunction()}
    set {_uniqueStorage()._func = newValue}
  }
  /// Returns true if ``func`` has been explicitly set.
  var hasFunc: Bool {return _storage._func != nil}
  /// Clears the value of ``func``. Subsequent reads from it will return its default value.
  mutating func clearFunc() {_uniqueStorage()._func = nil}

  /// (Optional) Whether to use barrier mode execution or not.
  var isBarrier: Bool {
    get {return _storage._isBarrier ?? false}
    set {_uniqueStorage()._isBarrier = newValue}
  }
  /// Returns true if `isBarrier` has been explicitly set.
  var hasIsBarrier: Bool {return _storage._isBarrier != nil}
  /// Clears the value of `isBarrier`. Subsequent reads from it will return its default value.
  mutating func clearIsBarrier() {_uniqueStorage()._isBarrier = nil}

  /// (Optional) ResourceProfile id used for the stage level scheduling.
  var profileID: Int32 {
    get {return _storage._profileID ?? 0}
    set {_uniqueStorage()._profileID = newValue}
  }
  /// Returns true if `profileID` has been explicitly set.
  var hasProfileID: Bool {return _storage._profileID != nil}
  /// Clears the value of `profileID`. Subsequent reads from it will return its default value.
  mutating func clearProfileID() {_uniqueStorage()._profileID = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

struct Spark_Connect_GroupMap: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Input relation for Group Map API: apply, applyInPandas.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) Expressions for grouping keys.
  var groupingExpressions: [Spark_Connect_Expression] {
    get {return _storage._groupingExpressions}
    set {_uniqueStorage()._groupingExpressions = newValue}
  }

  /// (Required) Input user-defined function.
  var `func`: Spark_Connect_CommonInlineUserDefinedFunction {
    get {return _storage._func ?? Spark_Connect_CommonInlineUserDefinedFunction()}
    set {_uniqueStorage()._func = newValue}
  }
  /// Returns true if ``func`` has been explicitly set.
  var hasFunc: Bool {return _storage._func != nil}
  /// Clears the value of ``func``. Subsequent reads from it will return its default value.
  mutating func clearFunc() {_uniqueStorage()._func = nil}

  /// (Optional) Expressions for sorting. Only used by Scala Sorted Group Map API.
  var sortingExpressions: [Spark_Connect_Expression] {
    get {return _storage._sortingExpressions}
    set {_uniqueStorage()._sortingExpressions = newValue}
  }

  /// Below fields are only used by (Flat)MapGroupsWithState
  /// (Optional) Input relation for initial State.
  var initialInput: Spark_Connect_Relation {
    get {return _storage._initialInput ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._initialInput = newValue}
  }
  /// Returns true if `initialInput` has been explicitly set.
  var hasInitialInput: Bool {return _storage._initialInput != nil}
  /// Clears the value of `initialInput`. Subsequent reads from it will return its default value.
  mutating func clearInitialInput() {_uniqueStorage()._initialInput = nil}

  /// (Optional) Expressions for grouping keys of the initial state input relation.
  var initialGroupingExpressions: [Spark_Connect_Expression] {
    get {return _storage._initialGroupingExpressions}
    set {_uniqueStorage()._initialGroupingExpressions = newValue}
  }

  /// (Optional) True if MapGroupsWithState, false if FlatMapGroupsWithState.
  var isMapGroupsWithState: Bool {
    get {return _storage._isMapGroupsWithState ?? false}
    set {_uniqueStorage()._isMapGroupsWithState = newValue}
  }
  /// Returns true if `isMapGroupsWithState` has been explicitly set.
  var hasIsMapGroupsWithState: Bool {return _storage._isMapGroupsWithState != nil}
  /// Clears the value of `isMapGroupsWithState`. Subsequent reads from it will return its default value.
  mutating func clearIsMapGroupsWithState() {_uniqueStorage()._isMapGroupsWithState = nil}

  /// (Optional) The output mode of the function.
  var outputMode: String {
    get {return _storage._outputMode ?? String()}
    set {_uniqueStorage()._outputMode = newValue}
  }
  /// Returns true if `outputMode` has been explicitly set.
  var hasOutputMode: Bool {return _storage._outputMode != nil}
  /// Clears the value of `outputMode`. Subsequent reads from it will return its default value.
  mutating func clearOutputMode() {_uniqueStorage()._outputMode = nil}

  /// (Optional) Timeout configuration for groups that do not receive data for a while.
  var timeoutConf: String {
    get {return _storage._timeoutConf ?? String()}
    set {_uniqueStorage()._timeoutConf = newValue}
  }
  /// Returns true if `timeoutConf` has been explicitly set.
  var hasTimeoutConf: Bool {return _storage._timeoutConf != nil}
  /// Clears the value of `timeoutConf`. Subsequent reads from it will return its default value.
  mutating func clearTimeoutConf() {_uniqueStorage()._timeoutConf = nil}

  /// (Optional) The schema for the grouped state.
  var stateSchema: Spark_Connect_DataType {
    get {return _storage._stateSchema ?? Spark_Connect_DataType()}
    set {_uniqueStorage()._stateSchema = newValue}
  }
  /// Returns true if `stateSchema` has been explicitly set.
  var hasStateSchema: Bool {return _storage._stateSchema != nil}
  /// Clears the value of `stateSchema`. Subsequent reads from it will return its default value.
  mutating func clearStateSchema() {_uniqueStorage()._stateSchema = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

struct Spark_Connect_CoGroupMap: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) One input relation for CoGroup Map API - applyInPandas.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// Expressions for grouping keys of the first input relation.
  var inputGroupingExpressions: [Spark_Connect_Expression] {
    get {return _storage._inputGroupingExpressions}
    set {_uniqueStorage()._inputGroupingExpressions = newValue}
  }

  /// (Required) The other input relation.
  var other: Spark_Connect_Relation {
    get {return _storage._other ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._other = newValue}
  }
  /// Returns true if `other` has been explicitly set.
  var hasOther: Bool {return _storage._other != nil}
  /// Clears the value of `other`. Subsequent reads from it will return its default value.
  mutating func clearOther() {_uniqueStorage()._other = nil}

  /// Expressions for grouping keys of the other input relation.
  var otherGroupingExpressions: [Spark_Connect_Expression] {
    get {return _storage._otherGroupingExpressions}
    set {_uniqueStorage()._otherGroupingExpressions = newValue}
  }

  /// (Required) Input user-defined function.
  var `func`: Spark_Connect_CommonInlineUserDefinedFunction {
    get {return _storage._func ?? Spark_Connect_CommonInlineUserDefinedFunction()}
    set {_uniqueStorage()._func = newValue}
  }
  /// Returns true if ``func`` has been explicitly set.
  var hasFunc: Bool {return _storage._func != nil}
  /// Clears the value of ``func``. Subsequent reads from it will return its default value.
  mutating func clearFunc() {_uniqueStorage()._func = nil}

  /// (Optional) Expressions for sorting. Only used by Scala Sorted CoGroup Map API.
  var inputSortingExpressions: [Spark_Connect_Expression] {
    get {return _storage._inputSortingExpressions}
    set {_uniqueStorage()._inputSortingExpressions = newValue}
  }

  /// (Optional) Expressions for sorting. Only used by Scala Sorted CoGroup Map API.
  var otherSortingExpressions: [Spark_Connect_Expression] {
    get {return _storage._otherSortingExpressions}
    set {_uniqueStorage()._otherSortingExpressions = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

struct Spark_Connect_ApplyInPandasWithState: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Input relation for applyInPandasWithState.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) Expressions for grouping keys.
  var groupingExpressions: [Spark_Connect_Expression] {
    get {return _storage._groupingExpressions}
    set {_uniqueStorage()._groupingExpressions = newValue}
  }

  /// (Required) Input user-defined function.
  var `func`: Spark_Connect_CommonInlineUserDefinedFunction {
    get {return _storage._func ?? Spark_Connect_CommonInlineUserDefinedFunction()}
    set {_uniqueStorage()._func = newValue}
  }
  /// Returns true if ``func`` has been explicitly set.
  var hasFunc: Bool {return _storage._func != nil}
  /// Clears the value of ``func``. Subsequent reads from it will return its default value.
  mutating func clearFunc() {_uniqueStorage()._func = nil}

  /// (Required) Schema for the output DataFrame.
  var outputSchema: String {
    get {return _storage._outputSchema}
    set {_uniqueStorage()._outputSchema = newValue}
  }

  /// (Required) Schema for the state.
  var stateSchema: String {
    get {return _storage._stateSchema}
    set {_uniqueStorage()._stateSchema = newValue}
  }

  /// (Required) The output mode of the function.
  var outputMode: String {
    get {return _storage._outputMode}
    set {_uniqueStorage()._outputMode = newValue}
  }

  /// (Required) Timeout configuration for groups that do not receive data for a while.
  var timeoutConf: String {
    get {return _storage._timeoutConf}
    set {_uniqueStorage()._timeoutConf = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

struct Spark_Connect_CommonInlineUserDefinedTableFunction: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Name of the user-defined table function.
  var functionName: String = String()

  /// (Optional) Whether the user-defined table function is deterministic.
  var deterministic: Bool = false

  /// (Optional) Function input arguments. Empty arguments are allowed.
  var arguments: [Spark_Connect_Expression] = []

  /// (Required) Type of the user-defined table function.
  var function: Spark_Connect_CommonInlineUserDefinedTableFunction.OneOf_Function? = nil

  var pythonUdtf: Spark_Connect_PythonUDTF {
    get {
      if case .pythonUdtf(let v)? = function {return v}
      return Spark_Connect_PythonUDTF()
    }
    set {function = .pythonUdtf(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  /// (Required) Type of the user-defined table function.
  enum OneOf_Function: Equatable, Sendable {
    case pythonUdtf(Spark_Connect_PythonUDTF)

  }

  init() {}
}

struct Spark_Connect_PythonUDTF: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Optional) Return type of the Python UDTF.
  var returnType: Spark_Connect_DataType {
    get {return _returnType ?? Spark_Connect_DataType()}
    set {_returnType = newValue}
  }
  /// Returns true if `returnType` has been explicitly set.
  var hasReturnType: Bool {return self._returnType != nil}
  /// Clears the value of `returnType`. Subsequent reads from it will return its default value.
  mutating func clearReturnType() {self._returnType = nil}

  /// (Required) EvalType of the Python UDTF.
  var evalType: Int32 = 0

  /// (Required) The encoded commands of the Python UDTF.
  var command: Data = Data()

  /// (Required) Python version being used in the client.
  var pythonVer: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _returnType: Spark_Connect_DataType? = nil
}

struct Spark_Connect_CommonInlineUserDefinedDataSource: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Name of the data source.
  var name: String = String()

  /// (Required) The data source type.
  var dataSource: Spark_Connect_CommonInlineUserDefinedDataSource.OneOf_DataSource? = nil

  var pythonDataSource: Spark_Connect_PythonDataSource {
    get {
      if case .pythonDataSource(let v)? = dataSource {return v}
      return Spark_Connect_PythonDataSource()
    }
    set {dataSource = .pythonDataSource(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  /// (Required) The data source type.
  enum OneOf_DataSource: Equatable, Sendable {
    case pythonDataSource(Spark_Connect_PythonDataSource)

  }

  init() {}
}

struct Spark_Connect_PythonDataSource: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The encoded commands of the Python data source.
  var command: Data = Data()

  /// (Required) Python version being used in the client.
  var pythonVer: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// Collect arbitrary (named) metrics from a dataset.
struct Spark_Connect_CollectMetrics: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The input relation.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) Name of the metrics.
  var name: String {
    get {return _storage._name}
    set {_uniqueStorage()._name = newValue}
  }

  /// (Required) The metric sequence.
  var metrics: [Spark_Connect_Expression] {
    get {return _storage._metrics}
    set {_uniqueStorage()._metrics = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

struct Spark_Connect_Parse: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Input relation to Parse. The input is expected to have single text column.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  /// (Required) The expected format of the text.
  var format: Spark_Connect_Parse.ParseFormat {
    get {return _storage._format}
    set {_uniqueStorage()._format = newValue}
  }

  /// (Optional) DataType representing the schema. If not set, Spark will infer the schema.
  var schema: Spark_Connect_DataType {
    get {return _storage._schema ?? Spark_Connect_DataType()}
    set {_uniqueStorage()._schema = newValue}
  }
  /// Returns true if `schema` has been explicitly set.
  var hasSchema: Bool {return _storage._schema != nil}
  /// Clears the value of `schema`. Subsequent reads from it will return its default value.
  mutating func clearSchema() {_uniqueStorage()._schema = nil}

  /// Options for the csv/json parser. The map key is case insensitive.
  var options: Dictionary<String,String> {
    get {return _storage._options}
    set {_uniqueStorage()._options = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum ParseFormat: SwiftProtobuf.Enum, Swift.CaseIterable {
    typealias RawValue = Int
    case unspecified // = 0
    case csv // = 1
    case json // = 2
    case UNRECOGNIZED(Int)

    init() {
      self = .unspecified
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .unspecified
      case 1: self = .csv
      case 2: self = .json
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .unspecified: return 0
      case .csv: return 1
      case .json: return 2
      case .UNRECOGNIZED(let i): return i
      }
    }

    // The compiler won't synthesize support with the UNRECOGNIZED case.
    static let allCases: [Spark_Connect_Parse.ParseFormat] = [
      .unspecified,
      .csv,
      .json,
    ]

  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Relation of type [[AsOfJoin]].
///
/// `left` and `right` must be present.
struct Spark_Connect_AsOfJoin: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Left input relation for a Join.
  var left: Spark_Connect_Relation {
    get {return _storage._left ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._left = newValue}
  }
  /// Returns true if `left` has been explicitly set.
  var hasLeft: Bool {return _storage._left != nil}
  /// Clears the value of `left`. Subsequent reads from it will return its default value.
  mutating func clearLeft() {_uniqueStorage()._left = nil}

  /// (Required) Right input relation for a Join.
  var right: Spark_Connect_Relation {
    get {return _storage._right ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._right = newValue}
  }
  /// Returns true if `right` has been explicitly set.
  var hasRight: Bool {return _storage._right != nil}
  /// Clears the value of `right`. Subsequent reads from it will return its default value.
  mutating func clearRight() {_uniqueStorage()._right = nil}

  /// (Required) Field to join on in left DataFrame
  var leftAsOf: Spark_Connect_Expression {
    get {return _storage._leftAsOf ?? Spark_Connect_Expression()}
    set {_uniqueStorage()._leftAsOf = newValue}
  }
  /// Returns true if `leftAsOf` has been explicitly set.
  var hasLeftAsOf: Bool {return _storage._leftAsOf != nil}
  /// Clears the value of `leftAsOf`. Subsequent reads from it will return its default value.
  mutating func clearLeftAsOf() {_uniqueStorage()._leftAsOf = nil}

  /// (Required) Field to join on in right DataFrame
  var rightAsOf: Spark_Connect_Expression {
    get {return _storage._rightAsOf ?? Spark_Connect_Expression()}
    set {_uniqueStorage()._rightAsOf = newValue}
  }
  /// Returns true if `rightAsOf` has been explicitly set.
  var hasRightAsOf: Bool {return _storage._rightAsOf != nil}
  /// Clears the value of `rightAsOf`. Subsequent reads from it will return its default value.
  mutating func clearRightAsOf() {_uniqueStorage()._rightAsOf = nil}

  /// (Optional) The join condition. Could be unset when `using_columns` is utilized.
  ///
  /// This field does not co-exist with using_columns.
  var joinExpr: Spark_Connect_Expression {
    get {return _storage._joinExpr ?? Spark_Connect_Expression()}
    set {_uniqueStorage()._joinExpr = newValue}
  }
  /// Returns true if `joinExpr` has been explicitly set.
  var hasJoinExpr: Bool {return _storage._joinExpr != nil}
  /// Clears the value of `joinExpr`. Subsequent reads from it will return its default value.
  mutating func clearJoinExpr() {_uniqueStorage()._joinExpr = nil}

  /// Optional. using_columns provides a list of columns that should present on both sides of
  /// the join inputs that this Join will join on. For example A JOIN B USING col_name is
  /// equivalent to A JOIN B on A.col_name = B.col_name.
  ///
  /// This field does not co-exist with join_condition.
  var usingColumns: [String] {
    get {return _storage._usingColumns}
    set {_uniqueStorage()._usingColumns = newValue}
  }

  /// (Required) The join type.
  var joinType: String {
    get {return _storage._joinType}
    set {_uniqueStorage()._joinType = newValue}
  }

  /// (Optional) The asof tolerance within this range.
  var tolerance: Spark_Connect_Expression {
    get {return _storage._tolerance ?? Spark_Connect_Expression()}
    set {_uniqueStorage()._tolerance = newValue}
  }
  /// Returns true if `tolerance` has been explicitly set.
  var hasTolerance: Bool {return _storage._tolerance != nil}
  /// Clears the value of `tolerance`. Subsequent reads from it will return its default value.
  mutating func clearTolerance() {_uniqueStorage()._tolerance = nil}

  /// (Required) Whether allow matching with the same value or not.
  var allowExactMatches: Bool {
    get {return _storage._allowExactMatches}
    set {_uniqueStorage()._allowExactMatches = newValue}
  }

  /// (Required) Whether to search for prior, subsequent, or closest matches.
  var direction: String {
    get {return _storage._direction}
    set {_uniqueStorage()._direction = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Relation of type [[LateralJoin]].
///
/// `left` and `right` must be present.
struct Spark_Connect_LateralJoin: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Left input relation for a Join.
  var left: Spark_Connect_Relation {
    get {return _storage._left ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._left = newValue}
  }
  /// Returns true if `left` has been explicitly set.
  var hasLeft: Bool {return _storage._left != nil}
  /// Clears the value of `left`. Subsequent reads from it will return its default value.
  mutating func clearLeft() {_uniqueStorage()._left = nil}

  /// (Required) Right input relation for a Join.
  var right: Spark_Connect_Relation {
    get {return _storage._right ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._right = newValue}
  }
  /// Returns true if `right` has been explicitly set.
  var hasRight: Bool {return _storage._right != nil}
  /// Clears the value of `right`. Subsequent reads from it will return its default value.
  mutating func clearRight() {_uniqueStorage()._right = nil}

  /// (Optional) The join condition.
  var joinCondition: Spark_Connect_Expression {
    get {return _storage._joinCondition ?? Spark_Connect_Expression()}
    set {_uniqueStorage()._joinCondition = newValue}
  }
  /// Returns true if `joinCondition` has been explicitly set.
  var hasJoinCondition: Bool {return _storage._joinCondition != nil}
  /// Clears the value of `joinCondition`. Subsequent reads from it will return its default value.
  mutating func clearJoinCondition() {_uniqueStorage()._joinCondition = nil}

  /// (Required) The join type.
  var joinType: Spark_Connect_Join.JoinType {
    get {return _storage._joinType}
    set {_uniqueStorage()._joinType = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "spark.connect"

extension Spark_Connect_Relation: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Relation"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "common"),
    2: .same(proto: "read"),
    3: .same(proto: "project"),
    4: .same(proto: "filter"),
    5: .same(proto: "join"),
    6: .standard(proto: "set_op"),
    7: .same(proto: "sort"),
    8: .same(proto: "limit"),
    9: .same(proto: "aggregate"),
    10: .same(proto: "sql"),
    11: .standard(proto: "local_relation"),
    12: .same(proto: "sample"),
    13: .same(proto: "offset"),
    14: .same(proto: "deduplicate"),
    15: .same(proto: "range"),
    16: .standard(proto: "subquery_alias"),
    17: .same(proto: "repartition"),
    18: .standard(proto: "to_df"),
    19: .standard(proto: "with_columns_renamed"),
    20: .standard(proto: "show_string"),
    21: .same(proto: "drop"),
    22: .same(proto: "tail"),
    23: .standard(proto: "with_columns"),
    24: .same(proto: "hint"),
    25: .same(proto: "unpivot"),
    26: .standard(proto: "to_schema"),
    27: .standard(proto: "repartition_by_expression"),
    28: .standard(proto: "map_partitions"),
    29: .standard(proto: "collect_metrics"),
    30: .same(proto: "parse"),
    31: .standard(proto: "group_map"),
    32: .standard(proto: "co_group_map"),
    33: .standard(proto: "with_watermark"),
    34: .standard(proto: "apply_in_pandas_with_state"),
    35: .standard(proto: "html_string"),
    36: .standard(proto: "cached_local_relation"),
    37: .standard(proto: "cached_remote_relation"),
    38: .standard(proto: "common_inline_user_defined_table_function"),
    39: .standard(proto: "as_of_join"),
    40: .standard(proto: "common_inline_user_defined_data_source"),
    41: .standard(proto: "with_relations"),
    42: .same(proto: "transpose"),
    43: .standard(proto: "unresolved_table_valued_function"),
    44: .standard(proto: "lateral_join"),
    90: .standard(proto: "fill_na"),
    91: .standard(proto: "drop_na"),
    92: .same(proto: "replace"),
    100: .same(proto: "summary"),
    101: .same(proto: "crosstab"),
    102: .same(proto: "describe"),
    103: .same(proto: "cov"),
    104: .same(proto: "corr"),
    105: .standard(proto: "approx_quantile"),
    106: .standard(proto: "freq_items"),
    107: .standard(proto: "sample_by"),
    200: .same(proto: "catalog"),
    300: .standard(proto: "ml_relation"),
    998: .same(proto: "extension"),
    999: .same(proto: "unknown"),
  ]

  fileprivate class _StorageClass {
    var _common: Spark_Connect_RelationCommon? = nil
    var _relType: Spark_Connect_Relation.OneOf_RelType?

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _common = source._common
      _relType = source._relType
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._common) }()
        case 2: try {
          var v: Spark_Connect_Read?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .read(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .read(v)
          }
        }()
        case 3: try {
          var v: Spark_Connect_Project?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .project(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .project(v)
          }
        }()
        case 4: try {
          var v: Spark_Connect_Filter?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .filter(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .filter(v)
          }
        }()
        case 5: try {
          var v: Spark_Connect_Join?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .join(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .join(v)
          }
        }()
        case 6: try {
          var v: Spark_Connect_SetOperation?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .setOp(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .setOp(v)
          }
        }()
        case 7: try {
          var v: Spark_Connect_Sort?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .sort(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .sort(v)
          }
        }()
        case 8: try {
          var v: Spark_Connect_Limit?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .limit(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .limit(v)
          }
        }()
        case 9: try {
          var v: Spark_Connect_Aggregate?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .aggregate(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .aggregate(v)
          }
        }()
        case 10: try {
          var v: Spark_Connect_SQL?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .sql(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .sql(v)
          }
        }()
        case 11: try {
          var v: Spark_Connect_LocalRelation?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .localRelation(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .localRelation(v)
          }
        }()
        case 12: try {
          var v: Spark_Connect_Sample?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .sample(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .sample(v)
          }
        }()
        case 13: try {
          var v: Spark_Connect_Offset?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .offset(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .offset(v)
          }
        }()
        case 14: try {
          var v: Spark_Connect_Deduplicate?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .deduplicate(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .deduplicate(v)
          }
        }()
        case 15: try {
          var v: Spark_Connect_Range?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .range(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .range(v)
          }
        }()
        case 16: try {
          var v: Spark_Connect_SubqueryAlias?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .subqueryAlias(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .subqueryAlias(v)
          }
        }()
        case 17: try {
          var v: Spark_Connect_Repartition?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .repartition(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .repartition(v)
          }
        }()
        case 18: try {
          var v: Spark_Connect_ToDF?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .toDf(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .toDf(v)
          }
        }()
        case 19: try {
          var v: Spark_Connect_WithColumnsRenamed?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .withColumnsRenamed(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .withColumnsRenamed(v)
          }
        }()
        case 20: try {
          var v: Spark_Connect_ShowString?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .showString(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .showString(v)
          }
        }()
        case 21: try {
          var v: Spark_Connect_Drop?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .drop(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .drop(v)
          }
        }()
        case 22: try {
          var v: Spark_Connect_Tail?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .tail(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .tail(v)
          }
        }()
        case 23: try {
          var v: Spark_Connect_WithColumns?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .withColumns(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .withColumns(v)
          }
        }()
        case 24: try {
          var v: Spark_Connect_Hint?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .hint(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .hint(v)
          }
        }()
        case 25: try {
          var v: Spark_Connect_Unpivot?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .unpivot(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .unpivot(v)
          }
        }()
        case 26: try {
          var v: Spark_Connect_ToSchema?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .toSchema(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .toSchema(v)
          }
        }()
        case 27: try {
          var v: Spark_Connect_RepartitionByExpression?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .repartitionByExpression(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .repartitionByExpression(v)
          }
        }()
        case 28: try {
          var v: Spark_Connect_MapPartitions?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .mapPartitions(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .mapPartitions(v)
          }
        }()
        case 29: try {
          var v: Spark_Connect_CollectMetrics?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .collectMetrics(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .collectMetrics(v)
          }
        }()
        case 30: try {
          var v: Spark_Connect_Parse?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .parse(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .parse(v)
          }
        }()
        case 31: try {
          var v: Spark_Connect_GroupMap?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .groupMap(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .groupMap(v)
          }
        }()
        case 32: try {
          var v: Spark_Connect_CoGroupMap?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .coGroupMap(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .coGroupMap(v)
          }
        }()
        case 33: try {
          var v: Spark_Connect_WithWatermark?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .withWatermark(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .withWatermark(v)
          }
        }()
        case 34: try {
          var v: Spark_Connect_ApplyInPandasWithState?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .applyInPandasWithState(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .applyInPandasWithState(v)
          }
        }()
        case 35: try {
          var v: Spark_Connect_HtmlString?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .htmlString(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .htmlString(v)
          }
        }()
        case 36: try {
          var v: Spark_Connect_CachedLocalRelation?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .cachedLocalRelation(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .cachedLocalRelation(v)
          }
        }()
        case 37: try {
          var v: Spark_Connect_CachedRemoteRelation?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .cachedRemoteRelation(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .cachedRemoteRelation(v)
          }
        }()
        case 38: try {
          var v: Spark_Connect_CommonInlineUserDefinedTableFunction?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .commonInlineUserDefinedTableFunction(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .commonInlineUserDefinedTableFunction(v)
          }
        }()
        case 39: try {
          var v: Spark_Connect_AsOfJoin?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .asOfJoin(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .asOfJoin(v)
          }
        }()
        case 40: try {
          var v: Spark_Connect_CommonInlineUserDefinedDataSource?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .commonInlineUserDefinedDataSource(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .commonInlineUserDefinedDataSource(v)
          }
        }()
        case 41: try {
          var v: Spark_Connect_WithRelations?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .withRelations(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .withRelations(v)
          }
        }()
        case 42: try {
          var v: Spark_Connect_Transpose?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .transpose(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .transpose(v)
          }
        }()
        case 43: try {
          var v: Spark_Connect_UnresolvedTableValuedFunction?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .unresolvedTableValuedFunction(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .unresolvedTableValuedFunction(v)
          }
        }()
        case 44: try {
          var v: Spark_Connect_LateralJoin?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .lateralJoin(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .lateralJoin(v)
          }
        }()
        case 90: try {
          var v: Spark_Connect_NAFill?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .fillNa(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .fillNa(v)
          }
        }()
        case 91: try {
          var v: Spark_Connect_NADrop?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .dropNa(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .dropNa(v)
          }
        }()
        case 92: try {
          var v: Spark_Connect_NAReplace?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .replace(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .replace(v)
          }
        }()
        case 100: try {
          var v: Spark_Connect_StatSummary?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .summary(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .summary(v)
          }
        }()
        case 101: try {
          var v: Spark_Connect_StatCrosstab?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .crosstab(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .crosstab(v)
          }
        }()
        case 102: try {
          var v: Spark_Connect_StatDescribe?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .describe(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .describe(v)
          }
        }()
        case 103: try {
          var v: Spark_Connect_StatCov?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .cov(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .cov(v)
          }
        }()
        case 104: try {
          var v: Spark_Connect_StatCorr?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .corr(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .corr(v)
          }
        }()
        case 105: try {
          var v: Spark_Connect_StatApproxQuantile?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .approxQuantile(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .approxQuantile(v)
          }
        }()
        case 106: try {
          var v: Spark_Connect_StatFreqItems?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .freqItems(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .freqItems(v)
          }
        }()
        case 107: try {
          var v: Spark_Connect_StatSampleBy?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .sampleBy(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .sampleBy(v)
          }
        }()
        case 200: try {
          var v: Spark_Connect_Catalog?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .catalog(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .catalog(v)
          }
        }()
        case 300: try {
          var v: Spark_Connect_MlRelation?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .mlRelation(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .mlRelation(v)
          }
        }()
        case 998: try {
          var v: SwiftProtobuf.Google_Protobuf_Any?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .extension(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .extension(v)
          }
        }()
        case 999: try {
          var v: Spark_Connect_Unknown?
          var hadOneofValue = false
          if let current = _storage._relType {
            hadOneofValue = true
            if case .unknown(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._relType = .unknown(v)
          }
        }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._common {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      switch _storage._relType {
      case .read?: try {
        guard case .read(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      }()
      case .project?: try {
        guard case .project(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      }()
      case .filter?: try {
        guard case .filter(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
      }()
      case .join?: try {
        guard case .join(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
      }()
      case .setOp?: try {
        guard case .setOp(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 6)
      }()
      case .sort?: try {
        guard case .sort(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 7)
      }()
      case .limit?: try {
        guard case .limit(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 8)
      }()
      case .aggregate?: try {
        guard case .aggregate(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 9)
      }()
      case .sql?: try {
        guard case .sql(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
      }()
      case .localRelation?: try {
        guard case .localRelation(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 11)
      }()
      case .sample?: try {
        guard case .sample(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 12)
      }()
      case .offset?: try {
        guard case .offset(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 13)
      }()
      case .deduplicate?: try {
        guard case .deduplicate(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 14)
      }()
      case .range?: try {
        guard case .range(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 15)
      }()
      case .subqueryAlias?: try {
        guard case .subqueryAlias(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 16)
      }()
      case .repartition?: try {
        guard case .repartition(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 17)
      }()
      case .toDf?: try {
        guard case .toDf(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 18)
      }()
      case .withColumnsRenamed?: try {
        guard case .withColumnsRenamed(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 19)
      }()
      case .showString?: try {
        guard case .showString(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 20)
      }()
      case .drop?: try {
        guard case .drop(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 21)
      }()
      case .tail?: try {
        guard case .tail(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 22)
      }()
      case .withColumns?: try {
        guard case .withColumns(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 23)
      }()
      case .hint?: try {
        guard case .hint(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 24)
      }()
      case .unpivot?: try {
        guard case .unpivot(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 25)
      }()
      case .toSchema?: try {
        guard case .toSchema(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 26)
      }()
      case .repartitionByExpression?: try {
        guard case .repartitionByExpression(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 27)
      }()
      case .mapPartitions?: try {
        guard case .mapPartitions(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 28)
      }()
      case .collectMetrics?: try {
        guard case .collectMetrics(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 29)
      }()
      case .parse?: try {
        guard case .parse(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 30)
      }()
      case .groupMap?: try {
        guard case .groupMap(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 31)
      }()
      case .coGroupMap?: try {
        guard case .coGroupMap(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 32)
      }()
      case .withWatermark?: try {
        guard case .withWatermark(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 33)
      }()
      case .applyInPandasWithState?: try {
        guard case .applyInPandasWithState(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 34)
      }()
      case .htmlString?: try {
        guard case .htmlString(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 35)
      }()
      case .cachedLocalRelation?: try {
        guard case .cachedLocalRelation(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 36)
      }()
      case .cachedRemoteRelation?: try {
        guard case .cachedRemoteRelation(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 37)
      }()
      case .commonInlineUserDefinedTableFunction?: try {
        guard case .commonInlineUserDefinedTableFunction(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 38)
      }()
      case .asOfJoin?: try {
        guard case .asOfJoin(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 39)
      }()
      case .commonInlineUserDefinedDataSource?: try {
        guard case .commonInlineUserDefinedDataSource(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 40)
      }()
      case .withRelations?: try {
        guard case .withRelations(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 41)
      }()
      case .transpose?: try {
        guard case .transpose(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 42)
      }()
      case .unresolvedTableValuedFunction?: try {
        guard case .unresolvedTableValuedFunction(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 43)
      }()
      case .lateralJoin?: try {
        guard case .lateralJoin(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 44)
      }()
      case .fillNa?: try {
        guard case .fillNa(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 90)
      }()
      case .dropNa?: try {
        guard case .dropNa(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 91)
      }()
      case .replace?: try {
        guard case .replace(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 92)
      }()
      case .summary?: try {
        guard case .summary(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 100)
      }()
      case .crosstab?: try {
        guard case .crosstab(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 101)
      }()
      case .describe?: try {
        guard case .describe(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 102)
      }()
      case .cov?: try {
        guard case .cov(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 103)
      }()
      case .corr?: try {
        guard case .corr(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 104)
      }()
      case .approxQuantile?: try {
        guard case .approxQuantile(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 105)
      }()
      case .freqItems?: try {
        guard case .freqItems(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 106)
      }()
      case .sampleBy?: try {
        guard case .sampleBy(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 107)
      }()
      case .catalog?: try {
        guard case .catalog(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 200)
      }()
      case .mlRelation?: try {
        guard case .mlRelation(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 300)
      }()
      case .extension?: try {
        guard case .extension(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 998)
      }()
      case .unknown?: try {
        guard case .unknown(let v)? = _storage._relType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 999)
      }()
      case nil: break
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Relation, rhs: Spark_Connect_Relation) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._common != rhs_storage._common {return false}
        if _storage._relType != rhs_storage._relType {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_MlRelation: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".MlRelation"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "transform"),
    2: .same(proto: "fetch"),
  ]

  fileprivate class _StorageClass {
    var _mlType: Spark_Connect_MlRelation.OneOf_MlType?

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _mlType = source._mlType
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try {
          var v: Spark_Connect_MlRelation.Transform?
          var hadOneofValue = false
          if let current = _storage._mlType {
            hadOneofValue = true
            if case .transform(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._mlType = .transform(v)
          }
        }()
        case 2: try {
          var v: Spark_Connect_Fetch?
          var hadOneofValue = false
          if let current = _storage._mlType {
            hadOneofValue = true
            if case .fetch(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._mlType = .fetch(v)
          }
        }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      switch _storage._mlType {
      case .transform?: try {
        guard case .transform(let v)? = _storage._mlType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      }()
      case .fetch?: try {
        guard case .fetch(let v)? = _storage._mlType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      }()
      case nil: break
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_MlRelation, rhs: Spark_Connect_MlRelation) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._mlType != rhs_storage._mlType {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_MlRelation.Transform: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_MlRelation.protoMessageName + ".Transform"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "obj_ref"),
    2: .same(proto: "transformer"),
    3: .same(proto: "input"),
    4: .same(proto: "params"),
  ]

  fileprivate class _StorageClass {
    var _operator: Spark_Connect_MlRelation.Transform.OneOf_Operator?
    var _input: Spark_Connect_Relation? = nil
    var _params: Spark_Connect_MlParams? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _operator = source._operator
      _input = source._input
      _params = source._params
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try {
          var v: Spark_Connect_ObjectRef?
          var hadOneofValue = false
          if let current = _storage._operator {
            hadOneofValue = true
            if case .objRef(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._operator = .objRef(v)
          }
        }()
        case 2: try {
          var v: Spark_Connect_MlOperator?
          var hadOneofValue = false
          if let current = _storage._operator {
            hadOneofValue = true
            if case .transformer(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._operator = .transformer(v)
          }
        }()
        case 3: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 4: try { try decoder.decodeSingularMessageField(value: &_storage._params) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      switch _storage._operator {
      case .objRef?: try {
        guard case .objRef(let v)? = _storage._operator else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      }()
      case .transformer?: try {
        guard case .transformer(let v)? = _storage._operator else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      }()
      case nil: break
      }
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      } }()
      try { if let v = _storage._params {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_MlRelation.Transform, rhs: Spark_Connect_MlRelation.Transform) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._operator != rhs_storage._operator {return false}
        if _storage._input != rhs_storage._input {return false}
        if _storage._params != rhs_storage._params {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Fetch: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Fetch"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "obj_ref"),
    2: .same(proto: "methods"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._objRef) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.methods) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._objRef {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    if !self.methods.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.methods, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Fetch, rhs: Spark_Connect_Fetch) -> Bool {
    if lhs._objRef != rhs._objRef {return false}
    if lhs.methods != rhs.methods {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Fetch.Method: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_Fetch.protoMessageName + ".Method"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "method"),
    2: .same(proto: "args"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.method) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.args) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.method.isEmpty {
      try visitor.visitSingularStringField(value: self.method, fieldNumber: 1)
    }
    if !self.args.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.args, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Fetch.Method, rhs: Spark_Connect_Fetch.Method) -> Bool {
    if lhs.method != rhs.method {return false}
    if lhs.args != rhs.args {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Fetch.Method.Args: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_Fetch.Method.protoMessageName + ".Args"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "param"),
    2: .same(proto: "input"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Spark_Connect_Expression.Literal?
        var hadOneofValue = false
        if let current = self.argsType {
          hadOneofValue = true
          if case .param(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.argsType = .param(v)
        }
      }()
      case 2: try {
        var v: Spark_Connect_Relation?
        var hadOneofValue = false
        if let current = self.argsType {
          hadOneofValue = true
          if case .input(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.argsType = .input(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.argsType {
    case .param?: try {
      guard case .param(let v)? = self.argsType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .input?: try {
      guard case .input(let v)? = self.argsType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Fetch.Method.Args, rhs: Spark_Connect_Fetch.Method.Args) -> Bool {
    if lhs.argsType != rhs.argsType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Unknown: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Unknown"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    // Load everything into unknown fields
    while try decoder.nextFieldNumber() != nil {}
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Unknown, rhs: Spark_Connect_Unknown) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_RelationCommon: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".RelationCommon"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "source_info"),
    2: .standard(proto: "plan_id"),
    3: .same(proto: "origin"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.sourceInfo) }()
      case 2: try { try decoder.decodeSingularInt64Field(value: &self._planID) }()
      case 3: try { try decoder.decodeSingularMessageField(value: &self._origin) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.sourceInfo.isEmpty {
      try visitor.visitSingularStringField(value: self.sourceInfo, fieldNumber: 1)
    }
    try { if let v = self._planID {
      try visitor.visitSingularInt64Field(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._origin {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_RelationCommon, rhs: Spark_Connect_RelationCommon) -> Bool {
    if lhs.sourceInfo != rhs.sourceInfo {return false}
    if lhs._planID != rhs._planID {return false}
    if lhs._origin != rhs._origin {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_SQL: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SQL"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "query"),
    2: .same(proto: "args"),
    3: .standard(proto: "pos_args"),
    4: .standard(proto: "named_arguments"),
    5: .standard(proto: "pos_arguments"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.query) }()
      case 2: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_Expression.Literal>.self, value: &self.args) }()
      case 3: try { try decoder.decodeRepeatedMessageField(value: &self.posArgs) }()
      case 4: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_Expression>.self, value: &self.namedArguments) }()
      case 5: try { try decoder.decodeRepeatedMessageField(value: &self.posArguments) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.query.isEmpty {
      try visitor.visitSingularStringField(value: self.query, fieldNumber: 1)
    }
    if !self.args.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_Expression.Literal>.self, value: self.args, fieldNumber: 2)
    }
    if !self.posArgs.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.posArgs, fieldNumber: 3)
    }
    if !self.namedArguments.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_Expression>.self, value: self.namedArguments, fieldNumber: 4)
    }
    if !self.posArguments.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.posArguments, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_SQL, rhs: Spark_Connect_SQL) -> Bool {
    if lhs.query != rhs.query {return false}
    if lhs.args != rhs.args {return false}
    if lhs.posArgs != rhs.posArgs {return false}
    if lhs.namedArguments != rhs.namedArguments {return false}
    if lhs.posArguments != rhs.posArguments {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_WithRelations: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".WithRelations"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "root"),
    2: .same(proto: "references"),
  ]

  fileprivate class _StorageClass {
    var _root: Spark_Connect_Relation? = nil
    var _references: [Spark_Connect_Relation] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _root = source._root
      _references = source._references
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._root) }()
        case 2: try { try decoder.decodeRepeatedMessageField(value: &_storage._references) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._root {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._references.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._references, fieldNumber: 2)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_WithRelations, rhs: Spark_Connect_WithRelations) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._root != rhs_storage._root {return false}
        if _storage._references != rhs_storage._references {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Read: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Read"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "named_table"),
    2: .standard(proto: "data_source"),
    3: .standard(proto: "is_streaming"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Spark_Connect_Read.NamedTable?
        var hadOneofValue = false
        if let current = self.readType {
          hadOneofValue = true
          if case .namedTable(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.readType = .namedTable(v)
        }
      }()
      case 2: try {
        var v: Spark_Connect_Read.DataSource?
        var hadOneofValue = false
        if let current = self.readType {
          hadOneofValue = true
          if case .dataSource(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.readType = .dataSource(v)
        }
      }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.isStreaming) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.readType {
    case .namedTable?: try {
      guard case .namedTable(let v)? = self.readType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .dataSource?: try {
      guard case .dataSource(let v)? = self.readType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case nil: break
    }
    if self.isStreaming != false {
      try visitor.visitSingularBoolField(value: self.isStreaming, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Read, rhs: Spark_Connect_Read) -> Bool {
    if lhs.readType != rhs.readType {return false}
    if lhs.isStreaming != rhs.isStreaming {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Read.NamedTable: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_Read.protoMessageName + ".NamedTable"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "unparsed_identifier"),
    2: .same(proto: "options"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.unparsedIdentifier) }()
      case 2: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &self.options) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.unparsedIdentifier.isEmpty {
      try visitor.visitSingularStringField(value: self.unparsedIdentifier, fieldNumber: 1)
    }
    if !self.options.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: self.options, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Read.NamedTable, rhs: Spark_Connect_Read.NamedTable) -> Bool {
    if lhs.unparsedIdentifier != rhs.unparsedIdentifier {return false}
    if lhs.options != rhs.options {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Read.DataSource: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_Read.protoMessageName + ".DataSource"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "format"),
    2: .same(proto: "schema"),
    3: .same(proto: "options"),
    4: .same(proto: "paths"),
    5: .same(proto: "predicates"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._format) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._schema) }()
      case 3: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &self.options) }()
      case 4: try { try decoder.decodeRepeatedStringField(value: &self.paths) }()
      case 5: try { try decoder.decodeRepeatedStringField(value: &self.predicates) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._format {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._schema {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    if !self.options.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: self.options, fieldNumber: 3)
    }
    if !self.paths.isEmpty {
      try visitor.visitRepeatedStringField(value: self.paths, fieldNumber: 4)
    }
    if !self.predicates.isEmpty {
      try visitor.visitRepeatedStringField(value: self.predicates, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Read.DataSource, rhs: Spark_Connect_Read.DataSource) -> Bool {
    if lhs._format != rhs._format {return false}
    if lhs._schema != rhs._schema {return false}
    if lhs.options != rhs.options {return false}
    if lhs.paths != rhs.paths {return false}
    if lhs.predicates != rhs.predicates {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Project: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Project"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    3: .same(proto: "expressions"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _expressions: [Spark_Connect_Expression] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _expressions = source._expressions
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 3: try { try decoder.decodeRepeatedMessageField(value: &_storage._expressions) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._expressions.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._expressions, fieldNumber: 3)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Project, rhs: Spark_Connect_Project) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._expressions != rhs_storage._expressions {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Filter: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Filter"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "condition"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _condition: Spark_Connect_Expression? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _condition = source._condition
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._condition) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      try { if let v = _storage._condition {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Filter, rhs: Spark_Connect_Filter) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._condition != rhs_storage._condition {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Join: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Join"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "left"),
    2: .same(proto: "right"),
    3: .standard(proto: "join_condition"),
    4: .standard(proto: "join_type"),
    5: .standard(proto: "using_columns"),
    6: .standard(proto: "join_data_type"),
  ]

  fileprivate class _StorageClass {
    var _left: Spark_Connect_Relation? = nil
    var _right: Spark_Connect_Relation? = nil
    var _joinCondition: Spark_Connect_Expression? = nil
    var _joinType: Spark_Connect_Join.JoinType = .unspecified
    var _usingColumns: [String] = []
    var _joinDataType: Spark_Connect_Join.JoinDataType? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _left = source._left
      _right = source._right
      _joinCondition = source._joinCondition
      _joinType = source._joinType
      _usingColumns = source._usingColumns
      _joinDataType = source._joinDataType
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._left) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._right) }()
        case 3: try { try decoder.decodeSingularMessageField(value: &_storage._joinCondition) }()
        case 4: try { try decoder.decodeSingularEnumField(value: &_storage._joinType) }()
        case 5: try { try decoder.decodeRepeatedStringField(value: &_storage._usingColumns) }()
        case 6: try { try decoder.decodeSingularMessageField(value: &_storage._joinDataType) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._left {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      try { if let v = _storage._right {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
      try { if let v = _storage._joinCondition {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      } }()
      if _storage._joinType != .unspecified {
        try visitor.visitSingularEnumField(value: _storage._joinType, fieldNumber: 4)
      }
      if !_storage._usingColumns.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._usingColumns, fieldNumber: 5)
      }
      try { if let v = _storage._joinDataType {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 6)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Join, rhs: Spark_Connect_Join) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._left != rhs_storage._left {return false}
        if _storage._right != rhs_storage._right {return false}
        if _storage._joinCondition != rhs_storage._joinCondition {return false}
        if _storage._joinType != rhs_storage._joinType {return false}
        if _storage._usingColumns != rhs_storage._usingColumns {return false}
        if _storage._joinDataType != rhs_storage._joinDataType {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Join.JoinType: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "JOIN_TYPE_UNSPECIFIED"),
    1: .same(proto: "JOIN_TYPE_INNER"),
    2: .same(proto: "JOIN_TYPE_FULL_OUTER"),
    3: .same(proto: "JOIN_TYPE_LEFT_OUTER"),
    4: .same(proto: "JOIN_TYPE_RIGHT_OUTER"),
    5: .same(proto: "JOIN_TYPE_LEFT_ANTI"),
    6: .same(proto: "JOIN_TYPE_LEFT_SEMI"),
    7: .same(proto: "JOIN_TYPE_CROSS"),
  ]
}

extension Spark_Connect_Join.JoinDataType: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_Join.protoMessageName + ".JoinDataType"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "is_left_struct"),
    2: .standard(proto: "is_right_struct"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBoolField(value: &self.isLeftStruct) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.isRightStruct) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.isLeftStruct != false {
      try visitor.visitSingularBoolField(value: self.isLeftStruct, fieldNumber: 1)
    }
    if self.isRightStruct != false {
      try visitor.visitSingularBoolField(value: self.isRightStruct, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Join.JoinDataType, rhs: Spark_Connect_Join.JoinDataType) -> Bool {
    if lhs.isLeftStruct != rhs.isLeftStruct {return false}
    if lhs.isRightStruct != rhs.isRightStruct {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_SetOperation: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SetOperation"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "left_input"),
    2: .standard(proto: "right_input"),
    3: .standard(proto: "set_op_type"),
    4: .standard(proto: "is_all"),
    5: .standard(proto: "by_name"),
    6: .standard(proto: "allow_missing_columns"),
  ]

  fileprivate class _StorageClass {
    var _leftInput: Spark_Connect_Relation? = nil
    var _rightInput: Spark_Connect_Relation? = nil
    var _setOpType: Spark_Connect_SetOperation.SetOpType = .unspecified
    var _isAll: Bool? = nil
    var _byName: Bool? = nil
    var _allowMissingColumns: Bool? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _leftInput = source._leftInput
      _rightInput = source._rightInput
      _setOpType = source._setOpType
      _isAll = source._isAll
      _byName = source._byName
      _allowMissingColumns = source._allowMissingColumns
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._leftInput) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._rightInput) }()
        case 3: try { try decoder.decodeSingularEnumField(value: &_storage._setOpType) }()
        case 4: try { try decoder.decodeSingularBoolField(value: &_storage._isAll) }()
        case 5: try { try decoder.decodeSingularBoolField(value: &_storage._byName) }()
        case 6: try { try decoder.decodeSingularBoolField(value: &_storage._allowMissingColumns) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._leftInput {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      try { if let v = _storage._rightInput {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
      if _storage._setOpType != .unspecified {
        try visitor.visitSingularEnumField(value: _storage._setOpType, fieldNumber: 3)
      }
      try { if let v = _storage._isAll {
        try visitor.visitSingularBoolField(value: v, fieldNumber: 4)
      } }()
      try { if let v = _storage._byName {
        try visitor.visitSingularBoolField(value: v, fieldNumber: 5)
      } }()
      try { if let v = _storage._allowMissingColumns {
        try visitor.visitSingularBoolField(value: v, fieldNumber: 6)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_SetOperation, rhs: Spark_Connect_SetOperation) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._leftInput != rhs_storage._leftInput {return false}
        if _storage._rightInput != rhs_storage._rightInput {return false}
        if _storage._setOpType != rhs_storage._setOpType {return false}
        if _storage._isAll != rhs_storage._isAll {return false}
        if _storage._byName != rhs_storage._byName {return false}
        if _storage._allowMissingColumns != rhs_storage._allowMissingColumns {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_SetOperation.SetOpType: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SET_OP_TYPE_UNSPECIFIED"),
    1: .same(proto: "SET_OP_TYPE_INTERSECT"),
    2: .same(proto: "SET_OP_TYPE_UNION"),
    3: .same(proto: "SET_OP_TYPE_EXCEPT"),
  ]
}

extension Spark_Connect_Limit: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Limit"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "limit"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _limit: Int32 = 0

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _limit = source._limit
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularInt32Field(value: &_storage._limit) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if _storage._limit != 0 {
        try visitor.visitSingularInt32Field(value: _storage._limit, fieldNumber: 2)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Limit, rhs: Spark_Connect_Limit) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._limit != rhs_storage._limit {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Offset: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Offset"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "offset"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _offset: Int32 = 0

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _offset = source._offset
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularInt32Field(value: &_storage._offset) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if _storage._offset != 0 {
        try visitor.visitSingularInt32Field(value: _storage._offset, fieldNumber: 2)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Offset, rhs: Spark_Connect_Offset) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._offset != rhs_storage._offset {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Tail: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Tail"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "limit"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _limit: Int32 = 0

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _limit = source._limit
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularInt32Field(value: &_storage._limit) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if _storage._limit != 0 {
        try visitor.visitSingularInt32Field(value: _storage._limit, fieldNumber: 2)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Tail, rhs: Spark_Connect_Tail) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._limit != rhs_storage._limit {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Aggregate: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Aggregate"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .standard(proto: "group_type"),
    3: .standard(proto: "grouping_expressions"),
    4: .standard(proto: "aggregate_expressions"),
    5: .same(proto: "pivot"),
    6: .standard(proto: "grouping_sets"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _groupType: Spark_Connect_Aggregate.GroupType = .unspecified
    var _groupingExpressions: [Spark_Connect_Expression] = []
    var _aggregateExpressions: [Spark_Connect_Expression] = []
    var _pivot: Spark_Connect_Aggregate.Pivot? = nil
    var _groupingSets: [Spark_Connect_Aggregate.GroupingSets] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _groupType = source._groupType
      _groupingExpressions = source._groupingExpressions
      _aggregateExpressions = source._aggregateExpressions
      _pivot = source._pivot
      _groupingSets = source._groupingSets
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularEnumField(value: &_storage._groupType) }()
        case 3: try { try decoder.decodeRepeatedMessageField(value: &_storage._groupingExpressions) }()
        case 4: try { try decoder.decodeRepeatedMessageField(value: &_storage._aggregateExpressions) }()
        case 5: try { try decoder.decodeSingularMessageField(value: &_storage._pivot) }()
        case 6: try { try decoder.decodeRepeatedMessageField(value: &_storage._groupingSets) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if _storage._groupType != .unspecified {
        try visitor.visitSingularEnumField(value: _storage._groupType, fieldNumber: 2)
      }
      if !_storage._groupingExpressions.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._groupingExpressions, fieldNumber: 3)
      }
      if !_storage._aggregateExpressions.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._aggregateExpressions, fieldNumber: 4)
      }
      try { if let v = _storage._pivot {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
      } }()
      if !_storage._groupingSets.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._groupingSets, fieldNumber: 6)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Aggregate, rhs: Spark_Connect_Aggregate) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._groupType != rhs_storage._groupType {return false}
        if _storage._groupingExpressions != rhs_storage._groupingExpressions {return false}
        if _storage._aggregateExpressions != rhs_storage._aggregateExpressions {return false}
        if _storage._pivot != rhs_storage._pivot {return false}
        if _storage._groupingSets != rhs_storage._groupingSets {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Aggregate.GroupType: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "GROUP_TYPE_UNSPECIFIED"),
    1: .same(proto: "GROUP_TYPE_GROUPBY"),
    2: .same(proto: "GROUP_TYPE_ROLLUP"),
    3: .same(proto: "GROUP_TYPE_CUBE"),
    4: .same(proto: "GROUP_TYPE_PIVOT"),
    5: .same(proto: "GROUP_TYPE_GROUPING_SETS"),
  ]
}

extension Spark_Connect_Aggregate.Pivot: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_Aggregate.protoMessageName + ".Pivot"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "col"),
    2: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._col) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._col {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    if !self.values.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.values, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Aggregate.Pivot, rhs: Spark_Connect_Aggregate.Pivot) -> Bool {
    if lhs._col != rhs._col {return false}
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Aggregate.GroupingSets: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_Aggregate.protoMessageName + ".GroupingSets"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "grouping_set"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.groupingSet) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.groupingSet.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.groupingSet, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Aggregate.GroupingSets, rhs: Spark_Connect_Aggregate.GroupingSets) -> Bool {
    if lhs.groupingSet != rhs.groupingSet {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Sort: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Sort"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "order"),
    3: .standard(proto: "is_global"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _order: [Spark_Connect_Expression.SortOrder] = []
    var _isGlobal: Bool? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _order = source._order
      _isGlobal = source._isGlobal
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedMessageField(value: &_storage._order) }()
        case 3: try { try decoder.decodeSingularBoolField(value: &_storage._isGlobal) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._order.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._order, fieldNumber: 2)
      }
      try { if let v = _storage._isGlobal {
        try visitor.visitSingularBoolField(value: v, fieldNumber: 3)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Sort, rhs: Spark_Connect_Sort) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._order != rhs_storage._order {return false}
        if _storage._isGlobal != rhs_storage._isGlobal {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Drop: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Drop"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "columns"),
    3: .standard(proto: "column_names"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _columns: [Spark_Connect_Expression] = []
    var _columnNames: [String] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _columns = source._columns
      _columnNames = source._columnNames
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedMessageField(value: &_storage._columns) }()
        case 3: try { try decoder.decodeRepeatedStringField(value: &_storage._columnNames) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._columns.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._columns, fieldNumber: 2)
      }
      if !_storage._columnNames.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._columnNames, fieldNumber: 3)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Drop, rhs: Spark_Connect_Drop) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._columns != rhs_storage._columns {return false}
        if _storage._columnNames != rhs_storage._columnNames {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Deduplicate: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Deduplicate"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .standard(proto: "column_names"),
    3: .standard(proto: "all_columns_as_keys"),
    4: .standard(proto: "within_watermark"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _columnNames: [String] = []
    var _allColumnsAsKeys: Bool? = nil
    var _withinWatermark: Bool? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _columnNames = source._columnNames
      _allColumnsAsKeys = source._allColumnsAsKeys
      _withinWatermark = source._withinWatermark
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedStringField(value: &_storage._columnNames) }()
        case 3: try { try decoder.decodeSingularBoolField(value: &_storage._allColumnsAsKeys) }()
        case 4: try { try decoder.decodeSingularBoolField(value: &_storage._withinWatermark) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._columnNames.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._columnNames, fieldNumber: 2)
      }
      try { if let v = _storage._allColumnsAsKeys {
        try visitor.visitSingularBoolField(value: v, fieldNumber: 3)
      } }()
      try { if let v = _storage._withinWatermark {
        try visitor.visitSingularBoolField(value: v, fieldNumber: 4)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Deduplicate, rhs: Spark_Connect_Deduplicate) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._columnNames != rhs_storage._columnNames {return false}
        if _storage._allColumnsAsKeys != rhs_storage._allColumnsAsKeys {return false}
        if _storage._withinWatermark != rhs_storage._withinWatermark {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_LocalRelation: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LocalRelation"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "data"),
    2: .same(proto: "schema"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self._data) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._schema) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._data {
      try visitor.visitSingularBytesField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._schema {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_LocalRelation, rhs: Spark_Connect_LocalRelation) -> Bool {
    if lhs._data != rhs._data {return false}
    if lhs._schema != rhs._schema {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_CachedLocalRelation: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CachedLocalRelation"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    3: .same(proto: "hash"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 3: try { try decoder.decodeSingularStringField(value: &self.hash) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.hash.isEmpty {
      try visitor.visitSingularStringField(value: self.hash, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_CachedLocalRelation, rhs: Spark_Connect_CachedLocalRelation) -> Bool {
    if lhs.hash != rhs.hash {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_CachedRemoteRelation: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CachedRemoteRelation"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "relation_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.relationID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.relationID.isEmpty {
      try visitor.visitSingularStringField(value: self.relationID, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_CachedRemoteRelation, rhs: Spark_Connect_CachedRemoteRelation) -> Bool {
    if lhs.relationID != rhs.relationID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Sample: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Sample"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .standard(proto: "lower_bound"),
    3: .standard(proto: "upper_bound"),
    4: .standard(proto: "with_replacement"),
    5: .same(proto: "seed"),
    6: .standard(proto: "deterministic_order"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _lowerBound: Double = 0
    var _upperBound: Double = 0
    var _withReplacement: Bool? = nil
    var _seed: Int64? = nil
    var _deterministicOrder: Bool = false

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _lowerBound = source._lowerBound
      _upperBound = source._upperBound
      _withReplacement = source._withReplacement
      _seed = source._seed
      _deterministicOrder = source._deterministicOrder
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularDoubleField(value: &_storage._lowerBound) }()
        case 3: try { try decoder.decodeSingularDoubleField(value: &_storage._upperBound) }()
        case 4: try { try decoder.decodeSingularBoolField(value: &_storage._withReplacement) }()
        case 5: try { try decoder.decodeSingularInt64Field(value: &_storage._seed) }()
        case 6: try { try decoder.decodeSingularBoolField(value: &_storage._deterministicOrder) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if _storage._lowerBound.bitPattern != 0 {
        try visitor.visitSingularDoubleField(value: _storage._lowerBound, fieldNumber: 2)
      }
      if _storage._upperBound.bitPattern != 0 {
        try visitor.visitSingularDoubleField(value: _storage._upperBound, fieldNumber: 3)
      }
      try { if let v = _storage._withReplacement {
        try visitor.visitSingularBoolField(value: v, fieldNumber: 4)
      } }()
      try { if let v = _storage._seed {
        try visitor.visitSingularInt64Field(value: v, fieldNumber: 5)
      } }()
      if _storage._deterministicOrder != false {
        try visitor.visitSingularBoolField(value: _storage._deterministicOrder, fieldNumber: 6)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Sample, rhs: Spark_Connect_Sample) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._lowerBound != rhs_storage._lowerBound {return false}
        if _storage._upperBound != rhs_storage._upperBound {return false}
        if _storage._withReplacement != rhs_storage._withReplacement {return false}
        if _storage._seed != rhs_storage._seed {return false}
        if _storage._deterministicOrder != rhs_storage._deterministicOrder {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Range: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Range"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "start"),
    2: .same(proto: "end"),
    3: .same(proto: "step"),
    4: .standard(proto: "num_partitions"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self._start) }()
      case 2: try { try decoder.decodeSingularInt64Field(value: &self.end) }()
      case 3: try { try decoder.decodeSingularInt64Field(value: &self.step) }()
      case 4: try { try decoder.decodeSingularInt32Field(value: &self._numPartitions) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._start {
      try visitor.visitSingularInt64Field(value: v, fieldNumber: 1)
    } }()
    if self.end != 0 {
      try visitor.visitSingularInt64Field(value: self.end, fieldNumber: 2)
    }
    if self.step != 0 {
      try visitor.visitSingularInt64Field(value: self.step, fieldNumber: 3)
    }
    try { if let v = self._numPartitions {
      try visitor.visitSingularInt32Field(value: v, fieldNumber: 4)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Range, rhs: Spark_Connect_Range) -> Bool {
    if lhs._start != rhs._start {return false}
    if lhs.end != rhs.end {return false}
    if lhs.step != rhs.step {return false}
    if lhs._numPartitions != rhs._numPartitions {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_SubqueryAlias: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SubqueryAlias"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "alias"),
    3: .same(proto: "qualifier"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _alias: String = String()
    var _qualifier: [String] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _alias = source._alias
      _qualifier = source._qualifier
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularStringField(value: &_storage._alias) }()
        case 3: try { try decoder.decodeRepeatedStringField(value: &_storage._qualifier) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._alias.isEmpty {
        try visitor.visitSingularStringField(value: _storage._alias, fieldNumber: 2)
      }
      if !_storage._qualifier.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._qualifier, fieldNumber: 3)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_SubqueryAlias, rhs: Spark_Connect_SubqueryAlias) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._alias != rhs_storage._alias {return false}
        if _storage._qualifier != rhs_storage._qualifier {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Repartition: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Repartition"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .standard(proto: "num_partitions"),
    3: .same(proto: "shuffle"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _numPartitions: Int32 = 0
    var _shuffle: Bool? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _numPartitions = source._numPartitions
      _shuffle = source._shuffle
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularInt32Field(value: &_storage._numPartitions) }()
        case 3: try { try decoder.decodeSingularBoolField(value: &_storage._shuffle) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if _storage._numPartitions != 0 {
        try visitor.visitSingularInt32Field(value: _storage._numPartitions, fieldNumber: 2)
      }
      try { if let v = _storage._shuffle {
        try visitor.visitSingularBoolField(value: v, fieldNumber: 3)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Repartition, rhs: Spark_Connect_Repartition) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._numPartitions != rhs_storage._numPartitions {return false}
        if _storage._shuffle != rhs_storage._shuffle {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ShowString: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ShowString"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .standard(proto: "num_rows"),
    3: .same(proto: "truncate"),
    4: .same(proto: "vertical"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _numRows: Int32 = 0
    var _truncate: Int32 = 0
    var _vertical: Bool = false

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _numRows = source._numRows
      _truncate = source._truncate
      _vertical = source._vertical
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularInt32Field(value: &_storage._numRows) }()
        case 3: try { try decoder.decodeSingularInt32Field(value: &_storage._truncate) }()
        case 4: try { try decoder.decodeSingularBoolField(value: &_storage._vertical) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if _storage._numRows != 0 {
        try visitor.visitSingularInt32Field(value: _storage._numRows, fieldNumber: 2)
      }
      if _storage._truncate != 0 {
        try visitor.visitSingularInt32Field(value: _storage._truncate, fieldNumber: 3)
      }
      if _storage._vertical != false {
        try visitor.visitSingularBoolField(value: _storage._vertical, fieldNumber: 4)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ShowString, rhs: Spark_Connect_ShowString) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._numRows != rhs_storage._numRows {return false}
        if _storage._truncate != rhs_storage._truncate {return false}
        if _storage._vertical != rhs_storage._vertical {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_HtmlString: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".HtmlString"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .standard(proto: "num_rows"),
    3: .same(proto: "truncate"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _numRows: Int32 = 0
    var _truncate: Int32 = 0

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _numRows = source._numRows
      _truncate = source._truncate
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularInt32Field(value: &_storage._numRows) }()
        case 3: try { try decoder.decodeSingularInt32Field(value: &_storage._truncate) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if _storage._numRows != 0 {
        try visitor.visitSingularInt32Field(value: _storage._numRows, fieldNumber: 2)
      }
      if _storage._truncate != 0 {
        try visitor.visitSingularInt32Field(value: _storage._truncate, fieldNumber: 3)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_HtmlString, rhs: Spark_Connect_HtmlString) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._numRows != rhs_storage._numRows {return false}
        if _storage._truncate != rhs_storage._truncate {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StatSummary: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StatSummary"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "statistics"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _statistics: [String] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _statistics = source._statistics
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedStringField(value: &_storage._statistics) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._statistics.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._statistics, fieldNumber: 2)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StatSummary, rhs: Spark_Connect_StatSummary) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._statistics != rhs_storage._statistics {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StatDescribe: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StatDescribe"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "cols"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _cols: [String] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _cols = source._cols
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedStringField(value: &_storage._cols) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._cols.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._cols, fieldNumber: 2)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StatDescribe, rhs: Spark_Connect_StatDescribe) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._cols != rhs_storage._cols {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StatCrosstab: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StatCrosstab"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "col1"),
    3: .same(proto: "col2"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _col1: String = String()
    var _col2: String = String()

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _col1 = source._col1
      _col2 = source._col2
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularStringField(value: &_storage._col1) }()
        case 3: try { try decoder.decodeSingularStringField(value: &_storage._col2) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._col1.isEmpty {
        try visitor.visitSingularStringField(value: _storage._col1, fieldNumber: 2)
      }
      if !_storage._col2.isEmpty {
        try visitor.visitSingularStringField(value: _storage._col2, fieldNumber: 3)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StatCrosstab, rhs: Spark_Connect_StatCrosstab) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._col1 != rhs_storage._col1 {return false}
        if _storage._col2 != rhs_storage._col2 {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StatCov: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StatCov"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "col1"),
    3: .same(proto: "col2"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _col1: String = String()
    var _col2: String = String()

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _col1 = source._col1
      _col2 = source._col2
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularStringField(value: &_storage._col1) }()
        case 3: try { try decoder.decodeSingularStringField(value: &_storage._col2) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._col1.isEmpty {
        try visitor.visitSingularStringField(value: _storage._col1, fieldNumber: 2)
      }
      if !_storage._col2.isEmpty {
        try visitor.visitSingularStringField(value: _storage._col2, fieldNumber: 3)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StatCov, rhs: Spark_Connect_StatCov) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._col1 != rhs_storage._col1 {return false}
        if _storage._col2 != rhs_storage._col2 {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StatCorr: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StatCorr"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "col1"),
    3: .same(proto: "col2"),
    4: .same(proto: "method"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _col1: String = String()
    var _col2: String = String()
    var _method: String? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _col1 = source._col1
      _col2 = source._col2
      _method = source._method
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularStringField(value: &_storage._col1) }()
        case 3: try { try decoder.decodeSingularStringField(value: &_storage._col2) }()
        case 4: try { try decoder.decodeSingularStringField(value: &_storage._method) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._col1.isEmpty {
        try visitor.visitSingularStringField(value: _storage._col1, fieldNumber: 2)
      }
      if !_storage._col2.isEmpty {
        try visitor.visitSingularStringField(value: _storage._col2, fieldNumber: 3)
      }
      try { if let v = _storage._method {
        try visitor.visitSingularStringField(value: v, fieldNumber: 4)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StatCorr, rhs: Spark_Connect_StatCorr) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._col1 != rhs_storage._col1 {return false}
        if _storage._col2 != rhs_storage._col2 {return false}
        if _storage._method != rhs_storage._method {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StatApproxQuantile: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StatApproxQuantile"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "cols"),
    3: .same(proto: "probabilities"),
    4: .standard(proto: "relative_error"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _cols: [String] = []
    var _probabilities: [Double] = []
    var _relativeError: Double = 0

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _cols = source._cols
      _probabilities = source._probabilities
      _relativeError = source._relativeError
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedStringField(value: &_storage._cols) }()
        case 3: try { try decoder.decodeRepeatedDoubleField(value: &_storage._probabilities) }()
        case 4: try { try decoder.decodeSingularDoubleField(value: &_storage._relativeError) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._cols.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._cols, fieldNumber: 2)
      }
      if !_storage._probabilities.isEmpty {
        try visitor.visitPackedDoubleField(value: _storage._probabilities, fieldNumber: 3)
      }
      if _storage._relativeError.bitPattern != 0 {
        try visitor.visitSingularDoubleField(value: _storage._relativeError, fieldNumber: 4)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StatApproxQuantile, rhs: Spark_Connect_StatApproxQuantile) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._cols != rhs_storage._cols {return false}
        if _storage._probabilities != rhs_storage._probabilities {return false}
        if _storage._relativeError != rhs_storage._relativeError {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StatFreqItems: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StatFreqItems"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "cols"),
    3: .same(proto: "support"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _cols: [String] = []
    var _support: Double? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _cols = source._cols
      _support = source._support
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedStringField(value: &_storage._cols) }()
        case 3: try { try decoder.decodeSingularDoubleField(value: &_storage._support) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._cols.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._cols, fieldNumber: 2)
      }
      try { if let v = _storage._support {
        try visitor.visitSingularDoubleField(value: v, fieldNumber: 3)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StatFreqItems, rhs: Spark_Connect_StatFreqItems) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._cols != rhs_storage._cols {return false}
        if _storage._support != rhs_storage._support {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StatSampleBy: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StatSampleBy"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "col"),
    3: .same(proto: "fractions"),
    5: .same(proto: "seed"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _col: Spark_Connect_Expression? = nil
    var _fractions: [Spark_Connect_StatSampleBy.Fraction] = []
    var _seed: Int64? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _col = source._col
      _fractions = source._fractions
      _seed = source._seed
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._col) }()
        case 3: try { try decoder.decodeRepeatedMessageField(value: &_storage._fractions) }()
        case 5: try { try decoder.decodeSingularInt64Field(value: &_storage._seed) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      try { if let v = _storage._col {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
      if !_storage._fractions.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._fractions, fieldNumber: 3)
      }
      try { if let v = _storage._seed {
        try visitor.visitSingularInt64Field(value: v, fieldNumber: 5)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StatSampleBy, rhs: Spark_Connect_StatSampleBy) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._col != rhs_storage._col {return false}
        if _storage._fractions != rhs_storage._fractions {return false}
        if _storage._seed != rhs_storage._seed {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StatSampleBy.Fraction: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_StatSampleBy.protoMessageName + ".Fraction"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "stratum"),
    2: .same(proto: "fraction"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._stratum) }()
      case 2: try { try decoder.decodeSingularDoubleField(value: &self.fraction) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._stratum {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    if self.fraction.bitPattern != 0 {
      try visitor.visitSingularDoubleField(value: self.fraction, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StatSampleBy.Fraction, rhs: Spark_Connect_StatSampleBy.Fraction) -> Bool {
    if lhs._stratum != rhs._stratum {return false}
    if lhs.fraction != rhs.fraction {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_NAFill: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".NAFill"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "cols"),
    3: .same(proto: "values"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _cols: [String] = []
    var _values: [Spark_Connect_Expression.Literal] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _cols = source._cols
      _values = source._values
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedStringField(value: &_storage._cols) }()
        case 3: try { try decoder.decodeRepeatedMessageField(value: &_storage._values) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._cols.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._cols, fieldNumber: 2)
      }
      if !_storage._values.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._values, fieldNumber: 3)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_NAFill, rhs: Spark_Connect_NAFill) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._cols != rhs_storage._cols {return false}
        if _storage._values != rhs_storage._values {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_NADrop: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".NADrop"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "cols"),
    3: .standard(proto: "min_non_nulls"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _cols: [String] = []
    var _minNonNulls: Int32? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _cols = source._cols
      _minNonNulls = source._minNonNulls
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedStringField(value: &_storage._cols) }()
        case 3: try { try decoder.decodeSingularInt32Field(value: &_storage._minNonNulls) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._cols.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._cols, fieldNumber: 2)
      }
      try { if let v = _storage._minNonNulls {
        try visitor.visitSingularInt32Field(value: v, fieldNumber: 3)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_NADrop, rhs: Spark_Connect_NADrop) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._cols != rhs_storage._cols {return false}
        if _storage._minNonNulls != rhs_storage._minNonNulls {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_NAReplace: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".NAReplace"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "cols"),
    3: .same(proto: "replacements"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _cols: [String] = []
    var _replacements: [Spark_Connect_NAReplace.Replacement] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _cols = source._cols
      _replacements = source._replacements
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedStringField(value: &_storage._cols) }()
        case 3: try { try decoder.decodeRepeatedMessageField(value: &_storage._replacements) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._cols.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._cols, fieldNumber: 2)
      }
      if !_storage._replacements.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._replacements, fieldNumber: 3)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_NAReplace, rhs: Spark_Connect_NAReplace) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._cols != rhs_storage._cols {return false}
        if _storage._replacements != rhs_storage._replacements {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_NAReplace.Replacement: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_NAReplace.protoMessageName + ".Replacement"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "old_value"),
    2: .standard(proto: "new_value"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._oldValue) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._newValue) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._oldValue {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._newValue {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_NAReplace.Replacement, rhs: Spark_Connect_NAReplace.Replacement) -> Bool {
    if lhs._oldValue != rhs._oldValue {return false}
    if lhs._newValue != rhs._newValue {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ToDF: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ToDF"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .standard(proto: "column_names"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _columnNames: [String] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _columnNames = source._columnNames
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedStringField(value: &_storage._columnNames) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._columnNames.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._columnNames, fieldNumber: 2)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ToDF, rhs: Spark_Connect_ToDF) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._columnNames != rhs_storage._columnNames {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_WithColumnsRenamed: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".WithColumnsRenamed"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .standard(proto: "rename_columns_map"),
    3: .same(proto: "renames"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _renameColumnsMap: Dictionary<String,String> = [:]
    var _renames: [Spark_Connect_WithColumnsRenamed.Rename] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _renameColumnsMap = source._renameColumnsMap
      _renames = source._renames
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &_storage._renameColumnsMap) }()
        case 3: try { try decoder.decodeRepeatedMessageField(value: &_storage._renames) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._renameColumnsMap.isEmpty {
        try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: _storage._renameColumnsMap, fieldNumber: 2)
      }
      if !_storage._renames.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._renames, fieldNumber: 3)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_WithColumnsRenamed, rhs: Spark_Connect_WithColumnsRenamed) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._renameColumnsMap != rhs_storage._renameColumnsMap {return false}
        if _storage._renames != rhs_storage._renames {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_WithColumnsRenamed.Rename: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_WithColumnsRenamed.protoMessageName + ".Rename"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "col_name"),
    2: .standard(proto: "new_col_name"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.colName) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.newColName) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.colName.isEmpty {
      try visitor.visitSingularStringField(value: self.colName, fieldNumber: 1)
    }
    if !self.newColName.isEmpty {
      try visitor.visitSingularStringField(value: self.newColName, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_WithColumnsRenamed.Rename, rhs: Spark_Connect_WithColumnsRenamed.Rename) -> Bool {
    if lhs.colName != rhs.colName {return false}
    if lhs.newColName != rhs.newColName {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_WithColumns: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".WithColumns"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "aliases"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _aliases: [Spark_Connect_Expression.Alias] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _aliases = source._aliases
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedMessageField(value: &_storage._aliases) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._aliases.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._aliases, fieldNumber: 2)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_WithColumns, rhs: Spark_Connect_WithColumns) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._aliases != rhs_storage._aliases {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_WithWatermark: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".WithWatermark"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .standard(proto: "event_time"),
    3: .standard(proto: "delay_threshold"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _eventTime: String = String()
    var _delayThreshold: String = String()

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _eventTime = source._eventTime
      _delayThreshold = source._delayThreshold
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularStringField(value: &_storage._eventTime) }()
        case 3: try { try decoder.decodeSingularStringField(value: &_storage._delayThreshold) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._eventTime.isEmpty {
        try visitor.visitSingularStringField(value: _storage._eventTime, fieldNumber: 2)
      }
      if !_storage._delayThreshold.isEmpty {
        try visitor.visitSingularStringField(value: _storage._delayThreshold, fieldNumber: 3)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_WithWatermark, rhs: Spark_Connect_WithWatermark) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._eventTime != rhs_storage._eventTime {return false}
        if _storage._delayThreshold != rhs_storage._delayThreshold {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Hint: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Hint"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "name"),
    3: .same(proto: "parameters"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _name: String = String()
    var _parameters: [Spark_Connect_Expression] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _name = source._name
      _parameters = source._parameters
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularStringField(value: &_storage._name) }()
        case 3: try { try decoder.decodeRepeatedMessageField(value: &_storage._parameters) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._name.isEmpty {
        try visitor.visitSingularStringField(value: _storage._name, fieldNumber: 2)
      }
      if !_storage._parameters.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._parameters, fieldNumber: 3)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Hint, rhs: Spark_Connect_Hint) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._name != rhs_storage._name {return false}
        if _storage._parameters != rhs_storage._parameters {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Unpivot: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Unpivot"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "ids"),
    3: .same(proto: "values"),
    4: .standard(proto: "variable_column_name"),
    5: .standard(proto: "value_column_name"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _ids: [Spark_Connect_Expression] = []
    var _values: Spark_Connect_Unpivot.Values? = nil
    var _variableColumnName: String = String()
    var _valueColumnName: String = String()

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _ids = source._ids
      _values = source._values
      _variableColumnName = source._variableColumnName
      _valueColumnName = source._valueColumnName
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedMessageField(value: &_storage._ids) }()
        case 3: try { try decoder.decodeSingularMessageField(value: &_storage._values) }()
        case 4: try { try decoder.decodeSingularStringField(value: &_storage._variableColumnName) }()
        case 5: try { try decoder.decodeSingularStringField(value: &_storage._valueColumnName) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._ids.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._ids, fieldNumber: 2)
      }
      try { if let v = _storage._values {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      } }()
      if !_storage._variableColumnName.isEmpty {
        try visitor.visitSingularStringField(value: _storage._variableColumnName, fieldNumber: 4)
      }
      if !_storage._valueColumnName.isEmpty {
        try visitor.visitSingularStringField(value: _storage._valueColumnName, fieldNumber: 5)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Unpivot, rhs: Spark_Connect_Unpivot) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._ids != rhs_storage._ids {return false}
        if _storage._values != rhs_storage._values {return false}
        if _storage._variableColumnName != rhs_storage._variableColumnName {return false}
        if _storage._valueColumnName != rhs_storage._valueColumnName {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Unpivot.Values: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_Unpivot.protoMessageName + ".Values"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Unpivot.Values, rhs: Spark_Connect_Unpivot.Values) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Transpose: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Transpose"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .standard(proto: "index_columns"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _indexColumns: [Spark_Connect_Expression] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _indexColumns = source._indexColumns
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedMessageField(value: &_storage._indexColumns) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._indexColumns.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._indexColumns, fieldNumber: 2)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Transpose, rhs: Spark_Connect_Transpose) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._indexColumns != rhs_storage._indexColumns {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_UnresolvedTableValuedFunction: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".UnresolvedTableValuedFunction"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "function_name"),
    2: .same(proto: "arguments"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.functionName) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.arguments) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.functionName.isEmpty {
      try visitor.visitSingularStringField(value: self.functionName, fieldNumber: 1)
    }
    if !self.arguments.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.arguments, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_UnresolvedTableValuedFunction, rhs: Spark_Connect_UnresolvedTableValuedFunction) -> Bool {
    if lhs.functionName != rhs.functionName {return false}
    if lhs.arguments != rhs.arguments {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ToSchema: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ToSchema"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "schema"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _schema: Spark_Connect_DataType? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _schema = source._schema
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._schema) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      try { if let v = _storage._schema {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ToSchema, rhs: Spark_Connect_ToSchema) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._schema != rhs_storage._schema {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_RepartitionByExpression: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".RepartitionByExpression"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .standard(proto: "partition_exprs"),
    3: .standard(proto: "num_partitions"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _partitionExprs: [Spark_Connect_Expression] = []
    var _numPartitions: Int32? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _partitionExprs = source._partitionExprs
      _numPartitions = source._numPartitions
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedMessageField(value: &_storage._partitionExprs) }()
        case 3: try { try decoder.decodeSingularInt32Field(value: &_storage._numPartitions) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._partitionExprs.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._partitionExprs, fieldNumber: 2)
      }
      try { if let v = _storage._numPartitions {
        try visitor.visitSingularInt32Field(value: v, fieldNumber: 3)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_RepartitionByExpression, rhs: Spark_Connect_RepartitionByExpression) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._partitionExprs != rhs_storage._partitionExprs {return false}
        if _storage._numPartitions != rhs_storage._numPartitions {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_MapPartitions: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".MapPartitions"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "func"),
    3: .standard(proto: "is_barrier"),
    4: .standard(proto: "profile_id"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _func: Spark_Connect_CommonInlineUserDefinedFunction? = nil
    var _isBarrier: Bool? = nil
    var _profileID: Int32? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _func = source._func
      _isBarrier = source._isBarrier
      _profileID = source._profileID
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._func) }()
        case 3: try { try decoder.decodeSingularBoolField(value: &_storage._isBarrier) }()
        case 4: try { try decoder.decodeSingularInt32Field(value: &_storage._profileID) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      try { if let v = _storage._func {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
      try { if let v = _storage._isBarrier {
        try visitor.visitSingularBoolField(value: v, fieldNumber: 3)
      } }()
      try { if let v = _storage._profileID {
        try visitor.visitSingularInt32Field(value: v, fieldNumber: 4)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_MapPartitions, rhs: Spark_Connect_MapPartitions) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._func != rhs_storage._func {return false}
        if _storage._isBarrier != rhs_storage._isBarrier {return false}
        if _storage._profileID != rhs_storage._profileID {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_GroupMap: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".GroupMap"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .standard(proto: "grouping_expressions"),
    3: .same(proto: "func"),
    4: .standard(proto: "sorting_expressions"),
    5: .standard(proto: "initial_input"),
    6: .standard(proto: "initial_grouping_expressions"),
    7: .standard(proto: "is_map_groups_with_state"),
    8: .standard(proto: "output_mode"),
    9: .standard(proto: "timeout_conf"),
    10: .standard(proto: "state_schema"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _groupingExpressions: [Spark_Connect_Expression] = []
    var _func: Spark_Connect_CommonInlineUserDefinedFunction? = nil
    var _sortingExpressions: [Spark_Connect_Expression] = []
    var _initialInput: Spark_Connect_Relation? = nil
    var _initialGroupingExpressions: [Spark_Connect_Expression] = []
    var _isMapGroupsWithState: Bool? = nil
    var _outputMode: String? = nil
    var _timeoutConf: String? = nil
    var _stateSchema: Spark_Connect_DataType? = nil

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _groupingExpressions = source._groupingExpressions
      _func = source._func
      _sortingExpressions = source._sortingExpressions
      _initialInput = source._initialInput
      _initialGroupingExpressions = source._initialGroupingExpressions
      _isMapGroupsWithState = source._isMapGroupsWithState
      _outputMode = source._outputMode
      _timeoutConf = source._timeoutConf
      _stateSchema = source._stateSchema
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedMessageField(value: &_storage._groupingExpressions) }()
        case 3: try { try decoder.decodeSingularMessageField(value: &_storage._func) }()
        case 4: try { try decoder.decodeRepeatedMessageField(value: &_storage._sortingExpressions) }()
        case 5: try { try decoder.decodeSingularMessageField(value: &_storage._initialInput) }()
        case 6: try { try decoder.decodeRepeatedMessageField(value: &_storage._initialGroupingExpressions) }()
        case 7: try { try decoder.decodeSingularBoolField(value: &_storage._isMapGroupsWithState) }()
        case 8: try { try decoder.decodeSingularStringField(value: &_storage._outputMode) }()
        case 9: try { try decoder.decodeSingularStringField(value: &_storage._timeoutConf) }()
        case 10: try { try decoder.decodeSingularMessageField(value: &_storage._stateSchema) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._groupingExpressions.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._groupingExpressions, fieldNumber: 2)
      }
      try { if let v = _storage._func {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      } }()
      if !_storage._sortingExpressions.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._sortingExpressions, fieldNumber: 4)
      }
      try { if let v = _storage._initialInput {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
      } }()
      if !_storage._initialGroupingExpressions.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._initialGroupingExpressions, fieldNumber: 6)
      }
      try { if let v = _storage._isMapGroupsWithState {
        try visitor.visitSingularBoolField(value: v, fieldNumber: 7)
      } }()
      try { if let v = _storage._outputMode {
        try visitor.visitSingularStringField(value: v, fieldNumber: 8)
      } }()
      try { if let v = _storage._timeoutConf {
        try visitor.visitSingularStringField(value: v, fieldNumber: 9)
      } }()
      try { if let v = _storage._stateSchema {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_GroupMap, rhs: Spark_Connect_GroupMap) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._groupingExpressions != rhs_storage._groupingExpressions {return false}
        if _storage._func != rhs_storage._func {return false}
        if _storage._sortingExpressions != rhs_storage._sortingExpressions {return false}
        if _storage._initialInput != rhs_storage._initialInput {return false}
        if _storage._initialGroupingExpressions != rhs_storage._initialGroupingExpressions {return false}
        if _storage._isMapGroupsWithState != rhs_storage._isMapGroupsWithState {return false}
        if _storage._outputMode != rhs_storage._outputMode {return false}
        if _storage._timeoutConf != rhs_storage._timeoutConf {return false}
        if _storage._stateSchema != rhs_storage._stateSchema {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_CoGroupMap: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CoGroupMap"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .standard(proto: "input_grouping_expressions"),
    3: .same(proto: "other"),
    4: .standard(proto: "other_grouping_expressions"),
    5: .same(proto: "func"),
    6: .standard(proto: "input_sorting_expressions"),
    7: .standard(proto: "other_sorting_expressions"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _inputGroupingExpressions: [Spark_Connect_Expression] = []
    var _other: Spark_Connect_Relation? = nil
    var _otherGroupingExpressions: [Spark_Connect_Expression] = []
    var _func: Spark_Connect_CommonInlineUserDefinedFunction? = nil
    var _inputSortingExpressions: [Spark_Connect_Expression] = []
    var _otherSortingExpressions: [Spark_Connect_Expression] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _inputGroupingExpressions = source._inputGroupingExpressions
      _other = source._other
      _otherGroupingExpressions = source._otherGroupingExpressions
      _func = source._func
      _inputSortingExpressions = source._inputSortingExpressions
      _otherSortingExpressions = source._otherSortingExpressions
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedMessageField(value: &_storage._inputGroupingExpressions) }()
        case 3: try { try decoder.decodeSingularMessageField(value: &_storage._other) }()
        case 4: try { try decoder.decodeRepeatedMessageField(value: &_storage._otherGroupingExpressions) }()
        case 5: try { try decoder.decodeSingularMessageField(value: &_storage._func) }()
        case 6: try { try decoder.decodeRepeatedMessageField(value: &_storage._inputSortingExpressions) }()
        case 7: try { try decoder.decodeRepeatedMessageField(value: &_storage._otherSortingExpressions) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._inputGroupingExpressions.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._inputGroupingExpressions, fieldNumber: 2)
      }
      try { if let v = _storage._other {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      } }()
      if !_storage._otherGroupingExpressions.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._otherGroupingExpressions, fieldNumber: 4)
      }
      try { if let v = _storage._func {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
      } }()
      if !_storage._inputSortingExpressions.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._inputSortingExpressions, fieldNumber: 6)
      }
      if !_storage._otherSortingExpressions.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._otherSortingExpressions, fieldNumber: 7)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_CoGroupMap, rhs: Spark_Connect_CoGroupMap) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._inputGroupingExpressions != rhs_storage._inputGroupingExpressions {return false}
        if _storage._other != rhs_storage._other {return false}
        if _storage._otherGroupingExpressions != rhs_storage._otherGroupingExpressions {return false}
        if _storage._func != rhs_storage._func {return false}
        if _storage._inputSortingExpressions != rhs_storage._inputSortingExpressions {return false}
        if _storage._otherSortingExpressions != rhs_storage._otherSortingExpressions {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ApplyInPandasWithState: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ApplyInPandasWithState"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .standard(proto: "grouping_expressions"),
    3: .same(proto: "func"),
    4: .standard(proto: "output_schema"),
    5: .standard(proto: "state_schema"),
    6: .standard(proto: "output_mode"),
    7: .standard(proto: "timeout_conf"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _groupingExpressions: [Spark_Connect_Expression] = []
    var _func: Spark_Connect_CommonInlineUserDefinedFunction? = nil
    var _outputSchema: String = String()
    var _stateSchema: String = String()
    var _outputMode: String = String()
    var _timeoutConf: String = String()

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _groupingExpressions = source._groupingExpressions
      _func = source._func
      _outputSchema = source._outputSchema
      _stateSchema = source._stateSchema
      _outputMode = source._outputMode
      _timeoutConf = source._timeoutConf
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeRepeatedMessageField(value: &_storage._groupingExpressions) }()
        case 3: try { try decoder.decodeSingularMessageField(value: &_storage._func) }()
        case 4: try { try decoder.decodeSingularStringField(value: &_storage._outputSchema) }()
        case 5: try { try decoder.decodeSingularStringField(value: &_storage._stateSchema) }()
        case 6: try { try decoder.decodeSingularStringField(value: &_storage._outputMode) }()
        case 7: try { try decoder.decodeSingularStringField(value: &_storage._timeoutConf) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._groupingExpressions.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._groupingExpressions, fieldNumber: 2)
      }
      try { if let v = _storage._func {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      } }()
      if !_storage._outputSchema.isEmpty {
        try visitor.visitSingularStringField(value: _storage._outputSchema, fieldNumber: 4)
      }
      if !_storage._stateSchema.isEmpty {
        try visitor.visitSingularStringField(value: _storage._stateSchema, fieldNumber: 5)
      }
      if !_storage._outputMode.isEmpty {
        try visitor.visitSingularStringField(value: _storage._outputMode, fieldNumber: 6)
      }
      if !_storage._timeoutConf.isEmpty {
        try visitor.visitSingularStringField(value: _storage._timeoutConf, fieldNumber: 7)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ApplyInPandasWithState, rhs: Spark_Connect_ApplyInPandasWithState) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._groupingExpressions != rhs_storage._groupingExpressions {return false}
        if _storage._func != rhs_storage._func {return false}
        if _storage._outputSchema != rhs_storage._outputSchema {return false}
        if _storage._stateSchema != rhs_storage._stateSchema {return false}
        if _storage._outputMode != rhs_storage._outputMode {return false}
        if _storage._timeoutConf != rhs_storage._timeoutConf {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_CommonInlineUserDefinedTableFunction: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommonInlineUserDefinedTableFunction"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "function_name"),
    2: .same(proto: "deterministic"),
    3: .same(proto: "arguments"),
    4: .standard(proto: "python_udtf"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.functionName) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.deterministic) }()
      case 3: try { try decoder.decodeRepeatedMessageField(value: &self.arguments) }()
      case 4: try {
        var v: Spark_Connect_PythonUDTF?
        var hadOneofValue = false
        if let current = self.function {
          hadOneofValue = true
          if case .pythonUdtf(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.function = .pythonUdtf(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.functionName.isEmpty {
      try visitor.visitSingularStringField(value: self.functionName, fieldNumber: 1)
    }
    if self.deterministic != false {
      try visitor.visitSingularBoolField(value: self.deterministic, fieldNumber: 2)
    }
    if !self.arguments.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.arguments, fieldNumber: 3)
    }
    try { if case .pythonUdtf(let v)? = self.function {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_CommonInlineUserDefinedTableFunction, rhs: Spark_Connect_CommonInlineUserDefinedTableFunction) -> Bool {
    if lhs.functionName != rhs.functionName {return false}
    if lhs.deterministic != rhs.deterministic {return false}
    if lhs.arguments != rhs.arguments {return false}
    if lhs.function != rhs.function {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_PythonUDTF: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".PythonUDTF"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "return_type"),
    2: .standard(proto: "eval_type"),
    3: .same(proto: "command"),
    4: .standard(proto: "python_ver"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._returnType) }()
      case 2: try { try decoder.decodeSingularInt32Field(value: &self.evalType) }()
      case 3: try { try decoder.decodeSingularBytesField(value: &self.command) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self.pythonVer) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._returnType {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    if self.evalType != 0 {
      try visitor.visitSingularInt32Field(value: self.evalType, fieldNumber: 2)
    }
    if !self.command.isEmpty {
      try visitor.visitSingularBytesField(value: self.command, fieldNumber: 3)
    }
    if !self.pythonVer.isEmpty {
      try visitor.visitSingularStringField(value: self.pythonVer, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_PythonUDTF, rhs: Spark_Connect_PythonUDTF) -> Bool {
    if lhs._returnType != rhs._returnType {return false}
    if lhs.evalType != rhs.evalType {return false}
    if lhs.command != rhs.command {return false}
    if lhs.pythonVer != rhs.pythonVer {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_CommonInlineUserDefinedDataSource: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommonInlineUserDefinedDataSource"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "name"),
    2: .standard(proto: "python_data_source"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.name) }()
      case 2: try {
        var v: Spark_Connect_PythonDataSource?
        var hadOneofValue = false
        if let current = self.dataSource {
          hadOneofValue = true
          if case .pythonDataSource(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.dataSource = .pythonDataSource(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 1)
    }
    try { if case .pythonDataSource(let v)? = self.dataSource {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_CommonInlineUserDefinedDataSource, rhs: Spark_Connect_CommonInlineUserDefinedDataSource) -> Bool {
    if lhs.name != rhs.name {return false}
    if lhs.dataSource != rhs.dataSource {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_PythonDataSource: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".PythonDataSource"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "command"),
    2: .standard(proto: "python_ver"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.command) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.pythonVer) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.command.isEmpty {
      try visitor.visitSingularBytesField(value: self.command, fieldNumber: 1)
    }
    if !self.pythonVer.isEmpty {
      try visitor.visitSingularStringField(value: self.pythonVer, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_PythonDataSource, rhs: Spark_Connect_PythonDataSource) -> Bool {
    if lhs.command != rhs.command {return false}
    if lhs.pythonVer != rhs.pythonVer {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_CollectMetrics: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CollectMetrics"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "name"),
    3: .same(proto: "metrics"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _name: String = String()
    var _metrics: [Spark_Connect_Expression] = []

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _name = source._name
      _metrics = source._metrics
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularStringField(value: &_storage._name) }()
        case 3: try { try decoder.decodeRepeatedMessageField(value: &_storage._metrics) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._name.isEmpty {
        try visitor.visitSingularStringField(value: _storage._name, fieldNumber: 2)
      }
      if !_storage._metrics.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._metrics, fieldNumber: 3)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_CollectMetrics, rhs: Spark_Connect_CollectMetrics) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._name != rhs_storage._name {return false}
        if _storage._metrics != rhs_storage._metrics {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Parse: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Parse"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "format"),
    3: .same(proto: "schema"),
    4: .same(proto: "options"),
  ]

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _format: Spark_Connect_Parse.ParseFormat = .unspecified
    var _schema: Spark_Connect_DataType? = nil
    var _options: Dictionary<String,String> = [:]

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _format = source._format
      _schema = source._schema
      _options = source._options
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularEnumField(value: &_storage._format) }()
        case 3: try { try decoder.decodeSingularMessageField(value: &_storage._schema) }()
        case 4: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &_storage._options) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if _storage._format != .unspecified {
        try visitor.visitSingularEnumField(value: _storage._format, fieldNumber: 2)
      }
      try { if let v = _storage._schema {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      } }()
      if !_storage._options.isEmpty {
        try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: _storage._options, fieldNumber: 4)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Parse, rhs: Spark_Connect_Parse) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._format != rhs_storage._format {return false}
        if _storage._schema != rhs_storage._schema {return false}
        if _storage._options != rhs_storage._options {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Parse.ParseFormat: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "PARSE_FORMAT_UNSPECIFIED"),
    1: .same(proto: "PARSE_FORMAT_CSV"),
    2: .same(proto: "PARSE_FORMAT_JSON"),
  ]
}

extension Spark_Connect_AsOfJoin: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".AsOfJoin"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "left"),
    2: .same(proto: "right"),
    3: .standard(proto: "left_as_of"),
    4: .standard(proto: "right_as_of"),
    5: .standard(proto: "join_expr"),
    6: .standard(proto: "using_columns"),
    7: .standard(proto: "join_type"),
    8: .same(proto: "tolerance"),
    9: .standard(proto: "allow_exact_matches"),
    10: .same(proto: "direction"),
  ]

  fileprivate class _StorageClass {
    var _left: Spark_Connect_Relation? = nil
    var _right: Spark_Connect_Relation? = nil
    var _leftAsOf: Spark_Connect_Expression? = nil
    var _rightAsOf: Spark_Connect_Expression? = nil
    var _joinExpr: Spark_Connect_Expression? = nil
    var _usingColumns: [String] = []
    var _joinType: String = String()
    var _tolerance: Spark_Connect_Expression? = nil
    var _allowExactMatches: Bool = false
    var _direction: String = String()

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _left = source._left
      _right = source._right
      _leftAsOf = source._leftAsOf
      _rightAsOf = source._rightAsOf
      _joinExpr = source._joinExpr
      _usingColumns = source._usingColumns
      _joinType = source._joinType
      _tolerance = source._tolerance
      _allowExactMatches = source._allowExactMatches
      _direction = source._direction
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._left) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._right) }()
        case 3: try { try decoder.decodeSingularMessageField(value: &_storage._leftAsOf) }()
        case 4: try { try decoder.decodeSingularMessageField(value: &_storage._rightAsOf) }()
        case 5: try { try decoder.decodeSingularMessageField(value: &_storage._joinExpr) }()
        case 6: try { try decoder.decodeRepeatedStringField(value: &_storage._usingColumns) }()
        case 7: try { try decoder.decodeSingularStringField(value: &_storage._joinType) }()
        case 8: try { try decoder.decodeSingularMessageField(value: &_storage._tolerance) }()
        case 9: try { try decoder.decodeSingularBoolField(value: &_storage._allowExactMatches) }()
        case 10: try { try decoder.decodeSingularStringField(value: &_storage._direction) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._left {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      try { if let v = _storage._right {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
      try { if let v = _storage._leftAsOf {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      } }()
      try { if let v = _storage._rightAsOf {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
      } }()
      try { if let v = _storage._joinExpr {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
      } }()
      if !_storage._usingColumns.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._usingColumns, fieldNumber: 6)
      }
      if !_storage._joinType.isEmpty {
        try visitor.visitSingularStringField(value: _storage._joinType, fieldNumber: 7)
      }
      try { if let v = _storage._tolerance {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 8)
      } }()
      if _storage._allowExactMatches != false {
        try visitor.visitSingularBoolField(value: _storage._allowExactMatches, fieldNumber: 9)
      }
      if !_storage._direction.isEmpty {
        try visitor.visitSingularStringField(value: _storage._direction, fieldNumber: 10)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AsOfJoin, rhs: Spark_Connect_AsOfJoin) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._left != rhs_storage._left {return false}
        if _storage._right != rhs_storage._right {return false}
        if _storage._leftAsOf != rhs_storage._leftAsOf {return false}
        if _storage._rightAsOf != rhs_storage._rightAsOf {return false}
        if _storage._joinExpr != rhs_storage._joinExpr {return false}
        if _storage._usingColumns != rhs_storage._usingColumns {return false}
        if _storage._joinType != rhs_storage._joinType {return false}
        if _storage._tolerance != rhs_storage._tolerance {return false}
        if _storage._allowExactMatches != rhs_storage._allowExactMatches {return false}
        if _storage._direction != rhs_storage._direction {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_LateralJoin: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LateralJoin"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "left"),
    2: .same(proto: "right"),
    3: .standard(proto: "join_condition"),
    4: .standard(proto: "join_type"),
  ]

  fileprivate class _StorageClass {
    var _left: Spark_Connect_Relation? = nil
    var _right: Spark_Connect_Relation? = nil
    var _joinCondition: Spark_Connect_Expression? = nil
    var _joinType: Spark_Connect_Join.JoinType = .unspecified

    #if swift(>=5.10)
      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()
    #else
      static let defaultInstance = _StorageClass()
    #endif

    private init() {}

    init(copying source: _StorageClass) {
      _left = source._left
      _right = source._right
      _joinCondition = source._joinCondition
      _joinType = source._joinType
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._left) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._right) }()
        case 3: try { try decoder.decodeSingularMessageField(value: &_storage._joinCondition) }()
        case 4: try { try decoder.decodeSingularEnumField(value: &_storage._joinType) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._left {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      try { if let v = _storage._right {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
      try { if let v = _storage._joinCondition {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      } }()
      if _storage._joinType != .unspecified {
        try visitor.visitSingularEnumField(value: _storage._joinType, fieldNumber: 4)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_LateralJoin, rhs: Spark_Connect_LateralJoin) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._left != rhs_storage._left {return false}
        if _storage._right != rhs_storage._right {return false}
        if _storage._joinCondition != rhs_storage._joinCondition {return false}
        if _storage._joinType != rhs_storage._joinType {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
