//
// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// DO NOT EDIT.
// swift-format-ignore-file
// swiftlint:disable all
//
// Generated by the gRPC Swift generator plugin for the protocol buffer compiler.
// Source: spark/connect/base.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/grpc/grpc-swift

import GRPCCore
import GRPCProtobuf
import SwiftProtobuf

// MARK: - spark.connect.SparkConnectService

/// Namespace containing generated types for the "spark.connect.SparkConnectService" service.
@available(macOS 15.0, iOS 18.0, watchOS 11.0, tvOS 18.0, visionOS 2.0, *)
internal enum Spark_Connect_SparkConnectService {
    /// Service descriptor for the "spark.connect.SparkConnectService" service.
    internal static let descriptor = GRPCCore.ServiceDescriptor(fullyQualifiedService: "spark.connect.SparkConnectService")
    /// Namespace for method metadata.
    internal enum Method {
        /// Namespace for "ExecutePlan" metadata.
        internal enum ExecutePlan {
            /// Request type for "ExecutePlan".
            internal typealias Input = Spark_Connect_ExecutePlanRequest
            /// Response type for "ExecutePlan".
            internal typealias Output = Spark_Connect_ExecutePlanResponse
            /// Descriptor for "ExecutePlan".
            internal static let descriptor = GRPCCore.MethodDescriptor(
                service: GRPCCore.ServiceDescriptor(fullyQualifiedService: "spark.connect.SparkConnectService"),
                method: "ExecutePlan"
            )
        }
        /// Namespace for "AnalyzePlan" metadata.
        internal enum AnalyzePlan {
            /// Request type for "AnalyzePlan".
            internal typealias Input = Spark_Connect_AnalyzePlanRequest
            /// Response type for "AnalyzePlan".
            internal typealias Output = Spark_Connect_AnalyzePlanResponse
            /// Descriptor for "AnalyzePlan".
            internal static let descriptor = GRPCCore.MethodDescriptor(
                service: GRPCCore.ServiceDescriptor(fullyQualifiedService: "spark.connect.SparkConnectService"),
                method: "AnalyzePlan"
            )
        }
        /// Namespace for "Config" metadata.
        internal enum Config {
            /// Request type for "Config".
            internal typealias Input = Spark_Connect_ConfigRequest
            /// Response type for "Config".
            internal typealias Output = Spark_Connect_ConfigResponse
            /// Descriptor for "Config".
            internal static let descriptor = GRPCCore.MethodDescriptor(
                service: GRPCCore.ServiceDescriptor(fullyQualifiedService: "spark.connect.SparkConnectService"),
                method: "Config"
            )
        }
        /// Namespace for "AddArtifacts" metadata.
        internal enum AddArtifacts {
            /// Request type for "AddArtifacts".
            internal typealias Input = Spark_Connect_AddArtifactsRequest
            /// Response type for "AddArtifacts".
            internal typealias Output = Spark_Connect_AddArtifactsResponse
            /// Descriptor for "AddArtifacts".
            internal static let descriptor = GRPCCore.MethodDescriptor(
                service: GRPCCore.ServiceDescriptor(fullyQualifiedService: "spark.connect.SparkConnectService"),
                method: "AddArtifacts"
            )
        }
        /// Namespace for "ArtifactStatus" metadata.
        internal enum ArtifactStatus {
            /// Request type for "ArtifactStatus".
            internal typealias Input = Spark_Connect_ArtifactStatusesRequest
            /// Response type for "ArtifactStatus".
            internal typealias Output = Spark_Connect_ArtifactStatusesResponse
            /// Descriptor for "ArtifactStatus".
            internal static let descriptor = GRPCCore.MethodDescriptor(
                service: GRPCCore.ServiceDescriptor(fullyQualifiedService: "spark.connect.SparkConnectService"),
                method: "ArtifactStatus"
            )
        }
        /// Namespace for "Interrupt" metadata.
        internal enum Interrupt {
            /// Request type for "Interrupt".
            internal typealias Input = Spark_Connect_InterruptRequest
            /// Response type for "Interrupt".
            internal typealias Output = Spark_Connect_InterruptResponse
            /// Descriptor for "Interrupt".
            internal static let descriptor = GRPCCore.MethodDescriptor(
                service: GRPCCore.ServiceDescriptor(fullyQualifiedService: "spark.connect.SparkConnectService"),
                method: "Interrupt"
            )
        }
        /// Namespace for "ReattachExecute" metadata.
        internal enum ReattachExecute {
            /// Request type for "ReattachExecute".
            internal typealias Input = Spark_Connect_ReattachExecuteRequest
            /// Response type for "ReattachExecute".
            internal typealias Output = Spark_Connect_ExecutePlanResponse
            /// Descriptor for "ReattachExecute".
            internal static let descriptor = GRPCCore.MethodDescriptor(
                service: GRPCCore.ServiceDescriptor(fullyQualifiedService: "spark.connect.SparkConnectService"),
                method: "ReattachExecute"
            )
        }
        /// Namespace for "ReleaseExecute" metadata.
        internal enum ReleaseExecute {
            /// Request type for "ReleaseExecute".
            internal typealias Input = Spark_Connect_ReleaseExecuteRequest
            /// Response type for "ReleaseExecute".
            internal typealias Output = Spark_Connect_ReleaseExecuteResponse
            /// Descriptor for "ReleaseExecute".
            internal static let descriptor = GRPCCore.MethodDescriptor(
                service: GRPCCore.ServiceDescriptor(fullyQualifiedService: "spark.connect.SparkConnectService"),
                method: "ReleaseExecute"
            )
        }
        /// Namespace for "ReleaseSession" metadata.
        internal enum ReleaseSession {
            /// Request type for "ReleaseSession".
            internal typealias Input = Spark_Connect_ReleaseSessionRequest
            /// Response type for "ReleaseSession".
            internal typealias Output = Spark_Connect_ReleaseSessionResponse
            /// Descriptor for "ReleaseSession".
            internal static let descriptor = GRPCCore.MethodDescriptor(
                service: GRPCCore.ServiceDescriptor(fullyQualifiedService: "spark.connect.SparkConnectService"),
                method: "ReleaseSession"
            )
        }
        /// Namespace for "FetchErrorDetails" metadata.
        internal enum FetchErrorDetails {
            /// Request type for "FetchErrorDetails".
            internal typealias Input = Spark_Connect_FetchErrorDetailsRequest
            /// Response type for "FetchErrorDetails".
            internal typealias Output = Spark_Connect_FetchErrorDetailsResponse
            /// Descriptor for "FetchErrorDetails".
            internal static let descriptor = GRPCCore.MethodDescriptor(
                service: GRPCCore.ServiceDescriptor(fullyQualifiedService: "spark.connect.SparkConnectService"),
                method: "FetchErrorDetails"
            )
        }
        /// Descriptors for all methods in the "spark.connect.SparkConnectService" service.
        internal static let descriptors: [GRPCCore.MethodDescriptor] = [
            ExecutePlan.descriptor,
            AnalyzePlan.descriptor,
            Config.descriptor,
            AddArtifacts.descriptor,
            ArtifactStatus.descriptor,
            Interrupt.descriptor,
            ReattachExecute.descriptor,
            ReleaseExecute.descriptor,
            ReleaseSession.descriptor,
            FetchErrorDetails.descriptor
        ]
    }
}

@available(macOS 15.0, iOS 18.0, watchOS 11.0, tvOS 18.0, visionOS 2.0, *)
extension GRPCCore.ServiceDescriptor {
    /// Service descriptor for the "spark.connect.SparkConnectService" service.
    internal static let spark_connect_SparkConnectService = GRPCCore.ServiceDescriptor(fullyQualifiedService: "spark.connect.SparkConnectService")
}

// MARK: spark.connect.SparkConnectService (server)

@available(macOS 15.0, iOS 18.0, watchOS 11.0, tvOS 18.0, visionOS 2.0, *)
extension Spark_Connect_SparkConnectService {
    /// Streaming variant of the service protocol for the "spark.connect.SparkConnectService" service.
    ///
    /// This protocol is the lowest-level of the service protocols generated for this service
    /// giving you the most flexibility over the implementation of your service. This comes at
    /// the cost of more verbose and less strict APIs. Each RPC requires you to implement it in
    /// terms of a request stream and response stream. Where only a single request or response
    /// message is expected, you are responsible for enforcing this invariant is maintained.
    ///
    /// Where possible, prefer using the stricter, less-verbose ``ServiceProtocol``
    /// or ``SimpleServiceProtocol`` instead.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Main interface for the SparkConnect service.
    internal protocol StreamingServiceProtocol: GRPCCore.RegistrableRPCService {
        /// Handle the "ExecutePlan" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Executes a request that contains the query and returns a stream of [[Response]].
        /// > 
        /// > It is guaranteed that there is at least one ARROW batch returned even if the result set is empty.
        ///
        /// - Parameters:
        ///   - request: A streaming request of `Spark_Connect_ExecutePlanRequest` messages.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A streaming response of `Spark_Connect_ExecutePlanResponse` messages.
        func executePlan(
            request: GRPCCore.StreamingServerRequest<Spark_Connect_ExecutePlanRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_ExecutePlanResponse>

        /// Handle the "AnalyzePlan" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Analyzes a query and returns a [[AnalyzeResponse]] containing metadata about the query.
        ///
        /// - Parameters:
        ///   - request: A streaming request of `Spark_Connect_AnalyzePlanRequest` messages.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A streaming response of `Spark_Connect_AnalyzePlanResponse` messages.
        func analyzePlan(
            request: GRPCCore.StreamingServerRequest<Spark_Connect_AnalyzePlanRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_AnalyzePlanResponse>

        /// Handle the "Config" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Update or fetch the configurations and returns a [[ConfigResponse]] containing the result.
        ///
        /// - Parameters:
        ///   - request: A streaming request of `Spark_Connect_ConfigRequest` messages.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A streaming response of `Spark_Connect_ConfigResponse` messages.
        func config(
            request: GRPCCore.StreamingServerRequest<Spark_Connect_ConfigRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_ConfigResponse>

        /// Handle the "AddArtifacts" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Add artifacts to the session and returns a [[AddArtifactsResponse]] containing metadata about
        /// > the added artifacts.
        ///
        /// - Parameters:
        ///   - request: A streaming request of `Spark_Connect_AddArtifactsRequest` messages.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A streaming response of `Spark_Connect_AddArtifactsResponse` messages.
        func addArtifacts(
            request: GRPCCore.StreamingServerRequest<Spark_Connect_AddArtifactsRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_AddArtifactsResponse>

        /// Handle the "ArtifactStatus" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Check statuses of artifacts in the session and returns them in a [[ArtifactStatusesResponse]]
        ///
        /// - Parameters:
        ///   - request: A streaming request of `Spark_Connect_ArtifactStatusesRequest` messages.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A streaming response of `Spark_Connect_ArtifactStatusesResponse` messages.
        func artifactStatus(
            request: GRPCCore.StreamingServerRequest<Spark_Connect_ArtifactStatusesRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_ArtifactStatusesResponse>

        /// Handle the "Interrupt" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Interrupts running executions
        ///
        /// - Parameters:
        ///   - request: A streaming request of `Spark_Connect_InterruptRequest` messages.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A streaming response of `Spark_Connect_InterruptResponse` messages.
        func interrupt(
            request: GRPCCore.StreamingServerRequest<Spark_Connect_InterruptRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_InterruptResponse>

        /// Handle the "ReattachExecute" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Reattach to an existing reattachable execution.
        /// > The ExecutePlan must have been started with ReattachOptions.reattachable=true.
        /// > If the ExecutePlanResponse stream ends without a ResultComplete message, there is more to
        /// > continue. If there is a ResultComplete, the client should use ReleaseExecute with
        ///
        /// - Parameters:
        ///   - request: A streaming request of `Spark_Connect_ReattachExecuteRequest` messages.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A streaming response of `Spark_Connect_ExecutePlanResponse` messages.
        func reattachExecute(
            request: GRPCCore.StreamingServerRequest<Spark_Connect_ReattachExecuteRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_ExecutePlanResponse>

        /// Handle the "ReleaseExecute" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Release an reattachable execution, or parts thereof.
        /// > The ExecutePlan must have been started with ReattachOptions.reattachable=true.
        /// > Non reattachable executions are released automatically and immediately after the ExecutePlan
        /// > RPC and ReleaseExecute may not be used.
        ///
        /// - Parameters:
        ///   - request: A streaming request of `Spark_Connect_ReleaseExecuteRequest` messages.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A streaming response of `Spark_Connect_ReleaseExecuteResponse` messages.
        func releaseExecute(
            request: GRPCCore.StreamingServerRequest<Spark_Connect_ReleaseExecuteRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_ReleaseExecuteResponse>

        /// Handle the "ReleaseSession" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Release a session.
        /// > All the executions in the session will be released. Any further requests for the session with
        /// > that session_id for the given user_id will fail. If the session didn't exist or was already
        /// > released, this is a noop.
        ///
        /// - Parameters:
        ///   - request: A streaming request of `Spark_Connect_ReleaseSessionRequest` messages.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A streaming response of `Spark_Connect_ReleaseSessionResponse` messages.
        func releaseSession(
            request: GRPCCore.StreamingServerRequest<Spark_Connect_ReleaseSessionRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_ReleaseSessionResponse>

        /// Handle the "FetchErrorDetails" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > FetchErrorDetails retrieves the matched exception with details based on a provided error id.
        ///
        /// - Parameters:
        ///   - request: A streaming request of `Spark_Connect_FetchErrorDetailsRequest` messages.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A streaming response of `Spark_Connect_FetchErrorDetailsResponse` messages.
        func fetchErrorDetails(
            request: GRPCCore.StreamingServerRequest<Spark_Connect_FetchErrorDetailsRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_FetchErrorDetailsResponse>
    }

    /// Service protocol for the "spark.connect.SparkConnectService" service.
    ///
    /// This protocol is higher level than ``StreamingServiceProtocol`` but lower level than
    /// the ``SimpleServiceProtocol``, it provides access to request and response metadata and
    /// trailing response metadata. If you don't need these then consider using
    /// the ``SimpleServiceProtocol``. If you need fine grained control over your RPCs then
    /// use ``StreamingServiceProtocol``.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Main interface for the SparkConnect service.
    internal protocol ServiceProtocol: Spark_Connect_SparkConnectService.StreamingServiceProtocol {
        /// Handle the "ExecutePlan" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Executes a request that contains the query and returns a stream of [[Response]].
        /// > 
        /// > It is guaranteed that there is at least one ARROW batch returned even if the result set is empty.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ExecutePlanRequest` message.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A streaming response of `Spark_Connect_ExecutePlanResponse` messages.
        func executePlan(
            request: GRPCCore.ServerRequest<Spark_Connect_ExecutePlanRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_ExecutePlanResponse>

        /// Handle the "AnalyzePlan" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Analyzes a query and returns a [[AnalyzeResponse]] containing metadata about the query.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_AnalyzePlanRequest` message.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A response containing a single `Spark_Connect_AnalyzePlanResponse` message.
        func analyzePlan(
            request: GRPCCore.ServerRequest<Spark_Connect_AnalyzePlanRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.ServerResponse<Spark_Connect_AnalyzePlanResponse>

        /// Handle the "Config" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Update or fetch the configurations and returns a [[ConfigResponse]] containing the result.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ConfigRequest` message.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A response containing a single `Spark_Connect_ConfigResponse` message.
        func config(
            request: GRPCCore.ServerRequest<Spark_Connect_ConfigRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.ServerResponse<Spark_Connect_ConfigResponse>

        /// Handle the "AddArtifacts" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Add artifacts to the session and returns a [[AddArtifactsResponse]] containing metadata about
        /// > the added artifacts.
        ///
        /// - Parameters:
        ///   - request: A streaming request of `Spark_Connect_AddArtifactsRequest` messages.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A response containing a single `Spark_Connect_AddArtifactsResponse` message.
        func addArtifacts(
            request: GRPCCore.StreamingServerRequest<Spark_Connect_AddArtifactsRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.ServerResponse<Spark_Connect_AddArtifactsResponse>

        /// Handle the "ArtifactStatus" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Check statuses of artifacts in the session and returns them in a [[ArtifactStatusesResponse]]
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ArtifactStatusesRequest` message.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A response containing a single `Spark_Connect_ArtifactStatusesResponse` message.
        func artifactStatus(
            request: GRPCCore.ServerRequest<Spark_Connect_ArtifactStatusesRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.ServerResponse<Spark_Connect_ArtifactStatusesResponse>

        /// Handle the "Interrupt" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Interrupts running executions
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_InterruptRequest` message.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A response containing a single `Spark_Connect_InterruptResponse` message.
        func interrupt(
            request: GRPCCore.ServerRequest<Spark_Connect_InterruptRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.ServerResponse<Spark_Connect_InterruptResponse>

        /// Handle the "ReattachExecute" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Reattach to an existing reattachable execution.
        /// > The ExecutePlan must have been started with ReattachOptions.reattachable=true.
        /// > If the ExecutePlanResponse stream ends without a ResultComplete message, there is more to
        /// > continue. If there is a ResultComplete, the client should use ReleaseExecute with
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ReattachExecuteRequest` message.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A streaming response of `Spark_Connect_ExecutePlanResponse` messages.
        func reattachExecute(
            request: GRPCCore.ServerRequest<Spark_Connect_ReattachExecuteRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_ExecutePlanResponse>

        /// Handle the "ReleaseExecute" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Release an reattachable execution, or parts thereof.
        /// > The ExecutePlan must have been started with ReattachOptions.reattachable=true.
        /// > Non reattachable executions are released automatically and immediately after the ExecutePlan
        /// > RPC and ReleaseExecute may not be used.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ReleaseExecuteRequest` message.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A response containing a single `Spark_Connect_ReleaseExecuteResponse` message.
        func releaseExecute(
            request: GRPCCore.ServerRequest<Spark_Connect_ReleaseExecuteRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.ServerResponse<Spark_Connect_ReleaseExecuteResponse>

        /// Handle the "ReleaseSession" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Release a session.
        /// > All the executions in the session will be released. Any further requests for the session with
        /// > that session_id for the given user_id will fail. If the session didn't exist or was already
        /// > released, this is a noop.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ReleaseSessionRequest` message.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A response containing a single `Spark_Connect_ReleaseSessionResponse` message.
        func releaseSession(
            request: GRPCCore.ServerRequest<Spark_Connect_ReleaseSessionRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.ServerResponse<Spark_Connect_ReleaseSessionResponse>

        /// Handle the "FetchErrorDetails" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > FetchErrorDetails retrieves the matched exception with details based on a provided error id.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_FetchErrorDetailsRequest` message.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A response containing a single `Spark_Connect_FetchErrorDetailsResponse` message.
        func fetchErrorDetails(
            request: GRPCCore.ServerRequest<Spark_Connect_FetchErrorDetailsRequest>,
            context: GRPCCore.ServerContext
        ) async throws -> GRPCCore.ServerResponse<Spark_Connect_FetchErrorDetailsResponse>
    }

    /// Simple service protocol for the "spark.connect.SparkConnectService" service.
    ///
    /// This is the highest level protocol for the service. The API is the easiest to use but
    /// doesn't provide access to request or response metadata. If you need access to these
    /// then use ``ServiceProtocol`` instead.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Main interface for the SparkConnect service.
    internal protocol SimpleServiceProtocol: Spark_Connect_SparkConnectService.ServiceProtocol {
        /// Handle the "ExecutePlan" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Executes a request that contains the query and returns a stream of [[Response]].
        /// > 
        /// > It is guaranteed that there is at least one ARROW batch returned even if the result set is empty.
        ///
        /// - Parameters:
        ///   - request: A `Spark_Connect_ExecutePlanRequest` message.
        ///   - response: A response stream of `Spark_Connect_ExecutePlanResponse` messages.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        func executePlan(
            request: Spark_Connect_ExecutePlanRequest,
            response: GRPCCore.RPCWriter<Spark_Connect_ExecutePlanResponse>,
            context: GRPCCore.ServerContext
        ) async throws

        /// Handle the "AnalyzePlan" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Analyzes a query and returns a [[AnalyzeResponse]] containing metadata about the query.
        ///
        /// - Parameters:
        ///   - request: A `Spark_Connect_AnalyzePlanRequest` message.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A `Spark_Connect_AnalyzePlanResponse` to respond with.
        func analyzePlan(
            request: Spark_Connect_AnalyzePlanRequest,
            context: GRPCCore.ServerContext
        ) async throws -> Spark_Connect_AnalyzePlanResponse

        /// Handle the "Config" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Update or fetch the configurations and returns a [[ConfigResponse]] containing the result.
        ///
        /// - Parameters:
        ///   - request: A `Spark_Connect_ConfigRequest` message.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A `Spark_Connect_ConfigResponse` to respond with.
        func config(
            request: Spark_Connect_ConfigRequest,
            context: GRPCCore.ServerContext
        ) async throws -> Spark_Connect_ConfigResponse

        /// Handle the "AddArtifacts" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Add artifacts to the session and returns a [[AddArtifactsResponse]] containing metadata about
        /// > the added artifacts.
        ///
        /// - Parameters:
        ///   - request: A stream of `Spark_Connect_AddArtifactsRequest` messages.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A `Spark_Connect_AddArtifactsResponse` to respond with.
        func addArtifacts(
            request: GRPCCore.RPCAsyncSequence<Spark_Connect_AddArtifactsRequest, any Swift.Error>,
            context: GRPCCore.ServerContext
        ) async throws -> Spark_Connect_AddArtifactsResponse

        /// Handle the "ArtifactStatus" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Check statuses of artifacts in the session and returns them in a [[ArtifactStatusesResponse]]
        ///
        /// - Parameters:
        ///   - request: A `Spark_Connect_ArtifactStatusesRequest` message.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A `Spark_Connect_ArtifactStatusesResponse` to respond with.
        func artifactStatus(
            request: Spark_Connect_ArtifactStatusesRequest,
            context: GRPCCore.ServerContext
        ) async throws -> Spark_Connect_ArtifactStatusesResponse

        /// Handle the "Interrupt" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Interrupts running executions
        ///
        /// - Parameters:
        ///   - request: A `Spark_Connect_InterruptRequest` message.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A `Spark_Connect_InterruptResponse` to respond with.
        func interrupt(
            request: Spark_Connect_InterruptRequest,
            context: GRPCCore.ServerContext
        ) async throws -> Spark_Connect_InterruptResponse

        /// Handle the "ReattachExecute" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Reattach to an existing reattachable execution.
        /// > The ExecutePlan must have been started with ReattachOptions.reattachable=true.
        /// > If the ExecutePlanResponse stream ends without a ResultComplete message, there is more to
        /// > continue. If there is a ResultComplete, the client should use ReleaseExecute with
        ///
        /// - Parameters:
        ///   - request: A `Spark_Connect_ReattachExecuteRequest` message.
        ///   - response: A response stream of `Spark_Connect_ExecutePlanResponse` messages.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        func reattachExecute(
            request: Spark_Connect_ReattachExecuteRequest,
            response: GRPCCore.RPCWriter<Spark_Connect_ExecutePlanResponse>,
            context: GRPCCore.ServerContext
        ) async throws

        /// Handle the "ReleaseExecute" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Release an reattachable execution, or parts thereof.
        /// > The ExecutePlan must have been started with ReattachOptions.reattachable=true.
        /// > Non reattachable executions are released automatically and immediately after the ExecutePlan
        /// > RPC and ReleaseExecute may not be used.
        ///
        /// - Parameters:
        ///   - request: A `Spark_Connect_ReleaseExecuteRequest` message.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A `Spark_Connect_ReleaseExecuteResponse` to respond with.
        func releaseExecute(
            request: Spark_Connect_ReleaseExecuteRequest,
            context: GRPCCore.ServerContext
        ) async throws -> Spark_Connect_ReleaseExecuteResponse

        /// Handle the "ReleaseSession" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Release a session.
        /// > All the executions in the session will be released. Any further requests for the session with
        /// > that session_id for the given user_id will fail. If the session didn't exist or was already
        /// > released, this is a noop.
        ///
        /// - Parameters:
        ///   - request: A `Spark_Connect_ReleaseSessionRequest` message.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A `Spark_Connect_ReleaseSessionResponse` to respond with.
        func releaseSession(
            request: Spark_Connect_ReleaseSessionRequest,
            context: GRPCCore.ServerContext
        ) async throws -> Spark_Connect_ReleaseSessionResponse

        /// Handle the "FetchErrorDetails" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > FetchErrorDetails retrieves the matched exception with details based on a provided error id.
        ///
        /// - Parameters:
        ///   - request: A `Spark_Connect_FetchErrorDetailsRequest` message.
        ///   - context: Context providing information about the RPC.
        /// - Throws: Any error which occurred during the processing of the request. Thrown errors
        ///     of type `RPCError` are mapped to appropriate statuses. All other errors are converted
        ///     to an internal error.
        /// - Returns: A `Spark_Connect_FetchErrorDetailsResponse` to respond with.
        func fetchErrorDetails(
            request: Spark_Connect_FetchErrorDetailsRequest,
            context: GRPCCore.ServerContext
        ) async throws -> Spark_Connect_FetchErrorDetailsResponse
    }
}

// Default implementation of 'registerMethods(with:)'.
@available(macOS 15.0, iOS 18.0, watchOS 11.0, tvOS 18.0, visionOS 2.0, *)
extension Spark_Connect_SparkConnectService.StreamingServiceProtocol {
    internal func registerMethods<Transport>(with router: inout GRPCCore.RPCRouter<Transport>) where Transport: GRPCCore.ServerTransport {
        router.registerHandler(
            forMethod: Spark_Connect_SparkConnectService.Method.ExecutePlan.descriptor,
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_ExecutePlanRequest>(),
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_ExecutePlanResponse>(),
            handler: { request, context in
                try await self.executePlan(
                    request: request,
                    context: context
                )
            }
        )
        router.registerHandler(
            forMethod: Spark_Connect_SparkConnectService.Method.AnalyzePlan.descriptor,
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_AnalyzePlanRequest>(),
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_AnalyzePlanResponse>(),
            handler: { request, context in
                try await self.analyzePlan(
                    request: request,
                    context: context
                )
            }
        )
        router.registerHandler(
            forMethod: Spark_Connect_SparkConnectService.Method.Config.descriptor,
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_ConfigRequest>(),
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_ConfigResponse>(),
            handler: { request, context in
                try await self.config(
                    request: request,
                    context: context
                )
            }
        )
        router.registerHandler(
            forMethod: Spark_Connect_SparkConnectService.Method.AddArtifacts.descriptor,
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_AddArtifactsRequest>(),
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_AddArtifactsResponse>(),
            handler: { request, context in
                try await self.addArtifacts(
                    request: request,
                    context: context
                )
            }
        )
        router.registerHandler(
            forMethod: Spark_Connect_SparkConnectService.Method.ArtifactStatus.descriptor,
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_ArtifactStatusesRequest>(),
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_ArtifactStatusesResponse>(),
            handler: { request, context in
                try await self.artifactStatus(
                    request: request,
                    context: context
                )
            }
        )
        router.registerHandler(
            forMethod: Spark_Connect_SparkConnectService.Method.Interrupt.descriptor,
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_InterruptRequest>(),
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_InterruptResponse>(),
            handler: { request, context in
                try await self.interrupt(
                    request: request,
                    context: context
                )
            }
        )
        router.registerHandler(
            forMethod: Spark_Connect_SparkConnectService.Method.ReattachExecute.descriptor,
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_ReattachExecuteRequest>(),
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_ExecutePlanResponse>(),
            handler: { request, context in
                try await self.reattachExecute(
                    request: request,
                    context: context
                )
            }
        )
        router.registerHandler(
            forMethod: Spark_Connect_SparkConnectService.Method.ReleaseExecute.descriptor,
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_ReleaseExecuteRequest>(),
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_ReleaseExecuteResponse>(),
            handler: { request, context in
                try await self.releaseExecute(
                    request: request,
                    context: context
                )
            }
        )
        router.registerHandler(
            forMethod: Spark_Connect_SparkConnectService.Method.ReleaseSession.descriptor,
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_ReleaseSessionRequest>(),
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_ReleaseSessionResponse>(),
            handler: { request, context in
                try await self.releaseSession(
                    request: request,
                    context: context
                )
            }
        )
        router.registerHandler(
            forMethod: Spark_Connect_SparkConnectService.Method.FetchErrorDetails.descriptor,
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_FetchErrorDetailsRequest>(),
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_FetchErrorDetailsResponse>(),
            handler: { request, context in
                try await self.fetchErrorDetails(
                    request: request,
                    context: context
                )
            }
        )
    }
}

// Default implementation of streaming methods from 'StreamingServiceProtocol'.
@available(macOS 15.0, iOS 18.0, watchOS 11.0, tvOS 18.0, visionOS 2.0, *)
extension Spark_Connect_SparkConnectService.ServiceProtocol {
    internal func executePlan(
        request: GRPCCore.StreamingServerRequest<Spark_Connect_ExecutePlanRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_ExecutePlanResponse> {
        let response = try await self.executePlan(
            request: GRPCCore.ServerRequest(stream: request),
            context: context
        )
        return response
    }

    internal func analyzePlan(
        request: GRPCCore.StreamingServerRequest<Spark_Connect_AnalyzePlanRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_AnalyzePlanResponse> {
        let response = try await self.analyzePlan(
            request: GRPCCore.ServerRequest(stream: request),
            context: context
        )
        return GRPCCore.StreamingServerResponse(single: response)
    }

    internal func config(
        request: GRPCCore.StreamingServerRequest<Spark_Connect_ConfigRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_ConfigResponse> {
        let response = try await self.config(
            request: GRPCCore.ServerRequest(stream: request),
            context: context
        )
        return GRPCCore.StreamingServerResponse(single: response)
    }

    internal func addArtifacts(
        request: GRPCCore.StreamingServerRequest<Spark_Connect_AddArtifactsRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_AddArtifactsResponse> {
        let response = try await self.addArtifacts(
            request: request,
            context: context
        )
        return GRPCCore.StreamingServerResponse(single: response)
    }

    internal func artifactStatus(
        request: GRPCCore.StreamingServerRequest<Spark_Connect_ArtifactStatusesRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_ArtifactStatusesResponse> {
        let response = try await self.artifactStatus(
            request: GRPCCore.ServerRequest(stream: request),
            context: context
        )
        return GRPCCore.StreamingServerResponse(single: response)
    }

    internal func interrupt(
        request: GRPCCore.StreamingServerRequest<Spark_Connect_InterruptRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_InterruptResponse> {
        let response = try await self.interrupt(
            request: GRPCCore.ServerRequest(stream: request),
            context: context
        )
        return GRPCCore.StreamingServerResponse(single: response)
    }

    internal func reattachExecute(
        request: GRPCCore.StreamingServerRequest<Spark_Connect_ReattachExecuteRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_ExecutePlanResponse> {
        let response = try await self.reattachExecute(
            request: GRPCCore.ServerRequest(stream: request),
            context: context
        )
        return response
    }

    internal func releaseExecute(
        request: GRPCCore.StreamingServerRequest<Spark_Connect_ReleaseExecuteRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_ReleaseExecuteResponse> {
        let response = try await self.releaseExecute(
            request: GRPCCore.ServerRequest(stream: request),
            context: context
        )
        return GRPCCore.StreamingServerResponse(single: response)
    }

    internal func releaseSession(
        request: GRPCCore.StreamingServerRequest<Spark_Connect_ReleaseSessionRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_ReleaseSessionResponse> {
        let response = try await self.releaseSession(
            request: GRPCCore.ServerRequest(stream: request),
            context: context
        )
        return GRPCCore.StreamingServerResponse(single: response)
    }

    internal func fetchErrorDetails(
        request: GRPCCore.StreamingServerRequest<Spark_Connect_FetchErrorDetailsRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_FetchErrorDetailsResponse> {
        let response = try await self.fetchErrorDetails(
            request: GRPCCore.ServerRequest(stream: request),
            context: context
        )
        return GRPCCore.StreamingServerResponse(single: response)
    }
}

// Default implementation of methods from 'ServiceProtocol'.
@available(macOS 15.0, iOS 18.0, watchOS 11.0, tvOS 18.0, visionOS 2.0, *)
extension Spark_Connect_SparkConnectService.SimpleServiceProtocol {
    internal func executePlan(
        request: GRPCCore.ServerRequest<Spark_Connect_ExecutePlanRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_ExecutePlanResponse> {
        return GRPCCore.StreamingServerResponse<Spark_Connect_ExecutePlanResponse>(
            metadata: [:],
            producer: { writer in
                try await self.executePlan(
                    request: request.message,
                    response: writer,
                    context: context
                )
                return [:]
            }
        )
    }

    internal func analyzePlan(
        request: GRPCCore.ServerRequest<Spark_Connect_AnalyzePlanRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.ServerResponse<Spark_Connect_AnalyzePlanResponse> {
        return GRPCCore.ServerResponse<Spark_Connect_AnalyzePlanResponse>(
            message: try await self.analyzePlan(
                request: request.message,
                context: context
            ),
            metadata: [:]
        )
    }

    internal func config(
        request: GRPCCore.ServerRequest<Spark_Connect_ConfigRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.ServerResponse<Spark_Connect_ConfigResponse> {
        return GRPCCore.ServerResponse<Spark_Connect_ConfigResponse>(
            message: try await self.config(
                request: request.message,
                context: context
            ),
            metadata: [:]
        )
    }

    internal func addArtifacts(
        request: GRPCCore.StreamingServerRequest<Spark_Connect_AddArtifactsRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.ServerResponse<Spark_Connect_AddArtifactsResponse> {
        return GRPCCore.ServerResponse<Spark_Connect_AddArtifactsResponse>(
            message: try await self.addArtifacts(
                request: request.messages,
                context: context
            ),
            metadata: [:]
        )
    }

    internal func artifactStatus(
        request: GRPCCore.ServerRequest<Spark_Connect_ArtifactStatusesRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.ServerResponse<Spark_Connect_ArtifactStatusesResponse> {
        return GRPCCore.ServerResponse<Spark_Connect_ArtifactStatusesResponse>(
            message: try await self.artifactStatus(
                request: request.message,
                context: context
            ),
            metadata: [:]
        )
    }

    internal func interrupt(
        request: GRPCCore.ServerRequest<Spark_Connect_InterruptRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.ServerResponse<Spark_Connect_InterruptResponse> {
        return GRPCCore.ServerResponse<Spark_Connect_InterruptResponse>(
            message: try await self.interrupt(
                request: request.message,
                context: context
            ),
            metadata: [:]
        )
    }

    internal func reattachExecute(
        request: GRPCCore.ServerRequest<Spark_Connect_ReattachExecuteRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.StreamingServerResponse<Spark_Connect_ExecutePlanResponse> {
        return GRPCCore.StreamingServerResponse<Spark_Connect_ExecutePlanResponse>(
            metadata: [:],
            producer: { writer in
                try await self.reattachExecute(
                    request: request.message,
                    response: writer,
                    context: context
                )
                return [:]
            }
        )
    }

    internal func releaseExecute(
        request: GRPCCore.ServerRequest<Spark_Connect_ReleaseExecuteRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.ServerResponse<Spark_Connect_ReleaseExecuteResponse> {
        return GRPCCore.ServerResponse<Spark_Connect_ReleaseExecuteResponse>(
            message: try await self.releaseExecute(
                request: request.message,
                context: context
            ),
            metadata: [:]
        )
    }

    internal func releaseSession(
        request: GRPCCore.ServerRequest<Spark_Connect_ReleaseSessionRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.ServerResponse<Spark_Connect_ReleaseSessionResponse> {
        return GRPCCore.ServerResponse<Spark_Connect_ReleaseSessionResponse>(
            message: try await self.releaseSession(
                request: request.message,
                context: context
            ),
            metadata: [:]
        )
    }

    internal func fetchErrorDetails(
        request: GRPCCore.ServerRequest<Spark_Connect_FetchErrorDetailsRequest>,
        context: GRPCCore.ServerContext
    ) async throws -> GRPCCore.ServerResponse<Spark_Connect_FetchErrorDetailsResponse> {
        return GRPCCore.ServerResponse<Spark_Connect_FetchErrorDetailsResponse>(
            message: try await self.fetchErrorDetails(
                request: request.message,
                context: context
            ),
            metadata: [:]
        )
    }
}

// MARK: spark.connect.SparkConnectService (client)

@available(macOS 15.0, iOS 18.0, watchOS 11.0, tvOS 18.0, visionOS 2.0, *)
extension Spark_Connect_SparkConnectService {
    /// Generated client protocol for the "spark.connect.SparkConnectService" service.
    ///
    /// You don't need to implement this protocol directly, use the generated
    /// implementation, ``Client``.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Main interface for the SparkConnect service.
    internal protocol ClientProtocol: Sendable {
        /// Call the "ExecutePlan" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Executes a request that contains the query and returns a stream of [[Response]].
        /// > 
        /// > It is guaranteed that there is at least one ARROW batch returned even if the result set is empty.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ExecutePlanRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_ExecutePlanRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_ExecutePlanResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        func executePlan<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_ExecutePlanRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_ExecutePlanRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_ExecutePlanResponse>,
            options: GRPCCore.CallOptions,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.StreamingClientResponse<Spark_Connect_ExecutePlanResponse>) async throws -> Result
        ) async throws -> Result where Result: Sendable

        /// Call the "AnalyzePlan" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Analyzes a query and returns a [[AnalyzeResponse]] containing metadata about the query.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_AnalyzePlanRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_AnalyzePlanRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_AnalyzePlanResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        func analyzePlan<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_AnalyzePlanRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_AnalyzePlanRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_AnalyzePlanResponse>,
            options: GRPCCore.CallOptions,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_AnalyzePlanResponse>) async throws -> Result
        ) async throws -> Result where Result: Sendable

        /// Call the "Config" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Update or fetch the configurations and returns a [[ConfigResponse]] containing the result.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ConfigRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_ConfigRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_ConfigResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        func config<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_ConfigRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_ConfigRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_ConfigResponse>,
            options: GRPCCore.CallOptions,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_ConfigResponse>) async throws -> Result
        ) async throws -> Result where Result: Sendable

        /// Call the "AddArtifacts" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Add artifacts to the session and returns a [[AddArtifactsResponse]] containing metadata about
        /// > the added artifacts.
        ///
        /// - Parameters:
        ///   - request: A streaming request producing `Spark_Connect_AddArtifactsRequest` messages.
        ///   - serializer: A serializer for `Spark_Connect_AddArtifactsRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_AddArtifactsResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        func addArtifacts<Result>(
            request: GRPCCore.StreamingClientRequest<Spark_Connect_AddArtifactsRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_AddArtifactsRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_AddArtifactsResponse>,
            options: GRPCCore.CallOptions,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_AddArtifactsResponse>) async throws -> Result
        ) async throws -> Result where Result: Sendable

        /// Call the "ArtifactStatus" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Check statuses of artifacts in the session and returns them in a [[ArtifactStatusesResponse]]
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ArtifactStatusesRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_ArtifactStatusesRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_ArtifactStatusesResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        func artifactStatus<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_ArtifactStatusesRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_ArtifactStatusesRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_ArtifactStatusesResponse>,
            options: GRPCCore.CallOptions,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_ArtifactStatusesResponse>) async throws -> Result
        ) async throws -> Result where Result: Sendable

        /// Call the "Interrupt" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Interrupts running executions
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_InterruptRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_InterruptRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_InterruptResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        func interrupt<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_InterruptRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_InterruptRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_InterruptResponse>,
            options: GRPCCore.CallOptions,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_InterruptResponse>) async throws -> Result
        ) async throws -> Result where Result: Sendable

        /// Call the "ReattachExecute" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Reattach to an existing reattachable execution.
        /// > The ExecutePlan must have been started with ReattachOptions.reattachable=true.
        /// > If the ExecutePlanResponse stream ends without a ResultComplete message, there is more to
        /// > continue. If there is a ResultComplete, the client should use ReleaseExecute with
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ReattachExecuteRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_ReattachExecuteRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_ExecutePlanResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        func reattachExecute<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_ReattachExecuteRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_ReattachExecuteRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_ExecutePlanResponse>,
            options: GRPCCore.CallOptions,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.StreamingClientResponse<Spark_Connect_ExecutePlanResponse>) async throws -> Result
        ) async throws -> Result where Result: Sendable

        /// Call the "ReleaseExecute" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Release an reattachable execution, or parts thereof.
        /// > The ExecutePlan must have been started with ReattachOptions.reattachable=true.
        /// > Non reattachable executions are released automatically and immediately after the ExecutePlan
        /// > RPC and ReleaseExecute may not be used.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ReleaseExecuteRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_ReleaseExecuteRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_ReleaseExecuteResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        func releaseExecute<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_ReleaseExecuteRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_ReleaseExecuteRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_ReleaseExecuteResponse>,
            options: GRPCCore.CallOptions,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_ReleaseExecuteResponse>) async throws -> Result
        ) async throws -> Result where Result: Sendable

        /// Call the "ReleaseSession" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Release a session.
        /// > All the executions in the session will be released. Any further requests for the session with
        /// > that session_id for the given user_id will fail. If the session didn't exist or was already
        /// > released, this is a noop.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ReleaseSessionRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_ReleaseSessionRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_ReleaseSessionResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        func releaseSession<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_ReleaseSessionRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_ReleaseSessionRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_ReleaseSessionResponse>,
            options: GRPCCore.CallOptions,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_ReleaseSessionResponse>) async throws -> Result
        ) async throws -> Result where Result: Sendable

        /// Call the "FetchErrorDetails" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > FetchErrorDetails retrieves the matched exception with details based on a provided error id.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_FetchErrorDetailsRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_FetchErrorDetailsRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_FetchErrorDetailsResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        func fetchErrorDetails<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_FetchErrorDetailsRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_FetchErrorDetailsRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_FetchErrorDetailsResponse>,
            options: GRPCCore.CallOptions,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_FetchErrorDetailsResponse>) async throws -> Result
        ) async throws -> Result where Result: Sendable
    }

    /// Generated client for the "spark.connect.SparkConnectService" service.
    ///
    /// The ``Client`` provides an implementation of ``ClientProtocol`` which wraps
    /// a `GRPCCore.GRPCCClient`. The underlying `GRPCClient` provides the long-lived
    /// means of communication with the remote peer.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Main interface for the SparkConnect service.
    internal struct Client<Transport>: ClientProtocol where Transport: GRPCCore.ClientTransport {
        private let client: GRPCCore.GRPCClient<Transport>

        /// Creates a new client wrapping the provided `GRPCCore.GRPCClient`.
        ///
        /// - Parameters:
        ///   - client: A `GRPCCore.GRPCClient` providing a communication channel to the service.
        internal init(wrapping client: GRPCCore.GRPCClient<Transport>) {
            self.client = client
        }

        /// Call the "ExecutePlan" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Executes a request that contains the query and returns a stream of [[Response]].
        /// > 
        /// > It is guaranteed that there is at least one ARROW batch returned even if the result set is empty.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ExecutePlanRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_ExecutePlanRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_ExecutePlanResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        internal func executePlan<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_ExecutePlanRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_ExecutePlanRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_ExecutePlanResponse>,
            options: GRPCCore.CallOptions = .defaults,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.StreamingClientResponse<Spark_Connect_ExecutePlanResponse>) async throws -> Result
        ) async throws -> Result where Result: Sendable {
            try await self.client.serverStreaming(
                request: request,
                descriptor: Spark_Connect_SparkConnectService.Method.ExecutePlan.descriptor,
                serializer: serializer,
                deserializer: deserializer,
                options: options,
                onResponse: handleResponse
            )
        }

        /// Call the "AnalyzePlan" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Analyzes a query and returns a [[AnalyzeResponse]] containing metadata about the query.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_AnalyzePlanRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_AnalyzePlanRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_AnalyzePlanResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        internal func analyzePlan<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_AnalyzePlanRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_AnalyzePlanRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_AnalyzePlanResponse>,
            options: GRPCCore.CallOptions = .defaults,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_AnalyzePlanResponse>) async throws -> Result = { response in
                try response.message
            }
        ) async throws -> Result where Result: Sendable {
            try await self.client.unary(
                request: request,
                descriptor: Spark_Connect_SparkConnectService.Method.AnalyzePlan.descriptor,
                serializer: serializer,
                deserializer: deserializer,
                options: options,
                onResponse: handleResponse
            )
        }

        /// Call the "Config" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Update or fetch the configurations and returns a [[ConfigResponse]] containing the result.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ConfigRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_ConfigRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_ConfigResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        internal func config<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_ConfigRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_ConfigRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_ConfigResponse>,
            options: GRPCCore.CallOptions = .defaults,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_ConfigResponse>) async throws -> Result = { response in
                try response.message
            }
        ) async throws -> Result where Result: Sendable {
            try await self.client.unary(
                request: request,
                descriptor: Spark_Connect_SparkConnectService.Method.Config.descriptor,
                serializer: serializer,
                deserializer: deserializer,
                options: options,
                onResponse: handleResponse
            )
        }

        /// Call the "AddArtifacts" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Add artifacts to the session and returns a [[AddArtifactsResponse]] containing metadata about
        /// > the added artifacts.
        ///
        /// - Parameters:
        ///   - request: A streaming request producing `Spark_Connect_AddArtifactsRequest` messages.
        ///   - serializer: A serializer for `Spark_Connect_AddArtifactsRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_AddArtifactsResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        internal func addArtifacts<Result>(
            request: GRPCCore.StreamingClientRequest<Spark_Connect_AddArtifactsRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_AddArtifactsRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_AddArtifactsResponse>,
            options: GRPCCore.CallOptions = .defaults,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_AddArtifactsResponse>) async throws -> Result = { response in
                try response.message
            }
        ) async throws -> Result where Result: Sendable {
            try await self.client.clientStreaming(
                request: request,
                descriptor: Spark_Connect_SparkConnectService.Method.AddArtifacts.descriptor,
                serializer: serializer,
                deserializer: deserializer,
                options: options,
                onResponse: handleResponse
            )
        }

        /// Call the "ArtifactStatus" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Check statuses of artifacts in the session and returns them in a [[ArtifactStatusesResponse]]
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ArtifactStatusesRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_ArtifactStatusesRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_ArtifactStatusesResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        internal func artifactStatus<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_ArtifactStatusesRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_ArtifactStatusesRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_ArtifactStatusesResponse>,
            options: GRPCCore.CallOptions = .defaults,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_ArtifactStatusesResponse>) async throws -> Result = { response in
                try response.message
            }
        ) async throws -> Result where Result: Sendable {
            try await self.client.unary(
                request: request,
                descriptor: Spark_Connect_SparkConnectService.Method.ArtifactStatus.descriptor,
                serializer: serializer,
                deserializer: deserializer,
                options: options,
                onResponse: handleResponse
            )
        }

        /// Call the "Interrupt" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Interrupts running executions
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_InterruptRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_InterruptRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_InterruptResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        internal func interrupt<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_InterruptRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_InterruptRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_InterruptResponse>,
            options: GRPCCore.CallOptions = .defaults,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_InterruptResponse>) async throws -> Result = { response in
                try response.message
            }
        ) async throws -> Result where Result: Sendable {
            try await self.client.unary(
                request: request,
                descriptor: Spark_Connect_SparkConnectService.Method.Interrupt.descriptor,
                serializer: serializer,
                deserializer: deserializer,
                options: options,
                onResponse: handleResponse
            )
        }

        /// Call the "ReattachExecute" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Reattach to an existing reattachable execution.
        /// > The ExecutePlan must have been started with ReattachOptions.reattachable=true.
        /// > If the ExecutePlanResponse stream ends without a ResultComplete message, there is more to
        /// > continue. If there is a ResultComplete, the client should use ReleaseExecute with
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ReattachExecuteRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_ReattachExecuteRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_ExecutePlanResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        internal func reattachExecute<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_ReattachExecuteRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_ReattachExecuteRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_ExecutePlanResponse>,
            options: GRPCCore.CallOptions = .defaults,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.StreamingClientResponse<Spark_Connect_ExecutePlanResponse>) async throws -> Result
        ) async throws -> Result where Result: Sendable {
            try await self.client.serverStreaming(
                request: request,
                descriptor: Spark_Connect_SparkConnectService.Method.ReattachExecute.descriptor,
                serializer: serializer,
                deserializer: deserializer,
                options: options,
                onResponse: handleResponse
            )
        }

        /// Call the "ReleaseExecute" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Release an reattachable execution, or parts thereof.
        /// > The ExecutePlan must have been started with ReattachOptions.reattachable=true.
        /// > Non reattachable executions are released automatically and immediately after the ExecutePlan
        /// > RPC and ReleaseExecute may not be used.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ReleaseExecuteRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_ReleaseExecuteRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_ReleaseExecuteResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        internal func releaseExecute<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_ReleaseExecuteRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_ReleaseExecuteRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_ReleaseExecuteResponse>,
            options: GRPCCore.CallOptions = .defaults,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_ReleaseExecuteResponse>) async throws -> Result = { response in
                try response.message
            }
        ) async throws -> Result where Result: Sendable {
            try await self.client.unary(
                request: request,
                descriptor: Spark_Connect_SparkConnectService.Method.ReleaseExecute.descriptor,
                serializer: serializer,
                deserializer: deserializer,
                options: options,
                onResponse: handleResponse
            )
        }

        /// Call the "ReleaseSession" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > Release a session.
        /// > All the executions in the session will be released. Any further requests for the session with
        /// > that session_id for the given user_id will fail. If the session didn't exist or was already
        /// > released, this is a noop.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_ReleaseSessionRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_ReleaseSessionRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_ReleaseSessionResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        internal func releaseSession<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_ReleaseSessionRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_ReleaseSessionRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_ReleaseSessionResponse>,
            options: GRPCCore.CallOptions = .defaults,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_ReleaseSessionResponse>) async throws -> Result = { response in
                try response.message
            }
        ) async throws -> Result where Result: Sendable {
            try await self.client.unary(
                request: request,
                descriptor: Spark_Connect_SparkConnectService.Method.ReleaseSession.descriptor,
                serializer: serializer,
                deserializer: deserializer,
                options: options,
                onResponse: handleResponse
            )
        }

        /// Call the "FetchErrorDetails" method.
        ///
        /// > Source IDL Documentation:
        /// >
        /// > FetchErrorDetails retrieves the matched exception with details based on a provided error id.
        ///
        /// - Parameters:
        ///   - request: A request containing a single `Spark_Connect_FetchErrorDetailsRequest` message.
        ///   - serializer: A serializer for `Spark_Connect_FetchErrorDetailsRequest` messages.
        ///   - deserializer: A deserializer for `Spark_Connect_FetchErrorDetailsResponse` messages.
        ///   - options: Options to apply to this RPC.
        ///   - handleResponse: A closure which handles the response, the result of which is
        ///       returned to the caller. Returning from the closure will cancel the RPC if it
        ///       hasn't already finished.
        /// - Returns: The result of `handleResponse`.
        internal func fetchErrorDetails<Result>(
            request: GRPCCore.ClientRequest<Spark_Connect_FetchErrorDetailsRequest>,
            serializer: some GRPCCore.MessageSerializer<Spark_Connect_FetchErrorDetailsRequest>,
            deserializer: some GRPCCore.MessageDeserializer<Spark_Connect_FetchErrorDetailsResponse>,
            options: GRPCCore.CallOptions = .defaults,
            onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_FetchErrorDetailsResponse>) async throws -> Result = { response in
                try response.message
            }
        ) async throws -> Result where Result: Sendable {
            try await self.client.unary(
                request: request,
                descriptor: Spark_Connect_SparkConnectService.Method.FetchErrorDetails.descriptor,
                serializer: serializer,
                deserializer: deserializer,
                options: options,
                onResponse: handleResponse
            )
        }
    }
}

// Helpers providing default arguments to 'ClientProtocol' methods.
@available(macOS 15.0, iOS 18.0, watchOS 11.0, tvOS 18.0, visionOS 2.0, *)
extension Spark_Connect_SparkConnectService.ClientProtocol {
    /// Call the "ExecutePlan" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Executes a request that contains the query and returns a stream of [[Response]].
    /// > 
    /// > It is guaranteed that there is at least one ARROW batch returned even if the result set is empty.
    ///
    /// - Parameters:
    ///   - request: A request containing a single `Spark_Connect_ExecutePlanRequest` message.
    ///   - options: Options to apply to this RPC.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func executePlan<Result>(
        request: GRPCCore.ClientRequest<Spark_Connect_ExecutePlanRequest>,
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.StreamingClientResponse<Spark_Connect_ExecutePlanResponse>) async throws -> Result
    ) async throws -> Result where Result: Sendable {
        try await self.executePlan(
            request: request,
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_ExecutePlanRequest>(),
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_ExecutePlanResponse>(),
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "AnalyzePlan" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Analyzes a query and returns a [[AnalyzeResponse]] containing metadata about the query.
    ///
    /// - Parameters:
    ///   - request: A request containing a single `Spark_Connect_AnalyzePlanRequest` message.
    ///   - options: Options to apply to this RPC.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func analyzePlan<Result>(
        request: GRPCCore.ClientRequest<Spark_Connect_AnalyzePlanRequest>,
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_AnalyzePlanResponse>) async throws -> Result = { response in
            try response.message
        }
    ) async throws -> Result where Result: Sendable {
        try await self.analyzePlan(
            request: request,
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_AnalyzePlanRequest>(),
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_AnalyzePlanResponse>(),
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "Config" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Update or fetch the configurations and returns a [[ConfigResponse]] containing the result.
    ///
    /// - Parameters:
    ///   - request: A request containing a single `Spark_Connect_ConfigRequest` message.
    ///   - options: Options to apply to this RPC.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func config<Result>(
        request: GRPCCore.ClientRequest<Spark_Connect_ConfigRequest>,
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_ConfigResponse>) async throws -> Result = { response in
            try response.message
        }
    ) async throws -> Result where Result: Sendable {
        try await self.config(
            request: request,
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_ConfigRequest>(),
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_ConfigResponse>(),
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "AddArtifacts" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Add artifacts to the session and returns a [[AddArtifactsResponse]] containing metadata about
    /// > the added artifacts.
    ///
    /// - Parameters:
    ///   - request: A streaming request producing `Spark_Connect_AddArtifactsRequest` messages.
    ///   - options: Options to apply to this RPC.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func addArtifacts<Result>(
        request: GRPCCore.StreamingClientRequest<Spark_Connect_AddArtifactsRequest>,
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_AddArtifactsResponse>) async throws -> Result = { response in
            try response.message
        }
    ) async throws -> Result where Result: Sendable {
        try await self.addArtifacts(
            request: request,
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_AddArtifactsRequest>(),
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_AddArtifactsResponse>(),
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "ArtifactStatus" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Check statuses of artifacts in the session and returns them in a [[ArtifactStatusesResponse]]
    ///
    /// - Parameters:
    ///   - request: A request containing a single `Spark_Connect_ArtifactStatusesRequest` message.
    ///   - options: Options to apply to this RPC.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func artifactStatus<Result>(
        request: GRPCCore.ClientRequest<Spark_Connect_ArtifactStatusesRequest>,
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_ArtifactStatusesResponse>) async throws -> Result = { response in
            try response.message
        }
    ) async throws -> Result where Result: Sendable {
        try await self.artifactStatus(
            request: request,
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_ArtifactStatusesRequest>(),
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_ArtifactStatusesResponse>(),
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "Interrupt" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Interrupts running executions
    ///
    /// - Parameters:
    ///   - request: A request containing a single `Spark_Connect_InterruptRequest` message.
    ///   - options: Options to apply to this RPC.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func interrupt<Result>(
        request: GRPCCore.ClientRequest<Spark_Connect_InterruptRequest>,
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_InterruptResponse>) async throws -> Result = { response in
            try response.message
        }
    ) async throws -> Result where Result: Sendable {
        try await self.interrupt(
            request: request,
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_InterruptRequest>(),
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_InterruptResponse>(),
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "ReattachExecute" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Reattach to an existing reattachable execution.
    /// > The ExecutePlan must have been started with ReattachOptions.reattachable=true.
    /// > If the ExecutePlanResponse stream ends without a ResultComplete message, there is more to
    /// > continue. If there is a ResultComplete, the client should use ReleaseExecute with
    ///
    /// - Parameters:
    ///   - request: A request containing a single `Spark_Connect_ReattachExecuteRequest` message.
    ///   - options: Options to apply to this RPC.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func reattachExecute<Result>(
        request: GRPCCore.ClientRequest<Spark_Connect_ReattachExecuteRequest>,
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.StreamingClientResponse<Spark_Connect_ExecutePlanResponse>) async throws -> Result
    ) async throws -> Result where Result: Sendable {
        try await self.reattachExecute(
            request: request,
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_ReattachExecuteRequest>(),
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_ExecutePlanResponse>(),
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "ReleaseExecute" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Release an reattachable execution, or parts thereof.
    /// > The ExecutePlan must have been started with ReattachOptions.reattachable=true.
    /// > Non reattachable executions are released automatically and immediately after the ExecutePlan
    /// > RPC and ReleaseExecute may not be used.
    ///
    /// - Parameters:
    ///   - request: A request containing a single `Spark_Connect_ReleaseExecuteRequest` message.
    ///   - options: Options to apply to this RPC.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func releaseExecute<Result>(
        request: GRPCCore.ClientRequest<Spark_Connect_ReleaseExecuteRequest>,
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_ReleaseExecuteResponse>) async throws -> Result = { response in
            try response.message
        }
    ) async throws -> Result where Result: Sendable {
        try await self.releaseExecute(
            request: request,
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_ReleaseExecuteRequest>(),
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_ReleaseExecuteResponse>(),
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "ReleaseSession" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Release a session.
    /// > All the executions in the session will be released. Any further requests for the session with
    /// > that session_id for the given user_id will fail. If the session didn't exist or was already
    /// > released, this is a noop.
    ///
    /// - Parameters:
    ///   - request: A request containing a single `Spark_Connect_ReleaseSessionRequest` message.
    ///   - options: Options to apply to this RPC.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func releaseSession<Result>(
        request: GRPCCore.ClientRequest<Spark_Connect_ReleaseSessionRequest>,
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_ReleaseSessionResponse>) async throws -> Result = { response in
            try response.message
        }
    ) async throws -> Result where Result: Sendable {
        try await self.releaseSession(
            request: request,
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_ReleaseSessionRequest>(),
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_ReleaseSessionResponse>(),
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "FetchErrorDetails" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > FetchErrorDetails retrieves the matched exception with details based on a provided error id.
    ///
    /// - Parameters:
    ///   - request: A request containing a single `Spark_Connect_FetchErrorDetailsRequest` message.
    ///   - options: Options to apply to this RPC.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func fetchErrorDetails<Result>(
        request: GRPCCore.ClientRequest<Spark_Connect_FetchErrorDetailsRequest>,
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_FetchErrorDetailsResponse>) async throws -> Result = { response in
            try response.message
        }
    ) async throws -> Result where Result: Sendable {
        try await self.fetchErrorDetails(
            request: request,
            serializer: GRPCProtobuf.ProtobufSerializer<Spark_Connect_FetchErrorDetailsRequest>(),
            deserializer: GRPCProtobuf.ProtobufDeserializer<Spark_Connect_FetchErrorDetailsResponse>(),
            options: options,
            onResponse: handleResponse
        )
    }
}

// Helpers providing sugared APIs for 'ClientProtocol' methods.
@available(macOS 15.0, iOS 18.0, watchOS 11.0, tvOS 18.0, visionOS 2.0, *)
extension Spark_Connect_SparkConnectService.ClientProtocol {
    /// Call the "ExecutePlan" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Executes a request that contains the query and returns a stream of [[Response]].
    /// > 
    /// > It is guaranteed that there is at least one ARROW batch returned even if the result set is empty.
    ///
    /// - Parameters:
    ///   - message: request message to send.
    ///   - metadata: Additional metadata to send, defaults to empty.
    ///   - options: Options to apply to this RPC, defaults to `.defaults`.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func executePlan<Result>(
        _ message: Spark_Connect_ExecutePlanRequest,
        metadata: GRPCCore.Metadata = [:],
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.StreamingClientResponse<Spark_Connect_ExecutePlanResponse>) async throws -> Result
    ) async throws -> Result where Result: Sendable {
        let request = GRPCCore.ClientRequest<Spark_Connect_ExecutePlanRequest>(
            message: message,
            metadata: metadata
        )
        return try await self.executePlan(
            request: request,
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "AnalyzePlan" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Analyzes a query and returns a [[AnalyzeResponse]] containing metadata about the query.
    ///
    /// - Parameters:
    ///   - message: request message to send.
    ///   - metadata: Additional metadata to send, defaults to empty.
    ///   - options: Options to apply to this RPC, defaults to `.defaults`.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func analyzePlan<Result>(
        _ message: Spark_Connect_AnalyzePlanRequest,
        metadata: GRPCCore.Metadata = [:],
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_AnalyzePlanResponse>) async throws -> Result = { response in
            try response.message
        }
    ) async throws -> Result where Result: Sendable {
        let request = GRPCCore.ClientRequest<Spark_Connect_AnalyzePlanRequest>(
            message: message,
            metadata: metadata
        )
        return try await self.analyzePlan(
            request: request,
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "Config" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Update or fetch the configurations and returns a [[ConfigResponse]] containing the result.
    ///
    /// - Parameters:
    ///   - message: request message to send.
    ///   - metadata: Additional metadata to send, defaults to empty.
    ///   - options: Options to apply to this RPC, defaults to `.defaults`.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func config<Result>(
        _ message: Spark_Connect_ConfigRequest,
        metadata: GRPCCore.Metadata = [:],
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_ConfigResponse>) async throws -> Result = { response in
            try response.message
        }
    ) async throws -> Result where Result: Sendable {
        let request = GRPCCore.ClientRequest<Spark_Connect_ConfigRequest>(
            message: message,
            metadata: metadata
        )
        return try await self.config(
            request: request,
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "AddArtifacts" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Add artifacts to the session and returns a [[AddArtifactsResponse]] containing metadata about
    /// > the added artifacts.
    ///
    /// - Parameters:
    ///   - metadata: Additional metadata to send, defaults to empty.
    ///   - options: Options to apply to this RPC, defaults to `.defaults`.
    ///   - producer: A closure producing request messages to send to the server. The request
    ///       stream is closed when the closure returns.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func addArtifacts<Result>(
        metadata: GRPCCore.Metadata = [:],
        options: GRPCCore.CallOptions = .defaults,
        requestProducer producer: @Sendable @escaping (GRPCCore.RPCWriter<Spark_Connect_AddArtifactsRequest>) async throws -> Void,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_AddArtifactsResponse>) async throws -> Result = { response in
            try response.message
        }
    ) async throws -> Result where Result: Sendable {
        let request = GRPCCore.StreamingClientRequest<Spark_Connect_AddArtifactsRequest>(
            metadata: metadata,
            producer: producer
        )
        return try await self.addArtifacts(
            request: request,
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "ArtifactStatus" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Check statuses of artifacts in the session and returns them in a [[ArtifactStatusesResponse]]
    ///
    /// - Parameters:
    ///   - message: request message to send.
    ///   - metadata: Additional metadata to send, defaults to empty.
    ///   - options: Options to apply to this RPC, defaults to `.defaults`.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func artifactStatus<Result>(
        _ message: Spark_Connect_ArtifactStatusesRequest,
        metadata: GRPCCore.Metadata = [:],
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_ArtifactStatusesResponse>) async throws -> Result = { response in
            try response.message
        }
    ) async throws -> Result where Result: Sendable {
        let request = GRPCCore.ClientRequest<Spark_Connect_ArtifactStatusesRequest>(
            message: message,
            metadata: metadata
        )
        return try await self.artifactStatus(
            request: request,
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "Interrupt" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Interrupts running executions
    ///
    /// - Parameters:
    ///   - message: request message to send.
    ///   - metadata: Additional metadata to send, defaults to empty.
    ///   - options: Options to apply to this RPC, defaults to `.defaults`.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func interrupt<Result>(
        _ message: Spark_Connect_InterruptRequest,
        metadata: GRPCCore.Metadata = [:],
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_InterruptResponse>) async throws -> Result = { response in
            try response.message
        }
    ) async throws -> Result where Result: Sendable {
        let request = GRPCCore.ClientRequest<Spark_Connect_InterruptRequest>(
            message: message,
            metadata: metadata
        )
        return try await self.interrupt(
            request: request,
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "ReattachExecute" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Reattach to an existing reattachable execution.
    /// > The ExecutePlan must have been started with ReattachOptions.reattachable=true.
    /// > If the ExecutePlanResponse stream ends without a ResultComplete message, there is more to
    /// > continue. If there is a ResultComplete, the client should use ReleaseExecute with
    ///
    /// - Parameters:
    ///   - message: request message to send.
    ///   - metadata: Additional metadata to send, defaults to empty.
    ///   - options: Options to apply to this RPC, defaults to `.defaults`.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func reattachExecute<Result>(
        _ message: Spark_Connect_ReattachExecuteRequest,
        metadata: GRPCCore.Metadata = [:],
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.StreamingClientResponse<Spark_Connect_ExecutePlanResponse>) async throws -> Result
    ) async throws -> Result where Result: Sendable {
        let request = GRPCCore.ClientRequest<Spark_Connect_ReattachExecuteRequest>(
            message: message,
            metadata: metadata
        )
        return try await self.reattachExecute(
            request: request,
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "ReleaseExecute" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Release an reattachable execution, or parts thereof.
    /// > The ExecutePlan must have been started with ReattachOptions.reattachable=true.
    /// > Non reattachable executions are released automatically and immediately after the ExecutePlan
    /// > RPC and ReleaseExecute may not be used.
    ///
    /// - Parameters:
    ///   - message: request message to send.
    ///   - metadata: Additional metadata to send, defaults to empty.
    ///   - options: Options to apply to this RPC, defaults to `.defaults`.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func releaseExecute<Result>(
        _ message: Spark_Connect_ReleaseExecuteRequest,
        metadata: GRPCCore.Metadata = [:],
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_ReleaseExecuteResponse>) async throws -> Result = { response in
            try response.message
        }
    ) async throws -> Result where Result: Sendable {
        let request = GRPCCore.ClientRequest<Spark_Connect_ReleaseExecuteRequest>(
            message: message,
            metadata: metadata
        )
        return try await self.releaseExecute(
            request: request,
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "ReleaseSession" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > Release a session.
    /// > All the executions in the session will be released. Any further requests for the session with
    /// > that session_id for the given user_id will fail. If the session didn't exist or was already
    /// > released, this is a noop.
    ///
    /// - Parameters:
    ///   - message: request message to send.
    ///   - metadata: Additional metadata to send, defaults to empty.
    ///   - options: Options to apply to this RPC, defaults to `.defaults`.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func releaseSession<Result>(
        _ message: Spark_Connect_ReleaseSessionRequest,
        metadata: GRPCCore.Metadata = [:],
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_ReleaseSessionResponse>) async throws -> Result = { response in
            try response.message
        }
    ) async throws -> Result where Result: Sendable {
        let request = GRPCCore.ClientRequest<Spark_Connect_ReleaseSessionRequest>(
            message: message,
            metadata: metadata
        )
        return try await self.releaseSession(
            request: request,
            options: options,
            onResponse: handleResponse
        )
    }

    /// Call the "FetchErrorDetails" method.
    ///
    /// > Source IDL Documentation:
    /// >
    /// > FetchErrorDetails retrieves the matched exception with details based on a provided error id.
    ///
    /// - Parameters:
    ///   - message: request message to send.
    ///   - metadata: Additional metadata to send, defaults to empty.
    ///   - options: Options to apply to this RPC, defaults to `.defaults`.
    ///   - handleResponse: A closure which handles the response, the result of which is
    ///       returned to the caller. Returning from the closure will cancel the RPC if it
    ///       hasn't already finished.
    /// - Returns: The result of `handleResponse`.
    internal func fetchErrorDetails<Result>(
        _ message: Spark_Connect_FetchErrorDetailsRequest,
        metadata: GRPCCore.Metadata = [:],
        options: GRPCCore.CallOptions = .defaults,
        onResponse handleResponse: @Sendable @escaping (GRPCCore.ClientResponse<Spark_Connect_FetchErrorDetailsResponse>) async throws -> Result = { response in
            try response.message
        }
    ) async throws -> Result where Result: Sendable {
        let request = GRPCCore.ClientRequest<Spark_Connect_FetchErrorDetailsRequest>(
            message: message,
            metadata: metadata
        )
        return try await self.fetchErrorDetails(
            request: request,
            options: options,
            onResponse: handleResponse
        )
    }
}