/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.security.auth.IHttpCredentialsPlugin;
import org.apache.storm.utils.ReflectionUtils;

public class ServerAuthUtils {
    public static IHttpCredentialsPlugin getHttpCredentialsPlugin(Map<String, Object> conf, String klassName) {
        try {
            IHttpCredentialsPlugin plugin = null;
            if (StringUtils.isNotBlank((String)klassName)) {
                plugin = (IHttpCredentialsPlugin)ReflectionUtils.newInstance((String)klassName);
                plugin.prepare(conf);
            }
            return plugin;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IHttpCredentialsPlugin getUiHttpCredentialsPlugin(Map<String, Object> conf) {
        String klassName = (String)conf.get("ui.http.creds.plugin");
        return ServerAuthUtils.getHttpCredentialsPlugin(conf, klassName);
    }

    public static IHttpCredentialsPlugin getDrpcHttpCredentialsPlugin(Map<String, Object> conf) {
        String klassName = (String)conf.get("drpc.http.creds.plugin");
        return klassName == null ? null : ServerAuthUtils.getHttpCredentialsPlugin(conf, klassName);
    }
}

