/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dataproperties;

import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.PartitioningProperty;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.util.Utils;
import org.apache.flink.runtime.io.network.DataExchangeMode;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;

public final class RequestedGlobalProperties
implements Cloneable {
    private PartitioningProperty partitioning = PartitioningProperty.RANDOM_PARTITIONED;
    private FieldSet partitioningFields;
    private Ordering ordering;
    private DataDistribution dataDistribution;
    private Partitioner<?> customPartitioner;

    public void setHashPartitioned(FieldSet partitionedFields) {
        if (partitionedFields == null) {
            throw new NullPointerException();
        }
        this.partitioning = PartitioningProperty.HASH_PARTITIONED;
        this.partitioningFields = partitionedFields;
        this.ordering = null;
    }

    public void setRangePartitioned(Ordering ordering) {
        this.setRangePartitioned(ordering, null);
    }

    public void setRangePartitioned(Ordering ordering, DataDistribution dataDistribution) {
        if (ordering == null) {
            throw new NullPointerException();
        }
        this.partitioning = PartitioningProperty.RANGE_PARTITIONED;
        this.ordering = ordering;
        this.partitioningFields = null;
        this.dataDistribution = dataDistribution;
    }

    public void setAnyPartitioning(FieldSet partitionedFields) {
        if (partitionedFields == null) {
            throw new NullPointerException();
        }
        this.partitioning = PartitioningProperty.ANY_PARTITIONING;
        this.partitioningFields = partitionedFields;
        this.ordering = null;
    }

    public void setRandomPartitioning() {
        this.partitioning = PartitioningProperty.RANDOM_PARTITIONED;
        this.partitioningFields = null;
        this.ordering = null;
    }

    public void setAnyDistribution() {
        this.partitioning = PartitioningProperty.ANY_DISTRIBUTION;
        this.partitioningFields = null;
        this.ordering = null;
    }

    public void setFullyReplicated() {
        this.partitioning = PartitioningProperty.FULL_REPLICATION;
        this.partitioningFields = null;
        this.ordering = null;
    }

    public void setForceRebalancing() {
        this.partitioning = PartitioningProperty.FORCED_REBALANCED;
        this.partitioningFields = null;
        this.ordering = null;
    }

    public void setCustomPartitioned(FieldSet partitionedFields, Partitioner<?> partitioner) {
        if (partitionedFields == null || partitioner == null) {
            throw new NullPointerException();
        }
        this.partitioning = PartitioningProperty.CUSTOM_PARTITIONING;
        this.partitioningFields = partitionedFields;
        this.ordering = null;
        this.customPartitioner = partitioner;
    }

    public PartitioningProperty getPartitioning() {
        return this.partitioning;
    }

    public FieldSet getPartitionedFields() {
        return this.partitioningFields;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public DataDistribution getDataDistribution() {
        return this.dataDistribution;
    }

    public Partitioner<?> getCustomPartitioner() {
        return this.customPartitioner;
    }

    public boolean isTrivial() {
        return this.partitioning == null || this.partitioning == PartitioningProperty.RANDOM_PARTITIONED;
    }

    public void reset() {
        this.partitioning = PartitioningProperty.RANDOM_PARTITIONED;
        this.ordering = null;
        this.partitioningFields = null;
        this.dataDistribution = null;
        this.customPartitioner = null;
    }

    public RequestedGlobalProperties filterBySemanticProperties(SemanticProperties props, int input) {
        if (props == null) {
            throw new NullPointerException("SemanticProperties may not be null.");
        }
        RequestedGlobalProperties rgProp = new RequestedGlobalProperties();
        switch (this.partitioning) {
            case FULL_REPLICATION: 
            case FORCED_REBALANCED: 
            case CUSTOM_PARTITIONING: 
            case RANDOM_PARTITIONED: 
            case ANY_DISTRIBUTION: {
                return null;
            }
            case HASH_PARTITIONED: 
            case ANY_PARTITIONING: {
                Object newFields = this.partitioningFields instanceof FieldList ? new FieldList() : new FieldSet();
                for (Integer targetField : this.partitioningFields) {
                    int sourceField = props.getForwardingSourceField(input, targetField.intValue());
                    if (sourceField >= 0) {
                        newFields = newFields.addField(Integer.valueOf(sourceField));
                        continue;
                    }
                    return null;
                }
                rgProp.partitioning = this.partitioning;
                rgProp.partitioningFields = newFields;
                return rgProp;
            }
            case RANGE_PARTITIONED: {
                Ordering newOrdering = new Ordering();
                for (int i = 0; i < this.ordering.getInvolvedIndexes().size(); ++i) {
                    int value = this.ordering.getInvolvedIndexes().get(i);
                    int sourceField = props.getForwardingSourceField(input, value);
                    if (sourceField < 0) {
                        return null;
                    }
                    newOrdering.appendOrdering(Integer.valueOf(sourceField), this.ordering.getType(i), this.ordering.getOrder(i));
                }
                rgProp.partitioning = this.partitioning;
                rgProp.ordering = newOrdering;
                rgProp.dataDistribution = this.dataDistribution;
                return rgProp;
            }
        }
        throw new RuntimeException("Unknown partitioning type encountered.");
    }

    public boolean isMetBy(GlobalProperties props) {
        if (this.partitioning == PartitioningProperty.ANY_DISTRIBUTION) {
            return true;
        }
        if (this.partitioning == PartitioningProperty.FULL_REPLICATION) {
            return props.isFullyReplicated();
        }
        if (props.isFullyReplicated()) {
            return false;
        }
        if (this.partitioning == PartitioningProperty.RANDOM_PARTITIONED) {
            return true;
        }
        if (this.partitioning == PartitioningProperty.ANY_PARTITIONING) {
            return this.checkCompatiblePartitioningFields(props);
        }
        if (this.partitioning == PartitioningProperty.HASH_PARTITIONED) {
            return props.getPartitioning() == PartitioningProperty.HASH_PARTITIONED && this.checkCompatiblePartitioningFields(props);
        }
        if (this.partitioning == PartitioningProperty.RANGE_PARTITIONED) {
            return props.getPartitioning() == PartitioningProperty.RANGE_PARTITIONED && props.matchesOrderedPartitioning(this.ordering);
        }
        if (this.partitioning == PartitioningProperty.FORCED_REBALANCED) {
            return props.getPartitioning() == PartitioningProperty.FORCED_REBALANCED;
        }
        if (this.partitioning == PartitioningProperty.CUSTOM_PARTITIONING) {
            return props.getPartitioning() == PartitioningProperty.CUSTOM_PARTITIONING && this.checkCompatiblePartitioningFields(props) && props.getCustomPartitioner().equals(this.customPartitioner);
        }
        throw new CompilerException("Properties matching logic leaves open cases.");
    }

    public void parameterizeChannel(Channel channel, boolean globalDopChange, ExecutionMode exchangeMode, boolean breakPipeline) {
        Partitioner<?> partitioner;
        boolean[] sortDirection;
        FieldList partitionKeys;
        ShipStrategyType shipType;
        if (channel.getSource().getGlobalProperties().isFullyReplicated() && this.partitioning != PartitioningProperty.FULL_REPLICATION && this.partitioning != PartitioningProperty.ANY_DISTRIBUTION) {
            throw new CompilerException("Fully replicated input must be preserved and may not be converted into another global property.");
        }
        if (this.isTrivial() || this.partitioning == PartitioningProperty.ANY_DISTRIBUTION) {
            ShipStrategyType shipStrategy = globalDopChange ? ShipStrategyType.PARTITION_RANDOM : ShipStrategyType.FORWARD;
            DataExchangeMode em = DataExchangeMode.select((ExecutionMode)exchangeMode, (ShipStrategyType)shipStrategy, (boolean)breakPipeline);
            channel.setShipStrategy(shipStrategy, em);
            return;
        }
        GlobalProperties inGlobals = channel.getSource().getGlobalProperties();
        if (!globalDopChange && this.isMetBy(inGlobals)) {
            DataExchangeMode em = DataExchangeMode.select((ExecutionMode)exchangeMode, (ShipStrategyType)ShipStrategyType.FORWARD, (boolean)breakPipeline);
            channel.setShipStrategy(ShipStrategyType.FORWARD, em);
            return;
        }
        switch (this.partitioning) {
            case FULL_REPLICATION: {
                shipType = ShipStrategyType.BROADCAST;
                partitionKeys = null;
                sortDirection = null;
                partitioner = null;
                break;
            }
            case HASH_PARTITIONED: 
            case ANY_PARTITIONING: {
                shipType = ShipStrategyType.PARTITION_HASH;
                partitionKeys = Utils.createOrderedFromSet(this.partitioningFields);
                sortDirection = null;
                partitioner = null;
                break;
            }
            case RANGE_PARTITIONED: {
                shipType = ShipStrategyType.PARTITION_RANGE;
                partitionKeys = this.ordering.getInvolvedIndexes();
                sortDirection = this.ordering.getFieldSortDirections();
                partitioner = null;
                if (this.dataDistribution == null) break;
                channel.setDataDistribution(this.dataDistribution);
                break;
            }
            case FORCED_REBALANCED: {
                shipType = ShipStrategyType.PARTITION_FORCED_REBALANCE;
                partitionKeys = null;
                sortDirection = null;
                partitioner = null;
                break;
            }
            case CUSTOM_PARTITIONING: {
                shipType = ShipStrategyType.PARTITION_CUSTOM;
                partitionKeys = Utils.createOrderedFromSet(this.partitioningFields);
                sortDirection = null;
                partitioner = this.customPartitioner;
                break;
            }
            default: {
                throw new CompilerException("Invalid partitioning to create through a data exchange: " + this.partitioning.name());
            }
        }
        DataExchangeMode exMode = DataExchangeMode.select((ExecutionMode)exchangeMode, (ShipStrategyType)shipType, (boolean)breakPipeline);
        channel.setShipStrategy(shipType, partitionKeys, sortDirection, partitioner, exMode);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.partitioning == null ? 0 : this.partitioning.ordinal());
        result = 31 * result + (this.partitioningFields == null ? 0 : this.partitioningFields.hashCode());
        result = 31 * result + (this.ordering == null ? 0 : this.ordering.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RequestedGlobalProperties) {
            RequestedGlobalProperties other = (RequestedGlobalProperties)obj;
            return (this.ordering == other.getOrdering() || this.ordering != null && this.ordering.equals((Object)other.getOrdering())) && this.partitioning == other.getPartitioning() && (this.partitioningFields == other.partitioningFields || this.partitioningFields != null && this.partitioningFields.equals((Object)other.getPartitionedFields()));
        }
        return false;
    }

    public String toString() {
        return "Requested Global Properties [partitioning=" + (Object)((Object)this.partitioning) + (this.partitioningFields == null ? "" : ", on fields " + this.partitioningFields) + (this.ordering == null ? "" : ", with ordering " + this.ordering) + "]";
    }

    public RequestedGlobalProperties clone() {
        try {
            return (RequestedGlobalProperties)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    private boolean checkCompatiblePartitioningFields(GlobalProperties props) {
        if (this.partitioningFields instanceof FieldList) {
            return props.isExactlyPartitionedOnFields((FieldList)this.partitioningFields);
        }
        return props.isPartitionedOnFields(this.partitioningFields);
    }
}

