/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.RMHAUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.streampark.common.conf.CommonConfig$;
import org.apache.streampark.common.conf.InternalConfigHolder$;
import org.apache.streampark.common.util.HadoopUtils$;
import org.apache.streampark.common.util.HttpClientUtils$;
import org.apache.streampark.common.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.Breaks$;

public final class YarnUtils$
implements Logger {
    public static YarnUtils$ MODULE$;
    private String PROXY_YARN_URL;
    private boolean hasYarnHttpKerberosAuth;
    private String rmHttpURL;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile byte bitmap$0;

    static {
        new YarnUtils$();
    }

    @Override
    public String logName() {
        return Logger.logName$(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger.logInfo$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger.logDebug$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger.logTrace$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger.logWarn$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    private String PROXY_YARN_URL$lzycompute() {
        YarnUtils$ yarnUtils$ = this;
        synchronized (yarnUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.PROXY_YARN_URL = (String)InternalConfigHolder$.MODULE$.get(CommonConfig$.MODULE$.STREAMPARK_PROXY_YARN_URL());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.PROXY_YARN_URL;
    }

    public String PROXY_YARN_URL() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.PROXY_YARN_URL$lzycompute() : this.PROXY_YARN_URL;
    }

    private boolean hasYarnHttpKerberosAuth$lzycompute() {
        YarnUtils$ yarnUtils$ = this;
        synchronized (yarnUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String yarnHttpAuth = (String)InternalConfigHolder$.MODULE$.get(CommonConfig$.MODULE$.STREAMPARK_YARN_AUTH());
                this.hasYarnHttpKerberosAuth = "kerberos".equalsIgnoreCase(yarnHttpAuth);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hasYarnHttpKerberosAuth;
    }

    public boolean hasYarnHttpKerberosAuth() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.hasYarnHttpKerberosAuth$lzycompute() : this.hasYarnHttpKerberosAuth;
    }

    public List<ApplicationId> getAppId(String appName) {
        Buffer buffer;
        EnumSet<YarnApplicationState> appStates = EnumSet.of(YarnApplicationState.RUNNING, YarnApplicationState.ACCEPTED, YarnApplicationState.SUBMITTED);
        try {
            buffer = (Buffer)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(HadoopUtils$.MODULE$.yarnClient().getApplications(appStates)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)YarnUtils$.$anonfun$getAppId$1(appName, x$1)))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getApplicationId(), Buffer$.MODULE$.canBuildFrom());
        }
        catch (Exception e) {
            e.printStackTrace();
            buffer = (Buffer)ArrayBuffer$.MODULE$.empty();
        }
        Buffer appIds = buffer;
        return JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)appIds.toList());
    }

    /*
     * WARNING - void declaration
     */
    public YarnApplicationState getState(String appId) {
        void var3_5;
        YarnApplicationState yarnApplicationState;
        ApplicationId applicationId = ConverterUtils.toApplicationId((String)appId);
        try {
            ApplicationReport applicationReport = HadoopUtils$.MODULE$.yarnClient().getApplicationReport(applicationId);
            yarnApplicationState = applicationReport.getYarnApplicationState();
        }
        catch (Exception e) {
            e.printStackTrace();
            yarnApplicationState = null;
        }
        YarnApplicationState state = yarnApplicationState;
        return var3_5;
    }

    public boolean isContains(String appName) {
        List runningApps = HadoopUtils$.MODULE$.yarnClient().getApplications(EnumSet.of(YarnApplicationState.RUNNING));
        return runningApps != null ? JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(runningApps).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)YarnUtils$.$anonfun$isContains$1(appName, x$3))) : false;
    }

    public String getRMWebAppProxyURL() {
        return StringUtils.isNotBlank((CharSequence)this.PROXY_YARN_URL()) ? this.PROXY_YARN_URL() : this.getRMWebAppURL();
    }

    public String getRMWebAppURL() {
        if (this.rmHttpURL == null) {
            YarnUtils$ yarnUtils$ = this;
            synchronized (yarnUtils$) {
                String string;
                boolean useHttps;
                Configuration conf = HadoopUtils$.MODULE$.hadoopConf();
                boolean bl = useHttps = YarnConfiguration.useHttps((Configuration)conf);
                Tuple3 tuple3 = bl ? new Tuple3((Object)"yarn.resourcemanager.webapp.https.address", (Object)"8090", (Object)"https://") : new Tuple3((Object)"yarn.resourcemanager.webapp.address", (Object)"8088", (Object)"http://");
                Tuple3 tuple32 = tuple3;
                if (tuple32 == null) {
                    throw new MatchError((Object)tuple32);
                }
                String addressPrefix = (String)tuple32._1();
                String defaultPort = (String)tuple32._2();
                String protocol = (String)tuple32._3();
                Tuple3 tuple33 = new Tuple3((Object)addressPrefix, (Object)defaultPort, (Object)protocol);
                Tuple3 tuple34 = tuple33;
                String addressPrefix2 = (String)tuple34._1();
                String defaultPort2 = (String)tuple34._2();
                String protocol2 = (String)tuple34._3();
                Option option = Option$.MODULE$.apply((Object)conf.get("yarn.web-proxy.address", null));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String proxy = (String)some.value();
                    string = new java.lang.StringBuilder(0).append(protocol2).append(proxy).toString();
                } else {
                    StringBuilder stringBuilder;
                    String string2;
                    if (!HAUtil.isHAEnabled((Configuration)conf)) {
                        string2 = addressPrefix2;
                    } else {
                        String string3;
                        YarnConfiguration yarnConf = new YarnConfiguration(conf);
                        Option option2 = Option$.MODULE$.apply((Object)RMHAUtils.findActiveRMHAId((Configuration)yarnConf));
                        if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            String x = (String)some.value();
                            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "findActiveRMHAId successful");
                            string3 = x;
                        } else if (None$.MODULE$.equals(option2)) {
                            this.logWarn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(65).append("findActiveRMHAId is null,config yarn.acl.enable:").append(yarnConf.get("yarn.acl.enable")).append(",now http try it.").toString());
                            HashMap idUrlMap = new HashMap();
                            Collection rmIds = HAUtil.getRMHAIds((Configuration)conf);
                            JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable(rmIds).foreach((Function1 & Serializable & scala.Serializable)id -> {
                                String string;
                                String string2 = conf.get(HAUtil.addSuffix((String)addressPrefix2, (String)id));
                                if (string2 == null) {
                                    String hostname = conf.get(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)id));
                                    string = new java.lang.StringBuilder(1).append(hostname).append(":").append(defaultPort2).toString();
                                } else {
                                    string = string2;
                                }
                                String address = string;
                                return idUrlMap.put(new java.lang.StringBuilder(0).append(protocol2).append(address).toString(), id);
                            });
                            ObjectRef rmId = ObjectRef.create(null);
                            int rpcTimeoutForChecks = yarnConf.getInt("ha.failover-controller.cli-check.rpc-timeout.ms", 20000);
                            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap((Map)idUrlMap).foreach((Function1 & Serializable & scala.Serializable)x -> {
                                YarnUtils$.$anonfun$getRMWebAppURL$5(rpcTimeoutForChecks, rmId, idUrlMap, x);
                                return BoxedUnit.UNIT;
                            }));
                            string3 = (String)rmId.elem;
                        } else {
                            throw new MatchError((Object)option2);
                        }
                        String activeRMId = string3;
                        Predef$.MODULE$.require(activeRMId != null, (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] YarnUtils.getRMWebAppURL: can not found yarn active node");
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(22).append("current activeRMHAId: ").append(activeRMId).toString());
                        String appActiveRMKey = HAUtil.addSuffix((String)addressPrefix2, (String)activeRMId);
                        String hostnameActiveRMKey = HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)activeRMId);
                        if (HAUtil.getConfValueForRMInstance((String)appActiveRMKey, (Configuration)yarnConf) == null && HAUtil.getConfValueForRMInstance((String)hostnameActiveRMKey, (Configuration)yarnConf) != null) {
                            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(25).append("Find rm web address by : ").append(hostnameActiveRMKey).toString());
                            string2 = hostnameActiveRMKey;
                        } else {
                            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(25).append("Find rm web address by : ").append(appActiveRMKey).toString());
                            string2 = appActiveRMKey;
                        }
                    }
                    String name = string2;
                    InetSocketAddress inetSocketAddress = conf.getSocketAddr(name, new java.lang.StringBuilder(8).append("0.0.0.0:").append(defaultPort2).toString(), new StringOps(Predef$.MODULE$.augmentString(defaultPort2)).toInt());
                    InetSocketAddress address = NetUtils.getConnectAddress((InetSocketAddress)inetSocketAddress);
                    StringBuilder buffer = new StringBuilder(protocol2);
                    InetAddress resolved = address.getAddress();
                    if (resolved != null && !resolved.isAnyLocalAddress() && !resolved.isLoopbackAddress()) {
                        stringBuilder = buffer.append(address.getHostName());
                    } else {
                        StringBuilder stringBuilder2;
                        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> InetAddress.getLocalHost().getCanonicalHostName());
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            String value = (String)success.value();
                            stringBuilder2 = buffer.append(value);
                        } else {
                            stringBuilder2 = buffer.append(address.getHostName());
                        }
                        stringBuilder = stringBuilder2;
                    }
                    string = buffer.append(":").append(address.getPort()).toString();
                }
                this.rmHttpURL = string;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(32).append("yarn resourceManager webapp url:").append(YarnUtils$.MODULE$.rmHttpURL).toString());
            }
        }
        return this.rmHttpURL;
    }

    private String httpTestYarnRMUrl(String url, int timeout) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpGet = new HttpGet(url);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).build();
        httpGet.setConfig(requestConfig);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> httpClient.execute((HttpUriRequest)httpGet, (HttpContext)context));
        String string = try_ instanceof Success ? context.getTargetHost().toString() : null;
        return string;
    }

    public String getYarnAppTrackingUrl(ApplicationId applicationId) {
        return HadoopUtils$.MODULE$.yarnClient().getApplicationReport(applicationId).getTrackingUrl();
    }

    public String restRequest(String url) {
        if (url == null) {
            return null;
        }
        return url.startsWith("http://") || url.startsWith("https://") ? this.request$1(url) : this.request$1(new java.lang.StringBuilder(1).append(this.getRMWebAppURL()).append("/").append(url).toString());
    }

    public static final /* synthetic */ boolean $anonfun$getAppId$1(String appName$1, ApplicationReport x$1) {
        String string = x$1.getName();
        String string2 = appName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isContains$1(String appName$2, ApplicationReport x$3) {
        String string = x$3.getName();
        String string2 = appName$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$getRMWebAppURL$5(int rpcTimeoutForChecks$1, ObjectRef rmId$1, HashMap idUrlMap$1, Tuple2 x) {
        String activeUrl = MODULE$.httpTestYarnRMUrl((String)x._1(), rpcTimeoutForChecks$1);
        if (activeUrl != null) {
            rmId$1.elem = (String)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap((Map)idUrlMap$1).apply((Object)activeUrl);
            throw Breaks$.MODULE$.break();
        }
    }

    private final String request$1(String url) {
        String string;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(15).append("request url is ").append(url).toString());
        RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).build();
        if (this.hasYarnHttpKerberosAuth()) {
            string = (String)HadoopUtils$.MODULE$.getUgi().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(url, config){
                private final String url$1;
                private final RequestConfig config$1;

                public String run() {
                    String string;
                    Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> HttpClientUtils$.MODULE$.httpAuthGetRequest($this.url$1, $this.config$1));
                    if (try_ instanceof Success) {
                        String v;
                        Success success = (Success)try_;
                        string = v = (String)success.value();
                    } else if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        YarnUtils$.MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "yarnUtils authRestRequest error, detail: ", e);
                        string = null;
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    return string;
                }
                {
                    this.url$1 = url$1;
                    this.config$1 = config$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.streampark.common.util.YarnUtils$$anon$1 ), $anonfun$run$2()}, serializedLambda);
                }
            });
        } else {
            String string2;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> HttpClientUtils$.MODULE$.httpGetRequest(url, config));
            if (try_ instanceof Success) {
                String v;
                Success success = (Success)try_;
                string2 = v = (String)success.value();
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "yarnUtils restRequest error, detail: ", e);
                string2 = null;
            } else {
                throw new MatchError((Object)try_);
            }
            string = string2;
        }
        return string;
    }

    private YarnUtils$() {
        MODULE$ = this;
        Logger.$init$(this);
    }
}

