/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.core.service.ApplicationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="FLINK_APPLICATION_HISTORY_TAG")
@Validated
@RestController
@RequestMapping(value={"flink/history"})
public class ApplicationHistoryController {
    private static final Logger log = LoggerFactory.getLogger(ApplicationHistoryController.class);
    @Autowired
    private ApplicationService applicationService;

    @Operation(summary="List the upload jar history records")
    @PostMapping(value={"uploadJars"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse listUploadJars() {
        List<String> jars = this.applicationService.historyUploadJars();
        return RestResponse.success(jars);
    }

    @Operation(summary="List the k8s namespace history records")
    @PostMapping(value={"k8sNamespaces"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse listK8sNamespace() {
        List<String> namespaces = this.applicationService.getRecentK8sNamespace();
        return RestResponse.success(namespaces);
    }

    @Operation(summary="List the session cluster history records")
    @PostMapping(value={"sessionClusterIds"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse listSessionClusterId(int executionMode) {
        List<Object> clusterIds;
        switch (ExecutionMode.of((Integer)executionMode)) {
            case KUBERNETES_NATIVE_SESSION: 
            case YARN_SESSION: 
            case REMOTE: {
                clusterIds = this.applicationService.getRecentK8sClusterId(executionMode);
                break;
            }
            default: {
                clusterIds = new ArrayList(0);
            }
        }
        return RestResponse.success(clusterIds);
    }

    @Operation(summary="List the flink base image history records")
    @PostMapping(value={"flinkBaseImages"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse listFlinkBaseImage() {
        List<String> images = this.applicationService.getRecentFlinkBaseImage();
        return RestResponse.success(images);
    }

    @Operation(summary="List the flink pod template history records")
    @PostMapping(value={"flinkPodTemplates"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse listPodTemplate() {
        List<String> templates = this.applicationService.getRecentK8sPodTemplate();
        return RestResponse.success(templates);
    }

    @Operation(summary="List the flink JM pod template history records")
    @PostMapping(value={"flinkJmPodTemplates"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse listJmPodTemplate() {
        List<String> templates = this.applicationService.getRecentK8sJmPodTemplate();
        return RestResponse.success(templates);
    }

    @Operation(summary="List the flink TM pod template history records")
    @PostMapping(value={"flinkTmPodTemplates"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse listTmPodTemplate() {
        List<String> templates = this.applicationService.getRecentK8sTmPodTemplate();
        return RestResponse.success(templates);
    }
}

