/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.files;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.LeaderRetrievalHandler;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.router.RoutedRequest;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.handler.util.MimeTypes;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFutureListener;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelPromise;
import org.apache.flink.shaded.netty4.io.netty.channel.DefaultFileRegion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.FullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpChunkedInput;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.LastHttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedFile;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedInput;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.GenericFutureListener;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class StaticFileServerHandler<T extends RestfulGateway>
extends LeaderRetrievalHandler<T> {
    private static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final int HTTP_CACHE_SECONDS = 300;
    private final File rootPath;

    public StaticFileServerHandler(GatewayRetriever<? extends T> retriever, Time timeout, File rootPath) throws IOException {
        super(retriever, timeout, Collections.emptyMap());
        this.rootPath = ((File)Preconditions.checkNotNull((Object)rootPath)).getCanonicalFile();
    }

    @Override
    protected void respondAsLeader(ChannelHandlerContext channelHandlerContext, RoutedRequest routedRequest, T gateway) throws Exception {
        HttpRequest request = routedRequest.getRequest();
        String requestPath = routedRequest.getPath().endsWith("/") ? routedRequest.getPath() + "index.html" : routedRequest.getPath();
        try {
            this.respondToRequest(channelHandlerContext, request, requestPath);
        }
        catch (RestHandlerException rhe) {
            HandlerUtils.sendErrorResponse(channelHandlerContext, routedRequest.getRequest(), new ErrorResponseBody(rhe.getMessage()), rhe.getHttpResponseStatus(), (Map<String, String>)this.responseHeaders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void respondToRequest(ChannelHandlerContext ctx, HttpRequest request, String requestPath) throws IOException, ParseException, URISyntaxException, RestHandlerException {
        block34: {
            file = new File(this.rootPath, requestPath);
            if (!file.exists()) {
                cl = StaticFileServerHandler.class.getClassLoader();
                resourceStream = cl.getResourceAsStream("web" + requestPath);
                var7_7 = null;
                try {
                    success = false;
                    try {
                        if (resourceStream != null) {
                            root = cl.getResource("web");
                            requested = cl.getResource("web" + requestPath);
                            if (root != null && requested != null && !(rootURI = new URI(root.getPath()).normalize()).relativize(requestedURI = new URI(requested.getPath()).normalize()).equals(requestedURI)) {
                                this.logger.debug("Loading missing file from classloader: {}", (Object)requestPath);
                                file.getParentFile().mkdirs();
                                Files.copy(resourceStream, file.toPath(), new CopyOption[0]);
                                success = true;
                            }
                        }
                        ** if (success) goto lbl-1000
                    }
                    catch (Throwable t) {
                        try {
                            this.logger.error("error while responding", t);
                            ** if (success) goto lbl-1000
                        }
                        catch (Throwable var13_21) {
                            if (!success) {
                                this.logger.debug("Unable to load requested file {} from classloader", (Object)requestPath);
                                throw new NotFoundException(String.format("Unable to load requested file %s.", new Object[]{requestPath}));
                            }
                            throw var13_21;
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.logger.debug("Unable to load requested file {} from classloader", (Object)requestPath);
                            throw new NotFoundException(String.format("Unable to load requested file %s.", new Object[]{requestPath}));
                        }
lbl-1000:
                        // 1 sources

                        {
                            break block34;
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.logger.debug("Unable to load requested file {} from classloader", (Object)requestPath);
                        throw new NotFoundException(String.format("Unable to load requested file %s.", new Object[]{requestPath}));
                    }
lbl-1000:
                    // 1 sources

                    {
                    }
                }
                catch (Throwable success) {
                    var7_7 = success;
                    throw success;
                }
                finally {
                    if (resourceStream != null) {
                        if (var7_7 != null) {
                            try {
                                resourceStream.close();
                            }
                            catch (Throwable success) {
                                var7_7.addSuppressed(success);
                            }
                        } else {
                            resourceStream.close();
                        }
                    }
                }
            }
        }
        StaticFileServerHandler.checkFileValidity(file, this.rootPath, this.logger);
        ifModifiedSince = request.headers().get("If-Modified-Since");
        if (ifModifiedSince != null && !ifModifiedSince.isEmpty() && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = (dateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US)).parse(ifModifiedSince)).getTime() / 1000L) == (fileLastModifiedSeconds = file.lastModified() / 1000L)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Responding 'NOT MODIFIED' for file '" + file.getAbsolutePath() + '\'');
            }
            StaticFileServerHandler.sendNotModified(ctx);
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Responding with file '" + file.getAbsolutePath() + '\'');
        }
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Could not find file {}.", (Object)file.getAbsolutePath());
            }
            throw new NotFoundException("File not found.");
        }
        try {
            fileLength = raf.length();
            response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            StaticFileServerHandler.setContentTypeHeader((HttpResponse)response, file);
            StaticFileServerHandler.setDateAndCacheHeaders((HttpResponse)response, file);
            if (HttpHeaders.isKeepAlive((HttpMessage)request)) {
                response.headers().set("Connection", (Object)"keep-alive");
            }
            HttpHeaders.setContentLength((HttpMessage)response, (long)fileLength);
            ctx.write((Object)response);
            if (ctx.pipeline().get(SslHandler.class) == null) {
                ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
                lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                lastContentFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 8192)), (ChannelPromise)ctx.newProgressivePromise());
            }
            if (!HttpHeaders.isKeepAlive((HttpMessage)request)) {
                lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (Exception e) {
            raf.close();
            this.logger.error("Failed to serve file.", (Throwable)e);
            throw new RestHandlerException("Internal server error.", HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ctx.channel().isActive()) {
            this.logger.error("Caught exception", cause);
            HandlerUtils.sendErrorResponse(ctx, false, new ErrorResponseBody("Internal server error."), HttpResponseStatus.INTERNAL_SERVER_ERROR, Collections.emptyMap());
        }
    }

    public static void sendNotModified(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        StaticFileServerHandler.setDateHeader((FullHttpResponse)response);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static void setDateHeader(FullHttpResponse response) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(GMT_TIMEZONE);
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set("Date", (Object)dateFormatter.format(time.getTime()));
    }

    public static void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(GMT_TIMEZONE);
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set("Date", (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 300);
        response.headers().set("Expires", (Object)dateFormatter.format(time.getTime()));
        response.headers().set("Cache-Control", (Object)"private, max-age=300");
        response.headers().set("Last-Modified", (Object)dateFormatter.format(new Date(fileToCache.lastModified())));
    }

    public static void setContentTypeHeader(HttpResponse response, File file) {
        String mimeType = MimeTypes.getMimeTypeForFileName(file.getName());
        String mimeFinal = mimeType != null ? mimeType : MimeTypes.getDefaultMimeType();
        response.headers().set("Content-Type", (Object)mimeFinal);
    }

    public static void checkFileValidity(File file, File rootPath, Logger logger) throws IOException, RestHandlerException {
        if (!file.getCanonicalFile().toPath().startsWith(rootPath.toPath())) {
            if (logger.isDebugEnabled()) {
                logger.debug("Requested path {} points outside the root directory.", (Object)file.getAbsolutePath());
            }
            throw new RestHandlerException("Forbidden.", HttpResponseStatus.FORBIDDEN);
        }
        if (!file.exists() || file.isHidden()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Requested path {} cannot be found.", (Object)file.getAbsolutePath());
            }
            throw new RestHandlerException("File not found.", HttpResponseStatus.NOT_FOUND);
        }
        if (file.isDirectory() || !file.isFile()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Requested path {} does not point to a file.", (Object)file.getAbsolutePath());
            }
            throw new RestHandlerException("File not found.", HttpResponseStatus.METHOD_NOT_ALLOWED);
        }
    }
}

