/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.util.Objects;
import org.apache.flink.runtime.jobgraph.OperatorID;

public class OperatorInstanceID {
    private final int subtaskId;
    private final OperatorID operatorId;

    public static OperatorInstanceID of(int subtaskId, OperatorID operatorID) {
        return new OperatorInstanceID(subtaskId, operatorID);
    }

    public OperatorInstanceID(int subtaskId, OperatorID operatorId) {
        this.subtaskId = subtaskId;
        this.operatorId = operatorId;
    }

    public int getSubtaskId() {
        return this.subtaskId;
    }

    public OperatorID getOperatorId() {
        return this.operatorId;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.subtaskId, this.operatorId});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperatorInstanceID)) {
            return false;
        }
        OperatorInstanceID other = (OperatorInstanceID)obj;
        return this.subtaskId == other.subtaskId && Objects.equals((Object)this.operatorId, (Object)other.operatorId);
    }

    public String toString() {
        return String.format("<%d, %s>", new Object[]{this.subtaskId, this.operatorId});
    }
}

