/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.shuffle;

import java.util.function.Function;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.UnknownShuffleDescriptor;

public class ShuffleUtils {
    private ShuffleUtils() {
    }

    public static <T, SD extends ShuffleDescriptor> T applyWithShuffleTypeCheck(Class<SD> shuffleDescriptorClass, ShuffleDescriptor shuffleDescriptor, Function<UnknownShuffleDescriptor, T> functionOfUnknownDescriptor, Function<SD, T> functionOfKnownDescriptor) {
        if (shuffleDescriptor.isUnknown()) {
            return functionOfUnknownDescriptor.apply((UnknownShuffleDescriptor)shuffleDescriptor);
        }
        if (shuffleDescriptorClass.equals(shuffleDescriptor.getClass())) {
            return functionOfKnownDescriptor.apply(shuffleDescriptor);
        }
        throw new IllegalArgumentException(String.format("Unsupported ShuffleDescriptor type <%s>, only <%s> is supported", shuffleDescriptor.getClass().getName(), shuffleDescriptorClass.getName()));
    }
}

