/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.ContainerOverlay;

abstract class AbstractContainerOverlay
implements ContainerOverlay {
    AbstractContainerOverlay() {
    }

    protected void addPathRecursively(File sourcePath, final Path targetPath, final ContainerSpecification env) throws IOException {
        final java.nio.file.Path sourceRoot = sourcePath.toPath().getParent();
        Files.walkFileTree(sourcePath.toPath(), (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

            @Override
            public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                java.nio.file.Path relativePath = sourceRoot.relativize(file);
                ContainerSpecification.Artifact.Builder artifact = ContainerSpecification.Artifact.newBuilder().setSource(new Path(file.toUri())).setDest(new Path(targetPath, relativePath.toString())).setExecutable(Files.isExecutable(file)).setCachable(true).setExtract(false);
                env.getArtifacts().add(artifact.build());
                return super.visitFile(file, attrs);
            }
        });
    }
}

