/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes;

import org.apache.streampark.common.util.Logger;
import org.apache.streampark.flink.kubernetes.EndpointCache;
import org.apache.streampark.flink.kubernetes.EndpointCache$;
import org.apache.streampark.flink.kubernetes.JobStatusCache;
import org.apache.streampark.flink.kubernetes.JobStatusCache$;
import org.apache.streampark.flink.kubernetes.K8sDeploymentEventCache;
import org.apache.streampark.flink.kubernetes.K8sDeploymentEventCache$;
import org.apache.streampark.flink.kubernetes.KubernetesRetriever$;
import org.apache.streampark.flink.kubernetes.MetricCache;
import org.apache.streampark.flink.kubernetes.MetricCache$;
import org.apache.streampark.flink.kubernetes.TrackIdCache;
import org.apache.streampark.flink.kubernetes.TrackIdCache$;
import org.apache.streampark.flink.kubernetes.model.ClusterKey;
import org.apache.streampark.flink.kubernetes.model.ClusterKey$;
import org.apache.streampark.flink.kubernetes.model.FlinkMetricCV;
import org.apache.streampark.flink.kubernetes.model.FlinkMetricCV$;
import org.apache.streampark.flink.kubernetes.model.TrackId;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u00015\u0011qC\u00127j].\\\u0005h],bi\u000eD7i\u001c8ue>dG.\u001a:\u000b\u0005\r!\u0011AC6vE\u0016\u0014h.\u001a;fg*\u0011QAB\u0001\u0006M2Lgn\u001b\u0006\u0003\u000f!\t!b\u001d;sK\u0006l\u0007/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u001d!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCG\u0007\u0002-)\u0011q\u0003G\u0001\u0005kRLGN\u0003\u0002\u001a\r\u000511m\\7n_:L!a\u0007\f\u0003\r1{wmZ3s!\ti\"%D\u0001\u001f\u0015\ty\u0002%\u0001\u0003mC:<'\"A\u0011\u0002\t)\fg/Y\u0005\u0003Gy\u0011Q\"Q;u_\u000ecwn]3bE2,\u0007\"B\u0013\u0001\t\u00031\u0013A\u0002\u001fj]&$h\bF\u0001(!\tA\u0003!D\u0001\u0003\u0011!Q\u0003\u0001#b\u0001\n\u0003Y\u0013\u0001\u0003;sC\u000e\\\u0017\nZ:\u0016\u00031\u0002\"\u0001K\u0017\n\u00059\u0012!\u0001\u0004+sC\u000e\\\u0017\nZ\"bG\",\u0007\u0002\u0003\u0019\u0001\u0011\u0003\u0005\u000b\u0015\u0002\u0017\u0002\u0013Q\u0014\u0018mY6JIN\u0004\u0003\u0002\u0003\u001a\u0001\u0011\u000b\u0007I\u0011A\u0016\u0002\u0013\r\fgnY3mS:<\u0007\u0002\u0003\u001b\u0001\u0011\u0003\u0005\u000b\u0015\u0002\u0017\u0002\u0015\r\fgnY3mS:<\u0007\u0005\u0003\u00057\u0001!\u0015\r\u0011\"\u00018\u0003%)g\u000e\u001a9pS:$8/F\u00019!\tA\u0013(\u0003\u0002;\u0005\tiQI\u001c3q_&tGoQ1dQ\u0016D\u0001\u0002\u0010\u0001\t\u0002\u0003\u0006K\u0001O\u0001\u000bK:$\u0007o\\5oiN\u0004\u0003\u0002\u0003 \u0001\u0011\u000b\u0007I\u0011A \u0002\u0017)|'m\u0015;biV\u001cXm]\u000b\u0002\u0001B\u0011\u0001&Q\u0005\u0003\u0005\n\u0011aBS8c'R\fG/^:DC\u000eDW\r\u0003\u0005E\u0001!\u0005\t\u0015)\u0003A\u00031QwNY*uCR,8/Z:!\u0011!1\u0005\u0001#b\u0001\n\u00039\u0015aE69g\u0012+\u0007\u000f\\8z[\u0016tG/\u0012<f]R\u001cX#\u0001%\u0011\u0005!J\u0015B\u0001&\u0003\u0005]Y\u0005h\u001d#fa2|\u00170\\3oi\u00163XM\u001c;DC\u000eDW\r\u0003\u0005M\u0001!\u0005\t\u0015)\u0003I\u0003QY\u0007h\u001d#fa2|\u00170\\3oi\u00163XM\u001c;tA!Aa\n\u0001EC\u0002\u0013\u0005q*\u0001\u0007gY&t7.T3ue&\u001c7/F\u0001Q!\tA\u0013+\u0003\u0002S\u0005\tYQ*\u001a;sS\u000e\u001c\u0015m\u00195f\u0011!!\u0006\u0001#A!B\u0013\u0001\u0016!\u00044mS:\\W*\u001a;sS\u000e\u001c\b\u0005C\u0003W\u0001\u0011\u0005s+A\u0003dY>\u001cX\rF\u0001Y!\ty\u0011,\u0003\u0002[!\t!QK\\5u\u0011\u0015a\u0006\u0001\"\u0001^\u0003E9W\r^!mY^\u000bGo\u00195j]\u001eLEm\u001d\u000b\u0002=B\u0019qLY3\u000f\u0005=\u0001\u0017BA1\u0011\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0004'\u0016$(BA1\u0011!\t1\u0017.D\u0001h\u0015\tA'!A\u0003n_\u0012,G.\u0003\u0002kO\n9AK]1dW&#\u0007\"\u00027\u0001\t\u0003i\u0017\u0001D5t\u0013:<\u0016\r^2iS:<GC\u00018r!\tyq.\u0003\u0002q!\t9!i\\8mK\u0006t\u0007\"\u0002:l\u0001\u0004)\u0017a\u0002;sC\u000e\\\u0017\n\u001a\u0005\u0006i\u0002!\t!^\u0001\u000bk:<\u0016\r^2iS:<GC\u0001-w\u0011\u0015\u00118\u000f1\u0001f\u0011\u0019A\b\u0001\"\u0001\u0003;\u0006!r-\u001a;BGRLg/Z,bi\u000eD\u0017N\\4JINDQA\u001f\u0001\u0005\u0002m\fQcY8mY\u0016\u001cG/Q2d\u000fJ|W\u000f]'fiJL7\r\u0006\u0002}\u007fB\u0011a-`\u0005\u0003}\u001e\u0014QB\u00127j].lU\r\u001e:jG\u000e3\u0006bBA\u0001s\u0002\u0007\u00111A\u0001\bOJ|W\u000f]%e!\ry\u0016QA\u0005\u0004\u0003\u000f!'AB*ue&tw\rC\u0004\u0002\f\u0001!\t!!\u0004\u0002#\u001d,Go\u00117vgR,'OU3tiV\u0013H\u000e\u0006\u0003\u0002\u0010\u0005U\u0001#B\b\u0002\u0012\u0005\r\u0011bAA\n!\t1q\n\u001d;j_:D\u0001\"a\u0006\u0002\n\u0001\u0007\u0011\u0011D\u0001\u000bG2,8\u000f^3s\u0017\u0016L\bc\u00014\u0002\u001c%\u0019\u0011QD4\u0003\u0015\rcWo\u001d;fe.+\u0017\u0010C\u0004\u0002\"\u0001!\t!a\t\u0002+I,gM]3tQ\u000ecWo\u001d;feJ+7\u000f^+sYR!\u0011qBA\u0013\u0011!\t9\"a\bA\u0002\u0005e\u0001")
public class FlinkK8sWatchController
implements Logger,
AutoCloseable {
    private TrackIdCache trackIds;
    private TrackIdCache canceling;
    private EndpointCache endpoints;
    private JobStatusCache jobStatuses;
    private K8sDeploymentEventCache k8sDeploymentEvents;
    private MetricCache flinkMetrics;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile byte bitmap$0;

    private TrackIdCache trackIds$lzycompute() {
        FlinkK8sWatchController flinkK8sWatchController = this;
        synchronized (flinkK8sWatchController) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.trackIds = TrackIdCache$.MODULE$.build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.trackIds;
        }
    }

    private TrackIdCache canceling$lzycompute() {
        FlinkK8sWatchController flinkK8sWatchController = this;
        synchronized (flinkK8sWatchController) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canceling = TrackIdCache$.MODULE$.build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.canceling;
        }
    }

    private EndpointCache endpoints$lzycompute() {
        FlinkK8sWatchController flinkK8sWatchController = this;
        synchronized (flinkK8sWatchController) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.endpoints = EndpointCache$.MODULE$.build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.endpoints;
        }
    }

    private JobStatusCache jobStatuses$lzycompute() {
        FlinkK8sWatchController flinkK8sWatchController = this;
        synchronized (flinkK8sWatchController) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.jobStatuses = JobStatusCache$.MODULE$.build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.jobStatuses;
        }
    }

    private K8sDeploymentEventCache k8sDeploymentEvents$lzycompute() {
        FlinkK8sWatchController flinkK8sWatchController = this;
        synchronized (flinkK8sWatchController) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.k8sDeploymentEvents = K8sDeploymentEventCache$.MODULE$.build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.k8sDeploymentEvents;
        }
    }

    private MetricCache flinkMetrics$lzycompute() {
        FlinkK8sWatchController flinkK8sWatchController = this;
        synchronized (flinkK8sWatchController) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.flinkMetrics = MetricCache$.MODULE$.build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
            return this.flinkMetrics;
        }
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public String logName() {
        return Logger.class.logName((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.class.logger((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.class.logInfo((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.class.logInfo((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.class.logDebug((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.class.logDebug((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.class.logTrace((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.class.logTrace((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.class.logWarn((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.class.logWarn((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.class.logError((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.class.logError((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.class.isTraceEnabled((Logger)this);
    }

    public TrackIdCache trackIds() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.trackIds$lzycompute() : this.trackIds;
    }

    public TrackIdCache canceling() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.canceling$lzycompute() : this.canceling;
    }

    public EndpointCache endpoints() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.endpoints$lzycompute() : this.endpoints;
    }

    public JobStatusCache jobStatuses() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.jobStatuses$lzycompute() : this.jobStatuses;
    }

    public K8sDeploymentEventCache k8sDeploymentEvents() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.k8sDeploymentEvents$lzycompute() : this.k8sDeploymentEvents;
    }

    public MetricCache flinkMetrics() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.flinkMetrics$lzycompute() : this.flinkMetrics;
    }

    @Override
    public void close() {
        this.jobStatuses().cleanUp();
        this.k8sDeploymentEvents().cleanUp();
        this.trackIds().cleanUp();
    }

    public Set<TrackId> getAllWatchingIds() {
        return this.trackIds().getAll();
    }

    public boolean isInWatching(TrackId trackId) {
        return trackId.isLegal() ? this.trackIds().get(trackId) != null : false;
    }

    public void unWatching(TrackId trackId) {
        if (trackId.isLegal()) {
            this.trackIds().invalidate(trackId);
            this.canceling().invalidate(trackId);
            this.jobStatuses().invalidate(trackId);
            this.flinkMetrics().invalidate(ClusterKey$.MODULE$.of(trackId));
        }
    }

    public Set<TrackId> getActiveWatchingIds() {
        return (Set)this.getAllWatchingIds().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(TrackId x$1) {
                return x$1.isActive();
            }
        });
    }

    public FlinkMetricCV collectAccGroupMetric(String groupId) {
        FlinkMetricCV flinkMetricCV;
        FlinkMetricCV empty = FlinkMetricCV$.MODULE$.empty(groupId);
        Set set = (Set)this.getActiveWatchingIds().filter((Function1)new Serializable(this, groupId){
            public static final long serialVersionUID = 0L;
            private final String groupId$1;

            public final boolean apply(TrackId x$2) {
                String string = x$2.groupId();
                String string2 = this.groupId$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.groupId$1 = groupId$1;
            }
        });
        if (set.isEmpty()) {
            flinkMetricCV = empty;
        } else {
            Map<ClusterKey, FlinkMetricCV> map = this.flinkMetrics().getAll((Set<ClusterKey>)((Set)set.withFilter((Function1)new Serializable(this, groupId){
                public static final long serialVersionUID = 0L;
                private final String groupId$1;

                public final boolean apply(TrackId elem) {
                    String string = elem.groupId();
                    String string2 = this.groupId$1;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
                {
                    this.groupId$1 = groupId$1;
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ClusterKey apply(TrackId elem) {
                    return ClusterKey$.MODULE$.of(elem);
                }
            }, Set$.MODULE$.canBuildFrom())));
            FlinkMetricCV flinkMetricCV2 = map.isEmpty() ? empty : (FlinkMetricCV)map.values().fold((Object)empty, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final FlinkMetricCV apply(FlinkMetricCV x, FlinkMetricCV y) {
                    return x.$plus(y);
                }
            });
            flinkMetricCV = flinkMetricCV2;
        }
        return flinkMetricCV;
    }

    public Option<String> getClusterRestUrl(ClusterKey clusterKey) {
        return Option$.MODULE$.apply((Object)this.endpoints().get(clusterKey)).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
            }
        }).orElse((Function0)new Serializable(this, clusterKey){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkK8sWatchController $outer;
            private final ClusterKey clusterKey$1;

            public final Option<String> apply() {
                return this.$outer.refreshClusterRestUrl(this.clusterKey$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clusterKey$1 = clusterKey$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Option<String> refreshClusterRestUrl(ClusterKey clusterKey) {
        void var2_2;
        Option<String> restUrl = KubernetesRetriever$.MODULE$.retrieveFlinkRestUrl(clusterKey);
        if (restUrl.nonEmpty()) {
            this.endpoints().put(clusterKey, (String)restUrl.get());
        }
        return var2_2;
    }

    public FlinkK8sWatchController() {
        Logger.class.$init$((Logger)this);
    }
}

