/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.metrics.WatermarkGauge;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.WatermarkGaugeExposingOutput;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

@Internal
public class RecordWriterOutput<OUT>
implements WatermarkGaugeExposingOutput<StreamRecord<OUT>> {
    private RecordWriter<SerializationDelegate<StreamElement>> recordWriter;
    private SerializationDelegate<StreamElement> serializationDelegate;
    private final boolean supportsUnalignedCheckpoints;
    private final OutputTag outputTag;
    private final WatermarkGauge watermarkGauge = new WatermarkGauge();
    private WatermarkStatus announcedStatus = WatermarkStatus.ACTIVE;

    public RecordWriterOutput(RecordWriter<SerializationDelegate<StreamRecord<OUT>>> recordWriter, TypeSerializer<OUT> outSerializer, OutputTag outputTag, boolean supportsUnalignedCheckpoints) {
        Preconditions.checkNotNull(recordWriter);
        this.outputTag = outputTag;
        this.recordWriter = recordWriter;
        StreamElementSerializer<OUT> outRecordSerializer = new StreamElementSerializer<OUT>(outSerializer);
        if (outSerializer != null) {
            this.serializationDelegate = new SerializationDelegate(outRecordSerializer);
        }
        this.supportsUnalignedCheckpoints = supportsUnalignedCheckpoints;
    }

    public void collect(StreamRecord<OUT> record) {
        if (this.outputTag != null) {
            return;
        }
        this.pushToRecordWriter(record);
    }

    @Override
    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        if (OutputTag.isResponsibleFor((OutputTag)this.outputTag, outputTag)) {
            this.pushToRecordWriter(record);
        }
    }

    private <X> void pushToRecordWriter(StreamRecord<X> record) {
        this.serializationDelegate.setInstance(record);
        try {
            this.recordWriter.emit(this.serializationDelegate);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void emitWatermark(Watermark mark) {
        if (this.announcedStatus.isIdle()) {
            return;
        }
        this.watermarkGauge.setCurrentWatermark(mark.getTimestamp());
        this.serializationDelegate.setInstance((Object)mark);
        try {
            this.recordWriter.broadcastEmit(this.serializationDelegate);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void emitWatermarkStatus(WatermarkStatus watermarkStatus) {
        if (!this.announcedStatus.equals(watermarkStatus)) {
            this.announcedStatus = watermarkStatus;
            this.serializationDelegate.setInstance((Object)watermarkStatus);
            try {
                this.recordWriter.broadcastEmit(this.serializationDelegate);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        this.serializationDelegate.setInstance((Object)latencyMarker);
        try {
            this.recordWriter.randomEmit(this.serializationDelegate);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void broadcastEvent(AbstractEvent event, boolean isPriorityEvent) throws IOException {
        if (isPriorityEvent && event instanceof CheckpointBarrier && !this.supportsUnalignedCheckpoints) {
            CheckpointBarrier barrier = (CheckpointBarrier)event;
            event = barrier.withOptions(barrier.getCheckpointOptions().withUnalignedUnsupported());
            isPriorityEvent = false;
        }
        this.recordWriter.broadcastEvent(event, isPriorityEvent);
    }

    public void flush() throws IOException {
        this.recordWriter.flushAll();
    }

    @Override
    public void close() {
        this.recordWriter.close();
    }

    @Override
    public Gauge<Long> getWatermarkGauge() {
        return this.watermarkGauge;
    }
}

