/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.scheduler.ExecutionSlotSharingGroup;
import org.apache.flink.runtime.scheduler.SharedSlotProfileRetriever;
import org.apache.flink.runtime.scheduler.SyncPreferredLocationsRetriever;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

class MergingSharedSlotProfileRetrieverFactory
implements SharedSlotProfileRetriever.SharedSlotProfileRetrieverFactory {
    private final SyncPreferredLocationsRetriever preferredLocationsRetriever;
    private final Function<ExecutionVertexID, AllocationID> priorAllocationIdRetriever;
    private final Supplier<Set<AllocationID>> reservedAllocationIdsRetriever;

    MergingSharedSlotProfileRetrieverFactory(SyncPreferredLocationsRetriever preferredLocationsRetriever, Function<ExecutionVertexID, AllocationID> priorAllocationIdRetriever, Supplier<Set<AllocationID>> reservedAllocationIdsRetriever) {
        this.preferredLocationsRetriever = (SyncPreferredLocationsRetriever)Preconditions.checkNotNull((Object)preferredLocationsRetriever);
        this.priorAllocationIdRetriever = (Function)Preconditions.checkNotNull(priorAllocationIdRetriever);
        this.reservedAllocationIdsRetriever = (Supplier)Preconditions.checkNotNull(reservedAllocationIdsRetriever);
    }

    @Override
    public SharedSlotProfileRetriever createFromBulk(Set<ExecutionVertexID> bulk) {
        return new MergingSharedSlotProfileRetriever(this.reservedAllocationIdsRetriever.get(), bulk);
    }

    private class MergingSharedSlotProfileRetriever
    implements SharedSlotProfileRetriever {
        private final Set<AllocationID> reservedAllocationIds;
        private final Set<ExecutionVertexID> producersToIgnore;

        private MergingSharedSlotProfileRetriever(Set<AllocationID> reservedAllocationIds, Set<ExecutionVertexID> producersToIgnore) {
            this.reservedAllocationIds = (Set)Preconditions.checkNotNull(reservedAllocationIds);
            this.producersToIgnore = (Set)Preconditions.checkNotNull(producersToIgnore);
        }

        @Override
        public SlotProfile getSlotProfile(ExecutionSlotSharingGroup executionSlotSharingGroup, ResourceProfile physicalSlotResourceProfile) {
            HashSet<AllocationID> priorAllocations = new HashSet<AllocationID>();
            ArrayList<TaskManagerLocation> preferredLocations = new ArrayList<TaskManagerLocation>();
            for (ExecutionVertexID execution : executionSlotSharingGroup.getExecutionVertexIds()) {
                priorAllocations.add((AllocationID)((Object)MergingSharedSlotProfileRetrieverFactory.this.priorAllocationIdRetriever.apply(execution)));
                preferredLocations.addAll(MergingSharedSlotProfileRetrieverFactory.this.preferredLocationsRetriever.getPreferredLocations(execution, this.producersToIgnore));
            }
            return SlotProfile.priorAllocation(physicalSlotResourceProfile, physicalSlotResourceProfile, preferredLocations, priorAllocations, this.reservedAllocationIds);
        }
    }
}

