/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.ACompressedArray;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.RaggedArray;
import org.apache.sysds.runtime.matrix.data.Pair;

public class DDCArray<T>
extends ACompressedArray<T> {
    private final Array<T> dict;
    private final AMapToData map;

    public DDCArray(Array<T> dict, AMapToData map) {
        super(map.size());
        this.dict = dict;
        this.map = map;
        if (FrameBlock.debug && dict.size() != map.getUnique()) {
            throw new DMLRuntimeException("Invalid DDCArray, dictionary size is not equal to map unique");
        }
    }

    public Array<T> getDict() {
        return this.dict;
    }

    public AMapToData getMap() {
        return this.map;
    }

    public <J> DDCArray<J> setDict(Array<J> dict) {
        return new DDCArray<J>(dict, this.map);
    }

    public DDCArray<T> nullDict() {
        return new DDCArray<T>(null, this.map);
    }

    private static int getTryThreshold(Types.ValueType t, int allRows, long inMemSize) {
        switch (t) {
            case BOOLEAN: {
                return 1;
            }
            case UINT4: 
            case UINT8: {
                return 2;
            }
            case CHARACTER: {
                return 256;
            }
            case FP32: 
            case INT32: {
                return 65536;
            }
        }
        long MapSize = MapToFactory.estimateInMemorySize(allRows, allRows);
        int i = 2;
        while (allRows / i >= 1 && inMemSize - MapSize < ArrayFactory.getInMemorySize(t, allRows / i, false)) {
            i *= 2;
        }
        int d = Math.max(0, allRows / i);
        return d;
    }

    public static <T> Array<T> compressToDDC(Array<T> arr) {
        int s = arr.size();
        if (s <= 10 || arr instanceof RaggedArray) {
            return arr;
        }
        int t = DDCArray.getTryThreshold(arr.getValueType(), s, arr.getInMemorySize());
        Map<T, Integer> rcd = arr.tryGetDictionary(t);
        if (rcd == null) {
            return arr;
        }
        if (rcd.size() > s / 2) {
            return arr;
        }
        Array<?> ar = rcd.keySet().contains(null) ? ArrayFactory.allocateOptional(arr.getValueType(), rcd.size()) : ArrayFactory.allocate(arr.getValueType(), rcd.size());
        for (Map.Entry<T, Integer> e : rcd.entrySet()) {
            ar.set((int)e.getValue(), e.getKey());
        }
        AMapToData m = arr.createMapping(rcd);
        return new DDCArray(ar, m);
    }

    @Override
    protected Map<T, Long> createRecodeMap() {
        return this.dict.createRecodeMap();
    }

    public static <T> Array<?> compressToDDC(Array<T> arr, Types.ValueType vt, boolean containsNull) {
        Array<?> arrT;
        try {
            arrT = containsNull ? arr.changeTypeWithNulls(vt) : arr.changeType(vt);
        }
        catch (Exception e) {
            Pair<Types.ValueType, Boolean> ct = arr.analyzeValueType();
            arrT = ct.getValue() != false ? arr.changeTypeWithNulls(ct.getKey()) : arr.changeType(ct.getKey());
        }
        return DDCArray.compressToDDC(arrT);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(ArrayFactory.FrameArrayType.DDC.ordinal());
        this.map.write(out);
        if (this.dict == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.dict.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        throw new DMLRuntimeException("Should not be called");
    }

    public static DDCArray<?> read(DataInput in) throws IOException {
        AMapToData map = MapToFactory.readIn(in);
        if (in.readBoolean()) {
            Array<?> dict = ArrayFactory.read(in, map.getUnique());
            switch (dict.getValueType()) {
                case BOOLEAN: {
                    return new DDCArray(dict, map);
                }
                case FP32: {
                    return new DDCArray(dict, map);
                }
                case FP64: {
                    return new DDCArray(dict, map);
                }
                case UINT8: 
                case INT32: {
                    return new DDCArray(dict, map);
                }
                case INT64: {
                    return new DDCArray(dict, map);
                }
                case CHARACTER: {
                    return new DDCArray(dict, map);
                }
            }
            return new DDCArray(dict, map);
        }
        return new DDCArray(null, map);
    }

    @Override
    public T get(int index) {
        return this.dict.get(this.map.getIndex(index));
    }

    @Override
    public double[] extractDouble(double[] ret, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            ret[i - rl] = this.getAsDouble(i);
        }
        return ret;
    }

    @Override
    public double getAsDouble(int i) {
        return this.dict.getAsDouble(this.map.getIndex(i));
    }

    @Override
    public double getAsNaNDouble(int i) {
        return this.dict.getAsNaNDouble(this.map.getIndex(i));
    }

    @Override
    public Array<T> append(Array<T> other) {
        throw new DMLCompressionException("Currently not supported to append compressed but could be cool");
    }

    @Override
    public Array<T> slice(int rl, int ru) {
        return new DDCArray<T>(this.dict, this.map.slice(rl, ru));
    }

    @Override
    public byte[] getAsByteArray() {
        throw new DMLCompressionException("Unimplemented method 'getAsByteArray'");
    }

    @Override
    public Types.ValueType getValueType() {
        return this.dict == null ? Types.ValueType.STRING : this.dict.getValueType();
    }

    @Override
    public Pair<Types.ValueType, Boolean> analyzeValueType(int maxCells) {
        return this.dict.analyzeValueType(maxCells);
    }

    @Override
    protected void set(int rl, int ru, DDCArray<T> value) {
        if (this.dict != null && value.dict != null && (value.dict.size() != this.dict.size() || FrameBlock.debug && !value.dict.equals(this.dict))) {
            throw new DMLCompressionException("Invalid setting of DDC Array, of incompatible instance.");
        }
        AMapToData tm = value.map;
        for (int i = rl; i <= ru; ++i) {
            this.map.set(i, tm.getIndex(i - rl));
        }
    }

    @Override
    public ArrayFactory.FrameArrayType getFrameArrayType() {
        return ArrayFactory.FrameArrayType.DDC;
    }

    @Override
    public long getExactSerializedSize() {
        return 2L + this.map.getExactSizeOnDisk() + this.dict.getExactSerializedSize();
    }

    @Override
    protected Array<Boolean> changeTypeBitSet() {
        return new DDCArray<Boolean>(this.dict.changeTypeBitSet(), this.map);
    }

    @Override
    protected Array<Boolean> changeTypeBoolean() {
        return new DDCArray<Boolean>(this.dict.changeTypeBoolean(), this.map);
    }

    @Override
    protected Array<Double> changeTypeDouble() {
        return new DDCArray<Double>(this.dict.changeTypeDouble(), this.map);
    }

    @Override
    protected Array<Float> changeTypeFloat() {
        return new DDCArray<Float>(this.dict.changeTypeFloat(), this.map);
    }

    @Override
    protected Array<Integer> changeTypeInteger() {
        return new DDCArray<Integer>(this.dict.changeTypeInteger(), this.map);
    }

    @Override
    protected Array<Long> changeTypeLong() {
        return new DDCArray<Long>(this.dict.changeTypeLong(), this.map);
    }

    @Override
    protected Array<Object> changeTypeHash64() {
        return new DDCArray<Object>(this.dict.changeTypeHash64(), this.map);
    }

    @Override
    protected Array<String> changeTypeString() {
        return new DDCArray<String>(this.dict.changeTypeString(), this.map);
    }

    @Override
    protected Array<Character> changeTypeCharacter() {
        return new DDCArray<Character>(this.dict.changeTypeCharacter(), this.map);
    }

    @Override
    public Array<?> changeTypeWithNulls(Types.ValueType t) {
        Array<?> d2 = this.dict.changeTypeWithNulls(t);
        return new DDCArray(d2, this.map);
    }

    @Override
    public boolean isShallowSerialize() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Array<T> select(int[] indices) {
        int[] newSelect = new int[indices.length];
        for (int i = 0; i < newSelect.length; ++i) {
            newSelect[i] = this.map.getIndex(indices[i]);
        }
        return this.dict.select(newSelect);
    }

    @Override
    public Array<T> select(boolean[] select, int nTrue) {
        AMapToData map2 = MapToFactory.create(nTrue, this.map.getUnique());
        int j = 0;
        for (int i = 0; i < select.length; ++i) {
            if (!select[i]) continue;
            map2.set(j++, this.map.getIndex(i));
        }
        return new DDCArray<T>(this.dict, map2);
    }

    @Override
    public boolean isNotEmpty(int i) {
        return this.dict.isNotEmpty(this.map.getIndex(i));
    }

    @Override
    public Array<T> clone() {
        return new DDCArray<T>(this.dict, this.map);
    }

    @Override
    public double hashDouble(int idx) {
        return this.dict.hashDouble(this.map.getIndex(idx));
    }

    @Override
    public long getInMemorySize() {
        return super.getInMemorySize() + this.map.getInMemorySize() + this.dict.getInMemorySize();
    }

    @Override
    protected Map<T, Integer> getDictionary() {
        return this.dict.getDictionary();
    }

    public static long estimateInMemorySize(int memSizeBitPerElement, int estDistinct, int nRow) {
        return (long)estDistinct * (long)memSizeBitPerElement + MapToFactory.estimateInMemorySize(nRow, estDistinct);
    }

    protected DDCArray<T> allocateLarger(int nRow) {
        AMapToData m = MapToFactory.create(nRow, this.map.getUnique());
        return new DDCArray<T>(this.dict, m);
    }

    @Override
    public boolean containsNull() {
        return this.dict.containsNull();
    }

    @Override
    public boolean equals(Array<T> other) {
        if (other instanceof DDCArray) {
            DDCArray ot = (DDCArray)other;
            return this.dict.equals(ot.dict) && this.map.equals(ot.map);
        }
        return false;
    }

    @Override
    public boolean possiblyContainsNaN() {
        return this.dict.possiblyContainsNaN();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n%15s", "Values: "));
        sb.append(this.dict);
        sb.append(String.format("\n%15s", "Data: "));
        sb.append(this.map);
        return sb.toString();
    }
}

